/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time.applicability;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.internal.time.applicability.AllTemporalsApplicability;
import org.sellcom.geotemporal.internal.time.applicability.DayOfWeekAfterMonthDayApplicability;
import org.sellcom.geotemporal.internal.time.applicability.DayOfWeekBeforeMonthDayApplicability;
import org.sellcom.geotemporal.internal.time.applicability.EvenIsoWeekNumberApplicability;
import org.sellcom.geotemporal.internal.time.applicability.InverseTemporalApplicability;
import org.sellcom.geotemporal.internal.time.applicability.OddIsoWeekNumberApplicability;
import org.sellcom.geotemporal.internal.time.applicability.RangeOfDaysOfWeekApplicability;
import org.sellcom.geotemporal.internal.time.applicability.RangeOfIsoWeekNumbersApplicability;
import org.sellcom.geotemporal.internal.time.applicability.RangeOfLocalDatesApplicability;
import org.sellcom.geotemporal.internal.time.applicability.RangeOfMonthDaysApplicability;
import org.sellcom.geotemporal.internal.time.applicability.RangeOfMonthsApplicability;
import org.sellcom.geotemporal.internal.time.applicability.RangeOfYearsApplicability;
import org.sellcom.geotemporal.internal.time.applicability.SingleDayOfWeekApplicability;
import org.sellcom.geotemporal.internal.time.applicability.SingleIsoWeekNumberApplicability;
import org.sellcom.geotemporal.internal.time.applicability.SingleLocalDateApplicability;
import org.sellcom.geotemporal.internal.time.applicability.SingleMonthApplicability;
import org.sellcom.geotemporal.internal.time.applicability.SingleMonthDayApplicability;
import org.sellcom.geotemporal.internal.time.applicability.SingleYearApplicability;
import org.sellcom.geotemporal.time.DaysOfWeek;
import org.sellcom.geotemporal.time.MonthDays;
import org.sellcom.geotemporal.time.Months;
import org.sellcom.geotemporal.time.TemporalPredicate;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicability;

public abstract class TemporalApplicability
extends GeoTemporalApplicability
implements TemporalPredicate {
    public static TemporalApplicability always() {
        return new AllTemporalsApplicability();
    }

    public static TemporalApplicability dateRange(LocalDate startDate, LocalDate endDate) {
        Contract.checkArgument(startDate != null, "Start date must not be null", new Object[0]);
        Contract.checkArgument(endDate != null, "End date must not be null", new Object[0]);
        if (startDate.equals(endDate)) {
            return new SingleLocalDateApplicability(startDate);
        }
        if (endDate.isBefore(startDate)) {
            return new RangeOfLocalDatesApplicability(endDate, startDate);
        }
        return new RangeOfLocalDatesApplicability(startDate, endDate);
    }

    public static TemporalApplicability dayOfWeekAfter(int ordinal, DayOfWeek dayOfWeek, MonthDay monthDay) {
        Contract.checkArgument(ordinal != 0, "Ordinal must not be zero", new Object[0]);
        if (ordinal < 0) {
            return new DayOfWeekBeforeMonthDayApplicability(-ordinal, dayOfWeek, monthDay);
        }
        return new DayOfWeekAfterMonthDayApplicability(ordinal, dayOfWeek, monthDay);
    }

    public static TemporalApplicability dayOfWeekBefore(int ordinal, DayOfWeek dayOfWeek, MonthDay monthDay) {
        Contract.checkArgument(ordinal != 0, "Ordinal must not be zero", new Object[0]);
        if (ordinal < 0) {
            return new DayOfWeekAfterMonthDayApplicability(-ordinal, dayOfWeek, monthDay);
        }
        return new DayOfWeekBeforeMonthDayApplicability(ordinal, dayOfWeek, monthDay);
    }

    public static TemporalApplicability dayOfWeekRange(DayOfWeek startDayOfWeek, DayOfWeek endDayOfWeek) {
        Contract.checkArgument(startDayOfWeek != null, "Start day of week must not be null", new Object[0]);
        Contract.checkArgument(endDayOfWeek != null, "End day of week must not be null", new Object[0]);
        if (startDayOfWeek.equals(endDayOfWeek)) {
            return new SingleDayOfWeekApplicability(startDayOfWeek);
        }
        if (DaysOfWeek.next(endDayOfWeek).equals(startDayOfWeek)) {
            return new AllTemporalsApplicability();
        }
        if (DaysOfWeek.isAfter(startDayOfWeek, endDayOfWeek)) {
            return new InverseTemporalApplicability(TemporalApplicability.dayOfWeekRange(DaysOfWeek.next(endDayOfWeek), DaysOfWeek.previous(startDayOfWeek)));
        }
        return new RangeOfDaysOfWeekApplicability(startDayOfWeek, endDayOfWeek);
    }

    public static TemporalApplicability evenIsoWeek() {
        return new EvenIsoWeekNumberApplicability();
    }

    public static TemporalApplicability isoWeekRange(int startWeekNumber, int endWeekNumber) {
        if (startWeekNumber == endWeekNumber) {
            return new SingleIsoWeekNumberApplicability(startWeekNumber);
        }
        if (endWeekNumber < startWeekNumber) {
            return new InverseTemporalApplicability(new RangeOfIsoWeekNumbersApplicability(endWeekNumber + 1, startWeekNumber - 1));
        }
        return new RangeOfIsoWeekNumbersApplicability(startWeekNumber, endWeekNumber);
    }

    public static TemporalApplicability monthDayRange(MonthDay startMonthDay, MonthDay endMonthDay) {
        Contract.checkArgument(startMonthDay != null, "Start month-day must not be null", new Object[0]);
        Contract.checkArgument(endMonthDay != null, "End month-day must not be null", new Object[0]);
        if (startMonthDay.equals(endMonthDay)) {
            return new SingleMonthDayApplicability(startMonthDay);
        }
        if (MonthDays.next(endMonthDay).equals(startMonthDay)) {
            return new AllTemporalsApplicability();
        }
        if (startMonthDay.isAfter(endMonthDay)) {
            return new InverseTemporalApplicability(TemporalApplicability.monthDayRange(MonthDays.next(endMonthDay), MonthDays.previous(startMonthDay)));
        }
        return new RangeOfMonthDaysApplicability(startMonthDay, endMonthDay);
    }

    public static TemporalApplicability monthRange(Month startMonth, Month endMonth) {
        Contract.checkArgument(startMonth != null, "Start month must not be null", new Object[0]);
        Contract.checkArgument(endMonth != null, "End month must not be null", new Object[0]);
        if (startMonth.equals(endMonth)) {
            return new SingleMonthApplicability(startMonth);
        }
        if (Months.next(endMonth).equals(startMonth)) {
            return new AllTemporalsApplicability();
        }
        if (Months.isAfter(startMonth, endMonth)) {
            return new InverseTemporalApplicability(TemporalApplicability.monthRange(Months.next(endMonth), Months.previous(startMonth)));
        }
        return new RangeOfMonthsApplicability(startMonth, endMonth);
    }

    public TemporalApplicability negate() {
        return new InverseTemporalApplicability(this);
    }

    public static TemporalApplicability never() {
        return new InverseTemporalApplicability(new AllTemporalsApplicability());
    }

    public static TemporalApplicability oddIsoWeek() {
        return new OddIsoWeekNumberApplicability();
    }

    public static TemporalApplicability singleDate(LocalDate date) {
        return new SingleLocalDateApplicability(date);
    }

    public static TemporalApplicability singleDayOfWeek(DayOfWeek dayOfWeek) {
        return new SingleDayOfWeekApplicability(dayOfWeek);
    }

    public static TemporalApplicability singleIsoWeek(int weekNumber) {
        return new SingleIsoWeekNumberApplicability(weekNumber);
    }

    public static TemporalApplicability singleMonth(Month month) {
        return new SingleMonthApplicability(month);
    }

    public static TemporalApplicability singleMonthDay(MonthDay monthDay) {
        return new SingleMonthDayApplicability(monthDay);
    }

    public static TemporalApplicability singleYear(int year) {
        return new SingleYearApplicability(year);
    }

    public static TemporalApplicability singleYear(Year year) {
        return TemporalApplicability.singleYear(year.getValue());
    }

    @Override
    public abstract boolean test(Temporal var1);

    @Override
    public final boolean test(Temporal temporal, GeoRegion region) {
        return this.test(temporal);
    }

    public static TemporalApplicability yearRange(int startYear, int endYear) {
        if (startYear == endYear) {
            return new SingleYearApplicability(startYear);
        }
        if (endYear < startYear) {
            return new RangeOfYearsApplicability(endYear, startYear);
        }
        return new RangeOfYearsApplicability(startYear, endYear);
    }

    public static TemporalApplicability yearRange(Year startYear, Year endYear) {
        Contract.checkArgument(startYear != null, "Start year must not be null", new Object[0]);
        Contract.checkArgument(endYear != null, "End year must not be null", new Object[0]);
        return TemporalApplicability.yearRange(startYear.getValue(), endYear.getValue());
    }
}

