/*
 * Copyright (c) 2015-2018 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.geotemporal.geography;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class GeoRegionUtils {

	private static final Map<String, String> countryCodes;

	static {
		Map<String, String> codes = new HashMap<>();

		// ISO 3166-1 numeric-3 codes
		codes.put("004", StandardGeoRegions.AFGHANISTAN);
		codes.put("008", StandardGeoRegions.ALBANIA);
		codes.put("010", StandardGeoRegions.ANTARCTICA);
		codes.put("012", StandardGeoRegions.ALGERIA);
		codes.put("016", StandardGeoRegions.AMERICAN_SAMOA);
		codes.put("020", StandardGeoRegions.ANDORRA);
		codes.put("024", StandardGeoRegions.ANGOLA);
		codes.put("028", StandardGeoRegions.ANTIGUA_AND_BARBUDA);
		codes.put("031", StandardGeoRegions.AZERBAIJAN);
		codes.put("032", StandardGeoRegions.ARGENTINA);
		codes.put("036", StandardGeoRegions.AUSTRALIA);
		codes.put("040", StandardGeoRegions.AUSTRIA);
		codes.put("044", StandardGeoRegions.BAHAMAS);
		codes.put("048", StandardGeoRegions.BAHRAIN);
		codes.put("050", StandardGeoRegions.BANGLADESH);
		codes.put("051", StandardGeoRegions.ARMENIA);
		codes.put("052", StandardGeoRegions.BARBADOS);
		codes.put("056", StandardGeoRegions.BELGIUM);
		codes.put("060", StandardGeoRegions.BERMUDA);
		codes.put("064", StandardGeoRegions.BHUTAN);
		codes.put("068", StandardGeoRegions.BOLIVIA);
		codes.put("070", StandardGeoRegions.BOSNIA_AND_HERZEGOVINA);
		codes.put("072", StandardGeoRegions.BOTSWANA);
		codes.put("074", StandardGeoRegions.BOUVET_ISLAND);
		codes.put("076", StandardGeoRegions.BRAZIL);
		codes.put("084", StandardGeoRegions.BELIZE);
		codes.put("086", StandardGeoRegions.BRITISH_INDIAN_OCEAN_TERRITORY);
		codes.put("090", StandardGeoRegions.SOLOMON_ISLANDS);
		codes.put("092", StandardGeoRegions.BRITISH_VIRGIN_ISLANDS);
		codes.put("096", StandardGeoRegions.BRUNEI_DARUSSALAM);
		codes.put("100", StandardGeoRegions.BULGARIA);
		codes.put("104", StandardGeoRegions.MYANMAR);
		codes.put("108", StandardGeoRegions.BURUNDI);
		codes.put("112", StandardGeoRegions.BELARUS);
		codes.put("116", StandardGeoRegions.CAMBODIA);
		codes.put("120", StandardGeoRegions.CAMEROON);
		codes.put("124", StandardGeoRegions.CANADA);
		codes.put("132", StandardGeoRegions.CAPE_VERDE);
		codes.put("136", StandardGeoRegions.CAYMAN_ISLANDS);
		codes.put("140", StandardGeoRegions.CENTRAL_AFRICAN_REPUBLIC);
		codes.put("144", StandardGeoRegions.SRI_LANKA);
		codes.put("148", StandardGeoRegions.CHAD);
		codes.put("152", StandardGeoRegions.CHILE);
		codes.put("156", StandardGeoRegions.CHINA);
		codes.put("158", StandardGeoRegions.TAIWAN);
		codes.put("162", StandardGeoRegions.CHRISTMAS_ISLAND);
		codes.put("166", StandardGeoRegions.COCOS_ISLANDS);
		codes.put("170", StandardGeoRegions.COLOMBIA);
		codes.put("174", StandardGeoRegions.COMOROS);
		codes.put("175", StandardGeoRegions.MAYOTTE);
		codes.put("178", StandardGeoRegions.REPUBLIC_OF_THE_CONGO);
		codes.put("180", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("184", StandardGeoRegions.COOK_ISLANDS);
		codes.put("188", StandardGeoRegions.COSTA_RICA);
		codes.put("191", StandardGeoRegions.CROATIA);
		codes.put("192", StandardGeoRegions.CUBA);
		codes.put("196", StandardGeoRegions.CYPRUS);
		codes.put("203", StandardGeoRegions.CZECH_REPUBLIC);
		codes.put("204", StandardGeoRegions.BENIN);
		codes.put("208", StandardGeoRegions.DENMARK);
		codes.put("212", StandardGeoRegions.DOMINICA);
		codes.put("214", StandardGeoRegions.DOMINICAN_REPUBLIC);
		codes.put("218", StandardGeoRegions.ECUADOR);
		codes.put("222", StandardGeoRegions.EL_SALVADOR);
		codes.put("226", StandardGeoRegions.EQUATORIAL_GUINEA);
		codes.put("231", StandardGeoRegions.ETHIOPIA);
		codes.put("232", StandardGeoRegions.ERITREA);
		codes.put("233", StandardGeoRegions.ESTONIA);
		codes.put("234", StandardGeoRegions.FAROE_ISLANDS);
		codes.put("238", StandardGeoRegions.FALKLAND_ISLANDS);
		codes.put("239", StandardGeoRegions.SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS);
		codes.put("242", StandardGeoRegions.FIJI);
		codes.put("246", StandardGeoRegions.FINLAND);
		codes.put("248", StandardGeoRegions.ALAND_ISLANDS);
		codes.put("250", StandardGeoRegions.FRANCE);
		codes.put("254", StandardGeoRegions.FRENCH_GUIANA);
		codes.put("258", StandardGeoRegions.FRENCH_POLYNESIA);
		codes.put("260", StandardGeoRegions.FRENCH_SOUTHERN_AND_ANTARCTIC_LANDS);
		codes.put("262", StandardGeoRegions.DJIBOUTI);
		codes.put("266", StandardGeoRegions.GABON);
		codes.put("268", StandardGeoRegions.GEORGIA);
		codes.put("270", StandardGeoRegions.GAMBIA);
		codes.put("275", StandardGeoRegions.PALESTINE);
		codes.put("276", StandardGeoRegions.GERMANY);
		codes.put("288", StandardGeoRegions.GHANA);
		codes.put("292", StandardGeoRegions.GIBRALTAR);
		codes.put("296", StandardGeoRegions.KIRIBATI);
		codes.put("300", StandardGeoRegions.GREECE);
		codes.put("304", StandardGeoRegions.GREENLAND);
		codes.put("308", StandardGeoRegions.GRENADA);
		codes.put("312", StandardGeoRegions.GUADELOUPE);
		codes.put("316", StandardGeoRegions.GUAM);
		codes.put("320", StandardGeoRegions.GUATEMALA);
		codes.put("324", StandardGeoRegions.GUINEA);
		codes.put("328", StandardGeoRegions.GUYANA);
		codes.put("332", StandardGeoRegions.HAITI);
		codes.put("334", StandardGeoRegions.HEARD_ISLAND_AND_MCDONALD_ISLANDS);
		codes.put("336", StandardGeoRegions.VATICAN_CITY);
		codes.put("340", StandardGeoRegions.HONDURAS);
		codes.put("344", StandardGeoRegions.HONG_KONG);
		codes.put("348", StandardGeoRegions.HUNGARY);
		codes.put("352", StandardGeoRegions.ICELAND);
		codes.put("356", StandardGeoRegions.INDIA);
		codes.put("360", StandardGeoRegions.INDONESIA);
		codes.put("364", StandardGeoRegions.IRAN);
		codes.put("368", StandardGeoRegions.IRAQ);
		codes.put("372", StandardGeoRegions.REPUBLIC_OF_IRELAND);
		codes.put("376", StandardGeoRegions.ISRAEL);
		codes.put("380", StandardGeoRegions.ITALY);
		codes.put("384", StandardGeoRegions.IVORY_COAST);
		codes.put("388", StandardGeoRegions.JAMAICA);
		codes.put("392", StandardGeoRegions.JAPAN);
		codes.put("398", StandardGeoRegions.KAZAKHSTAN);
		codes.put("400", StandardGeoRegions.JORDAN);
		codes.put("404", StandardGeoRegions.KENYA);
		codes.put("408", StandardGeoRegions.NORTH_KOREA);
		codes.put("410", StandardGeoRegions.SOUTH_KOREA);
		codes.put("414", StandardGeoRegions.KUWAIT);
		codes.put("417", StandardGeoRegions.KYRGYZSTAN);
		codes.put("418", StandardGeoRegions.LAOS);
		codes.put("422", StandardGeoRegions.LEBANON);
		codes.put("426", StandardGeoRegions.LESOTHO);
		codes.put("428", StandardGeoRegions.LATVIA);
		codes.put("430", StandardGeoRegions.LIBERIA);
		codes.put("434", StandardGeoRegions.LIBYA);
		codes.put("438", StandardGeoRegions.LIECHTENSTEIN);
		codes.put("440", StandardGeoRegions.LITHUANIA);
		codes.put("442", StandardGeoRegions.LUXEMBOURG);
		codes.put("446", StandardGeoRegions.MACAU);
		codes.put("450", StandardGeoRegions.MADAGASCAR);
		codes.put("454", StandardGeoRegions.MALAWI);
		codes.put("458", StandardGeoRegions.MALAYSIA);
		codes.put("462", StandardGeoRegions.MALDIVES);
		codes.put("466", StandardGeoRegions.MALI);
		codes.put("470", StandardGeoRegions.MALTA);
		codes.put("474", StandardGeoRegions.MARTINIQUE);
		codes.put("478", StandardGeoRegions.MAURITANIA);
		codes.put("480", StandardGeoRegions.MAURITIUS);
		codes.put("484", StandardGeoRegions.MEXICO);
		codes.put("492", StandardGeoRegions.MONACO);
		codes.put("496", StandardGeoRegions.MONGOLIA);
		codes.put("498", StandardGeoRegions.MOLDOVA);
		codes.put("499", StandardGeoRegions.MONTENEGRO);
		codes.put("500", StandardGeoRegions.MONTSERRAT);
		codes.put("504", StandardGeoRegions.MOROCCO);
		codes.put("508", StandardGeoRegions.MOZAMBIQUE);
		codes.put("512", StandardGeoRegions.OMAN);
		codes.put("516", StandardGeoRegions.NAMIBIA);
		codes.put("520", StandardGeoRegions.NAURU);
		codes.put("524", StandardGeoRegions.NEPAL);
		codes.put("528", StandardGeoRegions.NETHERLANDS);
		codes.put("531", StandardGeoRegions.CURACAO);
		codes.put("533", StandardGeoRegions.ARUBA);
		codes.put("534", StandardGeoRegions.SINT_MAARTEN);
		codes.put("535", StandardGeoRegions.BONAIRE_SINT_EUSTATIUS_AND_SABA);
		codes.put("540", StandardGeoRegions.NEW_CALEDONIA);
		codes.put("548", StandardGeoRegions.VANUATU);
		codes.put("554", StandardGeoRegions.NEW_ZEALAND);
		codes.put("558", StandardGeoRegions.NICARAGUA);
		codes.put("562", StandardGeoRegions.NIGER);
		codes.put("566", StandardGeoRegions.NIGERIA);
		codes.put("570", StandardGeoRegions.NIUE);
		codes.put("574", StandardGeoRegions.NORFOLK_ISLAND);
		codes.put("578", StandardGeoRegions.NORWAY);
		codes.put("580", StandardGeoRegions.NORTHERN_MARIANA_ISLANDS);
		codes.put("581", StandardGeoRegions.UNITED_STATES_MINOR_OUTLYING_ISLANDS);
		codes.put("583", StandardGeoRegions.FEDERATED_STATES_OF_MICRONESIA);
		codes.put("584", StandardGeoRegions.MARSHALL_ISLANDS);
		codes.put("585", StandardGeoRegions.PALAU);
		codes.put("586", StandardGeoRegions.PAKISTAN);
		codes.put("591", StandardGeoRegions.PANAMA);
		codes.put("598", StandardGeoRegions.PAPUA_NEW_GUINEA);
		codes.put("600", StandardGeoRegions.PARAGUAY);
		codes.put("604", StandardGeoRegions.PERU);
		codes.put("608", StandardGeoRegions.PHILIPPINES);
		codes.put("612", StandardGeoRegions.PITCAIRN_ISLANDS);
		codes.put("616", StandardGeoRegions.POLAND);
		codes.put("620", StandardGeoRegions.PORTUGAL);
		codes.put("624", StandardGeoRegions.GUINEA_BISSAU);
		codes.put("626", StandardGeoRegions.EAST_TIMOR);
		codes.put("630", StandardGeoRegions.PUERTO_RICO);
		codes.put("634", StandardGeoRegions.QATAR);
		codes.put("638", StandardGeoRegions.REUNION);
		codes.put("642", StandardGeoRegions.ROMANIA);
		codes.put("643", StandardGeoRegions.RUSSIA);
		codes.put("646", StandardGeoRegions.RWANDA);
		codes.put("652", StandardGeoRegions.SAINT_BARTHELEMY);
		codes.put("654", StandardGeoRegions.SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA);
		codes.put("659", StandardGeoRegions.SAINT_KITTS_AND_NEVIS);
		codes.put("660", StandardGeoRegions.ANGUILLA);
		codes.put("662", StandardGeoRegions.SAINT_LUCIA);
		codes.put("663", StandardGeoRegions.SAINT_MARTIN);
		codes.put("666", StandardGeoRegions.SAINT_PIERRE_AND_MIQUELON);
		codes.put("670", StandardGeoRegions.SAINT_VINCENT_AND_THE_GRENADINES);
		codes.put("674", StandardGeoRegions.SAN_MARINO);
		codes.put("678", StandardGeoRegions.SAO_TOME_AND_PRINCIPE);
		codes.put("682", StandardGeoRegions.SAUDI_ARABIA);
		codes.put("686", StandardGeoRegions.SENEGAL);
		codes.put("688", StandardGeoRegions.SERBIA);
		codes.put("690", StandardGeoRegions.SEYCHELLES);
		codes.put("694", StandardGeoRegions.SIERRA_LEONE);
		codes.put("702", StandardGeoRegions.SINGAPORE);
		codes.put("703", StandardGeoRegions.SLOVAKIA);
		codes.put("704", StandardGeoRegions.VIETNAM);
		codes.put("705", StandardGeoRegions.SLOVENIA);
		codes.put("706", StandardGeoRegions.SOMALIA);
		codes.put("710", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("716", StandardGeoRegions.ZIMBABWE);
		codes.put("724", StandardGeoRegions.SPAIN);
		codes.put("728", StandardGeoRegions.SOUTH_SUDAN);
		codes.put("729", StandardGeoRegions.SUDAN);
		codes.put("732", StandardGeoRegions.WESTERN_SAHARA);
		codes.put("740", StandardGeoRegions.SURINAME);
		codes.put("744", StandardGeoRegions.SVALBARD_AND_JAN_MAYEN);
		codes.put("748", StandardGeoRegions.SWAZILAND);
		codes.put("752", StandardGeoRegions.SWEDEN);
		codes.put("756", StandardGeoRegions.SWITZERLAND);
		codes.put("760", StandardGeoRegions.SYRIA);
		codes.put("762", StandardGeoRegions.TAJIKISTAN);
		codes.put("764", StandardGeoRegions.THAILAND);
		codes.put("768", StandardGeoRegions.TOGO);
		codes.put("772", StandardGeoRegions.TOKELAU);
		codes.put("776", StandardGeoRegions.TONGA);
		codes.put("780", StandardGeoRegions.TRINIDAD_AND_TOBAGO);
		codes.put("784", StandardGeoRegions.UNITED_ARAB_EMIRATES);
		codes.put("788", StandardGeoRegions.TUNISIA);
		codes.put("792", StandardGeoRegions.TURKEY);
		codes.put("795", StandardGeoRegions.TURKMENISTAN);
		codes.put("796", StandardGeoRegions.TURKS_AND_CAICOS_ISLANDS);
		codes.put("798", StandardGeoRegions.TUVALU);
		codes.put("800", StandardGeoRegions.UGANDA);
		codes.put("804", StandardGeoRegions.UKRAINE);
		codes.put("807", StandardGeoRegions.REPUBLIC_OF_MACEDONIA);
		codes.put("818", StandardGeoRegions.EGYPT);
		codes.put("826", StandardGeoRegions.UNITED_KINGDOM);
		codes.put("831", StandardGeoRegions.GUERNSEY);
		codes.put("832", StandardGeoRegions.JERSEY);
		codes.put("833", StandardGeoRegions.ISLE_OF_MAN);
		codes.put("834", StandardGeoRegions.TANZANIA);
		codes.put("840", StandardGeoRegions.UNITED_STATES);
		codes.put("850", StandardGeoRegions.UNITED_STATES_VIRGIN_ISLANDS);
		codes.put("854", StandardGeoRegions.BURKINA_FASO);
		codes.put("858", StandardGeoRegions.URUGUAY);
		codes.put("860", StandardGeoRegions.UZBEKISTAN);
		codes.put("862", StandardGeoRegions.VENEZUELA);
		codes.put("876", StandardGeoRegions.WALLIS_AND_FUTUNA);
		codes.put("882", StandardGeoRegions.SAMOA);
		codes.put("887", StandardGeoRegions.YEMEN);
		codes.put("894", StandardGeoRegions.ZAMBIA);

		countryCodes = Collections.unmodifiableMap(codes);
	}

	private static final Map<String, String> languageCodes;

	static {
		Map<String, String> codes = new HashMap<>();

		// ISO 639 alpha-2 codes
		codes.put("aa", StandardGeoRegions.ETHIOPIA);
		codes.put("ab", StandardGeoRegions.Georgia.APKHAZETIS_AVTONOMIURI_RESPUBLIKA);
		codes.put("af", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("ak", StandardGeoRegions.GHANA);
		codes.put("am", StandardGeoRegions.ETHIOPIA);
		codes.put("an", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_ARAGON);
		codes.put("as", StandardGeoRegions.INDIA);
		codes.put("av", StandardGeoRegions.Russia.RESPUBLIKA_DAGESTAN);
		codes.put("ay", StandardGeoRegions.BOLIVIA);
		codes.put("az", StandardGeoRegions.AZERBAIJAN);
		codes.put("ba", StandardGeoRegions.Russia.RESPUBLIKA_BASHKORTOSTAN);
		codes.put("be", StandardGeoRegions.BELARUS);
		codes.put("bg", StandardGeoRegions.BULGARIA);
		codes.put("bi", StandardGeoRegions.VANUATU);
		codes.put("bm", StandardGeoRegions.MALI);
		codes.put("bn", StandardGeoRegions.BANGLADESH);
		codes.put("bo", StandardGeoRegions.China.XIZANG_ZIZHIQU);
		codes.put("br", StandardGeoRegions.France.REGION_DE_BRETAGNE);
		codes.put("bs", StandardGeoRegions.BOSNIA_AND_HERZEGOVINA);
		codes.put("ca", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_CATALUNA);
		codes.put("ce", StandardGeoRegions.Russia.RESPUBLIKA_CHECHNYA);
		codes.put("ch", StandardGeoRegions.GUAM);
		codes.put("co", StandardGeoRegions.France.REGION_DE_CORSE);
		codes.put("cr", StandardGeoRegions.Canada.NORTHWEST_TERRITORIES);
		codes.put("cs", StandardGeoRegions.CZECH_REPUBLIC);
		codes.put("cv", StandardGeoRegions.Russia.RESPUBLIKA_CHUVASHIYA);
		codes.put("cy", StandardGeoRegions.UnitedKingdom.COUNTRY_OF_WALES);
		codes.put("da", StandardGeoRegions.DENMARK);
		codes.put("de", StandardGeoRegions.GERMANY);
		codes.put("dv", StandardGeoRegions.MALDIVES);
		codes.put("dz", StandardGeoRegions.BHUTAN);
		codes.put("ee", StandardGeoRegions.GHANA);
		codes.put("el", StandardGeoRegions.GREECE);
		codes.put("en", StandardGeoRegions.UNITED_KINGDOM);
		codes.put("es", StandardGeoRegions.SPAIN);
		codes.put("et", StandardGeoRegions.ESTONIA);
		codes.put("eu", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DEL_PAIS_VASCO);
		codes.put("fa", StandardGeoRegions.IRAN);
		codes.put("ff", StandardGeoRegions.SENEGAL);
		codes.put("fi", StandardGeoRegions.FINLAND);
		codes.put("fj", StandardGeoRegions.FIJI);
		codes.put("fo", StandardGeoRegions.FAROE_ISLANDS);
		codes.put("fr", StandardGeoRegions.FRANCE);
		codes.put("fy", StandardGeoRegions.Netherlands.PROVINCIE_FRIESLAND);
		codes.put("ga", StandardGeoRegions.REPUBLIC_OF_IRELAND);
		codes.put("gd", StandardGeoRegions.UnitedKingdom.COUNTRY_OF_SCOTLAND);
		codes.put("gl", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_GALICIA);
		codes.put("gn", StandardGeoRegions.PARAGUAY);
		codes.put("gu", StandardGeoRegions.INDIA);
		codes.put("gv", StandardGeoRegions.ISLE_OF_MAN);
		codes.put("ha", StandardGeoRegions.NIGERIA);
		codes.put("he", StandardGeoRegions.ISRAEL);
		codes.put("hi", StandardGeoRegions.INDIA);
		codes.put("ho", StandardGeoRegions.PAPUA_NEW_GUINEA);
		codes.put("hr", StandardGeoRegions.CROATIA);
		codes.put("ht", StandardGeoRegions.HAITI);
		codes.put("hu", StandardGeoRegions.HUNGARY);
		codes.put("hy", StandardGeoRegions.ARMENIA);
		codes.put("hz", StandardGeoRegions.NAMIBIA);
		codes.put("id", StandardGeoRegions.INDONESIA);
		codes.put("ig", StandardGeoRegions.NIGERIA);
		codes.put("ii", StandardGeoRegions.CHINA);
		codes.put("ik", StandardGeoRegions.UnitedStates.STATE_OF_ALASKA);
		codes.put("is", StandardGeoRegions.ICELAND);
		codes.put("it", StandardGeoRegions.ITALY);
		codes.put("iu", StandardGeoRegions.CANADA);
		codes.put("ja", StandardGeoRegions.JAPAN);
		codes.put("jv", StandardGeoRegions.INDONESIA);
		codes.put("ka", StandardGeoRegions.GEORGIA);
		codes.put("kg", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("ki", StandardGeoRegions.KENYA);
		codes.put("kj", StandardGeoRegions.ANGOLA);
		codes.put("kk", StandardGeoRegions.KAZAKHSTAN);
		codes.put("kl", StandardGeoRegions.GREENLAND);
		codes.put("km", StandardGeoRegions.CAMBODIA);
		codes.put("kn", StandardGeoRegions.INDIA);
		codes.put("ko", StandardGeoRegions.SOUTH_KOREA);
		codes.put("kr", StandardGeoRegions.NIGERIA);
		codes.put("ks", StandardGeoRegions.INDIA);
		codes.put("ku", StandardGeoRegions.Iraq.IQLIM_KURDISTAN);
		codes.put("kv", StandardGeoRegions.Russia.RESPUBLIKA_KOMI);
		codes.put("kw", StandardGeoRegions.UnitedKingdom.COUNTY_OF_CORNWALL);
		codes.put("ky", StandardGeoRegions.KYRGYZSTAN);
		codes.put("lb", StandardGeoRegions.LUXEMBOURG);
		codes.put("lg", StandardGeoRegions.UGANDA);
		codes.put("li", StandardGeoRegions.Netherlands.PROVINCIE_LIMBURG);
		codes.put("ln", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("lo", StandardGeoRegions.LAOS);
		codes.put("lt", StandardGeoRegions.LITHUANIA);
		codes.put("lu", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("lv", StandardGeoRegions.LATVIA);
		codes.put("mg", StandardGeoRegions.MADAGASCAR);
		codes.put("mh", StandardGeoRegions.MARSHALL_ISLANDS);
		codes.put("mi", StandardGeoRegions.NEW_ZEALAND);
		codes.put("mk", StandardGeoRegions.REPUBLIC_OF_MACEDONIA);
		codes.put("ml", StandardGeoRegions.INDIA);
		codes.put("mn", StandardGeoRegions.MONGOLIA);
		codes.put("mr", StandardGeoRegions.INDIA);
		codes.put("ms", StandardGeoRegions.MALAYSIA);
		codes.put("mt", StandardGeoRegions.MALTA);
		codes.put("my", StandardGeoRegions.MYANMAR);
		codes.put("na", StandardGeoRegions.NAURU);
		codes.put("nb", StandardGeoRegions.NORWAY);
		codes.put("nd", StandardGeoRegions.ZIMBABWE);
		codes.put("ne", StandardGeoRegions.NEPAL);
		codes.put("ng", StandardGeoRegions.NAMIBIA);
		codes.put("nl", StandardGeoRegions.NETHERLANDS);
		codes.put("nn", StandardGeoRegions.NORWAY);
		codes.put("no", StandardGeoRegions.NORWAY);
		codes.put("nr", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("nv", StandardGeoRegions.UNITED_STATES);
		codes.put("ny", StandardGeoRegions.MALAWI);
		codes.put("oc", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_CATALUNA);
		codes.put("oj", StandardGeoRegions.CANADA);
		codes.put("om", StandardGeoRegions.ETHIOPIA);
		codes.put("or", StandardGeoRegions.INDIA);
		codes.put("os", StandardGeoRegions.Russia.RESPUBLIKA_SEVERNAYA_OSETIYA_ALANIYA);
		codes.put("pa", StandardGeoRegions.INDIA);
		codes.put("pl", StandardGeoRegions.POLAND);
		codes.put("ps", StandardGeoRegions.PAKISTAN);
		codes.put("pt", StandardGeoRegions.PORTUGAL);
		codes.put("qu", StandardGeoRegions.PERU);
		codes.put("rm", StandardGeoRegions.Switzerland.KANTON_GRAUBUENDEN);
		codes.put("rn", StandardGeoRegions.BURUNDI);
		codes.put("ro", StandardGeoRegions.ROMANIA);
		codes.put("ru", StandardGeoRegions.RUSSIA);
		codes.put("rw", StandardGeoRegions.RWANDA);
		codes.put("sa", StandardGeoRegions.INDIA);
		codes.put("sc", StandardGeoRegions.Italy.REGIONE_AUTONOMA_DELLA_SARDEGNA);
		codes.put("sd", StandardGeoRegions.PAKISTAN);
		codes.put("se", StandardGeoRegions.NORWAY);
		codes.put("sg", StandardGeoRegions.CENTRAL_AFRICAN_REPUBLIC);
		codes.put("si", StandardGeoRegions.SRI_LANKA);
		codes.put("sk", StandardGeoRegions.SLOVAKIA);
		codes.put("sl", StandardGeoRegions.SLOVENIA);
		codes.put("sm", StandardGeoRegions.SAMOA);
		codes.put("sn", StandardGeoRegions.ZIMBABWE);
		codes.put("so", StandardGeoRegions.SOMALIA);
		codes.put("sq", StandardGeoRegions.ALBANIA);
		codes.put("sr", StandardGeoRegions.SERBIA);
		codes.put("ss", StandardGeoRegions.SWAZILAND);
		codes.put("st", StandardGeoRegions.LESOTHO);
		codes.put("su", StandardGeoRegions.INDONESIA);
		codes.put("sv", StandardGeoRegions.SWEDEN);
		codes.put("sw", StandardGeoRegions.TANZANIA);
		codes.put("ta", StandardGeoRegions.INDIA);
		codes.put("te", StandardGeoRegions.INDIA);
		codes.put("tg", StandardGeoRegions.TAJIKISTAN);
		codes.put("th", StandardGeoRegions.THAILAND);
		codes.put("ti", StandardGeoRegions.ETHIOPIA);
		codes.put("tk", StandardGeoRegions.TURKMENISTAN);
		codes.put("tl", StandardGeoRegions.PHILIPPINES);
		codes.put("tn", StandardGeoRegions.BOTSWANA);
		codes.put("to", StandardGeoRegions.TONGA);
		codes.put("tr", StandardGeoRegions.TURKEY);
		codes.put("ts", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("tt", StandardGeoRegions.Russia.RESPUBLIKA_TATARSTAN);
		codes.put("tw", StandardGeoRegions.GHANA);
		codes.put("ty", StandardGeoRegions.FRENCH_POLYNESIA);
		codes.put("ug", StandardGeoRegions.CHINA);
		codes.put("uk", StandardGeoRegions.UKRAINE);
		codes.put("ur", StandardGeoRegions.PAKISTAN);
		codes.put("uz", StandardGeoRegions.UZBEKISTAN);
		codes.put("ve", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("vi", StandardGeoRegions.VIETNAM);
		codes.put("wa", StandardGeoRegions.Belgium.REGION_WALLONNE);
		codes.put("wo", StandardGeoRegions.SENEGAL);
		codes.put("xh", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("yi", StandardGeoRegions.ISRAEL);
		codes.put("yo", StandardGeoRegions.NIGERIA);
		codes.put("za", StandardGeoRegions.CHINA);
		codes.put("zh", StandardGeoRegions.CHINA);
		codes.put("zu", StandardGeoRegions.SOUTH_AFRICA);

		// ISO 639 alpha-3 codes
		codes.put("aar", StandardGeoRegions.ETHIOPIA);
		codes.put("abk", StandardGeoRegions.Georgia.APKHAZETIS_AVTONOMIURI_RESPUBLIKA);
		codes.put("ace", StandardGeoRegions.INDONESIA);
		codes.put("ach", StandardGeoRegions.UGANDA);
		codes.put("ada", StandardGeoRegions.GHANA);
		codes.put("ady", StandardGeoRegions.Russia.RESPUBLIKA_ADYGEYA);
		codes.put("afr", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("ain", StandardGeoRegions.JAPAN);
		codes.put("aka", StandardGeoRegions.GHANA);
		codes.put("ale", StandardGeoRegions.UnitedStates.STATE_OF_ALASKA);
		codes.put("alt", StandardGeoRegions.Russia.RESPUBLIKA_ALTAY);
		codes.put("amh", StandardGeoRegions.ETHIOPIA);
		codes.put("anp", StandardGeoRegions.INDIA);
		codes.put("arg", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_ARAGON);
		codes.put("arn", StandardGeoRegions.CHILE);
		codes.put("arp", StandardGeoRegions.UnitedStates.STATE_OF_WYOMING);
		codes.put("arw", StandardGeoRegions.SURINAME);
		codes.put("asm", StandardGeoRegions.INDIA);
		codes.put("ast", StandardGeoRegions.Spain.PRINCIPADO_DE_ASTURIAS);
		codes.put("ava", StandardGeoRegions.Russia.RESPUBLIKA_DAGESTAN);
		codes.put("awa", StandardGeoRegions.INDIA);
		codes.put("aym", StandardGeoRegions.BOLIVIA);
		codes.put("aze", StandardGeoRegions.AZERBAIJAN);
		codes.put("bak", StandardGeoRegions.Russia.RESPUBLIKA_BASHKORTOSTAN);
		codes.put("bal", StandardGeoRegions.PAKISTAN);
		codes.put("bam", StandardGeoRegions.MALI);
		codes.put("ban", StandardGeoRegions.INDONESIA);
		codes.put("bas", StandardGeoRegions.CAMEROON);
		codes.put("bej", StandardGeoRegions.SUDAN);
		codes.put("bel", StandardGeoRegions.BELARUS);
		codes.put("bem", StandardGeoRegions.ZAMBIA);
		codes.put("ben", StandardGeoRegions.BANGLADESH);
		codes.put("bho", StandardGeoRegions.INDIA);
		codes.put("bik", StandardGeoRegions.PHILIPPINES);
		codes.put("bin", StandardGeoRegions.NIGERIA);
		codes.put("bis", StandardGeoRegions.VANUATU);
		codes.put("bla", StandardGeoRegions.Canada.PROVINCE_OF_ALBERTA);
		codes.put("bod", StandardGeoRegions.China.XIZANG_ZIZHIQU);
		codes.put("bos", StandardGeoRegions.BOSNIA_AND_HERZEGOVINA);
		codes.put("bra", StandardGeoRegions.INDIA);
		codes.put("bre", StandardGeoRegions.France.REGION_DE_BRETAGNE);
		codes.put("bua", StandardGeoRegions.Russia.RESPUBLIKA_BURYATIYA);
		codes.put("bug", StandardGeoRegions.INDONESIA);
		codes.put("bul", StandardGeoRegions.BULGARIA);
		codes.put("byn", StandardGeoRegions.ERITREA);
		codes.put("cad", StandardGeoRegions.UnitedStates.STATE_OF_OKLAHOMA);
		codes.put("car", StandardGeoRegions.VENEZUELA);
		codes.put("cat", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_CATALUNA);
		codes.put("ceb", StandardGeoRegions.PHILIPPINES);
		codes.put("ces", StandardGeoRegions.CZECH_REPUBLIC);
		codes.put("cha", StandardGeoRegions.GUAM);
		codes.put("che", StandardGeoRegions.Russia.RESPUBLIKA_CHECHNYA);
		codes.put("chk", StandardGeoRegions.FEDERATED_STATES_OF_MICRONESIA);
		codes.put("chm", StandardGeoRegions.Russia.RESPUBLIKA_MARIY_EL);
		codes.put("chn", StandardGeoRegions.Canada.PROVINCE_OF_BRITISH_COLUMBIA);
		codes.put("cho", StandardGeoRegions.UnitedStates.STATE_OF_OKLAHOMA);
		codes.put("chp", StandardGeoRegions.CANADA);
		codes.put("chr", StandardGeoRegions.UnitedStates.STATE_OF_OKLAHOMA);
		codes.put("chv", StandardGeoRegions.Russia.RESPUBLIKA_CHUVASHIYA);
		codes.put("chy", StandardGeoRegions.UnitedStates.STATE_OF_MONTANA);
		codes.put("cor", StandardGeoRegions.UnitedKingdom.COUNTY_OF_CORNWALL);
		codes.put("cos", StandardGeoRegions.France.REGION_DE_CORSE);
		codes.put("cre", StandardGeoRegions.Canada.NORTHWEST_TERRITORIES);
		codes.put("crh", StandardGeoRegions.Ukraine.AVTONOMNA_RESPUBLIKA_KRYM);
		codes.put("csb", StandardGeoRegions.Poland.WOJEWODZTWO_POMORSKIE);
		codes.put("cym", StandardGeoRegions.UnitedKingdom.COUNTRY_OF_WALES);
		codes.put("dak", StandardGeoRegions.UNITED_STATES);
		codes.put("dan", StandardGeoRegions.DENMARK);
		codes.put("dar", StandardGeoRegions.Russia.RESPUBLIKA_DAGESTAN);
		codes.put("del", StandardGeoRegions.UnitedStates.STATE_OF_DELAWARE);
		codes.put("den", StandardGeoRegions.Canada.NORTHWEST_TERRITORIES);
		codes.put("deu", StandardGeoRegions.GERMANY);
		codes.put("dgr", StandardGeoRegions.Canada.NORTHWEST_TERRITORIES);
		codes.put("din", StandardGeoRegions.SOUTH_SUDAN);
		codes.put("div", StandardGeoRegions.MALDIVES);
		codes.put("doi", StandardGeoRegions.INDIA);
		codes.put("dsb", StandardGeoRegions.Germany.LAND_BRANDENBURG);
		codes.put("dua", StandardGeoRegions.CAMEROON);
		codes.put("dyu", StandardGeoRegions.IVORY_COAST);
		codes.put("dzo", StandardGeoRegions.BHUTAN);
		codes.put("efi", StandardGeoRegions.NIGERIA);
		codes.put("eka", StandardGeoRegions.NIGERIA);
		codes.put("ell", StandardGeoRegions.GREECE);
		codes.put("eng", StandardGeoRegions.UNITED_KINGDOM);
		codes.put("est", StandardGeoRegions.ESTONIA);
		codes.put("eus", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DEL_PAIS_VASCO);
		codes.put("ewe", StandardGeoRegions.GHANA);
		codes.put("ewo", StandardGeoRegions.CAMEROON);
		codes.put("fan", StandardGeoRegions.EQUATORIAL_GUINEA);
		codes.put("fao", StandardGeoRegions.FAROE_ISLANDS);
		codes.put("fas", StandardGeoRegions.IRAN);
		codes.put("fat", StandardGeoRegions.GHANA);
		codes.put("fij", StandardGeoRegions.FIJI);
		codes.put("fil", StandardGeoRegions.PHILIPPINES);
		codes.put("fin", StandardGeoRegions.FINLAND);
		codes.put("fon", StandardGeoRegions.BENIN);
		codes.put("fra", StandardGeoRegions.FRANCE);
		codes.put("frr", StandardGeoRegions.Germany.LAND_SCHLESWIG_HOLSTEIN);
		codes.put("frs", StandardGeoRegions.Germany.LAND_NIEDERSACHSEN);
		codes.put("fry", StandardGeoRegions.Netherlands.PROVINCIE_FRIESLAND);
		codes.put("ful", StandardGeoRegions.SENEGAL);
		codes.put("fur", StandardGeoRegions.Italy.REGIONE_AUTONOMA_FRIULI_VENEZIA_GIULIA);
		codes.put("gaa", StandardGeoRegions.GHANA);
		codes.put("gay", StandardGeoRegions.INDONESIA);
		codes.put("gba", StandardGeoRegions.CENTRAL_AFRICAN_REPUBLIC);
		codes.put("gez", StandardGeoRegions.ETHIOPIA);
		codes.put("gil", StandardGeoRegions.KIRIBATI);
		codes.put("gla", StandardGeoRegions.UnitedKingdom.COUNTRY_OF_SCOTLAND);
		codes.put("gle", StandardGeoRegions.REPUBLIC_OF_IRELAND);
		codes.put("glg", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_GALICIA);
		codes.put("glv", StandardGeoRegions.ISLE_OF_MAN);
		codes.put("gon", StandardGeoRegions.INDIA);
		codes.put("gor", StandardGeoRegions.INDONESIA);
		codes.put("grb", StandardGeoRegions.LIBERIA);
		codes.put("grn", StandardGeoRegions.PARAGUAY);
		codes.put("gsw", StandardGeoRegions.SWITZERLAND);
		codes.put("guj", StandardGeoRegions.INDIA);
		codes.put("gwi", StandardGeoRegions.Canada.NORTHWEST_TERRITORIES);
		codes.put("hai", StandardGeoRegions.Canada.PROVINCE_OF_BRITISH_COLUMBIA);
		codes.put("hat", StandardGeoRegions.HAITI);
		codes.put("hau", StandardGeoRegions.NIGERIA);
		codes.put("haw", StandardGeoRegions.UnitedStates.STATE_OF_HAWAII);
		codes.put("heb", StandardGeoRegions.ISRAEL);
		codes.put("her", StandardGeoRegions.NAMIBIA);
		codes.put("hil", StandardGeoRegions.PHILIPPINES);
		codes.put("hin", StandardGeoRegions.INDIA);
		codes.put("hmn", StandardGeoRegions.CHINA);
		codes.put("hmo", StandardGeoRegions.PAPUA_NEW_GUINEA);
		codes.put("hrv", StandardGeoRegions.CROATIA);
		codes.put("hsb", StandardGeoRegions.Germany.FREISTAAT_SACHSEN);
		codes.put("hun", StandardGeoRegions.HUNGARY);
		codes.put("hup", StandardGeoRegions.UnitedStates.STATE_OF_CALIFORNIA);
		codes.put("hye", StandardGeoRegions.ARMENIA);
		codes.put("iba", StandardGeoRegions.MALAYSIA);
		codes.put("ibo", StandardGeoRegions.NIGERIA);
		codes.put("iii", StandardGeoRegions.CHINA);
		codes.put("iku", StandardGeoRegions.CANADA);
		codes.put("ilo", StandardGeoRegions.PHILIPPINES);
		codes.put("ind", StandardGeoRegions.INDONESIA);
		codes.put("inh", StandardGeoRegions.Russia.RESPUBLIKA_INGUSHETIYA);
		codes.put("ipk", StandardGeoRegions.UnitedStates.STATE_OF_ALASKA);
		codes.put("isl", StandardGeoRegions.ICELAND);
		codes.put("ita", StandardGeoRegions.ITALY);
		codes.put("jav", StandardGeoRegions.INDONESIA);
		codes.put("jpn", StandardGeoRegions.JAPAN);
		codes.put("jpr", StandardGeoRegions.Israel.MAHOZ_YERUSHALAYIM);
		codes.put("jrb", StandardGeoRegions.ISRAEL);
		codes.put("kaa", StandardGeoRegions.UZBEKISTAN);
		codes.put("kab", StandardGeoRegions.ALGERIA);
		codes.put("kac", StandardGeoRegions.MYANMAR);
		codes.put("kal", StandardGeoRegions.GREENLAND);
		codes.put("kam", StandardGeoRegions.KENYA);
		codes.put("kan", StandardGeoRegions.INDIA);
		codes.put("kas", StandardGeoRegions.INDIA);
		codes.put("kat", StandardGeoRegions.GEORGIA);
		codes.put("kau", StandardGeoRegions.NIGERIA);
		codes.put("kaz", StandardGeoRegions.KAZAKHSTAN);
		codes.put("kbd", StandardGeoRegions.Russia.RESPUBLIKA_KABARDINO_BALKARIYA);
		codes.put("kha", StandardGeoRegions.INDIA);
		codes.put("khm", StandardGeoRegions.CAMBODIA);
		codes.put("kik", StandardGeoRegions.KENYA);
		codes.put("kin", StandardGeoRegions.RWANDA);
		codes.put("kir", StandardGeoRegions.KYRGYZSTAN);
		codes.put("kmb", StandardGeoRegions.ANGOLA);
		codes.put("kok", StandardGeoRegions.INDIA);
		codes.put("kom", StandardGeoRegions.Russia.RESPUBLIKA_KOMI);
		codes.put("kon", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("kor", StandardGeoRegions.SOUTH_KOREA);
		codes.put("kos", StandardGeoRegions.FEDERATED_STATES_OF_MICRONESIA);
		codes.put("kpe", StandardGeoRegions.LIBERIA);
		codes.put("krc", StandardGeoRegions.Russia.RESPUBLIKA_KARACHAYEVO_CHERKESIYA);
		codes.put("krl", StandardGeoRegions.Russia.RESPUBLIKA_KARELIYA);
		codes.put("kru", StandardGeoRegions.INDIA);
		codes.put("kua", StandardGeoRegions.ANGOLA);
		codes.put("kum", StandardGeoRegions.Russia.RESPUBLIKA_DAGESTAN);
		codes.put("kur", StandardGeoRegions.Iraq.IQLIM_KURDISTAN);
		codes.put("kut", StandardGeoRegions.Canada.PROVINCE_OF_BRITISH_COLUMBIA);
		codes.put("lad", StandardGeoRegions.Israel.MAHOZ_YERUSHALAYIM);
		codes.put("lah", StandardGeoRegions.PAKISTAN);
		codes.put("lam", StandardGeoRegions.ZAMBIA);
		codes.put("lao", StandardGeoRegions.LAOS);
		codes.put("lav", StandardGeoRegions.LATVIA);
		codes.put("lez", StandardGeoRegions.Russia.RESPUBLIKA_DAGESTAN);
		codes.put("lim", StandardGeoRegions.Netherlands.PROVINCIE_LIMBURG);
		codes.put("lin", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("lit", StandardGeoRegions.LITHUANIA);
		codes.put("lol", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("loz", StandardGeoRegions.ZAMBIA);
		codes.put("ltz", StandardGeoRegions.LUXEMBOURG);
		codes.put("lua", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("lub", StandardGeoRegions.DEMOCRATIC_REPUBLIC_OF_THE_CONGO);
		codes.put("lug", StandardGeoRegions.UGANDA);
		codes.put("lui", StandardGeoRegions.UnitedStates.STATE_OF_CALIFORNIA);
		codes.put("lun", StandardGeoRegions.ZAMBIA);
		codes.put("luo", StandardGeoRegions.KENYA);
		codes.put("lus", StandardGeoRegions.INDIA);
		codes.put("mad", StandardGeoRegions.INDONESIA);
		codes.put("mag", StandardGeoRegions.INDIA);
		codes.put("mah", StandardGeoRegions.MARSHALL_ISLANDS);
		codes.put("mai", StandardGeoRegions.INDIA);
		codes.put("mak", StandardGeoRegions.INDONESIA);
		codes.put("mal", StandardGeoRegions.INDIA);
		codes.put("man", StandardGeoRegions.GUINEA);
		codes.put("mar", StandardGeoRegions.INDIA);
		codes.put("mas", StandardGeoRegions.KENYA);
		codes.put("mdf", StandardGeoRegions.Russia.RESPUBLIKA_MORDOVIYA);
		codes.put("mdr", StandardGeoRegions.INDONESIA);
		codes.put("men", StandardGeoRegions.SIERRA_LEONE);
		codes.put("mic", StandardGeoRegions.Canada.PROVINCE_OF_NOVA_SCOTIA);
		codes.put("min", StandardGeoRegions.INDONESIA);
		codes.put("mkd", StandardGeoRegions.REPUBLIC_OF_MACEDONIA);
		codes.put("mlg", StandardGeoRegions.MADAGASCAR);
		codes.put("mlt", StandardGeoRegions.MALTA);
		codes.put("mnc", StandardGeoRegions.CHINA);
		codes.put("mni", StandardGeoRegions.INDIA);
		codes.put("moh", StandardGeoRegions.Canada.PROVINCE_OF_ONTARIO);
		codes.put("mon", StandardGeoRegions.MONGOLIA);
		codes.put("mos", StandardGeoRegions.BURKINA_FASO);
		codes.put("mri", StandardGeoRegions.NEW_ZEALAND);
		codes.put("msa", StandardGeoRegions.MALAYSIA);
		codes.put("mus", StandardGeoRegions.UnitedStates.STATE_OF_OKLAHOMA);
		codes.put("mwl", StandardGeoRegions.Portugal.DISTRITO_DE_BRAGANCA);
		codes.put("mwr", StandardGeoRegions.INDIA);
		codes.put("mya", StandardGeoRegions.MYANMAR);
		codes.put("myv", StandardGeoRegions.RUSSIA);
		codes.put("nap", StandardGeoRegions.Italy.CITTA_METROPOLITANA_DI_NAPOLI);
		codes.put("nau", StandardGeoRegions.NAURU);
		codes.put("nav", StandardGeoRegions.UNITED_STATES);
		codes.put("nbl", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("nde", StandardGeoRegions.ZIMBABWE);
		codes.put("ndo", StandardGeoRegions.NAMIBIA);
		codes.put("nds", StandardGeoRegions.Germany.LAND_NIEDERSACHSEN);
		codes.put("nep", StandardGeoRegions.NEPAL);
		codes.put("new", StandardGeoRegions.NEPAL);
		codes.put("nia", StandardGeoRegions.INDONESIA);
		codes.put("niu", StandardGeoRegions.NIUE);
		codes.put("nld", StandardGeoRegions.NETHERLANDS);
		codes.put("nno", StandardGeoRegions.NORWAY);
		codes.put("nob", StandardGeoRegions.NORWAY);
		codes.put("nog", StandardGeoRegions.RUSSIA);
		codes.put("nor", StandardGeoRegions.NORWAY);
		codes.put("nqo", StandardGeoRegions.GUINEA);
		codes.put("nso", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("nya", StandardGeoRegions.MALAWI);
		codes.put("nym", StandardGeoRegions.TANZANIA);
		codes.put("nyn", StandardGeoRegions.UGANDA);
		codes.put("nyo", StandardGeoRegions.UGANDA);
		codes.put("nzi", StandardGeoRegions.GHANA);
		codes.put("oci", StandardGeoRegions.Spain.COMUNIDAD_AUTONOMA_DE_CATALUNA);
		codes.put("oji", StandardGeoRegions.CANADA);
		codes.put("ori", StandardGeoRegions.INDIA);
		codes.put("orm", StandardGeoRegions.ETHIOPIA);
		codes.put("osa", StandardGeoRegions.UnitedStates.STATE_OF_OKLAHOMA);
		codes.put("oss", StandardGeoRegions.Russia.RESPUBLIKA_SEVERNAYA_OSETIYA_ALANIYA);
		codes.put("pag", StandardGeoRegions.PHILIPPINES);
		codes.put("pam", StandardGeoRegions.PHILIPPINES);
		codes.put("pan", StandardGeoRegions.INDIA);
		codes.put("pap", StandardGeoRegions.CURACAO);
		codes.put("pau", StandardGeoRegions.PALAU);
		codes.put("pol", StandardGeoRegions.POLAND);
		codes.put("pon", StandardGeoRegions.FEDERATED_STATES_OF_MICRONESIA);
		codes.put("por", StandardGeoRegions.PORTUGAL);
		codes.put("pus", StandardGeoRegions.PAKISTAN);
		codes.put("que", StandardGeoRegions.PERU);
		codes.put("raj", StandardGeoRegions.INDIA);
		codes.put("rap", StandardGeoRegions.CHILE);
		codes.put("rar", StandardGeoRegions.COOK_ISLANDS);
		codes.put("roh", StandardGeoRegions.Switzerland.KANTON_GRAUBUENDEN);
		codes.put("rom", StandardGeoRegions.ROMANIA);
		codes.put("ron", StandardGeoRegions.ROMANIA);
		codes.put("run", StandardGeoRegions.BURUNDI);
		codes.put("rup", StandardGeoRegions.GREECE);
		codes.put("rus", StandardGeoRegions.RUSSIA);
		codes.put("sad", StandardGeoRegions.TANZANIA);
		codes.put("sag", StandardGeoRegions.CENTRAL_AFRICAN_REPUBLIC);
		codes.put("sah", StandardGeoRegions.Russia.RESPUBLIKA_SAKHA);
		codes.put("sam", StandardGeoRegions.PALESTINE);
		codes.put("san", StandardGeoRegions.INDIA);
		codes.put("sas", StandardGeoRegions.INDONESIA);
		codes.put("sat", StandardGeoRegions.INDIA);
		codes.put("scn", StandardGeoRegions.Italy.REGIONE_SICILIANA);
		codes.put("sco", StandardGeoRegions.UnitedKingdom.COUNTRY_OF_SCOTLAND);
		codes.put("sel", StandardGeoRegions.RUSSIA);
		codes.put("shn", StandardGeoRegions.MYANMAR);
		codes.put("sid", StandardGeoRegions.ETHIOPIA);
		codes.put("sin", StandardGeoRegions.SRI_LANKA);
		codes.put("slk", StandardGeoRegions.SLOVAKIA);
		codes.put("slv", StandardGeoRegions.SLOVENIA);
		codes.put("sma", StandardGeoRegions.Sweden.JÄMTLANDS_LAN);
		codes.put("sme", StandardGeoRegions.NORWAY);
		codes.put("smj", StandardGeoRegions.Sweden.NORRBOTTENS_LAN);
		codes.put("smn", StandardGeoRegions.Finland.LAPIN_MAAKUNTA);
		codes.put("smo", StandardGeoRegions.SAMOA);
		codes.put("sms", StandardGeoRegions.Finland.LAPIN_MAAKUNTA);
		codes.put("sna", StandardGeoRegions.ZIMBABWE);
		codes.put("snd", StandardGeoRegions.PAKISTAN);
		codes.put("snk", StandardGeoRegions.MALI);
		codes.put("som", StandardGeoRegions.SOMALIA);
		codes.put("sot", StandardGeoRegions.LESOTHO);
		codes.put("spa", StandardGeoRegions.SPAIN);
		codes.put("sqi", StandardGeoRegions.ALBANIA);
		codes.put("srd", StandardGeoRegions.Italy.REGIONE_AUTONOMA_DELLA_SARDEGNA);
		codes.put("srn", StandardGeoRegions.SURINAME);
		codes.put("srp", StandardGeoRegions.SERBIA);
		codes.put("srr", StandardGeoRegions.SENEGAL);
		codes.put("ssw", StandardGeoRegions.SWAZILAND);
		codes.put("suk", StandardGeoRegions.TANZANIA);
		codes.put("sun", StandardGeoRegions.INDONESIA);
		codes.put("sus", StandardGeoRegions.GUINEA);
		codes.put("swa", StandardGeoRegions.TANZANIA);
		codes.put("swe", StandardGeoRegions.SWEDEN);
		codes.put("syr", StandardGeoRegions.IRAQ);
		codes.put("tah", StandardGeoRegions.FRENCH_POLYNESIA);
		codes.put("tam", StandardGeoRegions.INDIA);
		codes.put("tat", StandardGeoRegions.Russia.RESPUBLIKA_TATARSTAN);
		codes.put("tel", StandardGeoRegions.INDIA);
		codes.put("tem", StandardGeoRegions.SIERRA_LEONE);
		codes.put("ter", StandardGeoRegions.Brazil.ESTADO_DE_MATO_GROSSO_DO_SUL);
		codes.put("tet", StandardGeoRegions.INDONESIA);
		codes.put("tgk", StandardGeoRegions.TAJIKISTAN);
		codes.put("tgl", StandardGeoRegions.PHILIPPINES);
		codes.put("tha", StandardGeoRegions.THAILAND);
		codes.put("tig", StandardGeoRegions.ERITREA);
		codes.put("tir", StandardGeoRegions.ETHIOPIA);
		codes.put("tiv", StandardGeoRegions.NIGERIA);
		codes.put("tkl", StandardGeoRegions.TOKELAU);
		codes.put("tli", StandardGeoRegions.UnitedStates.STATE_OF_ALASKA);
		codes.put("tmh", StandardGeoRegions.MALI);
		codes.put("tog", StandardGeoRegions.MALAWI);
		codes.put("ton", StandardGeoRegions.TONGA);
		codes.put("tpi", StandardGeoRegions.PAPUA_NEW_GUINEA);
		codes.put("tsi", StandardGeoRegions.Canada.PROVINCE_OF_BRITISH_COLUMBIA);
		codes.put("tsn", StandardGeoRegions.BOTSWANA);
		codes.put("tso", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("tuk", StandardGeoRegions.TURKMENISTAN);
		codes.put("tum", StandardGeoRegions.MALAWI);
		codes.put("tur", StandardGeoRegions.TURKEY);
		codes.put("tvl", StandardGeoRegions.TUVALU);
		codes.put("twi", StandardGeoRegions.GHANA);
		codes.put("tyv", StandardGeoRegions.Russia.RESPUBLIKA_TYVA);
		codes.put("udm", StandardGeoRegions.Russia.RESPUBLIKA_UDMURTIYA);
		codes.put("uig", StandardGeoRegions.CHINA);
		codes.put("ukr", StandardGeoRegions.UKRAINE);
		codes.put("umb", StandardGeoRegions.ANGOLA);
		codes.put("urd", StandardGeoRegions.PAKISTAN);
		codes.put("uzb", StandardGeoRegions.UZBEKISTAN);
		codes.put("vai", StandardGeoRegions.LIBERIA);
		codes.put("ven", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("vie", StandardGeoRegions.VIETNAM);
		codes.put("vot", StandardGeoRegions.RUSSIA);
		codes.put("wal", StandardGeoRegions.ETHIOPIA);
		codes.put("war", StandardGeoRegions.PHILIPPINES);
		codes.put("was", StandardGeoRegions.UnitedStates.STATE_OF_CALIFORNIA);
		codes.put("wln", StandardGeoRegions.Belgium.REGION_WALLONNE);
		codes.put("wol", StandardGeoRegions.SENEGAL);
		codes.put("xal", StandardGeoRegions.Russia.RESPUBLIKA_KALMYKIYA);
		codes.put("xho", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("yao", StandardGeoRegions.MALAWI);
		codes.put("yap", StandardGeoRegions.FEDERATED_STATES_OF_MICRONESIA);
		codes.put("yid", StandardGeoRegions.ISRAEL);
		codes.put("yor", StandardGeoRegions.NIGERIA);
		codes.put("zap", StandardGeoRegions.MEXICO);
		codes.put("zen", StandardGeoRegions.MAURITANIA);
		codes.put("zgh", StandardGeoRegions.MOROCCO);
		codes.put("zha", StandardGeoRegions.CHINA);
		codes.put("zho", StandardGeoRegions.CHINA);
		codes.put("zul", StandardGeoRegions.SOUTH_AFRICA);
		codes.put("zun", StandardGeoRegions.UnitedStates.STATE_OF_NEW_MEXICO);
		codes.put("zza", StandardGeoRegions.TURKEY);

		languageCodes = Collections.unmodifiableMap(codes);
	}


	private GeoRegionUtils() {
		// Utility class, not to be instantiated
	}


	static String regionCodeFromCountry() {
		Locale defaultLocale = Locale.getDefault();
		String countryCode = defaultLocale.getCountry();

		// ISO 3166 alpha-2 country code
		if (countryCode.matches("[a-zA-Z]{2}")) {
			return countryCode.toUpperCase(Locale.ROOT);
		}

		// UN M.49 numeric-3 area code
		if (countryCode.matches("[0-9]{3}")) {
			return countryCodes.get(countryCode);
		}

		return null;
	}

	static String regionCodeFromLanguage() {
		Locale defaultLocale = Locale.getDefault();
		String languageCode = defaultLocale.getLanguage();

		// ISO 639 alpha-2 code
		if (languageCode.matches("[a-zA-Z]{2}")) {
			return languageCodes.get(languageCode);
		}

		// ISO 639 alpha-3 code
		if (languageCode.matches("[a-zA-Z]{3}")) {
			return languageCodes.get(languageCode);
		}

		return null;
	}

}
