/*
 * Copyright (c) 2015-2018 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.geotemporal.geography;

/**
 * Standard {@link GeoRegion}s.
 *
 * @since 1.0
 */
public class StandardGeoRegions {

	// see http://www.geopostcodes.com/index.php?pg=resources&file=ISO_3166_2_Regions_codes

	/**
	 * Region code of Afghanistan.
	 *
	 * @since 1.0
	 */
	public static final String AFGHANISTAN = "AF";

	/**
	 * Region code of the Åland Islands.
	 *
	 * @since 1.0
	 */
	public static final String ALAND_ISLANDS = "AX";

	/**
	 * Region code of Albania.
	 *
	 * @since 1.0
	 */
	public static final String ALBANIA = "AL";

	/**
	 * Region code of Algeria.
	 *
	 * @since 1.0
	 */
	public static final String ALGERIA = "DZ";

	/**
	 * Region code of American Samoa.
	 *
	 * @since 1.0
	 */
	public static final String AMERICAN_SAMOA = "AS";

	/**
	 * Region code of Andorra.
	 *
	 * @since 1.0
	 */
	public static final String ANDORRA = "AD";

	/**
	 * Region code of Angola.
	 *
	 * @since 1.0
	 */
	public static final String ANGOLA = "AO";

	/**
	 * Region code of Anguilla.
	 *
	 * @since 1.0
	 */
	public static final String ANGUILLA = "AI";

	/**
	 * Region code of Antarctica.
	 *
	 * @since 1.0
	 */
	public static final String ANTARCTICA = "AQ";

	/**
	 * Region code of Antigua and Barbuda.
	 *
	 * @since 1.0
	 */
	public static final String ANTIGUA_AND_BARBUDA = "AG";

	/**
	 * Region code of Argentina.
	 *
	 * @since 1.0
	 */
	public static final String ARGENTINA = "AR";

	/**
	 * Region code of Armenia.
	 *
	 * @since 1.0
	 */
	public static final String ARMENIA = "AM";

	/**
	 * Region code of Aruba.
	 *
	 * @since 1.0
	 */
	public static final String ARUBA = "AW";

	/**
	 * Region code of Australia.
	 *
	 * @since 1.0
	 */
	public static final String AUSTRALIA = "AU";

	/**
	 * Region code of Austria.
	 *
	 * @since 1.0
	 */
	public static final String AUSTRIA = "AT";

	/**
	 * Region code of Azerbaijan.
	 *
	 * @since 1.0
	 */
	public static final String AZERBAIJAN = "AZ";

	/**
	 * Region code of the Bahamas.
	 *
	 * @since 1.0
	 */
	public static final String BAHAMAS = "BS";

	/**
	 * Region code of Bahrain.
	 *
	 * @since 1.0
	 */
	public static final String BAHRAIN = "BH";

	/**
	 * Region code of Bangladesh.
	 *
	 * @since 1.0
	 */
	public static final String BANGLADESH = "BD";

	/**
	 * Region code of Barbados.
	 *
	 * @since 1.0
	 */
	public static final String BARBADOS = "BB";

	/**
	 * Region code of Belarus.
	 *
	 * @since 1.0
	 */
	public static final String BELARUS = "BY";

	/**
	 * Region code of Belgium.
	 *
	 * @since 1.0
	 */
	public static final String BELGIUM = "BE";

	/**
	 * Region code of Belize.
	 *
	 * @since 1.0
	 */
	public static final String BELIZE = "BZ";

	/**
	 * Region code of Benin (previously known as Dahomey).
	 *
	 * @since 1.0
	 */
	public static final String BENIN = "BJ";

	/**
	 * Region code of Bermuda.
	 *
	 * @since 1.0
	 */
	public static final String BERMUDA = "BM";

	/**
	 * Region code of Bhutan.
	 *
	 * @since 1.0
	 */
	public static final String BHUTAN = "BT";

	/**
	 * Region code of Bolivia.
	 *
	 * @since 1.0
	 */
	public static final String BOLIVIA = "BO";

	/**
	 * Region code of Bonaire, Sint Eustatius and Saba (also known as Caribbean Netherlands).
	 *
	 * @since 1.0
	 */
	public static final String BONAIRE_SINT_EUSTATIUS_AND_SABA = "BQ";

	/**
	 * Region code of Bosnia and Herzegovina.
	 *
	 * @since 1.0
	 */
	public static final String BOSNIA_AND_HERZEGOVINA = "BA";

	/**
	 * Region code of Botswana.
	 *
	 * @since 1.0
	 */
	public static final String BOTSWANA = "BW";

	/**
	 * Region code of Bouvet Island.
	 *
	 * @since 1.0
	 */
	public static final String BOUVET_ISLAND = "BV";

	/**
	 * Region code of Brazil.
	 *
	 * @since 1.0
	 */
	public static final String BRAZIL = "BR";

	/**
	 * Region code of British Indian Ocean Territory.
	 *
	 * @since 1.0
	 */
	public static final String BRITISH_INDIAN_OCEAN_TERRITORY = "IO";

	/**
	 * Region code of British Virgin Islands.
	 *
	 * @since 1.0
	 */
	public static final String BRITISH_VIRGIN_ISLANDS = "VG";

	/**
	 * Region code of Brunei Darussalam.
	 *
	 * @since 1.0
	 */
	public static final String BRUNEI_DARUSSALAM = "BN";

	/**
	 * Region code of Bulgaria.
	 *
	 * @since 1.0
	 */
	public static final String BULGARIA = "BG";

	/**
	 * Region code of Burkina Faso (previously known as Upper Volta).
	 *
	 * @since 1.0
	 */
	public static final String BURKINA_FASO = "BF";

	/**
	 * Region code of Burundi.
	 *
	 * @since 1.0
	 */
	public static final String BURUNDI = "BI";

	/**
	 * Region code of Cambodia (previously known as Kampuchea).
	 *
	 * @since 1.0
	 */
	public static final String CAMBODIA = "KH";

	/**
	 * Region code of Cameroon.
	 *
	 * @since 1.0
	 */
	public static final String CAMEROON = "CM";

	/**
	 * Region code of Canada.
	 *
	 * @since 1.0
	 */
	public static final String CANADA = "CA";

	/**
	 * Region code of Cabo Verde (also known as Cape Verde).
	 *
	 * @since 1.0
	 */
	public static final String CAPE_VERDE = "CV";

	/**
	 * Region code of Cayman Islands.
	 *
	 * @since 1.0
	 */
	public static final String CAYMAN_ISLANDS = "KY";

	/**
	 * Region code of Central African Republic.
	 *
	 * @since 1.0
	 */
	public static final String CENTRAL_AFRICAN_REPUBLIC = "CF";

	/**
	 * Region code of Chad.
	 *
	 * @since 1.0
	 */
	public static final String CHAD = "TD";

	/**
	 * Region code of Chile.
	 *
	 * @since 1.0
	 */
	public static final String CHILE = "CL";

	/**
	 * Region code of the People's Republic of China (also known as China).
	 *
	 * @since 1.0
	 */
	public static final String CHINA = "CN";

	/**
	 * Region code of Christmas Island.
	 *
	 * @since 1.0
	 */
	public static final String CHRISTMAS_ISLAND = "CX";

	/**
	 * Region code of Cocos (Keeling) Islands.
	 *
	 * @since 1.0
	 */
	public static final String COCOS_ISLANDS = "CC";

	/**
	 * Region code of Colombia.
	 *
	 * @since 1.0
	 */
	public static final String COLOMBIA = "CO";

	/**
	 * Region code of the Comoros.
	 *
	 * @since 1.0
	 */
	public static final String COMOROS = "KM";

	/**
	 * Region code of Cook Islands.
	 *
	 * @since 1.0
	 */
	public static final String COOK_ISLANDS = "CK";

	/**
	 * Region code of Costa Rica.
	 *
	 * @since 1.0
	 */
	public static final String COSTA_RICA = "CR";

	/**
	 * Region code of Croatia.
	 *
	 * @since 1.0
	 */
	public static final String CROATIA = "HR";

	/**
	 * Region code of Cuba.
	 *
	 * @since 1.0
	 */
	public static final String CUBA = "CU";

	/**
	 * Region code of Curaçao.
	 *
	 * @since 1.0
	 */
	public static final String CURACAO = "CW";

	/**
	 * Region code of Cyprus.
	 *
	 * @since 1.0
	 */
	public static final String CYPRUS = "CY";

	/**
	 * Region code of the Czech Republic.
	 *
	 * @since 1.0
	 */
	public static final String CZECH_REPUBLIC = "CZ";

	/**
	 * Region code of Denmark.
	 *
	 * @since 1.0
	 */
	public static final String DENMARK = "DK";

	/**
	 * Region code of the Democratic Republic of the Congo (previously known as Zaire).
	 *
	 * @since 1.0
	 */
	public static final String DEMOCRATIC_REPUBLIC_OF_THE_CONGO = "CD";

	/**
	 * Region code of Djibouti (previously known as French Afar and Issas).
	 *
	 * @since 1.0
	 */
	public static final String DJIBOUTI = "DJ";

	/**
	 * Region code of Dominica.
	 *
	 * @since 1.0
	 */
	public static final String DOMINICA = "DM";

	/**
	 * Region code of the Dominican Republic.
	 *
	 * @since 1.0
	 */
	public static final String DOMINICAN_REPUBLIC = "DO";

	/**
	 * Region code of Timor-Leste (also known as East Timor).
	 *
	 * @since 1.0
	 */
	public static final String EAST_TIMOR = "TL";

	/**
	 * Region code of Ecuador.
	 *
	 * @since 1.0
	 */
	public static final String ECUADOR = "EC";

	/**
	 * Region code of Egypt.
	 *
	 * @since 1.0
	 */
	public static final String EGYPT = "EG";

	/**
	 * Region code of El Salvador.
	 *
	 * @since 1.0
	 */
	public static final String EL_SALVADOR = "SV";

	/**
	 * Region code of Equatorial Guinea.
	 *
	 * @since 1.0
	 */
	public static final String EQUATORIAL_GUINEA = "GQ";

	/**
	 * Region code of Eritrea.
	 *
	 * @since 1.0
	 */
	public static final String ERITREA = "ER";

	/**
	 * Region code of Estonia.
	 *
	 * @since 1.0
	 */
	public static final String ESTONIA = "EE";

	/**
	 * Region code of Ethiopia.
	 *
	 * @since 1.0
	 */
	public static final String ETHIOPIA = "ET";

	/**
	 * Region code of Falkland Islands.
	 *
	 * @since 1.0
	 */
	public static final String FALKLAND_ISLANDS = "FK";

	/**
	 * Region code of Faroe Islands.
	 *
	 * @since 1.0
	 */
	public static final String FAROE_ISLANDS = "FO";

	/**
	 * Region code of the Federated States of Micronesia.
	 *
	 * @since 1.0
	 */
	public static final String FEDERATED_STATES_OF_MICRONESIA = "FM";

	/**
	 * Region code of Fiji.
	 *
	 * @since 1.0
	 */
	public static final String FIJI = "FJ";

	/**
	 * Region code of Finland.
	 *
	 * @since 1.0
	 */
	public static final String FINLAND = "FI";

	/**
	 * Region code of France.
	 *
	 * @since 1.0
	 */
	public static final String FRANCE = "FR";

	/**
	 * Region code of French Guiana.
	 *
	 * @since 1.0
	 */
	public static final String FRENCH_GUIANA = "GF";

	/**
	 * Region code of French Polynesia.
	 *
	 * @since 1.0
	 */
	public static final String FRENCH_POLYNESIA = "PF";

	/**
	 * Region code of French Southern and Antarctic Lands (also know as French Southern Territories).
	 *
	 * @since 1.0
	 */
	public static final String FRENCH_SOUTHERN_AND_ANTARCTIC_LANDS = "TF";

	/**
	 * Region code of Gabon.
	 *
	 * @since 1.0
	 */
	public static final String GABON = "GA";

	/**
	 * Region code of Gambia.
	 *
	 * @since 1.0
	 */
	public static final String GAMBIA = "GM";

	/**
	 * Region code of Georgia.
	 *
	 * @since 1.0
	 */
	public static final String GEORGIA = "GE";

	/**
	 * Region code of Germany.
	 *
	 * @since 1.0
	 */
	public static final String GERMANY = "DE";

	/**
	 * Region code of Ghana.
	 *
	 * @since 1.0
	 */
	public static final String GHANA = "GH";

	/**
	 * Region code of Gibraltar.
	 *
	 * @since 1.0
	 */
	public static final String GIBRALTAR = "GI";

	/**
	 * Region code of Greece.
	 *
	 * @since 1.0
	 */
	public static final String GREECE = "GR";

	/**
	 * Region code of Greenland.
	 *
	 * @since 1.0
	 */
	public static final String GREENLAND = "GL";

	/**
	 * Region code of Grenada.
	 *
	 * @since 1.0
	 */
	public static final String GRENADA = "GD";

	/**
	 * Region code of Guadeloupe.
	 *
	 * @since 1.0
	 */
	public static final String GUADELOUPE = "GP";

	/**
	 * Region code of Guam.
	 *
	 * @since 1.0
	 */
	public static final String GUAM = "GU";

	/**
	 * Region code of Guatemala.
	 *
	 * @since 1.0
	 */
	public static final String GUATEMALA = "GT";

	/**
	 * Region code of the Bailiwick of Guernsey.
	 *
	 * @since 1.0
	 */
	public static final String GUERNSEY = "GG";

	/**
	 * Region code of Guinea.
	 *
	 * @since 1.0
	 */
	public static final String GUINEA = "GN";

	/**
	 * Region code of Guinea-Bissau.
	 *
	 * @since 1.0
	 */
	public static final String GUINEA_BISSAU = "GW";

	/**
	 * Region code of Guyana.
	 *
	 * @since 1.0
	 */
	public static final String GUYANA = "GY";

	/**
	 * Region code of Haiti.
	 *
	 * @since 1.0
	 */
	public static final String HAITI = "HT";

	/**
	 * Region code of Heard Island and McDonald Islands.
	 *
	 * @since 1.0
	 */
	public static final String HEARD_ISLAND_AND_MCDONALD_ISLANDS = "HM";

	/**
	 * Region code of Honduras.
	 *
	 * @since 1.0
	 */
	public static final String HONDURAS = "HN";

	/**
	 * Region code of Hong Kong.
	 *
	 * @since 1.0
	 */
	public static final String HONG_KONG = "HK";

	/**
	 * Region code of Hungary.
	 *
	 * @since 1.0
	 */
	public static final String HUNGARY = "HU";

	/**
	 * Region code of Iceland.
	 *
	 * @since 1.0
	 */
	public static final String ICELAND = "IS";

	/**
	 * Region code of India.
	 *
	 * @since 1.0
	 */
	public static final String INDIA = "IN";

	/**
	 * Region code of Indonesia.
	 *
	 * @since 1.0
	 */
	public static final String INDONESIA = "ID";

	/**
	 * Region code of Iran.
	 *
	 * @since 1.0
	 */
	public static final String IRAN = "IR";

	/**
	 * Region code of Iraq.
	 *
	 * @since 1.0
	 */
	public static final String IRAQ = "IQ";

	/**
	 * Region code of the Isle of Man.
	 *
	 * @since 1.0
	 */
	public static final String ISLE_OF_MAN = "IM";

	/**
	 * Region code of Israel.
	 *
	 * @since 1.0
	 */
	public static final String ISRAEL = "IL";

	/**
	 * Region code of Italy.
	 *
	 * @since 1.0
	 */
	public static final String ITALY = "IT";

	/**
	 * Region code of Côte d'Ivoire (also known as Ivory Coast).
	 *
	 * @since 1.0
	 */
	public static final String IVORY_COAST = "CI";

	/**
	 * Region code of Jamaica.
	 *
	 * @since 1.0
	 */
	public static final String JAMAICA = "JM";

	/**
	 * Region code of Japan.
	 *
	 * @since 1.0
	 */
	public static final String JAPAN = "JP";

	/**
	 * Region code of the Bailiwick of Jersey.
	 *
	 * @since 1.0
	 */
	public static final String JERSEY = "JE";

	/**
	 * Region code of Jordan.
	 *
	 * @since 1.0
	 */
	public static final String JORDAN = "JO";

	/**
	 * Region code of Kazakhstan.
	 *
	 * @since 1.0
	 */
	public static final String KAZAKHSTAN = "KZ";

	/**
	 * Region code of Kenya.
	 *
	 * @since 1.0
	 */
	public static final String KENYA = "KE";

	/**
	 * Region code of Kiribati.
	 *
	 * @since 1.0
	 */
	public static final String KIRIBATI = "KI";

	/**
	 * Region code of Kuwait.
	 *
	 * @since 1.0
	 */
	public static final String KUWAIT = "KW";

	/**
	 * Region code of Kyrgyzstan.
	 *
	 * @since 1.0
	 */
	public static final String KYRGYZSTAN = "KG";

	/**
	 * Region code of Laos.
	 *
	 * @since 1.0
	 */
	public static final String LAOS = "LA";

	/**
	 * Region code of Latvia.
	 *
	 * @since 1.0
	 */
	public static final String LATVIA = "LV";

	/**
	 * Region code of Lebanon.
	 *
	 * @since 1.0
	 */
	public static final String LEBANON = "LB";

	/**
	 * Region code of Lesotho.
	 *
	 * @since 1.0
	 */
	public static final String LESOTHO = "LS";

	/**
	 * Region code of Liberia.
	 *
	 * @since 1.0
	 */
	public static final String LIBERIA = "LR";

	/**
	 * Region code of Libya.
	 *
	 * @since 1.0
	 */
	public static final String LIBYA = "LY";

	/**
	 * Region code of Liechtenstein.
	 *
	 * @since 1.0
	 */
	public static final String LIECHTENSTEIN = "LI";

	/**
	 * Region code of Lithuania.
	 *
	 * @since 1.0
	 */
	public static final String LITHUANIA = "LT";

	/**
	 * Region code of Luxembourg.
	 *
	 * @since 1.0
	 */
	public static final String LUXEMBOURG = "LU";

	/**
	 * Region code of Macau.
	 *
	 * @since 1.0
	 */
	public static final String MACAU = "MO";

	/**
	 * Region code of Madagascar.
	 *
	 * @since 1.0
	 */
	public static final String MADAGASCAR = "MG";

	/**
	 * Region code of Malaysia.
	 *
	 * @since 1.0
	 */
	public static final String MALAYSIA = "MY";

	/**
	 * Region code of Malawi.
	 *
	 * @since 1.0
	 */
	public static final String MALAWI = "MW";

	/**
	 * Region code of Maldives.
	 *
	 * @since 1.0
	 */
	public static final String MALDIVES = "MV";

	/**
	 * Region code of Mali.
	 *
	 * @since 1.0
	 */
	public static final String MALI = "ML";

	/**
	 * Region code of Malta.
	 *
	 * @since 1.0
	 */
	public static final String MALTA = "MT";

	/**
	 * Region code of the Marshall Islands.
	 *
	 * @since 1.0
	 */
	public static final String MARSHALL_ISLANDS = "MH";

	/**
	 * Region code of Martinique.
	 *
	 * @since 1.0
	 */
	public static final String MARTINIQUE = "MQ";

	/**
	 * Region code of Mauritania.
	 *
	 * @since 1.0
	 */
	public static final String MAURITANIA = "MR";

	/**
	 * Region code of Mauritius.
	 *
	 * @since 1.0
	 */
	public static final String MAURITIUS = "MU";

	/**
	 * Region code of Mayotte.
	 *
	 * @since 1.0
	 */
	public static final String MAYOTTE = "YT";

	/**
	 * Region code of Mexico.
	 *
	 * @since 1.0
	 */
	public static final String MEXICO = "MX";

	/**
	 * Region code of Moldova.
	 *
	 * @since 1.0
	 */
	public static final String MOLDOVA = "MD";

	/**
	 * Region code of Monaco.
	 *
	 * @since 1.0
	 */
	public static final String MONACO = "MC";

	/**
	 * Region code of Mongolia.
	 *
	 * @since 1.0
	 */
	public static final String MONGOLIA = "MN";

	/**
	 * Region code of Montenegro.
	 *
	 * @since 1.0
	 */
	public static final String MONTENEGRO = "ME";

	/**
	 * Region code of Montserrat.
	 *
	 * @since 1.0
	 */
	public static final String MONTSERRAT = "MS";

	/**
	 * Region code of Morocco.
	 *
	 * @since 1.0
	 */
	public static final String MOROCCO = "MA";

	/**
	 * Region code of Mozambique.
	 *
	 * @since 1.0
	 */
	public static final String MOZAMBIQUE = "MZ";

	/**
	 * Region code of Myanmar (previously known as Burma).
	 *
	 * @since 1.0
	 */
	public static final String MYANMAR = "MM";

	/**
	 * Region code of Namibia.
	 *
	 * @since 1.0
	 */
	public static final String NAMIBIA = "NA";

	/**
	 * Region code of Nauru.
	 *
	 * @since 1.0
	 */
	public static final String NAURU = "NR";

	/**
	 * Region code of Nepal.
	 *
	 * @since 1.0
	 */
	public static final String NEPAL = "NP";

	/**
	 * Region code of the Netherlands.
	 *
	 * @since 1.0
	 */
	public static final String NETHERLANDS = "NL";

	/**
	 * Region code of New Caledonia.
	 *
	 * @since 1.0
	 */
	public static final String NEW_CALEDONIA = "NC";

	/**
	 * Region code of New Zealand.
	 *
	 * @since 1.0
	 */
	public static final String NEW_ZEALAND = "NZ";

	/**
	 * Region code of Nicaragua.
	 *
	 * @since 1.0
	 */
	public static final String NICARAGUA = "NI";

	/**
	 * Region code of Niger.
	 *
	 * @since 1.0
	 */
	public static final String NIGER = "NE";

	/**
	 * Region code of Nigeria.
	 *
	 * @since 1.0
	 */
	public static final String NIGERIA = "NG";

	/**
	 * Region code of Niue.
	 *
	 * @since 1.0
	 */
	public static final String NIUE = "NU";

	/**
	 * Region code of Norfolk Island.
	 *
	 * @since 1.0
	 */
	public static final String NORFOLK_ISLAND = "NF";

	/**
	 * Region code of the Democratic People's Republic of Korea (also known as North Korea).
	 *
	 * @since 1.0
	 */
	public static final String NORTH_KOREA = "KP";

	/**
	 * Region code of Northern Mariana Islands.
	 *
	 * @since 1.0
	 */
	public static final String NORTHERN_MARIANA_ISLANDS = "MP";

	/**
	 * Region code of Norway.
	 *
	 * @since 1.0
	 */
	public static final String NORWAY = "NO";

	/**
	 * Region code of Oman.
	 *
	 * @since 1.0
	 */
	public static final String OMAN = "OM";

	/**
	 * Region code of Pakistan.
	 *
	 * @since 1.0
	 */
	public static final String PAKISTAN = "PK";

	/**
	 * Region code of Palau.
	 *
	 * @since 1.0
	 */
	public static final String PALAU = "PW";

	/**
	 * Region code of Palestine.
	 *
	 * @since 1.0
	 */
	public static final String PALESTINE = "PS";

	/**
	 * Region code of Panama.
	 *
	 * @since 1.0
	 */
	public static final String PANAMA = "PA";

	/**
	 * Region code of Papua New Guinea.
	 *
	 * @since 1.0
	 */
	public static final String PAPUA_NEW_GUINEA = "PG";

	/**
	 * Region code of Paraguay.
	 *
	 * @since 1.0
	 */
	public static final String PARAGUAY = "PY";

	/**
	 * Region code of Peru.
	 *
	 * @since 1.0
	 */
	public static final String PERU = "PE";

	/**
	 * Region code of Philippines.
	 *
	 * @since 1.0
	 */
	public static final String PHILIPPINES = "PH";

	/**
	 * Region code of the Pitcairn Islands.
	 *
	 * @since 1.0
	 */
	public static final String PITCAIRN_ISLANDS = "PN";

	/**
	 * Region code of Poland.
	 *
	 * @since 1.0
	 */
	public static final String POLAND = "PL";

	/**
	 * Region code of Portugal.
	 *
	 * @since 1.0
	 */
	public static final String PORTUGAL = "PT";

	/**
	 * Region code of Puerto Rico.
	 *
	 * @since 1.0
	 */
	public static final String PUERTO_RICO = "PR";

	/**
	 * Region code of Qatar.
	 *
	 * @since 1.0
	 */
	public static final String QATAR = "QA";

	/**
	 * Region code of the Republic of Ireland.
	 *
	 * @since 1.0
	 */
	public static final String REPUBLIC_OF_IRELAND = "IE";

	/**
	 * Region code of the Republic of Macedonia.
	 *
	 * @since 1.0
	 */
	public static final String REPUBLIC_OF_MACEDONIA = "MK";

	/**
	 * Region code of the Republic of the Congo.
	 *
	 * @since 1.0
	 */
	public static final String REPUBLIC_OF_THE_CONGO = "CG";

	/**
	 * Region code of Réunion.
	 *
	 * @since 1.0
	 */
	public static final String REUNION = "RE";

	/**
	 * Region code of Romania.
	 *
	 * @since 1.0
	 */
	public static final String ROMANIA = "RO";

	/**
	 * Region code of Russian Federation (also known as Russia).
	 *
	 * @since 1.0
	 */
	public static final String RUSSIA = "RU";

	/**
	 * Region code of Rwanda.
	 *
	 * @since 1.0
	 */
	public static final String RWANDA = "RW";

	/**
	 * Region code of Saint Barthélemy.
	 *
	 * @since 1.0
	 */
	public static final String SAINT_BARTHELEMY = "BL";

	/**
	 * Region code of Saint Helena, Ascension and Tristan da Cunha.
	 *
	 * @since 1.0
	 */
	public static final String SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA = "SH";

	/**
	 * Region code of Saint Kitts and Nevis.
	 *
	 * @since 1.0
	 */
	public static final String SAINT_KITTS_AND_NEVIS = "KN";

	/**
	 * Region code of Saint Lucia.
	 *
	 * @since 1.0
	 */
	public static final String SAINT_LUCIA = "LC";

	/**
	 * Region code of Saint Martin.
	 *
	 * @since 1.0
	 */
	public static final String SAINT_MARTIN = "MF";

	/**
	 * Region code of Saint Pierre and Miquelon.
	 *
	 * @since 1.0
	 */
	public static final String SAINT_PIERRE_AND_MIQUELON = "PM";

	/**
	 * Region code of Saint Vincent and the Grenadines.
	 *
	 * @since 1.0
	 */
	public static final String SAINT_VINCENT_AND_THE_GRENADINES = "VC";

	/**
	 * Region code of Samoa (previously known as Western Samoa).
	 *
	 * @since 1.0
	 */
	public static final String SAMOA = "WS";

	/**
	 * Region code of San Marino.
	 *
	 * @since 1.0
	 */
	public static final String SAN_MARINO = "SM";

	/**
	 * Region code of São Tomé and Príncipe.
	 *
	 * @since 1.0
	 */
	public static final String SAO_TOME_AND_PRINCIPE = "ST";

	/**
	 * Region code of Saudi Arabia.
	 *
	 * @since 1.0
	 */
	public static final String SAUDI_ARABIA = "SA";

	/**
	 * Region code of Senegal.
	 *
	 * @since 1.0
	 */
	public static final String SENEGAL = "SN";

	/**
	 * Region code of Serbia.
	 *
	 * @since 1.0
	 */
	public static final String SERBIA = "RS";

	/**
	 * Region code of Seychelles.
	 *
	 * @since 1.0
	 */
	public static final String SEYCHELLES = "SC";

	/**
	 * Region code of Sierra Leone.
	 *
	 * @since 1.0
	 */
	public static final String SIERRA_LEONE = "SL";

	/**
	 * Region code of Singapore.
	 *
	 * @since 1.0
	 */
	public static final String SINGAPORE = "SG";

	/**
	 * Region code of Sint Maarten.
	 *
	 * @since 1.0
	 */
	public static final String SINT_MAARTEN = "SX";

	/**
	 * Region code of Slovakia.
	 *
	 * @since 1.0
	 */
	public static final String SLOVAKIA = "SK";

	/**
	 * Region code of Slovenia.
	 *
	 * @since 1.0
	 */
	public static final String SLOVENIA = "SI";

	/**
	 * Region code of Solomon Islands (formerly known as British Solomon Islands).
	 *
	 * @since 1.0
	 */
	public static final String SOLOMON_ISLANDS = "SB";

	/**
	 * Region code of Somalia.
	 *
	 * @since 1.0
	 */
	public static final String SOMALIA = "SO";

	/**
	 * Region code of South Africa.
	 *
	 * @since 1.0
	 */
	public static final String SOUTH_AFRICA = "ZA";

	/**
	 * Region code of South Georgia and the South Sandwich Islands.
	 *
	 * @since 1.0
	 */
	public static final String SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = "GS";

	/**
	 * Region code of the Republic of Korea (also known as South Korea).
	 *
	 * @since 1.0
	 */
	public static final String SOUTH_KOREA = "KR";

	/**
	 * Region code of South Sudan.
	 *
	 * @since 1.0
	 */
	public static final String SOUTH_SUDAN = "SS";

	/**
	 * Region code of Spain.
	 *
	 * @since 1.0
	 */
	public static final String SPAIN = "ES";

	/**
	 * Region code of Sri Lanka.
	 *
	 * @since 1.0
	 */
	public static final String SRI_LANKA = "LK";

	/**
	 * Region code of Sudan.
	 *
	 * @since 1.0
	 */
	public static final String SUDAN = "SD";

	/**
	 * Region code of Suriname.
	 *
	 * @since 1.0
	 */
	public static final String SURINAME = "SR";

	/**
	 * Region code of Svalbard and Jan Mayen.
	 *
	 * @since 1.0
	 */
	public static final String SVALBARD_AND_JAN_MAYEN = "SJ";

	/**
	 * Region code of Swaziland.
	 *
	 * @since 1.0
	 */
	public static final String SWAZILAND = "SZ";

	/**
	 * Region code of Sweden.
	 *
	 * @since 1.0
	 */
	public static final String SWEDEN = "SE";

	/**
	 * Region code of Switzerland.
	 *
	 * @since 1.0
	 */
	public static final String SWITZERLAND = "CH";

	/**
	 * Region code of Syria.
	 *
	 * @since 1.0
	 */
	public static final String SYRIA = "SY";

	/**
	 * Region code of the Republic of China (also known as Taiwan).
	 *
	 * @since 1.0
	 */
	public static final String TAIWAN = "TW";

	/**
	 * Region code of Tajikistan.
	 *
	 * @since 1.0
	 */
	public static final String TAJIKISTAN = "TJ";

	/**
	 * Region code of Tanzania.
	 *
	 * @since 1.0
	 */
	public static final String TANZANIA = "TZ";

	/**
	 * Region code of Thailand.
	 *
	 * @since 1.0
	 */
	public static final String THAILAND = "TH";

	/**
	 * Region code of Togo.
	 *
	 * @since 1.0
	 */
	public static final String TOGO = "TG";

	/**
	 * Region code of Tokelau.
	 *
	 * @since 1.0
	 */
	public static final String TOKELAU = "TK";

	/**
	 * Region code of Tonga.
	 *
	 * @since 1.0
	 */
	public static final String TONGA = "TO";

	/**
	 * Region code of Trinidad and Tobago.
	 *
	 * @since 1.0
	 */
	public static final String TRINIDAD_AND_TOBAGO = "TT";

	/**
	 * Region code of Tunisia.
	 *
	 * @since 1.0
	 */
	public static final String TUNISIA = "TN";

	/**
	 * Region code of Turkey.
	 *
	 * @since 1.0
	 */
	public static final String TURKEY = "TR";

	/**
	 * Region code of Turkmenistan.
	 *
	 * @since 1.0
	 */
	public static final String TURKMENISTAN = "TM";

	/**
	 * Region code of Turks and Caicos Islands.
	 *
	 * @since 1.0
	 */
	public static final String TURKS_AND_CAICOS_ISLANDS = "TC";

	/**
	 * Region code of Tuvalu.
	 *
	 * @since 1.0
	 */
	public static final String TUVALU = "TV";

	/**
	 * Region code of Uganda.
	 *
	 * @since 1.0
	 */
	public static final String UGANDA = "UG";

	/**
	 * Region code of Ukraine.
	 *
	 * @since 1.0
	 */
	public static final String UKRAINE = "UA";

	/**
	 * Region code of the United Arab Emirates.
	 *
	 * @since 1.0
	 */
	public static final String UNITED_ARAB_EMIRATES = "AE";

	/**
	 * Region code of the United Kingdom of Great Britain and Northern Ireland.
	 *
	 * @since 1.0
	 */
	public static final String UNITED_KINGDOM = "GB";

	/**
	 * Region code of the United States of America.
	 *
	 * @since 1.0
	 */
	public static final String UNITED_STATES = "US";

	/**
	 * Region code of the United States Minor Outlying Islands.
	 *
	 * @since 1.0
	 */
	public static final String UNITED_STATES_MINOR_OUTLYING_ISLANDS = "UM";

	/**
	 * Region code of the United States Virgin Islands.
	 *
	 * @since 1.0
	 */
	public static final String UNITED_STATES_VIRGIN_ISLANDS = "VI";

	/**
	 * Region code of Uruguay.
	 *
	 * @since 1.0
	 */
	public static final String URUGUAY = "UY";

	/**
	 * Region code of Uzbekistan.
	 *
	 * @since 1.0
	 */
	public static final String UZBEKISTAN = "UZ";

	/**
	 * Region code of Vanuatu (previously known as New Hebrides).
	 *
	 * @since 1.0
	 */
	public static final String VANUATU = "VU";

	/**
	 * Region code of the Vatican City (also known as Holy See).
	 *
	 * @since 1.0
	 */
	public static final String VATICAN_CITY = "VA";

	/**
	 * Region code of Venezuela.
	 *
	 * @since 1.0
	 */
	public static final String VENEZUELA = "VE";

	/**
	 * Region code of Vietnam.
	 *
	 * @since 1.0
	 */
	public static final String VIETNAM = "VN";

	/**
	 * Region code of Wallis and Futuna.
	 *
	 * @since 1.0
	 */
	public static final String WALLIS_AND_FUTUNA = "WF";

	/**
	 * Region code of Sahrawi Arab Democratic Republic (also known as Western Sahara, previously known as Spanish Sahara).
	 *
	 * @since 1.0
	 */
	public static final String WESTERN_SAHARA = "EH";

	/**
	 * Region code of Yemen.
	 *
	 * @since 1.0
	 */
	public static final String YEMEN = "YE";

	/**
	 * Region code of Zambia.
	 *
	 * @since 1.0
	 */
	public static final String ZAMBIA = "ZM";

	/**
	 * Region code of Zimbabwe (previously known as Southern Rhodesia).
	 *
	 * @since 1.0
	 */
	public static final String ZIMBABWE = "ZW";


	private StandardGeoRegions() {
		// Namespace for constants, not to be instantiated
	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Austria.
	 *
	 * @since 1.0
	 */
	public static class Austria {

		/**
		 * Region code of the Bezirk Amstetten.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_AMSTETTEN = "AT,03,05";

		/**
		 * Region code of the Bezirk Baden.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_BADEN = "AT,03,06";

		/**
		 * Region code of the Bezirk Bludenz.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_BLUDENZ = "AT,08,01";

		/**
		 * Region code of the Bezirk Braunau am Inn.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_BRAUNAU_AM_INN = "AT,04,04";

		/**
		 * Region code of the Bezirk Bregenz.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_BREGENZ = "AT,08,02";

		/**
		 * Region code of the Bezirk Bruck an der Leitha.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_BRUCK_AN_DER_LEITHA = "AT,03,07";

		/**
		 * Region code of the Bezirk Bruck-Mürzzuschlag.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_BRUCK_MUERZZUSCHLAG = "AT,06,21";

		/**
		 * Region code of the Bezirk Deutschlandsberg.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_DEUTSCHLANDSBERG = "AT,06,03";

		/**
		 * Region code of the Bezirk Dornbirn.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_DORNBIRN = "AT,08,03";

		/**
		 * Region code of the Bezirk Eferding.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_EFERDING = "AT,04,05";

		/**
		 * Region code of the Bezirk Eisenstadt-Umgebung.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_EISENSTADT_UMGEBUNG = "AT,01,03";

		/**
		 * Region code of the Bezirk Feldkirch.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_FELDKIRCH = "AT,08,04";

		/**
		 * Region code of the Bezirk Feldkirchen.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_FELDKIRCHEN = "AT,02,10";

		/**
		 * Region code of the Bezirk Freistadt.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_FREISTADT = "AT,04,06";

		/**
		 * Region code of the Bezirk Gänserndorf.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_GAENSERNDORF = "AT,03,08";

		/**
		 * Region code of the Bezirk Gmünd.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_GMUEND = "AT,03,09";

		/**
		 * Region code of the Bezirk Gmunden.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_GMUNDEN = "AT,04,07";

		/**
		 * Region code of the Bezirk Graz-Umgebung.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_GRAZ_UMGEBUNG = "AT,06,06";

		/**
		 * Region code of the Bezirk Grieskirchen.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_GRIESKIRCHEN = "AT,04,08";

		/**
		 * Region code of the Bezirk Güssing.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_GUESSING = "AT,01,04";

		/**
		 * Region code of the Bezirk Hallein.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_HALLEIN = "AT,05,02";

		/**
		 * Region code of the Bezirk Hartberg-Fürstenfeld.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_HARTBERG_FUERSTENFELD = "AT,06,22";

		/**
		 * Region code of the Bezirk Hermagor.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_HERMAGOR = "AT,02,03";

		/**
		 * Region code of the Bezirk Hollabrunn.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_HOLLABRUNN = "AT,03,10";

		/**
		 * Region code of the Bezirk Horn.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_HORN = "AT,03,11";

		/**
		 * Region code of the Bezirk Imst.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_IMST = "AT,07,02";

		/**
		 * Region code of the Bezirk Innsbruck-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_INNSBRUCK_LAND = "AT,07,03";

		/**
		 * Region code of the Bezirk Jennersdorf.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_JENNERSDORF = "AT,01,05";

		/**
		 * Region code of the Bezirk Kirchdorf an der Krems.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_KIRCHDORF_AN_DER_KREMS = "AT,04,09";

		/**
		 * Region code of the Bezirk Kitzbühel.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_KITZBUEHEL = "AT,07,04";

		/**
		 * Region code of the Bezirk Klagenfurt-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_KLAGENFURT_LAND = "AT,02,04";

		/**
		 * Region code of the Bezirk Korneuburg.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_KORNEUBURG = "AT,03,12";

		/**
		 * Region code of the Bezirk Krems-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_KREMS_LAND = "AT,03,13";

		/**
		 * Region code of the Bezirk Kufstein.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_KUFSTEIN = "AT,07,05";

		/**
		 * Region code of the Bezirk Landeck.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_LANDECK = "AT,07,06";

		/**
		 * Region code of the Bezirk Leibnitz.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_LEIBNITZ = "AT,06,10";

		/**
		 * Region code of the Bezirk Leoben.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_LEOBEN = "AT,06,11";

		/**
		 * Region code of the Bezirk Lienz.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_LIENZ = "AT,07,07";

		/**
		 * Region code of the Bezirk Liezen.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_LIEZEN = "AT,06,12";

		/**
		 * Region code of the Bezirk Lilienfeld.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_LILIENFELD = "AT,03,14";

		/**
		 * Region code of the Bezirk Linz-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_LINZ_LAND = "AT,04,10";

		/**
		 * Region code of the Bezirk Mattersburg.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_MATTERSBURG = "AT,01,06";

		/**
		 * Region code of the Bezirk Melk.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_MELK = "AT,03,15";

		/**
		 * Region code of the Bezirk Mistelbach.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_MISTELBACH = "AT,03,16";

		/**
		 * Region code of the Bezirk Mödling.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_MOEDLING = "AT,03,17";

		/**
		 * Region code of the Bezirk Murau.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_MURAU = "AT,06,14";

		/**
		 * Region code of the Bezirk Murtal.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_MURTAL = "AT,06,20";

		/**
		 * Region code of the Bezirk Neunkirchen.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_NEUNKIRCHEN = "AT,03,18";

		/**
		 * Region code of the Bezirk Neusiedl am See.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_NEUSIEDL_AM_SEE = "AT,01,07";

		/**
		 * Region code of the Bezirk Oberpullendorf.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_OBERPULLENDORF = "AT,01,08";

		/**
		 * Region code of the Bezirk Oberwart.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_OBERWART = "AT,01,09";

		/**
		 * Region code of the Bezirk Perg.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_PERG = "AT,04,11";

		/**
		 * Region code of the Bezirk Reutte.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_REUTTE = "AT,07,08";

		/**
		 * Region code of the Bezirk Ried im Innkreis.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_RIED_IM_INNKREIS = "AT,04,12";

		/**
		 * Region code of the Bezirk Rohrbach.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_ROHRBACH = "AT,04,13";

		/**
		 * Region code of the Bezirk Salzburg-Umgebung.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SALZBURG_UMGEBUNG = "AT,05,03";

		/**
		 * Region code of the Bezirk Sankt Johann im Pongau.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SANKT_JOHANN_IM_PONGAU = "AT,05,04";

		/**
		 * Region code of the Bezirk Sankt Pölten-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SANKT_POELTEN_LAND = "AT,03,19";

		/**
		 * Region code of the Bezirk Sankt Veit an der Glan.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SANKT_VEIT_AN_DER_GLAN = "AT,02,05";

		/**
		 * Region code of the Bezirk Schärding.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SCHAERDING = "AT,04,14";

		/**
		 * Region code of the Bezirk Scheibbs.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SCHEIBBS = "AT,03,20";

		/**
		 * Region code of the Bezirk Schwaz.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SCHWAZ = "AT,07,09";

		/**
		 * Region code of the Bezirk Spittal an der Drau.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SPITTAL_AN_DER_DRAU = "AT,02,06";

		/**
		 * Region code of the Bezirk Steyr-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_STEYR_LAND = "AT,04,15";

		/**
		 * Region code of the Bezirk Südoststeiermark.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_SUEDOSTSTEIERMARK = "AT,06,23";

		/**
		 * Region code of the Bezirk Tamsweg.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_TAMSWEG = "AT,05,05";

		/**
		 * Region code of the Bezirk Tulln.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_TULLN = "AT,03,21";

		/**
		 * Region code of the Bezirk Urfahr-Umgebung.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_URFAHR_UMGEBUNG = "AT,04,16";

		/**
		 * Region code of the Bezirk Villach-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_VILLACH_LAND = "AT,02,07";

		/**
		 * Region code of the Bezirk Vöcklabruck.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_VOECKLABRUCK = "AT,04,17";

		/**
		 * Region code of the Bezirk Völkermarkt.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_VOELKERMARKT = "AT,02,08";

		/**
		 * Region code of the Bezirk Voitsberg.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_VOITSBERG = "AT,06,16";

		/**
		 * Region code of the Bezirk Waidhofen an der Thaya.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_WAIDHOFEN_AN_DER_THAYA = "AT,03,22";

		/**
		 * Region code of the Bezirk Weiz.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_WEIZ = "AT,06,17";

		/**
		 * Region code of the Bezirk Wels-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_WELS_LAND = "AT,04,18";

		/**
		 * Region code of the Bezirk Wien-Umgebung.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_WIEN_UMGEBUNG = "AT,03,24";

		/**
		 * Region code of the Bezirk Wiener Neustadt-Land.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_WIENER_NEUSTADT_LAND = "AT,03,23";

		/**
		 * Region code of the Bezirk Wolfsberg.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_WOLFSBERG = "AT,02,09";

		/**
		 * Region code of the Bezirk Zell am See.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_ZELL_AM_SEE = "AT,05,06";

		/**
		 * Region code of the Bezirk Zwettl.
		 *
		 * @since 1.0
		 */
		public static final String BEZIRK_ZWETTL = "AT,03,25";

		/**
		 * Region code of the Burgenland.
		 *
		 * @since 1.0
		 */
		public static final String BURGENLAND = "AT,01";

		/**
		 * Region code of the Hauptstadt Wien.
		 *
		 * @since 1.0
		 */
		public static final String HAUPTSTADT_WIEN = "AT,09";

		/**
		 * Region code of the Land Kärnten.
		 *
		 * @since 1.0
		 */
		public static final String LAND_KAERNTEN = "AT,02";

		/**
		 * Region code of the Land Niederösterreich.
		 *
		 * @since 1.0
		 */
		public static final String LAND_NIEDEROESTERREICH = "AT,03";

		/**
		 * Region code of the Land Oberösterreich.
		 *
		 * @since 1.0
		 */
		public static final String LAND_OBEROESTERREICH = "AT,04";

		/**
		 * Region code of the Land Salzburg.
		 *
		 * @since 1.0
		 */
		public static final String LAND_SALZBURG = "AT,05";

		/**
		 * Region code of the Land Steiermark.
		 *
		 * @since 1.0
		 */
		public static final String LAND_STEIERMARK = "AT,06";

		/**
		 * Region code of the Land Tirol.
		 *
		 * @since 1.0
		 */
		public static final String LAND_TIROL = "AT,07";

		/**
		 * Region code of the Land Vorarlberg.
		 *
		 * @since 1.0
		 */
		public static final String LAND_VORARLBERG = "AT,08";

		/**
		 * Region code of the Stadt Eisenstadt.
		 *
		 * @since 1.0
		 */
		public static final String STADT_EISENSTADT = "AT,01,01";

		/**
		 * Region code of the Stadt Graz.
		 *
		 * @since 1.0
		 */
		public static final String STADT_GRAZ = "AT,06,01";

		/**
		 * Region code of the Stadt Innsbruck.
		 *
		 * @since 1.0
		 */
		public static final String STADT_INNSBRUCK = "AT,07,01";

		/**
		 * Region code of the Stadt Klagenfurt am Wörthersee.
		 *
		 * @since 1.0
		 */
		public static final String STADT_KLAGENFURT_AM_WOERTHERSEE = "AT,02,01";

		/**
		 * Region code of the Stadt Krems an der Donau.
		 *
		 * @since 1.0
		 */
		public static final String STADT_KREMS_AN_DER_DONAU = "AT,03,01";

		/**
		 * Region code of the Stadt Linz.
		 *
		 * @since 1.0
		 */
		public static final String STADT_LINZ = "AT,04,01";

		/**
		 * Region code of the Stadt Rust.
		 *
		 * @since 1.0
		 */
		public static final String STADT_RUST = "AT,01,02";

		/**
		 * Region code of the Stadt Salzburg
		 *
		 * @since 1.0
		 */
		public static final String STADT_SALZBURG = "AT,05,01";

		/**
		 * Region code of the Stadt Sankt Pölten.
		 *
		 * @since 1.0
		 */
		public static final String STADT_SANKT_POELTEN = "AT,03,02";

		/**
		 * Region code of the Stadt Steyr.
		 *
		 * @since 1.0
		 */
		public static final String STADT_STEYR = "AT,04,02";

		/**
		 * Region code of the Stadt Villach.
		 *
		 * @since 1.0
		 */
		public static final String STADT_VILLACH = "AT,02,02";

		/**
		 * Region code of the Stadt Waidhofen an der Ybbs.
		 *
		 * @since 1.0
		 */
		public static final String STADT_WAIDHOFEN_AN_DER_YBBS = "AT,03,03";

		/**
		 * Region code of the Stadt Wels.
		 *
		 * @since 1.0
		 */
		public static final String STADT_WELS = "AT,04,03";

		/**
		 * Region code of the Stadt Wiener Neustadt.
		 *
		 * @since 1.0
		 */
		public static final String STADT_WIENER_NEUSTADT = "AT,03,04";


		private Austria() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Belgium.
	 *
	 * @since 1.0
	 */
	public static class Belgium {

		/**
		 * Region code of the Province d'Anvers (also known as Antwerpen).
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_ANVERS = "BE,02,10";

		/**
		 * Region code of the Province de Flandre-Occidentale (also known as West-Vlaanderen).
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_FLANDRE_OCCIDENTALE = "BE,02,30";

		/**
		 * Region code of the Province de Flandre-Orientale (also known as Oost-Vlaanderen).
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_FLANDRE_ORIENTALE = "BE,02,40";

		/**
		 * Region code of the Province de Hainaut.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_HAINAUT = "BE,03,50";

		/**
		 * Region code of the Province de Liège.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_LIEGE = "BE,03,60";

		/**
		 * Region code of the Province de Limbourg (also known as Limburg).
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_LIMBOURG = "BE,02,70";

		/**
		 * Region code of the Province de Luxembourg.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_LUXEMBOURG = "BE,03,80";

		/**
		 * Region code of the Province de Namur.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DE_NAMUR = "BE,03,90";

		/**
		 * Region code of the Province du Brabant flamand (also known as Vlaams-Brabant).
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DU_BRABANT_FLAMAND = "BE,02,21";

		/**
		 * Region code of the Province du Brabant wallon.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_DU_BRABANT_WALLON = "BE,03,22";

		/**
		 * Region code of the Région de Bruxelles-Capitale.
		 *
		 * @since 1.0
		 */
		public static final String REGION_DE_BRUXELLES_CAPITALE = "BE,04";

		/**
		 * Region code of the Région flamande (also known as Vlaams Gewest).
		 *
		 * @since 1.0
		 */
		public static final String REGION_FLAMANDE = "BE,02";

		/**
		 * Region code of the Région wallonne.
		 *
		 * @since 1.0
		 */
		public static final String REGION_WALLONNE = "BE,03";


		private Belgium() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Brazil.
	 *
	 * @since 1.0
	 */
	public static class Brazil {

		/**
		 * Region code of the Distrito Federal.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_FEDERAL = "BR,03,53";

		/**
		 * Region code of the Estado da Bahia.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DA_BAHIA = "BR,02,29";

		/**
		 * Region code of the Estado da Paraíba.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DA_PARAIBA = "BR,02,25";

		/**
		 * Region code of the Estado de Alagoas.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_ALAGOAS = "BR,02,27";

		/**
		 * Region code of the Estado de Goiás.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_GOIAS = "BR,03,52";

		/**
		 * Region code of the Estado de Mato Grosso.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_MATO_GROSSO = "BR,03,51";

		/**
		 * Region code of the Estado de Mato Grosso do Sul.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_MATO_GROSSO_DO_SUL = "BR,03,50";

		/**
		 * Region code of the Estado de Minas Gerais.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_MINAS_GERAIS = "BR,04,31";

		/**
		 * Region code of the Estado de Pernambuco.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_PERNAMBUCO = "BR,02,26";

		/**
		 * Region code of the Estado de Rondônia.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_RONDONIA = "BR,01,11";

		/**
		 * Region code of the Estado de Roraima.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_RORAIMA = "BR,01,14";

		/**
		 * Region code of the Estado de Santa Catarina.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_SANTA_CATARINA = "BR,05,42";

		/**
		 * Region code of the Estado de São Paulo.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_SAO_PAULO = "BR,04,35";

		/**
		 * Region code of the Estado de Sergipe.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DE_SERGIPE = "BR,02,28";

		/**
		 * Region code of the Estado do Acre.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_ACRE = "BR,01,12";

		/**
		 * Region code of the Estado do Amapá.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_AMAPA = "BR,01,16";

		/**
		 * Region code of the Estado do Amazonas.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_AMAZONAS = "BR,01,13";

		/**
		 * Region code of the Estado do Ceará.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_CEARA = "BR,02,23";

		/**
		 * Region code of the Estado do Espírito Santo.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_ESPIRITO_SANTO = "BR,04,32";

		/**
		 * Region code of the Estado do Maranhão.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_MARANHAO = "BR,02,21";

		/**
		 * Region code of the Estado do Pará.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_PARA = "BR,01,15";

		/**
		 * Region code of the Estado do Paraná.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_PARANA = "BR,05,41";

		/**
		 * Region code of the Estado do Piauí.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_PIAUI = "BR,02,22";

		/**
		 * Region code of the Estado do Rio de Janeiro.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_RIO_DE_JANEIRO = "BR,04,33";

		/**
		 * Region code of the Estado do Rio Grande do Norte.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_RIO_GRANDE_DO_NORTE = "BR,02,24";

		/**
		 * Region code of the Estado do Rio Grande do Sul.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_RIO_GRANDE_DO_SUL = "BR,05,43";

		/**
		 * Region code of the Estado do Tocantins.
		 *
		 * @since 1.0
		 */
		public static final String ESTADO_DO_TOCANTINS = "BR,01,17";

		/**
		 * Region code of the Região Centro-Oeste.
		 *
		 * @since 1.0
		 */
		public static final String REGIAO_CENTRO_OESTE = "BR,03";

		/**
		 * Region code of the Região Nordeste.
		 *
		 * @since 1.0
		 */
		public static final String REGIAO_NORDESTE = "BR,02";

		/**
		 * Region code of the Região Norte.
		 *
		 * @since 1.0
		 */
		public static final String REGIAO_NORTE = "BR,01";

		/**
		 * Region code of the Região Sudeste.
		 *
		 * @since 1.0
		 */
		public static final String REGIAO_SUDESTE = "BR,04";

		/**
		 * Region code of the Região Sul.
		 *
		 * @since 1.0
		 */
		public static final String REGIAO_SUL = "BR,05";


		private Brazil() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Canada.
	 *
	 * @since 1.0
	 */
	public static class Canada {

		/**
		 * Region code of the Northwest Territories.
		 *
		 * @since 1.0
		 */
		public static final String NORTHWEST_TERRITORIES = "CA,61";

		/**
		 * Region code of the Province of Alberta.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_ALBERTA = "CA,48";

		/**
		 * Region code of the Province of British Columbia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_BRITISH_COLUMBIA = "CA,59";

		/**
		 * Region code of the Province of Manitoba.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_MANITOBA = "CA,46";

		/**
		 * Region code of the Province of New Brunswick.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_NEW_BRUNSWICK = "CA,13";

		/**
		 * Region code of the Province of Newfoundland and Labrador.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_NEWFOUNDLAND_AND_LABRADOR = "CA,10";

		/**
		 * Region code of the Province of Nova Scotia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_NOVA_SCOTIA = "CA,12";

		/**
		 * Region code of the Province of Ontario.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_ONTARIO = "CA,35";

		/**
		 * Region code of the Province of Prince Edward Island.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_PRINCE_EDWARD_ISLAND = "CA,11";

		/**
		 * Region code of the Province of Quebec.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_QUEBEC = "CA,24";

		/**
		 * Region code of the Province of Saskatchewan.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCE_OF_SASKATCHEWAN = "CA,47";

		/**
		 * Region code of the Territory of Nunavut.
		 *
		 * @since 1.0
		 */
		public static final String TERRITORY_OF_NUNAVUT = "CA,62";

		/**
		 * Region code of the Territory of Yukon.
		 *
		 * @since 1.0
		 */
		public static final String TERRITORY_OF_YUKON = "CA,60";


		private Canada() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in China.
	 *
	 * @since 1.0
	 */
	public static class China {

		/**
		 * Region code of the Ānhuī Shěng.
		 *
		 * @since 1.0
		 */
		public static final String ANHUI_SHENG = "CN,34";

		/**
		 * Region code of the Àomén Tèbié Xíngzhèngqū (known as Macau Special Administrative Region).
		 *
		 * @since 1.0
		 */
		public static final String AOMEN_TEBIE_XINGZHENGQU = "MO"; // "CN,92" not used

		/**
		 * Region code of the Běijīng Shì.
		 *
		 * @since 1.0
		 */
		public static final String BEIJING_SHI = "CN,11";

		/**
		 * Region code of the Chóngqìng Shì.
		 *
		 * @since 1.0
		 */
		public static final String CHONGQING_SHI = "CN,50";

		/**
		 * Region code of the Fújiàn Shěng.
		 *
		 * @since 1.0
		 */
		public static final String FUJIAN_SHENG = "CN,35";

		/**
		 * Region code of the Gānsù Shěng.
		 *
		 * @since 1.0
		 */
		public static final String GANSU_SHENG = "CN,62";

		/**
		 * Region code of the Guǎngdōng Shěng.
		 *
		 * @since 1.0
		 */
		public static final String GUANGDONG_SHENG = "CN,44";

		/**
		 * Region code of the Guǎngxī Zhuàngzú Zìzhìqū.
		 *
		 * @since 1.0
		 */
		public static final String GUANGXI_ZHUANGZU_ZIZHIQU = "CN,45";

		/**
		 * Region code of the Guìzhōu Shěng.
		 *
		 * @since 1.0
		 */
		public static final String GUIZHOU_SHENG = "CN,52";

		/**
		 * Region code of the Hǎinán Shěng.
		 *
		 * @since 1.0
		 */
		public static final String HAINAN_SHENG = "CN,46";

		/**
		 * Region code of the Héběi Shěng.
		 *
		 * @since 1.0
		 */
		public static final String HEBEI_SHENG = "CN,13";

		/**
		 * Region code of the Hēilóngjiāng Shěng.
		 *
		 * @since 1.0
		 */
		public static final String HEILONGJIANG_SHENG = "CN,23";

		/**
		 * Region code of the Hénán Shěng.
		 *
		 * @since 1.0
		 */
		public static final String HENAN_SHENG = "CN,41";

		/**
		 * Region code of the Húběi Shěng.
		 *
		 * @since 1.0
		 */
		public static final String HUBEI_SHENG = "CN,42";

		/**
		 * Region code of the Húnán Shěng.
		 *
		 * @since 1.0
		 */
		public static final String HUNAN_SHENG = "CN,43";

		/**
		 * Region code of the Jiāngsū Shěng.
		 *
		 * @since 1.0
		 */
		public static final String JIANGSU_SHENG = "CN,32";

		/**
		 * Region code of the Jiāngxī Shěng.
		 *
		 * @since 1.0
		 */
		public static final String JIANGXI_SHENG = "CN,36";

		/**
		 * Region code of the Jílín Shěng.
		 *
		 * @since 1.0
		 */
		public static final String JILIN_SHENG = "CN,22";

		/**
		 * Region code of the Liáoníng Shěng.
		 *
		 * @since 1.0
		 */
		public static final String LIAONING_SHENG = "CN,21";

		/**
		 * Region code of the Nèi Měnggǔ Zìzhìqū (known as Inner Mongolia Autonomous Region).
		 *
		 * @since 1.0
		 */
		public static final String NEI_MENGGU_ZIZHIQU = "CN,15";

		/**
		 * Region code of the Níngxià Huízú Zìzhìqū.
		 *
		 * @since 1.0
		 */
		public static final String NINGXIA_HUIZU_ZIZHIQU = "CN,64";

		/**
		 * Region code of the Qīnghǎi Shěng.
		 *
		 * @since 1.0
		 */
		public static final String QINGHAI_SHENG = "CN,63";

		/**
		 * Region code of the Shǎnxī (Shaanxi) Shěng.
		 *
		 * @since 1.0
		 */
		public static final String SHAANXI_SHENG = "CN,61";

		/**
		 * Region code of the Shāndōng Shěng.
		 *
		 * @since 1.0
		 */
		public static final String SHANDONG_SHENG = "CN,37";

		/**
		 * Region code of the Shànghǎi Shì.
		 *
		 * @since 1.0
		 */
		public static final String SHANGHAI_SHI = "CN,31";

		/**
		 * Region code of the Shānxī (Shanxi) Shěng.
		 *
		 * @since 1.0
		 */
		public static final String SHANXI_SHENG = "CN,14";

		/**
		 * Region code of the Sìchuān Shěng.
		 *
		 * @since 1.0
		 */
		public static final String SICHUAN_SHENG = "CN,51";

		/**
		 * Region code of the Táiwān Shěng.
		 *
		 * @since 1.0
		 */
		public static final String TAIWAN_SHENG = "TW"; // "CN,71" not used

		/**
		 * Region code of the Tiānjīn Shì.
		 *
		 * @since 1.0
		 */
		public static final String TIANJIN_SHI = "CN,12";

		/**
		 * Region code of the Xiānggǎng Tèbié Xíngzhèngqū (known as Hong Kong Special Administrative Region).
		 *
		 * @since 1.0
		 */
		public static final String XIANGGANG_TEBIE_XINGZHENGQU = "HK"; // "CN,91" not used

		/**
		 * Region code of the Xīnjiāng Wéiwú'ěr Zìzhìqū.
		 *
		 * @since 1.0
		 */
		public static final String XINJIANG_WEIWUER_ZIZHIQU = "CN,65";

		/**
		 * Region code of the Xīzàng Zìzhìqū (known as Tibet Autonomous Region).
		 *
		 * @since 1.0
		 */
		public static final String XIZANG_ZIZHIQU = "CN,54";

		/**
		 * Region code of the Yúnnán Shěng.
		 *
		 * @since 1.0
		 */
		public static final String YUNNAN_SHENG = "CN,53";

		/**
		 * Region code of the Zhèjiāng Shěng.
		 *
		 * @since 1.0
		 */
		public static final String ZHEJIANG_SHENG = "CN,33";


		private China() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Croatia.
	 *
	 * @since 1.0
	 */
	public static class Croatia {

		/**
		 * Region code of the Bjelovarsko-bilogorska županija.
		 *
		 * @since 1.0
		 */
		public static final String BJELOVARSKO_BILOGORSKA_ZUPANIJA = "HR,01";

		/**
		 * Region code of the Brodsko-posavska županija.
		 *
		 * @since 1.0
		 */
		public static final String BRODSKO_POSAVSKA_ZUPANIJA = "HR,02";

		/**
		 * Region code of the Dubrovačko-neretvanska županija.
		 *
		 * @since 1.0
		 */
		public static final String DUBROVACKO_NERETVANSKA_ZUPANIJA = "HR,03";

		/**
		 * Region code of the Grad Zagreb.
		 *
		 * @since 1.0
		 */
		public static final String GRAD_ZAGREB = "HR,21";

		/**
		 * Region code of the Istarska županija.
		 *
		 * @since 1.0
		 */
		public static final String ISTARSKA_ZUPANIJA = "HR,04";

		/**
		 * Region code of the Karlovačka županija.
		 *
		 * @since 1.0
		 */
		public static final String KARLOVACKA_ZUPANIJA = "HR,05";

		/**
		 * Region code of the Koprivničko-križevačka županija.
		 *
		 * @since 1.0
		 */
		public static final String KOPRIVNICKO_KRIZEVACKA_ZUPANIJA = "HR,06";

		/**
		 * Region code of the Krapinsko-zagorska županija.
		 *
		 * @since 1.0
		 */
		public static final String KRAPINSKO_ZAGORSKA_ZUPANIJA = "HR,07";

		/**
		 * Region code of the Ličko-senjska županija.
		 *
		 * @since 1.0
		 */
		public static final String LICKO_SENJSKA_ZUPANIJA = "HR,08";

		/**
		 * Region code of the Međimurska županija.
		 *
		 * @since 1.0
		 */
		public static final String MEDIMURSKA_ZUPANIJA = "HR,09";

		/**
		 * Region code of the Osječko-baranjska županija.
		 *
		 * @since 1.0
		 */
		public static final String OSJECKO_BARANJSKA_ZUPANIJA = "HR,10";

		/**
		 * Region code of the Požeško-slavonska županija.
		 *
		 * @since 1.0
		 */
		public static final String POZESKO_SLAVONSKA_ZUPANIJA = "HR,11";

		/**
		 * Region code of the Primorsko-goranska županija.
		 *
		 * @since 1.0
		 */
		public static final String PRIMORSKO_GORANSKA_ZUPANIJA = "HR,12";

		/**
		 * Region code of the Šibensko-kninska županija.
		 *
		 * @since 1.0
		 */
		public static final String SIBENSKO_KNINSKA_ZUPANIJA = "HR,13";

		/**
		 * Region code of the Sisačko-moslavačka županija.
		 *
		 * @since 1.0
		 */
		public static final String SISACKO_MOSLAVACKA_ZUPANIJA = "HR,14";

		/**
		 * Region code of the Splitsko-dalmatinska županija.
		 *
		 * @since 1.0
		 */
		public static final String SPLITSKO_DALMATINSKA_ZUPANIJA = "HR,15";

		/**
		 * Region code of the Varaždinska županija.
		 *
		 * @since 1.0
		 */
		public static final String VARAZDINSKA_ZUPANIJA = "HR,16";

		/**
		 * Region code of the Virovitičko-podravska županija.
		 *
		 * @since 1.0
		 */
		public static final String VIROVITICKO_PODRAVSKA_ZUPANIJA = "HR,17";

		/**
		 * Region code of the Vukovarsko-srijemska županija.
		 *
		 * @since 1.0
		 */
		public static final String VUKOVARSKO_SRIJEMSKA_ZUPANIJA = "HR,18";

		/**
		 * Region code of the Zadarska županija.
		 *
		 * @since 1.0
		 */
		public static final String ZADARSKA_ZUPANIJA = "HR,19";

		/**
		 * Region code of the Zagrebačka županija.
		 *
		 * @since 1.0
		 */
		public static final String ZAGREBACKA_ZUPANIJA = "HR,20";


		private Croatia() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in the Czech Republic.
	 *
	 * @since 1.0
	 */
	public static class CzechRepublic {

		/**
		 * Region code of the Hlavní město Praha.
		 *
		 * @since 1.0
		 */
		public static final String HLAVNI_MESTO_PRAHA = "CZ,10";

		/**
		 * Region code of the Jihočeský kraj.
		 *
		 * @since 1.0
		 */
		public static final String JIHOCESKY_KRAJ = "CZ,31";

		/**
		 * Region code of the Jihomoravský kraj.
		 *
		 * @since 1.0
		 */
		public static final String JIHOMORAVSKY_KRAJ = "CZ,64";

		/**
		 * Region code of the Karlovarský kraj.
		 *
		 * @since 1.0
		 */
		public static final String KARLOVARSKY_KRAJ = "CZ,41";

		/**
		 * Region code of the Kraj Vysočina.
		 *
		 * @since 1.0
		 */
		public static final String KRAJ_VYSOCINA = "CZ,63";

		/**
		 * Region code of the Královéhradecký kraj.
		 *
		 * @since 1.0
		 */
		public static final String KRALOVEHRADECKY_KRAJ = "CZ,52";

		/**
		 * Region code of the Liberecký kraj.
		 *
		 * @since 1.0
		 */
		public static final String LIBERECKY_KRAJ = "CZ,51";

		/**
		 * Region code of the Městská část Praha 1.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_1 = "CZ,10,,500054";

		/**
		 * Region code of the Městská část Praha 10.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_10 = "CZ,10,,500224";

		/**
		 * Region code of the Městská část Praha 11.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_11 = "CZ,10,,547034";

		/**
		 * Region code of the Městská část Praha 12.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_12 = "CZ,10,,547107";

		/**
		 * Region code of the Městská část Praha 13.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_13 = "CZ,10,,539694";

		/**
		 * Region code of the Městská část Praha 14.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_14 = "CZ,10,,547361";

		/**
		 * Region code of the Městská část Praha 15.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_15 = "CZ,10,,547387";

		/**
		 * Region code of the Městská část Praha 16.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_16 = "CZ,10,,539601";

		/**
		 * Region code of the Městská část Praha 17.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_17 = "CZ,10,,547174";

		/**
		 * Region code of the Městská část Praha 18.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_18 = "CZ,10,,547417";

		/**
		 * Region code of the Městská část Praha 19.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_19 = "CZ,10,,547344";

		/**
		 * Region code of the Městská část Praha 2.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_2 = "CZ,10,,500089";

		/**
		 * Region code of the Městská část Praha 20.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_20 = "CZ,10,,538213";

		/**
		 * Region code of the Městská část Praha 21.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_21 = "CZ,10,,538949";

		/**
		 * Region code of the Městská část Praha 22.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_22 = "CZ,10,,538931";

		/**
		 * Region code of the Městská část Praha 3.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_3 = "CZ,10,,500097";

		/**
		 * Region code of the Městská část Praha 4.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_4 = "CZ,10,,500119";

		/**
		 * Region code of the Městská část Praha 5.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_5 = "CZ,10,,500143";

		/**
		 * Region code of the Městská část Praha 6.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_6 = "CZ,10,,500178";

		/**
		 * Region code of the Městská část Praha 7.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_7 = "CZ,10,,500186";

		/**
		 * Region code of the Městská část Praha 8.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_8 = "CZ,10,,500208";

		/**
		 * Region code of the Městská část Praha 9.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_9 = "CZ,10,,500216";

		/**
		 * Region code of the Městská část Praha-Běchovice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_BECHOVICE = "CZ,10,,538060";

		/**
		 * Region code of the Městská část Praha-Benice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_BENICE = "CZ,10,,538078";

		/**
		 * Region code of the Městská část Praha-Březiněves.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_BREZINEVES = "CZ,10,,538124";

		/**
		 * Region code of the Městská část Praha-Čakovice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_CAKOVICE = "CZ,10,,547310";

		/**
		 * Region code of the Městská část Praha-Ďáblice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_DABLICE = "CZ,10,,547298";

		/**
		 * Region code of the Městská část Praha-Dolní Chabry.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_DOLNI_CHABRY = "CZ,10,,547301";

		/**
		 * Region code of the Městská část Praha-Dolní Měcholupy.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_DOLNI_MECHOLUPY = "CZ,10,,547379";

		/**
		 * Region code of the Městská část Praha-Dolní Počernice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_DOLNI_POCERNICE = "CZ,10,,538175";

		/**
		 * Region code of the Městská část Praha-Dubeč.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_DUBEC = "CZ,10,,538205";

		/**
		 * Region code of the Městská část Praha-Klánovice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_KLANOVICE = "CZ,10,,538302";

		/**
		 * Region code of the Městská část Praha-Koloděje.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_KOLODEJE = "CZ,10,,538353";

		/**
		 * Region code of the Městská část Praha-Kolovraty.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_KOLOVRATY = "CZ,10,,538361";

		/**
		 * Region code of the Městská část Praha-Královice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_KRALOVICE = "CZ,10,,538388";

		/**
		 * Region code of the Městská část Praha-Křeslice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_KRESLICE = "CZ,10,,538400";

		/**
		 * Region code of the Městská část Praha-Kunratice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_KUNRATICE = "CZ,10,,547042";

		/**
		 * Region code of the Městská část Praha-Libuš.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_LIBUS = "CZ,10,,547051";

		/**
		 * Region code of the Městská část Praha-Lipence.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_LIPENCE = "CZ,10,,539449";

		/**
		 * Region code of the Městská část Praha-Lochkov.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_LOCHKOV = "CZ,10,,539465";

		/**
		 * Region code of the Městská část Praha-Lysolaje.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_LYSOLAJE = "CZ,10,,547140";

		/**
		 * Region code of the Městská část Praha-Nebušice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_NEBUSICE = "CZ,10,,547158";

		/**
		 * Region code of the Městská část Praha-Nedvězí.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_NEDVEZI = "CZ,10,,538531";

		/**
		 * Region code of the Městská část Praha-Petrovice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_PETROVICE = "CZ,10,,547395";

		/**
		 * Region code of the Městská část Praha-Přední Kopanina.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_PREDNI_KOPANINA = "CZ,10,,539589";

		/**
		 * Region code of the Městská část Praha-Řeporyje.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_REPORYJE = "CZ,10,,539635";

		/**
		 * Region code of the Městská část Praha-Satalice.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_SATALICE = "CZ,10,,538736";

		/**
		 * Region code of the Městská část Praha-Šeberov.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_SEBEROV = "CZ,10,,539724";

		/**
		 * Region code of the Městská část Praha-Slivenec.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_SLIVENEC = "CZ,10,,539678";

		/**
		 * Region code of the Městská část Praha-Štěrboholy.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_STERBOHOLY = "CZ,10,,547409";

		/**
		 * Region code of the Městská část Praha-Suchdol.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_SUCHDOL = "CZ,10,,547271";

		/**
		 * Region code of the Městská část Praha-Troja.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_TROJA = "CZ,10,,547328";

		/**
		 * Region code of the Městská část Praha-Újezd.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_UJEZD = "CZ,10,,539791";

		/**
		 * Region code of the Městská část Praha-Velká Chuchle.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_VELKA_CHUCHLE = "CZ,10,,547115";

		/**
		 * Region code of the Městská část Praha-Vinoř.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_VINOR = "CZ,10,,539007";

		/**
		 * Region code of the Městská část Praha-Zbraslav.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_ZBRASLAV = "CZ,10,,539864";

		/**
		 * Region code of the Městská část Praha-Zličín.
		 *
		 * @since 1.0
		 */
		public static final String MESTSKA_CAST_PRAHA_ZLICIN = "CZ,10,,539899";

		/**
		 * Region code of the Moravskoslezský kraj.
		 *
		 * @since 1.0
		 */
		public static final String MORAVSKOSLEZSKY_KRAJ = "CZ,80";

		/**
		 * Region code of the Okres Benešov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BENESOV = "CZ,20,1";

		/**
		 * Region code of the Okres Beroun.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BEROUN = "CZ,20,2";

		/**
		 * Region code of the Okres Blansko.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BLANSKO = "CZ,64,1";

		/**
		 * Region code of the Okres Břeclav.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRECLAV = "CZ,64,4";

		/**
		 * Region code of the Okres Brno-město.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRNO_MESTO = "CZ,64,2";

		/**
		 * Region code of the Okres Brno-venkov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRNO_VENKOV = "CZ,64,3";

		/**
		 * Region code of the Okres Bruntál.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRUNTAL = "CZ,80,1";

		/**
		 * Region code of the Okres Česká Lípa.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_CESKA_LIPA = "CZ,51,1";

		/**
		 * Region code of the Okres České Budějovice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_CESKE_BUDEJOVICE = "CZ,31,1";

		/**
		 * Region code of the Okres Český Krumlov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_CESKY_KRUMLOV = "CZ,31,2";

		/**
		 * Region code of the Okres Cheb.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_CHEB = "CZ,41,1";

		/**
		 * Region code of the Okres Chomutov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_CHOMUTOV = "CZ,42,2";

		/**
		 * Region code of the Okres Chrudim.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_CHRUDIM = "CZ,53,1";

		/**
		 * Region code of the Okres Děčín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_DECIN = "CZ,42,1";

		/**
		 * Region code of the Okres Domažlice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_DOMAZLICE = "CZ,32,1";

		/**
		 * Region code of the Okres Frýdek-Místek.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_FRYDEK_MISTEK = "CZ,80,2";

		/**
		 * Region code of the Okres Havlíčkův Brod.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_HAVLICKUV_BROD = "CZ,63,1";

		/**
		 * Region code of the Okres Hodonín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_HODONIN = "CZ,64,5";

		/**
		 * Region code of the Okres Hradec Králové.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_HRADEC_KRALOVE = "CZ,52,1";

		/**
		 * Region code of the Okres Jablonec nad Nisou.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_JABLONEC_NAD_NISOU = "CZ,51,2";

		/**
		 * Region code of the Okres Jeseník.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_JESENIK = "CZ,71,1";

		/**
		 * Region code of the Okres Jičín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_JICIN = "CZ,52,2";

		/**
		 * Region code of the Okres Jihlava.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_JIHLAVA = "CZ,63,2";

		/**
		 * Region code of the Okres Jindřichův Hradec.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_JINDRICHUV_HRADEC = "CZ,31,3";

		/**
		 * Region code of the Okres Karlovy Vary.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KARLOVY_VARY = "CZ,41,2";

		/**
		 * Region code of the Okres Karviná.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KARVINA = "CZ,80,3";

		/**
		 * Region code of the Okres Kladno.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KLADNO = "CZ,20,3";

		/**
		 * Region code of the Okres Klatovy.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KLATOVY = "CZ,32,2";

		/**
		 * Region code of the Okres Kolín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KOLIN = "CZ,20,4";

		/**
		 * Region code of the Okres Kroměříž.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KROMERIZ = "CZ,72,1";

		/**
		 * Region code of the Okres Kutná Hora.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KUTNA_HORA = "CZ,20,5";

		/**
		 * Region code of the Okres Liberec.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_LIBEREC = "CZ,51,3";

		/**
		 * Region code of the Okres Litoměřice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_LITOMERICE = "CZ,42,3";

		/**
		 * Region code of the Okres Louny.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_LOUNY = "CZ,42,4";

		/**
		 * Region code of the Okres Mělník.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MELNIK = "CZ,20,6";

		/**
		 * Region code of the Okres Mladá Boleslav.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MLADA_BOLESLAV = "CZ,20,7";

		/**
		 * Region code of the Okres Most.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MOST = "CZ,42,5";

		/**
		 * Region code of the Okres Náchod.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_NACHOD = "CZ,52,3";

		/**
		 * Region code of the Okres Nový Jičín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_NOVY_JICIN = "CZ,80,4";

		/**
		 * Region code of the Okres Nymburk.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_NYMBURK = "CZ,20,8";

		/**
		 * Region code of the Okres Olomouc.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_OLOMOUC = "CZ,71,2";

		/**
		 * Region code of the Okres Opava.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_OPAVA = "CZ,80,5";

		/**
		 * Region code of the Okres Ostrava-město.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_OSTRAVA_MESTO = "CZ,80,6";

		/**
		 * Region code of the Okres Pardubice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PARDUBICE = "CZ,53,2";

		/**
		 * Region code of the Okres Pelhřimov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PELHRIMOV = "CZ,63,3";

		/**
		 * Region code of the Okres Písek.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PISEK = "CZ,31,4";

		/**
		 * Region code of the Okres Plzeň-město.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PLZEN_MESTO = "CZ,32,3";

		/**
		 * Region code of the Okres Plzeň-jih.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PLZEN_JIH = "CZ,32,4";

		/**
		 * Region code of the Okres Plzeň-sever.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PLZEN_SEVER = "CZ,32,5";

		/**
		 * Region code of the Okres Prachatice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PRACHATICE = "CZ,31,5";

		/**
		 * Region code of the Okres Praha-východ.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PRAHA_VYCHOD = "CZ,20,9";

		/**
		 * Region code of the Okres Praha-západ.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PRAHA_ZAPAD = "CZ,20,A";

		/**
		 * Region code of the Okres Přerov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PREROV = "CZ,71,4";

		/**
		 * Region code of the Okres Příbram.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PRIBRAM = "CZ,20,B";

		/**
		 * Region code of the Okres Prostějov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PROSTEJOV = "CZ,71,3";

		/**
		 * Region code of the Okres Rakovník.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_RAKOVNIK = "CZ,20,C";

		/**
		 * Region code of the Okres Rokycany.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ROKYCANY = "CZ,32,6";

		/**
		 * Region code of the Okres Rychnov nad Kněžnou.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_RYCHNOV_NAD_KNEZNOU = "CZ,52,4";

		/**
		 * Region code of the Okres Semily.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SEMILY = "CZ,51,4";

		/**
		 * Region code of the Okres Sokolov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SOKOLOV = "CZ,41,3";

		/**
		 * Region code of the Okres Strakonice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_STRAKONICE = "CZ,31,6";

		/**
		 * Region code of the Okres Šumperk.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SUMPERK = "CZ,71,5";

		/**
		 * Region code of the Okres Svitavy.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SVITAVY = "CZ,53,3";

		/**
		 * Region code of the Okres Tábor.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TABOR = "CZ,31,7";

		/**
		 * Region code of the Okres Tachov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TACHOV = "CZ,32,7";

		/**
		 * Region code of the Okres Teplice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TEPLICE = "CZ,42,6";

		/**
		 * Region code of the Okres Třebíč.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TREBIC = "CZ,63,4";

		/**
		 * Region code of the Okres Trutnov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TRUTNOV = "CZ,52,5";

		/**
		 * Region code of the Okres Uherské Hradiště.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_UHERSKE_HRADISTE = "CZ,72,2";

		/**
		 * Region code of the Okres Ústí nad Labem.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_USTI_NAD_LABEM = "CZ,42,7";

		/**
		 * Region code of the Okres Ústí nad Orlicí.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_USTI_NAD_ORLICI = "CZ,53,4";

		/**
		 * Region code of the Okres Vsetín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_VSETIN = "CZ,72,3";

		/**
		 * Region code of the Okres Vyškov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_VYSKOV = "CZ,64,6";

		/**
		 * Region code of the Okres Žďár nad Sázavou.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZDAR_NAD_SAZAVOU = "CZ,63,5";

		/**
		 * Region code of the Okres Zlín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZLIN = "CZ,72,4";

		/**
		 * Region code of the Okres Znojmo.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZNOJMO = "CZ,64,7";

		/**
		 * Region code of the Olomoucký kraj.
		 *
		 * @since 1.0
		 */
		public static final String OLOMOUCKY_KRAJ = "CZ,71";

		/**
		 * Region code of the Pardubický kraj.
		 *
		 * @since 1.0
		 */
		public static final String PARDUBICKY_KRAJ = "CZ,53";

		/**
		 * Region code of the Plzeňský kraj.
		 *
		 * @since 1.0
		 */
		public static final String PLZENSKY_KRAJ = "CZ,32";

		/**
		 * Region code of the Středočeský kraj.
		 *
		 * @since 1.0
		 */
		public static final String STREDOCESKY_KRAJ = "CZ,20";

		/**
		 * Region code of the Ústecký kraj.
		 *
		 * @since 1.0
		 */
		public static final String USTECKY_KRAJ = "CZ,42";

		/**
		 * Region code of the Zlínský kraj.
		 *
		 * @since 1.0
		 */
		public static final String ZLÍNSKY_KRAJ = "CZ,72";


		private CzechRepublic() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Denmark.
	 *
	 * @since 1.0
	 */
	public static class Denmark {

		/**
		 * Region code of the Færøerne.
		 *
		 * @since 1.0
		 */
		public static final String FAEROERNE = "FO";

		/**
		 * Region code of the Grønland.
		 *
		 * @since 1.0
		 */
		public static final String GRONLAND = "GL";

		/**
		 * Region code of the Region Hovedstaden.
		 *
		 * @since 1.0
		 */
		public static final String REGION_HOVEDSTADEN = "DA,84";

		/**
		 * Region code of the Region Midtjylland.
		 *
		 * @since 1.0
		 */
		public static final String REGION_MIDTJYLLAND = "DA,82";

		/**
		 * Region code of the Region Nordjylland.
		 *
		 * @since 1.0
		 */
		public static final String REGION_NORDJYLLAND = "DA,81";

		/**
		 * Region code of the Region Sjælland.
		 *
		 * @since 1.0
		 */
		public static final String REGION_SJAELLAND = "DA,85";

		/**
		 * Region code of the Region Syddanmark.
		 *
		 * @since 1.0
		 */
		public static final String REGION_SYDDANMARK = "DA,83";


		private Denmark() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Estonia.
	 *
	 * @since 1.0
	 */
	public static class Estonia {

		/**
		 * Region code of the Harju maakond.
		 *
		 * @since 1.0
		 */
		public static final String HARJU_MAAKOND = "EE,37";

		/**
		 * Region code of the Hiiu maakond.
		 *
		 * @since 1.0
		 */
		public static final String HIIU_MAAKOND = "EE,39";

		/**
		 * Region code of the Ida-Viru maakond.
		 *
		 * @since 1.0
		 */
		public static final String IDA_VIRU_MAAKOND = "EE,44";

		/**
		 * Region code of the Järva maakond.
		 *
		 * @since 1.0
		 */
		public static final String JARVA_MAAKOND = "EE,51";

		/**
		 * Region code of the Jõgeva maakond.
		 *
		 * @since 1.0
		 */
		public static final String JOGEVA_MAAKOND = "EE,49";

		/**
		 * Region code of the Lääne maakond.
		 *
		 * @since 1.0
		 */
		public static final String LAANE_MAAKOND = "EE,57";

		/**
		 * Region code of the Lääne-Viru maakond.
		 *
		 * @since 1.0
		 */
		public static final String LAANE_VIRU_MAAKOND = "EE,59";

		/**
		 * Region code of the Pärnu maakond.
		 *
		 * @since 1.0
		 */
		public static final String PARNU_MAAKOND = "EE,67";

		/**
		 * Region code of the Põlva maakond.
		 *
		 * @since 1.0
		 */
		public static final String POLVA_MAAKOND = "EE,65";

		/**
		 * Region code of the Rapla maakond.
		 *
		 * @since 1.0
		 */
		public static final String RAPLA_MAAKOND = "EE,70";

		/**
		 * Region code of the Saare maakond.
		 *
		 * @since 1.0
		 */
		public static final String SAARE_MAAKOND = "EE,74";

		/**
		 * Region code of the Tartu maakond.
		 *
		 * @since 1.0
		 */
		public static final String TARTU_MAAKOND = "EE,78";

		/**
		 * Region code of the Valga maakond.
		 *
		 * @since 1.0
		 */
		public static final String VALGA_MAAKOND = "EE,82";

		/**
		 * Region code of the Viljandi maakond.
		 *
		 * @since 1.0
		 */
		public static final String VILJANDI_MAAKOND = "EE,84";

		/**
		 * Region code of the Võru maakond.
		 *
		 * @since 1.0
		 */
		public static final String VORU_MAAKOND = "EE,86";


		private Estonia() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Finland.
	 *
	 * @since 1.0
	 */
	public static class Finland {

		/**
		 * Region code of the Ahvenanmaan maakunta (also known as Åland Islands).
		 *
		 * @since 1.0
		 */
		public static final String AHVENANMAAN_MAAKUNTA = "AX";

		/**
		 * Region code of the Etelä-Karjalan maakunta (also known as South Karelia).
		 *
		 * @since 1.0
		 */
		public static final String ETELA_KARJALAN_MAAKUNTA = "FI,09";

		/**
		 * Region code of the Etelä-Pohjanmaan maakunta (also known as Southern Ostrobothnia).
		 *
		 * @since 1.0
		 */
		public static final String ETELA_POHJANMAAN_MAAKUNTA = "FI,14";

		/**
		 * Region code of the Etelä-Savon maakunta (also known as Southern Savonia).
		 *
		 * @since 1.0
		 */
		public static final String ETELA_SAVON_MAAKUNTA = "FI,10";

		/**
		 * Region code of the Kainuun maakunta.
		 *
		 * @since 1.0
		 */
		public static final String KAINUUN_MAAKUNTA = "FI,18";

		/**
		 * Region code of the Kanta-Hämeen maakunta.
		 *
		 * @since 1.0
		 */
		public static final String KANTA_HAMEEN_MAAKUNTA = "FI,05";

		/**
		 * Region code of the Keski-Pohjanmaan maakunta (also known as Central Ostrobothnia).
		 *
		 * @since 1.0
		 */
		public static final String KESKI_POHJANMAAN_MAAKUNTA = "FI,16";

		/**
		 * Region code of the Keski-Suomen maakunta (also known as Central Finland).
		 *
		 * @since 1.0
		 */
		public static final String KESKI_SUOMEN_MAAKUNTA = "FI,13";

		/**
		 * Region code of the Kymenlaakson maakunta.
		 *
		 * @since 1.0
		 */
		public static final String KYMENLAAKSON_MAAKUNTA = "FI,08";

		/**
		 * Region code of the Lapin maakunta (also known as Lapland).
		 *
		 * @since 1.0
		 */
		public static final String LAPIN_MAAKUNTA = "FI,19";

		/**
		 * Region code of the Päijät-Hämeen maakunta.
		 *
		 * @since 1.0
		 */
		public static final String PAIJAT_HAMEEN_MAAKUNTA = "FI,07";

		/**
		 * Region code of the Pirkanmaan maakunta.
		 *
		 * @since 1.0
		 */
		public static final String PIRKANMAAN_MAAKUNTA = "FI,06";

		/**
		 * Region code of the Pohjanmaan maakunta (also known as Ostrobothnia).
		 *
		 * @since 1.0
		 */
		public static final String POHJANMAAN_MAAKUNTA = "FI,15";

		/**
		 * Region code of the Pohjois-Karjala (also known as North Karelia).
		 *
		 * @since 1.0
		 */
		public static final String POHJOIS_KARJALA = "FI,12";

		/**
		 * Region code of the Pohjois-Pohjanmaan maakunta (also known as Northern Ostrobothnia).
		 *
		 * @since 1.0
		 */
		public static final String POHJOIS_POHJANMAAN_MAAKUNTA = "FI,17";

		/**
		 * Region code of the Pohjois-Savon maakunta (also known as Northern Savonia).
		 *
		 * @since 1.0
		 */
		public static final String POHJOIS_SAVON_MAAKUNTA = "FI,11";

		/**
		 * Region code of the Satakunnan maakunta.
		 *
		 * @since 1.0
		 */
		public static final String SATAKUNNAN_MAAKUNTA = "FI,04";

		/**
		 * Region code of the Uudenmaan maakunta.
		 *
		 * @since 1.0
		 */
		public static final String UUDENMAAN_MAAKUNTA = "FI,01";

		/**
		 * Region code of the Varsinais-Suomen maakunta (also known as Southwest Finland).
		 *
		 * @since 1.0
		 */
		public static final String VARSINAIS_SUOMEN_MAAKUNTA = "FI,02";


		private Finland() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in France.
	 *
	 * @since 1.0
	 */
	public static class France {

		/**
		 * Region code of the Commune de Paris.
		 *
		 * @since 1.0
		 */
		public static final String COMMUNE_DE_PARIS = "FR,11,75";

		/**
		 * Region code of the Département d'Eure-et-Loir.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_D_EURE_ET_LOIR = "FR,24,28";

		/**
		 * Region code of the Département de l'Ain.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_AIN = "FR,84,01";

		/**
		 * Region code of the Département de l'Aisne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_AISNE = "FR,32,02";

		/**
		 * Region code of the Département de l'Allier.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_ALLIER = "FR,84,03";

		/**
		 * Region code of the Département de l'Ardèche.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_ARDECHE = "FR,84,07";

		/**
		 * Region code of the Département de l'Ariège.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_ARIEGE = "FR,76,09";

		/**
		 * Region code of the Département de l'Aube.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_AUBE = "FR,44,10";

		/**
		 * Region code of the Département de l'Aude.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_AUDE = "FR,76,11";

		/**
		 * Region code of the Département de l'Aveyron.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_AVEYRON = "FR,76,12";

		/**
		 * Region code of the Département de l'Essonne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_ESSONNE = "FR,11,91";

		/**
		 * Region code of the Département de l'Eure.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_EURE = "FR,28,27";

		/**
		 * Region code of the Département de l'Hérault.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_HERAULT = "FR,76,34";

		/**
		 * Region code of the Département de l'Ille-et-Vilaine.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_ILLE_ET_VILAINE = "FR,53,35";

		/**
		 * Region code of the Département de l'Indre.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_INDRE = "FR,24,36";

		/**
		 * Region code of the Département de l'Indre-et-Loire.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_INDRE_ET_LOIRE = "FR,24,37";

		/**
		 * Region code of the Département de l'Isère.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_ISERE = "FR,84,38";

		/**
		 * Region code of the Département de l'Oise.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_OISE = "FR,32,60";

		/**
		 * Region code of the Département de l'Orne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_ORNE = "FR,28,61";

		/**
		 * Region code of the Département de l'Yonne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_L_YONNE = "FR,27,89";

		/**
		 * Region code of the Département de la Charente.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_CHARENTE = "FR,75,16";

		/**
		 * Region code of the Département de la Charente-Maritime.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_CHARENTE_MARITIME = "FR,75,17";

		/**
		 * Region code of the Département de la Corrèze.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_CORREZE = "FR,75,19";

		/**
		 * Region code of the Département de la Corse-du-Sud.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_CORSE_DU_SUD = "FR,94,2A";

		/**
		 * Region code of the Département de la Côte-d'Or.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_COTE_D_OR = "FR,27,21";

		/**
		 * Region code of the Département de la Creuse.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_CREUSE = "FR,75,23";

		/**
		 * Region code of the Département de la Dordogne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_DORDOGNE = "FR,75,24";

		/**
		 * Region code of the Département de la Drôme.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_DROME = "FR,84,26";

		/**
		 * Region code of the Département de la Gironde.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_GIRONDE = "FR,75,33";

		/**
		 * Region code of the Département de la Haute-Corse.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_HAUTE_CORSE = "FR,94,2B";

		/**
		 * Region code of the Département de la Haute-Garonne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_HAUTE_GARONNE = "FR,76,31";

		/**
		 * Region code of the Département de la Haute-Loire.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_HAUTE_LOIRE = "FR,84,43";

		/**
		 * Region code of the Département de la Haute-Marne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_HAUTE_MARNE = "FR,44,52";

		/**
		 * Region code of the Département de la Haute-Saône.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_HAUTE_SAONE = "FR,27,70";

		/**
		 * Region code of the Département de la Haute-Savoie.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_HAUTE_SAVOIE = "FR,84,74";

		/**
		 * Region code of the Département de la Haute-Vienne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_HAUTE_VIENNE = "FR,75,87";

		/**
		 * Region code of the Département de la Loire.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_LOIRE = "FR,84,42";

		/**
		 * Region code of the Département de la Loire-Atlantique.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_LOIRE_ATLANTIQUE = "FR,52,44";

		/**
		 * Region code of the Département de la Lozère.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_LOZERE = "FR,76,48";

		/**
		 * Region code of the Département de la Manche.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_MANCHE = "FR,28,50";

		/**
		 * Region code of the Département de la Marne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_MARNE = "FR,44,51";

		/**
		 * Region code of the Département de la Mayenne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_MAYENNE = "FR,52,53";

		/**
		 * Region code of the Département de la Meuse.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_MEUSE = "FR,44,55";

		/**
		 * Region code of the Département de la Moselle.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_MOSELLE = "FR,44,57";

		/**
		 * Region code of the Département de la Sarthe.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_SARTHE = "FR,52,72";

		/**
		 * Region code of the Département de la Savoie.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_SAVOIE = "FR,84,73";

		/**
		 * Region code of the Département de la Seine-et-Marne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_SEINE_ET_MARNE = "FR,11,77";

		/**
		 * Region code of the Département de la Seine-Maritime.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_SEINE_MARITIME = "FR,28,76";

		/**
		 * Region code of the Département de la Seine-Saint-Denis.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_SEINE_SAINT_DENIS = "FR,11,93";

		/**
		 * Region code of the Département de la Somme.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_SOMME = "FR,32,80";

		/**
		 * Region code of the Département de la Vendée.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_VENDEE = "FR,52,85";

		/**
		 * Region code of the Département de la Vienne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_VIENNE = "FR,75,86";

		/**
		 * Region code of the Département de Loir-et-Cher.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LOIR_ET_CHER = "FR,24,41";

		/**
		 * Region code of the Département de Lot-et-Garonne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LOT_ET_GARONNE = "FR,75,47";

		/**
		 * Region code of the Département de Meurthe-et-Moselle.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_MEURTHE_ET_MOSELLE = "FR,44,54";

		/**
		 * Region code of the Département de la Nièvre.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_NIEVRE = "FR,27,58";

		/**
		 * Region code of the Département de la Saône-et-Loire.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DE_LA_SAONE_ET_LOIRE = "FR,27,71";

		/**
		 * Region code of the Département des Alpes-de-Haute-Provence.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_ALPES_DE_HAUTE_PROVENCE = "FR,93,04";

		/**
		 * Region code of the Département des Alpes-Maritimes.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_ALPES_MARITIMES = "FR,93,06";

		/**
		 * Region code of the Département des Ardennes.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_ARDENNES = "FR,44,08";

		/**
		 * Region code of the Département des Bouches-du-Rhône.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_BOUCHES_DU_RHONE = "FR,93,13";

		/**
		 * Region code of the Département des Côtes-d'Armor.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_COTES_D_ARMOR = "FR,53,22";

		/**
		 * Region code of the Département des Deux-Sèvres.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_DEUX_SEVRES = "FR,75,79";

		/**
		 * Region code of the Département des Hautes-Alpes.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_HAUTES_ALPES = "FR,93,05";

		/**
		 * Region code of the Département des Hautes-Pyrénées.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_HAUTES_PYRENEES = "FR,76,65";

		/**
		 * Region code of the Département des Hauts-de-Seine.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_HAUTS_DE_SEINE = "FR,11,92";

		/**
		 * Region code of the Département des Landes.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_LANDES = "FR,75,40";

		/**
		 * Region code of the Département des Pyrénées-Atlantiques.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_PYRENEES_ATLANTIQUES = "FR,75,64";

		/**
		 * Region code of the Département des Pyrénées-Orientales.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_PYRENEES_ORIENTALES = "FR,76,66";

		/**
		 * Region code of the Département des Vosges.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_VOSGES = "FR,44,88";

		/**
		 * Region code of the Département des Yvelines.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DES_YVELINES = "FR,11,78";

		/**
		 * Region code of the Département du Bas-Rhin.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_BAS_RHIN = "FR,44,67";

		/**
		 * Region code of the Département du Calvados.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_CALVADOS = "FR,28,14";

		/**
		 * Region code of the Département du Cantal.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_CANTAL = "FR,84,15";

		/**
		 * Region code of the Département du Cher.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_CHER = "FR,24,18";

		/**
		 * Region code of the Département du Doubs.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_DOUBS = "FR,27,25";

		/**
		 * Region code of the Département du Finistère.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_FINISTERE = "FR,53,29";

		/**
		 * Region code of the Département du Gard.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_GARD = "FR,76,30";

		/**
		 * Region code of the Département du Gers.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_GERS = "FR,76,32";

		/**
		 * Region code of the Département du Haut-Rhin.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_HAUT_RHIN = "FR,44,68";

		/**
		 * Region code of the Département du Jura.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_JURA = "FR,27,39";

		/**
		 * Region code of the Département du Loiret.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_LOIRET = "FR,24,45";

		/**
		 * Region code of the Département du Lot.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_LOT = "FR,76,46";

		/**
		 * Region code of the Département du Maine-et-Loire.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_MAINE_ET_LOIRE = "FR,52,49";

		/**
		 * Region code of the Département du Morbihan.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_MORBIHAN = "FR,53,56";

		/**
		 * Region code of the Département du Nord.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_NORD = "FR,32,59";

		/**
		 * Region code of the Département du Pas-de-Calais.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_PAS_DE_CALAIS = "FR,32,62";

		/**
		 * Region code of the Département du Puy-de-Dôme.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_PUY_DE_DOME = "FR,84,63";

		/**
		 * Region code of the Département du Rhône.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_RHONE = "FR,84,69";

		/**
		 * Region code of the Département du Tarn.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_TARN = "FR,76,81";

		/**
		 * Region code of the Département du Tarn-et-Garonne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_TARN_ET_GARONNE = "FR,76,82";

		/**
		 * Region code of the Département du Val-d'Oise.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_VAL_D_OISE = "FR,11,95";

		/**
		 * Region code of the Département du Val-de-Marne.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_VAL_DE_MARNE = "FR,11,94";

		/**
		 * Region code of the Département du Var.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_VAR = "FR,93,83";

		/**
		 * Region code of the Département du Vaucluse.
		 *
		 * @since 1.0
		 */
		public static final String DEPARTEMENT_DU_VAUCLUSE = "FR,93,84";

		/**
		 * Region code of the Métropole de Lyon.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLE_DE_LYON = "FR,84,69M";

		/**
		 * Region code of the Région Alsace-Champagne-Ardenne-Lorraine.
		 *
		 * @since 1.0
		 */
		public static final String REGION_ALSACE_CHAMPAGNE_ARDENNE_LORRAINE = "FR,44";

		/**
		 * Region code of the Région Aquitaine-Limousin-Poitou-Charentes.
		 *
		 * @since 1.0
		 */
		public static final String REGION_AQUITAINE_LIMOUSIN_POITOU_CHARENTES = "FR,75";

		/**
		 * Region code of the Région Auvergne-Rhône-Alpes.
		 *
		 * @since 1.0
		 */
		public static final String REGION_AUVERGNE_RHONE_ALPES = "FR,84";

		/**
		 * Region code of the Région Bourgogne-Franche-Comté.
		 *
		 * @since 1.0
		 */
		public static final String REGION_BOURGOGNE_FRANCHE_COMTE = "FR,27";

		/**
		 * Region code of the Région Centre-Val de Loire.
		 *
		 * @since 1.0
		 */
		public static final String REGION_CENTRE_VAL_DE_LOIRE = "FR,24";

		/**
		 * Region code of the Région de Bretagne.
		 *
		 * @since 1.0
		 */
		public static final String REGION_DE_BRETAGNE = "FR,53";

		/**
		 * Region code of the Région de Corse.
		 *
		 * @since 1.0
		 */
		public static final String REGION_DE_CORSE = "FR,94";

		/**
		 * Region code of the Région de Île-de-France.
		 *
		 * @since 1.0
		 */
		public static final String REGION_DE_ILE_DE_FRANCE = "FR,11";

		/**
		 * Region code of the Région de Normandie.
		 *
		 * @since 1.0
		 */
		public static final String REGION_DE_NORMANDIE = "FR,28";

		/**
		 * Region code of the Région de Pays de la Loire.
		 *
		 * @since 1.0
		 */
		public static final String REGION_DE_PAYS_DE_LA_LOIRE = "FR,52";

		/**
		 * Region code of the Région Languedoc-Roussillon-Midi-Pyrénées.
		 *
		 * @since 1.0
		 */
		public static final String REGION_LANGUEDOC_ROUSSILLON_MIDI_PYRENEES = "FR,76";

		/**
		 * Region code of the Région Nord-Pas-de-Calais-Picardie.
		 *
		 * @since 1.0
		 */
		public static final String REGION_NORD_PAS_DE_CALAIS_PICARDIE = "FR,32";

		/**
		 * Region code of the Région Provence-Alpes-Côte d'Azur.
		 *
		 * @since 1.0
		 */
		public static final String REGION_PROVENCE_ALPES_COTE_D_AZUR = "FR,93";

		/**
		 * Region code of the Territoire de Belfort.
		 *
		 * @since 1.0
		 */
		public static final String TERRITOIRE_DE_BELFORT = "FR,27,90";


		private France() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Georgia.
	 *
	 * @since 1.0
	 */
	public static class Georgia {

		/**
		 * Region code of the Acharis avtonomiuri respublika (known as Adjara).
		 *
		 * @since 1.0
		 */
		public static final String ACHARIS_AVTONOMIURI_RESPUBLIKA = "GE,04";

		/**
		 * Region code of the Apkhazetis avtonomiuri respublika (known as Abkhazia).
		 *
		 * @since 1.0
		 */
		public static final String APKHAZETIS_AVTONOMIURI_RESPUBLIKA = "GE,02";

		/**
		 * Region code of the Kalaki Tbilisi.
		 *
		 * @since 1.0
		 */
		public static final String KALAK_TBILISI = "GE,51";

		/**
		 * Region code of the Mkhare Guria.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_GURIA = "GE,65";

		/**
		 * Region code of the Mkhare Imereti.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_IMERETI = "GE,66";

		/**
		 * Region code of the Mkhare Kakheti.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_KAKHETI = "GE,67";

		/**
		 * Region code of the Mkhare Kvemo Kartli.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_KVEMO_KARTLI = "GE,68";

		/**
		 * Region code of the Mkhare Mtskheta-Mtianeti.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_MTSKHETA_MTIANETI = "GE,69";

		/**
		 * Region code of the Mkhare Racha-Lechkhumi da Kvemo Svaneti.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_RACHA_LECHKHUMI_DA_KVEMO_SVANETI = "GE,70";

		/**
		 * Region code of the Mkhare Samegrelo-Zemo Svaneti.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_SAMEGRELO_ZEMO_SVANETI = "GE,71";

		/**
		 * Region code of the Mkhare Samtskhe-Javakheti.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_SAMTSKHE_JAVAKHETI = "GE,72";

		/**
		 * Region code of the Mkhare Shida Kartli.
		 *
		 * @since 1.0
		 */
		public static final String MKHARE_SHIDA_KARTLI = "GE,73";


		private Georgia() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Germany.
	 *
	 * @since 1.0
	 */
	public static class Germany {

		/**
		 * Region code of the Freie Hansestadt Bremen.
		 *
		 * @since 1.0
		 */
		public static final String FREIE_HANSESTADT_BREMEN = "DE,04";

		/**
		 * Region code of the Freie und Hansestadt Hamburg.
		 *
		 * @since 1.0
		 */
		public static final String FREIE_UND_HANSESTADT_HAMBURG = "DE,02";

		/**
		 * Region code of the Freistaat Bayern.
		 *
		 * @since 1.0
		 */
		public static final String FREISTAAT_BAYERN = "DE,09";

		/**
		 * Region code of the Freistaat Sachsen.
		 *
		 * @since 1.0
		 */
		public static final String FREISTAAT_SACHSEN = "DE,14";

		/**
		 * Region code of the Freistaat Thüringen.
		 *
		 * @since 1.0
		 */
		public static final String FREISTAAT_THUERINGEN = "DE,16";

		/**
		 * Region code of the Land Baden-Württemberg.
		 *
		 * @since 1.0
		 */
		public static final String LAND_BADEN_WUERTTEMBERG = "DE,08";

		/**
		 * Region code of the Land Berlin.
		 *
		 * @since 1.0
		 */
		public static final String LAND_BERLIN = "DE,11";

		/**
		 * Region code of the Land Brandenburg.
		 *
		 * @since 1.0
		 */
		public static final String LAND_BRANDENBURG = "DE,12";

		/**
		 * Region code of the Land Hessen.
		 *
		 * @since 1.0
		 */
		public static final String LAND_HESSEN = "DE,06";

		/**
		 * Region code of the Land Mecklenburg-Vorpommern.
		 *
		 * @since 1.0
		 */
		public static final String LAND_MECKLENBURG_VORPOMMERN = "DE,13";

		/**
		 * Region code of the Land Niedersachsen.
		 *
		 * @since 1.0
		 */
		public static final String LAND_NIEDERSACHSEN = "DE,03";

		/**
		 * Region code of the Land Nordrhein-Westfalen.
		 *
		 * @since 1.0
		 */
		public static final String LAND_NORDRHEIN_WESTFALEN = "DE,05";

		/**
		 * Region code of the Land Rheinland-Pfalz.
		 *
		 * @since 1.0
		 */
		public static final String LAND_RHEINLAND_PFALZ = "DE,07";

		/**
		 * Region code of the Land Sachsen-Anhalt.
		 *
		 * @since 1.0
		 */
		public static final String LAND_SACHSEN_ANHALT = "DE,15";

		/**
		 * Region code of the Land Schleswig-Holstein.
		 *
		 * @since 1.0
		 */
		public static final String LAND_SCHLESWIG_HOLSTEIN = "DE,01";

		/**
		 * Region code of the Saarland.
		 *
		 * @since 1.0
		 */
		public static final String SAARLAND = "DE,10";


		private Germany() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in the Bailiwick of Guernsey.
	 *
	 * @since 1.0
	 */
	public static class Guernsey {

		/**
		 * Region code of the Jurisdiction of Alderney.
		 *
		 * @since 1.0
		 */
		public static final String JURISDICTION_OF_ALDERNEY = "GG,2";

		/**
		 * Region code of the Jurisdiction of Guernsey.
		 *
		 * @since 1.0
		 */
		public static final String JURISDICTION_OF_GUERNSEY = "GG,1";

		/**
		 * Region code of the Jurisdiction of Sark.
		 *
		 * @since 1.0
		 */
		public static final String JURISDICTION_OF_SARK = "GG,3";


		private Guernsey() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Hungary.
	 *
	 * @since 1.1
	 */
	public static class Hungary {

		/**
		 * Region code of the Bács-Kiskun megye.
		 *
		 * @since 1.1
		 */
		public static final String BACS_KISKUN_MEGYE = "HU,1,33";

		/**
		 * Region code of the Baranya megye.
		 *
		 * @since 1.1
		 */
		public static final String BARANYA_MEGYE = "HU,2,32";

		/**
		 * Region code of the Békés megye.
		 *
		 * @since 1.1
		 */
		public static final String BEKES_MEGYE = "HU,1,34";

		/**
		 * Region code of the Borsod-Abaúj-Zemplén megye.
		 *
		 * @since 1.1
		 */
		public static final String BORSOD_ABAUJ_ZEMPLEN_MEGYE = "HU,4,35";

		/**
		 * Region code of the Budapest főváros.
		 *
		 * @since 1.1
		 */
		public static final String BUDAPEST_FOVAROS = "HU,6,31";

		/**
		 * Region code of the Csongrád megye.
		 *
		 * @since 1.1
		 */
		public static final String CSONGRAD_MEGYE = "HU,1,36";

		/**
		 * Region code of the Dél-Alföld régió.
		 *
		 * @since 1.1
		 */
		public static final String DEL_ALFOLD_REGIO = "HU,1";

		/**
		 * Region code of the Dél-Dunántúl régió.
		 *
		 * @since 1.1
		 */
		public static final String DEL_DUNANTUL_REGIO = "HU,2";

		/**
		 * Region code of the Észak-Alföld régió.
		 *
		 * @since 1.1
		 */
		public static final String ESZAK_ALFOLD_REGIO = "HU,3";

		/**
		 * Region code of the Észak-Magyaroszág régió.
		 *
		 * @since 1.1
		 */
		public static final String ESZAK_MAGYAROSZAG_REGIO = "HU,4";

		/**
		 * Region code of the Fejér megye.
		 *
		 * @since 1.1
		 */
		public static final String FEJER_MEGYE = "HU,5,08";

		/**
		 * Region code of the Győr-Moson-Sopron megye.
		 *
		 * @since 1.1
		 */
		public static final String GYOR_MOSON_SOPRON_MEGYE = "HU,7,38";

		/**
		 * Region code of the Hajdú-Bihar megye.
		 *
		 * @since 1.1
		 */
		public static final String HAJDU_BIHAR_MEGYE = "HU,3,39";

		/**
		 * Region code of the Heves megye.
		 *
		 * @since 1.1
		 */
		public static final String HEVES_MEGYE = "HU,4,11";

		/**
		 * Region code of the Jász-Nagykun-Szolnok megye.
		 *
		 * @since 1.1
		 */
		public static final String JASZ_NAGYKUN_SZOLNOK_MEGYE = "HU,3,46";

		/**
		 * Region code of the Komárom-Esztergom megye.
		 *
		 * @since 1.1
		 */
		public static final String KOMAROM_ESZTERGOM_MEGYE = "HU,5,12";

		/**
		 * Region code of the Közép-Dunántúl régió.
		 *
		 * @since 1.1
		 */
		public static final String KOZEP_DUNANTUL_REGIO = "HU,5";

		/**
		 * Region code of the Közép-Magyarország régió.
		 *
		 * @since 1.1
		 */
		public static final String KOZEP_MAGYARORSZAG_REGIO = "HU,6";

		/**
		 * Region code of the Nógrád megye.
		 *
		 * @since 1.1
		 */
		public static final String NOGRAD_MEGYE = "HU,4,14";

		/**
		 * Region code of the Nyugat-Dunántúl régió.
		 *
		 * @since 1.1
		 */
		public static final String NYUGAT_DUNANTUL_REGIO = "HU,7";

		/**
		 * Region code of the Pest megye.
		 *
		 * @since 1.1
		 */
		public static final String PEST_MEGYE = "HU,6,43";

		/**
		 * Region code of the Somogy megye.
		 *
		 * @since 1.1
		 */
		public static final String SOMOGY_MEGYE = "HU,2,44";

		/**
		 * Region code of the Szabolcs-Szatmár-Bereg megye.
		 *
		 * @since 1.1
		 */
		public static final String SZABOLCS_SZATMAR_BEREG_MEGYE = "HU,3,45";

		/**
		 * Region code of the Tolna megye.
		 *
		 * @since 1.1
		 */
		public static final String TOLNA_MEGYE = "HU,2,47";

		/**
		 * Region code of the Vas megye.
		 *
		 * @since 1.1
		 */
		public static final String VAS_MEGYE = "HU,7,48";

		/**
		 * Region code of the Veszprém megye.
		 *
		 * @since 1.1
		 */
		public static final String VESZPREM_MEGYE = "HU,5,23";

		/**
		 * Region code of the Zala megye.
		 *
		 * @since 1.1
		 */
		public static final String ZALA_MEGYE = "HU,7,50";


		private Hungary() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Iceland.
	 *
	 * @since 1.0
	 */
	public static class Iceland {

		/**
		 * Region code of the Hérað Austurfirðir.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_AUSTURFIRDIR = "IS,7";

		/**
		 * Region code of the Hérað Höfuðborgarsvæðið.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_HOFUDBORGARSVAEDID = "IS,1";

		/**
		 * Region code of the Hérað Norðurland eystra.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_NORDURLAND_EYSTRA = "IS,6";

		/**
		 * Region code of the Hérað Norðurland vestra.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_NORDURLAND_VESTRA = "IS,5";

		/**
		 * Region code of the Hérað Suðurland.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_SUDURLAND = "IS,8";

		/**
		 * Region code of the Hérað Suðurnes.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_SUDURNES = "IS,2";

		/**
		 * Region code of the Hérað Vestfirðir.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_VESTFIRDIR = "IS,4";

		/**
		 * Region code of the Hérað Vesturland.
		 *
		 * @since 1.0
		 */
		public static final String HERAD_VESTURLAND = "IS,3";


		private Iceland() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Iraq.
	 *
	 * @since 1.0
	 */
	public static class Iraq {

		/**
		 * Region code of the Iqlim Kurdistan.
		 *
		 * @since 1.0
		 */
		public static final String IQLIM_KURDISTAN = "IQ,01";

		/**
		 * Region code of the Muhafazah al-Anbar.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_AL_ANBAR = "IQ,,31";

		/**
		 * Region code of the Muhafazah al-Basra.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_AL_BASRA = "IQ,,61";

		/**
		 * Region code of the Muhafazah al-Mutanna.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_AL_MUTANNA = "IQ,,66";

		/**
		 * Region code of the Muhafazah al-Qadisiya‎.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_AL_QADISIYA‎ = "IQ,,58";

		/**
		 * Region code of the Muhafazah an-Najaf.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_AN_NAJAF = "IQ,,54";

		/**
		 * Region code of the Muhafazah Arbil.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_ARBIL = "IQ,01,44";

		/**
		 * Region code of the Muhafazah Babil.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_BABIL = "IQ,,51";

		/**
		 * Region code of the Muhafazah Bagdad.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_BAGDAD = "IQ,,10";

		/**
		 * Region code of the Muhafazah Dahuk.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_DAHUK = "IQ,01,42";

		/**
		 * Region code of the Muhafazah Halabja.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_HALABJA = "IQ,01,47";

		/**
		 * Region code of the Muhafazah Dhi Qar.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_DHI_QAR = "IQ,,64";

		/**
		 * Region code of the Muhafazah Diyala.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_DIYALA = "IQ,,32";

		/**
		 * Region code of the Muhafazah Karbala.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_KARBALA = "IQ,,56";

		/**
		 * Region code of the Muhafazah Kirkuk.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_KIRKUK = "IQ,,36";

		/**
		 * Region code of the Muhafazah Maysan.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_MAYSAN = "IQ,,62";

		/**
		 * Region code of the Muhafazah Ninawa.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_NINAWA = "IQ,,41";

		/**
		 * Region code of the Muhafazah Salah ad-Din‎.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_SALAH_AD_DIN‎ = "IQ,,34";

		/**
		 * Region code of the Muhafazah Sulaymaniya.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_SULAYMANIYA = "IQ,01,46";

		/**
		 * Region code of the Muhafazah Wasit.
		 *
		 * @since 1.0
		 */
		public static final String MUHAFAZAH_WASIT = "IQ,,52";


		private Iraq() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Israel
	 *
	 * @since 1.0
	 */
	public static class Israel {

		/**
		 * Region code of the Ezor Yehuda ve-Shomron (also known as Judea and Samaria area).
		 *
		 * @since 1.0
		 */
		public static final String EZOR_YEHUDA_VE_SHOMRON = "IL,07";

		/**
		 * Region code of the Mahoz ha-Darom.
		 *
		 * @since 1.0
		 */
		public static final String MAHOZ_HA_DAROM = "IL,06";

		/**
		 * Region code of the Mahoz Haifa.
		 *
		 * @since 1.0
		 */
		public static final String MAHOZ_HAIFA = "IL,03";

		/**
		 * Region code of the Mahoz ha-Merkaz.
		 *
		 * @since 1.0
		 */
		public static final String MAHOZ_HA_MERKAZ = "IL,04";

		/**
		 * Region code of the Mahoz ha-Tsafon.
		 *
		 * @since 1.0
		 */
		public static final String MAHOZ_HA_TSAFON = "IL,02";

		/**
		 * Region code of the Mahoz Tel Aviv.
		 *
		 * @since 1.0
		 */
		public static final String MAHOZ_TEL_AVIV = "IL,05";

		/**
		 * Region code of the Mahoz Yerushalayim (also known as Jerusalem district).
		 *
		 * @since 1.0
		 */
		public static final String MAHOZ_YERUSHALAYIM = "IL,01";


		private Israel() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Italy.
	 *
	 * @since 1.0
	 */
	public static class Italy {

		/**
		 * Region code of the Città metropolitana di Bari.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_BARI = "IT,16,0072";

		/**
		 * Region code of the Città metropolitana di Bologna.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_BOLOGNA = "IT,08,0037";

		/**
		 * Region code of the Città metropolitana di Firenze.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_FIRENZE = "IT,09,0048";

		/**
		 * Region code of the Città metropolitana di Genova.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_GENOVA = "IT,07,0010";

		/**
		 * Region code of the Città metropolitana di Milano.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_MILANO = "IT,03,0015";

		/**
		 * Region code of the Città metropolitana di Napoli.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_NAPOLI = "IT,15,0063";

		/**
		 * Region code of the Città metropolitana di Torino.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_TORINO = "IT,01,0001";

		/**
		 * Region code of the Città metropolitana di Venezia.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_VENEZIA = "IT,05,0027";

		/**
		 * Region code of the Città metropolitana di Reggio Calabria.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_REGGIO_CALABRIA = "IT,18,0080";

		/**
		 * Region code of the Città metropolitana di Roma Capitale.
		 *
		 * @since 1.0
		 */
		public static final String CITTA_METROPOLITANA_DI_ROMA_CAPITALE = "IT,12,0058";

		/**
		 * Region code of the Libero consorzio comunale di Agrigento.
		 *
		 * @since 1.0
		 */
		public static final String LIBERO_CONSORZIO_COMUNALE_DI_AGRIGENTO = "IT,19,0084";

		/**
		 * Region code of the Libero consorzio comunale di Ragusa.
		 *
		 * @since 1.0
		 */
		public static final String LIBERO_CONSORZIO_COMUNALE_DI_RAGUSA = "IT,19,0088";

		/**
		 * Region code of the Provincia autonoma di Bolzano.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_AUTONOMA_DI_BOLZANO = "IT,04,0021";

		/**
		 * Region code of the Provincia autonoma di Trento.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_AUTONOMA_DI_TRENTO = "IT,04,0022";

		/**
		 * Region code of the Provincia del Medio Campidano.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DEL_MEDIO_CAMPIDANO = "IT,20,0106";

		/**
		 * Region code of the Provincia del Verbano-Cusio-Ossola.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DEL_VERBANO_CUSIO_OSSOLA = "IT,01,0103";

		/**
		 * Region code of the Provincia dell'Aquila.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DELL_AQUILA = "IT,13,0066";

		/**
		 * Region code of the Provincia dell'Ogliastra.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DELL_OGLIASTRA = "IT,20,0105";

		/**
		 * Region code of the Provincia della Spezia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DELLA_SPEZIA = "IT,07,0011";

		/**
		 * Region code of the Provincia di Alessandria.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ALESSANDRIA = "IT,01,0006";

		/**
		 * Region code of the Provincia di Ancona.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ANCONA = "IT,11,0042";

		/**
		 * Region code of the Provincia di Arezzo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_AREZZO = "IT,09,0051";

		/**
		 * Region code of the Provincia di Ascoli Piceno.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ASCOLI_PICENO = "IT,11,0044";

		/**
		 * Region code of the Provincia di Asti.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ASTI = "IT,01,0005";

		/**
		 * Region code of the Provincia di Avellino.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_AVELLINO = "IT,15,0064";

		/**
		 * Region code of the Provincia di Barletta-Andria-Trani.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_BARLETTA_ANDRIA_TRANI = "IT,16,0110";

		/**
		 * Region code of the Provincia di Belluno.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_BELLUNO = "IT,05,0025";

		/**
		 * Region code of the Provincia di Benevento.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_BENEVENTO = "IT,15,0062";

		/**
		 * Region code of the Provincia di Bergamo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_BERGAMO = "IT,03,0016";

		/**
		 * Region code of the Provincia di Biella.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_BIELLA = "IT,01,0096";

		/**
		 * Region code of the Provincia di Brescia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_BRESCIA = "IT,03,0017";

		/**
		 * Region code of the Provincia di Brindisi.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_BRINDISI = "IT,16,0074";

		/**
		 * Region code of the Provincia di Cagliari.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CAGLIARI = "IT,20,0092";

		/**
		 * Region code of the Provincia di Caltanissetta.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CALTANISSETTA = "IT,19,0085";

		/**
		 * Region code of the Provincia di Campobasso.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CAMPOBASSO = "IT,14,0070";

		/**
		 * Region code of the Provincia di Carbonia-Iglesias.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CARBONIA_IGLESIAS = "IT,20,0107";

		/**
		 * Region code of the Provincia di Caserta.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CASERTA = "IT,15,0061";

		/**
		 * Region code of the Provincia di Catania.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CATANIA = "IT,19,0087";

		/**
		 * Region code of the Provincia di Catanzaro.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CATANZARO = "IT,18,0079";

		/**
		 * Region code of the Provincia di Chieti.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CHIETI = "IT,13,0069";

		/**
		 * Region code of the Provincia di Como.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_COMO = "IT,03,0013";

		/**
		 * Region code of the Provincia di Cosenza.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_COSENZA = "IT,18,0078";

		/**
		 * Region code of the Provincia di Cremona.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CREMONA = "IT,03,0019";

		/**
		 * Region code of the Provincia di Crotone.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CROTONE = "IT,18,0101";

		/**
		 * Region code of the Provincia di Cuneo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_CUNEO = "IT,01,0004";

		/**
		 * Region code of the Provincia di Enna.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ENNA = "IT,19,0086";

		/**
		 * Region code of the Provincia di Fermo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_FERMO = "IT,11,0109";

		/**
		 * Region code of the Provincia di Ferrara.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_FERRARA = "IT,08,0038";

		/**
		 * Region code of the Provincia di Foggia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_FOGGIA = "IT,16,0071";

		/**
		 * Region code of the Provincia di Forlì-Cesena.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_FORLI_CESENA = "IT,08,0040";

		/**
		 * Region code of the Provincia di Frosinone.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_FROSINONE = "IT,12,0060";

		/**
		 * Region code of the Provincia di Gorizia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_GORIZIA = "IT,06,0031";

		/**
		 * Region code of the Provincia di Grosseto.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_GROSSETO = "IT,09,0053";

		/**
		 * Region code of the Provincia di Imperia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_IMPERIA = "IT,07,0008";

		/**
		 * Region code of the Provincia di Isernia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ISERNIA = "IT,14,0094";

		/**
		 * Region code of the Provincia di Latina.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_LATINA = "IT,12,0059";

		/**
		 * Region code of the Provincia di Lecce.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_LECCE = "IT,16,0075";

		/**
		 * Region code of the Provincia di Lecco.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_LECCO = "IT,03,0097";

		/**
		 * Region code of the Provincia di Livorno.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_LIVORNO = "IT,09,0049";

		/**
		 * Region code of the Provincia di Lodi.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_LODI = "IT,03,0098";

		/**
		 * Region code of the Provincia di Lucca.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_LUCCA = "IT,09,0046";

		/**
		 * Region code of the Provincia di Macerata.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_MACERATA = "IT,11,0043";

		/**
		 * Region code of the Provincia di Mantova.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_MANTOVA = "IT,03,0020";

		/**
		 * Region code of the Provincia di Massa e Carrara.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_MASSA_E_CARRARA = "IT,09,0045";

		/**
		 * Region code of the Provincia di Matera.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_MATERA = "IT,17,0077";

		/**
		 * Region code of the Provincia di Messina.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_MESSINA = "IT,19,0083";

		/**
		 * Region code of the Provincia di Modena.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_MODENA = "IT,08,0036";

		/**
		 * Region code of the Provincia di Monza e della Brianza.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_MONZA_E_DELLA_BRIANZA = "IT,03,0108";

		/**
		 * Region code of the Provincia di Novara.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_NOVARA = "IT,01,0003";

		/**
		 * Region code of the Provincia di Nuoro.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_NUORO = "IT,20,0091";

		/**
		 * Region code of the Provincia di Olbia-Tempio.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_OLBIA_TEMPIO = "IT,20,0104";

		/**
		 * Region code of the Provincia di Oristano.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ORISTANO = "IT,20,0095";

		/**
		 * Region code of the Provincia di Padova.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PADOVA = "IT,05,0028";

		/**
		 * Region code of the Provincia di Palermo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PALERMO = "IT,19,0082";

		/**
		 * Region code of the Provincia di Parma.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PARMA = "IT,08,0034";

		/**
		 * Region code of the Provincia di Pavia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PAVIA = "IT,03,0018";

		/**
		 * Region code of the Provincia di Perugia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PERUGIA = "IT,10,0054";

		/**
		 * Region code of the Provincia di Pesaro e Urbino.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PESARO_E_URBINO = "IT,11,0041";

		/**
		 * Region code of the Provincia di Pescara.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PESCARA = "IT,13,0068";

		/**
		 * Region code of the Provincia di Piacenza.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PIACENZA = "IT,08,0033";

		/**
		 * Region code of the Provincia di Pisa.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PISA = "IT,09,0050";

		/**
		 * Region code of the Provincia di Pistoia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PISTOIA = "IT,09,0047";

		/**
		 * Region code of the Provincia di Pordenone.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PORDENONE = "IT,06,0093";

		/**
		 * Region code of the Provincia di Potenza.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_POTENZA = "IT,17,0076";

		/**
		 * Region code of the Provincia di Prato.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_PRATO = "IT,09,0100";

		/**
		 * Region code of the Provincia di Ravenna.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_RAVENNA = "IT,08,0039";

		/**
		 * Region code of the Provincia di Reggio nell'Emilia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_REGGIO_NELL_EMILIA = "IT,08,0035";

		/**
		 * Region code of the Provincia di Rieti.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_RIETI = "IT,12,0057";

		/**
		 * Region code of the Provincia di Rimini.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_RIMINI = "IT,08,0099";

		/**
		 * Region code of the Provincia di Rovigo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_ROVIGO = "IT,05,0029";

		/**
		 * Region code of the Provincia di Salerno.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_SALERNO = "IT,15,0065";

		/**
		 * Region code of the Provincia di Sassari.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_SASSARI = "IT,20,0090";

		/**
		 * Region code of the Provincia di Savona.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_SAVONA = "IT,07,0009";

		/**
		 * Region code of the Provincia di Siena.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_SIENA = "IT,09,0052";

		/**
		 * Region code of the Provincia di Siracusa.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_SIRACUSA = "IT,19,0089";

		/**
		 * Region code of the Provincia di Sondrio.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_SONDRIO = "IT,03,0014";

		/**
		 * Region code of the Provincia di Taranto.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_TARANTO = "IT,16,0073";

		/**
		 * Region code of the Provincia di Teramo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_TERAMO = "IT,13,0067";

		/**
		 * Region code of the Provincia di Terni.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_TERNI = "IT,10,0055";

		/**
		 * Region code of the Provincia di Trapani.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_TRAPANI = "IT,19,0081";

		/**
		 * Region code of the Provincia di Treviso.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_TREVISO = "IT,05,0026";

		/**
		 * Region code of the Provincia di Trieste.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_TRIESTE = "IT,06,0032";

		/**
		 * Region code of the Provincia di Udine.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_UDINE = "IT,06,0030";

		/**
		 * Region code of the Provincia di Varese.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_VARESE = "IT,03,0012";

		/**
		 * Region code of the Provincia di Vercelli.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_VERCELLI = "IT,01,0002";

		/**
		 * Region code of the Provincia di Verona.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_VERONA = "IT,05,0023";

		/**
		 * Region code of the Provincia di Vibo Valentia.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_VIBO_VALENTIA = "IT,18,0102";

		/**
		 * Region code of the Provincia di Vicenza.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_VICENZA = "IT,05,0024";

		/**
		 * Region code of the Provincia di Viterbo.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIA_DI_VITERBO = "IT,12,0056";

		/**
		 * Region code of the Regione Abruzzo.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_ABRUZZO = "IT,13";

		/**
		 * Region code of the Regione Autonoma della Sardegna.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_AUTONOMA_DELLA_SARDEGNA = "IT,20";

		/**
		 * Region code of the Regione Autonoma Valle d'Aosta.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_AUTONOMA_VALLE_D_AOSTA = "IT,02";

		/**
		 * Region code of the Regione Autonoma Trentino-Alto Adige.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_AUTONOMA_TRENTINO_ALTO_ADIGE = "IT,04";

		/**
		 * Region code of the Regione Autonoma Friuli-Venezia Giulia.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_AUTONOMA_FRIULI_VENEZIA_GIULIA = "IT,06";

		/**
		 * Region code of the Regione Basilicata.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_BASILICATA = "IT,17";

		/**
		 * Region code of the Regione Calabria.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_CALABRIA = "IT,18";

		/**
		 * Region code of the Regione Campania.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_CAMPANIA = "IT,15";

		/**
		 * Region code of the Regione Emilia-Romagna.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_EMILIA_ROMAGNA = "IT,08";

		/**
		 * Region code of the Regione Lazio.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_LAZIO = "IT,12";

		/**
		 * Region code of the Regione Liguria.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_LIGURIA = "IT,07";

		/**
		 * Region code of the Regione Lombardia.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_LOMBARDIA = "IT,03";

		/**
		 * Region code of the Regione Marche.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_MARCHE = "IT,11";

		/**
		 * Region code of the Regione Molise.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_MOLISE = "IT,14";

		/**
		 * Region code of the Regione Piemonte.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_PIEMONTE = "IT,01";

		/**
		 * Region code of the Regione Puglia.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_PUGLIA = "IT,16";

		/**
		 * Region code of the Regione Siciliana.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_SICILIANA = "IT,19";

		/**
		 * Region code of the Regione Toscana.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_TOSCANA = "IT,09";

		/**
		 * Region code of the Regione Umbria.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_UMBRIA = "IT,10";

		/**
		 * Region code of the Regione Veneto.
		 *
		 * @since 1.0
		 */
		public static final String REGIONE_VENETO = "IT,05";


		private Italy() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Moldova.
	 *
	 * @since 1.0
	 */
	public static class Moldova {

		/**
		 * Region code of the Municipiul Bălți.
		 *
		 * @since 1.1
		 */
		public static final String MUNICIPIUL_BALTI = "MD,03";

		/**
		 * Region code of the Municipiul Bender.
		 *
		 * @since 1.1
		 */
		public static final String MUNICIPIUL_BENDER = "MD,05";

		/**
		 * Region code of the Municipiul Chișinău.
		 *
		 * @since 1.1
		 */
		public static final String MUNICIPIUL_CHISINAU = "MD,01";

		/**
		 * Region code of the Raionul Anenii Noi.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_ANENII_NOI = "MD,10";

		/**
		 * Region code of the Raionul Basarabeasca.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_BASARABEASCA = "MD,12";

		/**
		 * Region code of the Raionul Briceni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_BRICENI = "MD,14";

		/**
		 * Region code of the Raionul Cahul.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_CAHUL = "MD,17";

		/**
		 * Region code of the Raionul Călărași.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_CALARASI = "MD,25";

		/**
		 * Region code of the Raionul Cantemir.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_CANTEMIR = "MD,21";

		/**
		 * Region code of the Raionul Căușeni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_CAUSENI = "MD,27";

		/**
		 * Region code of the Raionul Cimișlia.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_CIMISLIA = "MD,29";

		/**
		 * Region code of the Raionul Criuleni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_CRIULENI = "MD,31";

		/**
		 * Region code of the Raionul Dondușeni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_DONDUSENI = "MD,34";

		/**
		 * Region code of the Raionul Drochia.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_DROCHIA = "MD,36";

		/**
		 * Region code of the Raionul Dubăsari.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_DUBASARI = "MD,38";

		/**
		 * Region code of the Raionul Edineț.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_EDINET = "MD,41";

		/**
		 * Region code of the Raionul Fălești.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_FALESTI = "MD,43";

		/**
		 * Region code of the Raionul Florești.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_FLORESTI = "MD,45";

		/**
		 * Region code of the Raionul Glodeni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_GLODENI = "MD,48";

		/**
		 * Region code of the Raionul Hîncești.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_HINCESTI = "MD,53";

		/**
		 * Region code of the Raionul Ialoveni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_IALOVENI = "MD,55";

		/**
		 * Region code of the Raionul Leova.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_LEOVA = "MD,57";

		/**
		 * Region code of the Raionul Nisporeni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_NISPORENI = "MD,60";

		/**
		 * Region code of the Raionul Ocnița.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_OCNITA = "MD,62";

		/**
		 * Region code of the Raionul Orhei.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_ORHEI = "MD,64";

		/**
		 * Region code of the Raionul Rezina.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_REZINA = "MD,67";

		/**
		 * Region code of the Raionul Rîșcani.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_RISCANI = "MD,71";

		/**
		 * Region code of the Raionul Sîngerei.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_SINGEREI = "MD,74";

		/**
		 * Region code of the Raionul Șoldănești.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_SOLDANESTI = "MD,83";

		/**
		 * Region code of the Raionul Soroca.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_SOROCA = "MD,78";

		/**
		 * Region code of the Raionul Ștefan Vodă.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_STEFAN_VODA = "MD,85";

		/**
		 * Region code of the Raionul Strășeni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_STRASENI = "MD,80";

		/**
		 * Region code of the Raionul Taraclia.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_TARACLIA = "MD,87";

		/**
		 * Region code of the Raionul Telenești.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_TELENESTI = "MD,89";

		/**
		 * Region code of the Raionul Ungheni.
		 *
		 * @since 1.1
		 */
		public static final String RAIONUL_UNGHENI = "MD,92";

		/**
		 * Region code of the Unitatea teritorială autonomă Găgăuzia.
		 *
		 * @since 1.1
		 */
		public static final String UNITATEA_TERITORIALA_AUTONOMA_GAGAUZIA = "MD,96";

		/**
		 * Region code of the Unitățile administrativ-teritoriale din stînga Nistrului.
		 *
		 * @since 1.1
		 */
		public static final String UNITATILE_ADMINISTRATIV_TERITORIALE_DIN_STINGA_NISTRULUI = "MD,98";


		private Moldova() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Malta.
	 *
	 * @since 1.0
	 */
	public static class Malta {

		/**
		 * Region code of the Reġjun Ċentrali.
		 *
		 * @since 1.0
		 */
		public static final String REGJUN_CENTRALI = "MT,1";

		/**
		 * Region code of the Reġjun Għawdex.
		 *
		 * @since 1.0
		 */
		public static final String REGJUN_GHAWDEX = "MT,5";

		/**
		 * Region code of the Reġjun Nofsinhar.
		 *
		 * @since 1.0
		 */
		public static final String REGJUN_NOFSINHAR = "MT,2";

		/**
		 * Region code of the Reġjun Tramuntana.
		 *
		 * @since 1.0
		 */
		public static final String REGJUN_TRAMUNTANA = "MT,4";

		/**
		 * Region code of the Reġjun Xlokk.
		 *
		 * @since 1.0
		 */
		public static final String REGJUN_XLOKK = "MT,3";


		private Malta() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in the Netherlands.
	 *
	 * @since 1.0
	 */
	public static class Netherlands {

		/**
		 * Region code of the Provincie Drenthe.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_DRENTHE = "NL,22";

		/**
		 * Region code of the Provincie Flevoland.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_FLEVOLAND = "NL,24";

		/**
		 * Region code of the Provincie Friesland.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_FRIESLAND = "NL,21";

		/**
		 * Region code of the Provincie Gelderland.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_GELDERLAND = "NL,25";

		/**
		 * Region code of the Provincie Groningen.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_GRONINGEN = "NL,20";

		/**
		 * Region code of the Provincie Limburg.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_LIMBURG = "NL,31";

		/**
		 * Region code of the Provincie Noord-Brabant.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_NOORD_BRABANT = "NL,30";

		/**
		 * Region code of the Provincie Noord-Holland.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_NOORD_HOLLAND = "NL,27";

		/**
		 * Region code of the Provincie Overijssel.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_OVERIJSSEL = "NL,23";

		/**
		 * Region code of the Provincie Utrecht.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_UTRECHT = "NL,26";

		/**
		 * Region code of the Provincie Zeeland.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_ZEELAND = "NL,29";

		/**
		 * Region code of the Provincie Zuid-Holland.
		 *
		 * @since 1.0
		 */
		public static final String PROVINCIE_ZUID_HOLLAND = "NL,28";


		private Netherlands() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Norway.
	 *
	 * @since 1.0
	 */
	public static class Norway {

		/**
		 * Region code of the Akershus fylke.
		 *
		 * @since 1.0
		 */
		public static final String AKERSHUS_FYLKE = "NO,02";

		/**
		 * Region code of the Aust-Agder fylke.
		 *
		 * @since 1.0
		 */
		public static final String AUST_AGDER_FYLKE = "NO,09";

		/**
		 * Region code of the Buskerud fylke.
		 *
		 * @since 1.0
		 */
		public static final String BUSKERUD_FYLKE = "NO,06";

		/**
		 * Region code of the Finnmark fylke.
		 *
		 * @since 1.0
		 */
		public static final String FINNMARK_FYLKE = "NO,20";

		/**
		 * Region code of the Hedmark fylke.
		 *
		 * @since 1.0
		 */
		public static final String HEDMARK_FYLKE = "NO,04";

		/**
		 * Region code of the Hordaland fylke.
		 *
		 * @since 1.0
		 */
		public static final String HORDALAND_FYLKE = "NO,12";

		/**
		 * Region code of the Hovestad Oslo.
		 *
		 * @since 1.0
		 */
		public static final String HOVESTAD_OSLO = "NO,03";

		/**
		 * Region code of the Møre og Romsdal fylke.
		 *
		 * @since 1.0
		 */
		public static final String MORE_OG_ROMSDAL_FYLKE = "NO,15";

		/**
		 * Region code of the Nordland fylke.
		 *
		 * @since 1.0
		 */
		public static final String NORDLAND_FYLKE = "NO,18";

		/**
		 * Region code of the Nord-Trøndelag fylke.
		 *
		 * @since 1.0
		 */
		public static final String NORD_TRONDELAG_FYLKE = "NO,17";

		/**
		 * Region code of the Oppland fylke.
		 *
		 * @since 1.0
		 */
		public static final String OPPLAND_FYLKE = "NO,05";

		/**
		 * Region code of the Østfold fylke.
		 *
		 * @since 1.0
		 */
		public static final String OSTFOLD_FYLKE = "NO,01";

		/**
		 * Region code of the Rogaland fylke.
		 *
		 * @since 1.0
		 */
		public static final String ROGALAND_FYLKE = "NO,11";

		/**
		 * Region code of the Sogn og Fjordane fylke.
		 *
		 * @since 1.0
		 */
		public static final String SOGN_OG_FJORDANE_FYLKE = "NO,14";

		/**
		 * Region code of the Sør-Trøndelag fylke.
		 *
		 * @since 1.0
		 */
		public static final String SOR_TRONDELAG_FYLKE = "NO,16";

		/**
		 * Region code of the Telemark fylke.
		 *
		 * @since 1.0
		 */
		public static final String TELEMARK_FYLKE = "NO,08";

		/**
		 * Region code of the Troms fylke.
		 *
		 * @since 1.0
		 */
		public static final String TROMS_FYLKE = "NO,19";

		/**
		 * Region code of the Vest-Agder fylke.
		 *
		 * @since 1.0
		 */
		public static final String VEST_AGDER_FYLKE = "NO,10";

		/**
		 * Region code of the Vestfold fylke.
		 *
		 * @since 1.0
		 */
		public static final String VESTFOLD_FYLKE = "NO,07";


		private Norway() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Poland.
	 *
	 * @since 1.0
	 */
	public static class Poland {

		/**
		 * Region code of the Województwo dolnośląskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_DOLNOSLASKIE = "PL,02";

		/**
		 * Region code of the Województwo kujawsko-pomorskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_KUJAWSKO_POMORSKIE = "PL,04";

		/**
		 * Region code of the Województwo lubelskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_LUBELSKIE = "PL,06";

		/**
		 * Region code of the Województwo lubuskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_LUBUSKIE = "PL,08";

		/**
		 * Region code of the Województwo łódzkie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_LODZKIE = "PL,10";

		/**
		 * Region code of the Województwo małopolskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_MALOPOLSKIE = "PL,12";

		/**
		 * Region code of the Województwo mazowieckie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_MAZOWIECKIE = "PL,14";

		/**
		 * Region code of the Województwo opolskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_OPOLSKIE = "PL,16";

		/**
		 * Region code of the Województwo podkarpackie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_PODKARPACKIE = "PL,18";

		/**
		 * Region code of the Województwo podlaskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_PODLASKIE = "PL,20";

		/**
		 * Region code of the Województwo pomorskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_POMORSKIE = "PL,22";

		/**
		 * Region code of the Województwo śląskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_SLASKIE = "PL,24";

		/**
		 * Region code of the Województwo świętokrzyskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_SWIETOKRZYSKIE = "PL,26";

		/**
		 * Region code of the Województwo warmińsko-mazurskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_WARMINSKO_MAZURSKIE = "PL,28";

		/**
		 * Region code of the Województwo wielkopolskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_WIELKOPOLSKIE = "PL,30";

		/**
		 * Region code of the Województwo zachodniopomorskie.
		 *
		 * @since 1.0
		 */
		public static final String WOJEWODZTWO_ZACHODNIOPOMORSKIE = "PL,32";


		private Poland() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Portugal.
	 *
	 * @since 1.0
	 */
	public static class Portugal {

		/**
		 * Region code of the Distrito da Guarda.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DA_GUARDA = "PT,09";

		/**
		 * Region code of the Distrito de Aveiro.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_AVEIRO = "PT,01";

		/**
		 * Region code of the Distrito de Beja.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_BEJA = "PT,02";

		/**
		 * Region code of the Distrito de Braga.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_BRAGA = "PT,03";

		/**
		 * Region code of the Distrito de Bragança.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_BRAGANCA = "PT,04";

		/**
		 * Region code of the Distrito de Castelo Branco.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_CASTELO_BRANCO = "PT,05";

		/**
		 * Region code of the Distrito de Coimbra.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_COIMBRA = "PT,06";

		/**
		 * Region code of the Distrito de Évora.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_EVORA = "PT,07";

		/**
		 * Region code of the Distrito de Faro.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_FARO = "PT,08";

		/**
		 * Region code of the Distrito de Leiria.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_LEIRIA = "PT,10";

		/**
		 * Region code of the Distrito de Lisboa.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_LISBOA = "PT,11";

		/**
		 * Region code of the Distrito de Portalegre.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_PORTALEGRE = "PT,12";

		/**
		 * Region code of the Distrito de Santarém.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_SANTAREM = "PT,14";

		/**
		 * Region code of the Distrito de Setúbal.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_SETUBAL = "PT,15";

		/**
		 * Region code of the Distrito de Viana do Castelo.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_VIANA_DO_CASTELO = "PT,16";

		/**
		 * Region code of the Distrito de Vila Real.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_VILA_REAL = "PT,17";

		/**
		 * Region code of the Distrito de Viseu.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DE_VISEU = "PT,18";

		/**
		 * Region code of the Distrito do Porto.
		 *
		 * @since 1.0
		 */
		public static final String DISTRITO_DO_PORTO = "PT,13";

		/**
		 * Region code of the Região Autónoma da Madeira.
		 *
		 * @since 1.0
		 */
		public static final String REGIAO_AUTONOMA_DA_MADEIRA = "PT,30";

		/**
		 * Region code of the Região Autónoma dos Açores.
		 *
		 * @since 1.0
		 */
		public static final String REGIAO_AUTONOMA_DOS_ACORES = "PT,20";


		private Portugal() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in the Republic of Ireland.
	 *
	 * @since 1.1
	 */
	public static class RepublicOfIreland {

		/**
		 * Region code of the Carlow County Council.
		 *
		 * @since 1.0
		 */
		public static final String CARLOW_COUNTY_COUNCIL = "IE,01";

		/**
		 * Region code of the Cavan County Council.
		 *
		 * @since 1.0
		 */
		public static final String CAVAN_COUNTY_COUNCIL = "IE,32";

		/**
		 * Region code of the Clare County Council.
		 *
		 * @since 1.0
		 */
		public static final String CLARE_COUNTY_COUNCIL = "IE,16";

		/**
		 * Region code of the Cork City Council.
		 *
		 * @since 1.0
		 */
		public static final String CORK_CITY_COUNCIL = "IE,17";

		/**
		 * Region code of the Cork County Council.
		 *
		 * @since 1.0
		 */
		public static final String CORK_COUNTY_COUNCIL = "IE,18";

		/**
		 * Region code of the Donegal County Council.
		 *
		 * @since 1.0
		 */
		public static final String DONEGAL_COUNTY_COUNCIL = "IE,33";

		/**
		 * Region code of the Dublin City Council.
		 *
		 * @since 1.0
		 */
		public static final String DUBLIN_CITY_COUNCIL = "IE,02";

		/**
		 * Region code of the Dún Laoghaire-Rathdown County Council.
		 *
		 * @since 1.0
		 */
		public static final String DUN_LAOGHAIRE_RATHDOWN_COUNTY_COUNCIL = "IE,05";

		/**
		 * Region code of the Fingal County Council.
		 *
		 * @since 1.0
		 */
		public static final String FINGAL_COUNTY_COUNCIL = "IE,04";

		/**
		 * Region code of the Galway City Council.
		 *
		 * @since 1.0
		 */
		public static final String GALWAY_CITY_COUNCIL = "IE,26";

		/**
		 * Region code of the Galway County Council.
		 *
		 * @since 1.0
		 */
		public static final String GALWAY_COUNTY_COUNCIL = "IE,27";

		/**
		 * Region code of the Kerry County Council.
		 *
		 * @since 1.0
		 */
		public static final String KERRY_COUNTY_COUNCIL = "IE,19";

		/**
		 * Region code of the Kildare County Council.
		 *
		 * @since 1.0
		 */
		public static final String KILDARE_COUNTY_COUNCIL = "IE,06";

		/**
		 * Region code of the Kilkenny County Council.
		 *
		 * @since 1.0
		 */
		public static final String KILKENNY_COUNTY_COUNCIL = "IE,07";

		/**
		 * Region code of the Laois County Council.
		 *
		 * @since 1.0
		 */
		public static final String LAOIS_COUNTY_COUNCIL = "IE,08";

		/**
		 * Region code of the Leitrim County Council.
		 *
		 * @since 1.0
		 */
		public static final String LEITRIM_COUNTY_COUNCIL = "IE,28";

		/**
		 * Region code of the Limerick City and County Council.
		 *
		 * @since 1.0
		 */
		public static final String LIMERICK_CITY_AND_COUNTY_COUNCIL = "IE,21";

		/**
		 * Region code of the Longford County Council.
		 *
		 * @since 1.0
		 */
		public static final String LONGFORD_COUNTY_COUNCIL = "IE,09";

		/**
		 * Region code of the Louth County Council.
		 *
		 * @since 1.0
		 */
		public static final String LOUTH_COUNTY_COUNCIL = "IE,10";

		/**
		 * Region code of the Mayo County Council.
		 *
		 * @since 1.0
		 */
		public static final String MAYO_COUNTY_COUNCIL = "IE,29";

		/**
		 * Region code of the Meath County Council.
		 *
		 * @since 1.0
		 */
		public static final String MEATH_COUNTY_COUNCIL = "IE,11";

		/**
		 * Region code of the Monaghan County Council.
		 *
		 * @since 1.0
		 */
		public static final String MONAGHAN_COUNTY_COUNCIL = "IE,34";

		/**
		 * Region code of the Offaly County Council.
		 *
		 * @since 1.0
		 */
		public static final String OFFALY_COUNTY_COUNCIL = "IE,12";

		/**
		 * Region code of the Roscommon County Council.
		 *
		 * @since 1.0
		 */
		public static final String ROSCOMMON_COUNTY_COUNCIL = "IE,30";

		/**
		 * Region code of the Sligo County Council.
		 *
		 * @since 1.0
		 */
		public static final String SLIGO_COUNTY_COUNCIL = "IE,31";

		/**
		 * Region code of the South Dublin County Council.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_DUBLIN_COUNTY_COUNCIL = "IE,03";

		/**
		 * Region code of the Tipperary County Council.
		 *
		 * @since 1.0
		 */
		public static final String TIPPERARY_COUNTY_COUNCIL = "IE,22";

		/**
		 * Region code of the Waterford City and County Council.
		 *
		 * @since 1.0
		 */
		public static final String WATERFORD_CITY_AND_COUNTY_COUNCIL = "IE,25";

		/**
		 * Region code of the Westmeath County Council.
		 *
		 * @since 1.0
		 */
		public static final String WESTMEATH_COUNTY_COUNCIL = "IE,13";

		/**
		 * Region code of the Wexford County Council.
		 *
		 * @since 1.0
		 */
		public static final String WEXFORD_COUNTY_COUNCIL = "IE,14";

		/**
		 * Region code of the Wicklow County Council.
		 *
		 * @since 1.0
		 */
		public static final String WICKLOW_COUNTY_COUNCIL = "IE,15";


		private RepublicOfIreland() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Romania.
	 *
	 * @since 1.1
	 */
	public static class Romania {

		/**
		 * Region code of the Județul Alba.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_ALBA = "RO,12,01";

		/**
		 * Region code of the Județul Arad.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_ARAD = "RO,42,02";

		/**
		 * Region code of the Județul Argeș.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_ARGES = "RO,31,03";

		/**
		 * Region code of the Județul Bacău.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_BACAU = "RO,21,04";

		/**
		 * Region code of the Județul Bihor.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_BIHOR = "RO,11,05";

		/**
		 * Region code of the Județul Bistrița-Năsăud.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_BISTRITA_NASAUD = "RO,11,06";

		/**
		 * Region code of the Județul Botoșani.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_BOTOSANI = "RO,21,07";

		/**
		 * Region code of the Județul Brașov.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_BRASOV = "RO,12,09";

		/**
		 * Region code of the Județul Brăila.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_BRAILA = "RO,22,08";

		/**
		 * Region code of the Județul Buzău.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_BUZAU = "RO,22,11";

		/**
		 * Region code of the Județul Călărași.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_CALARASI = "RO,31,41";

		/**
		 * Region code of the Județul Caraș-Severin.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_CARAS_SEVERIN = "RO,42,12";

		/**
		 * Region code of the Județul Cluj.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_CLUJ = "RO,11,13";

		/**
		 * Region code of the Județul Constanța.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_CONSTANTA = "RO,22,14";

		/**
		 * Region code of the Județul Covasna.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_COVASNA = "RO,12,15";

		/**
		 * Region code of the Județul Dâmbovița.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_DAMBOVITA = "RO,31,16";

		/**
		 * Region code of the Județul Dolj.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_DOLJ = "RO,41,17";

		/**
		 * Region code of the Județul Galați.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_GALATI = "RO,22,18";

		/**
		 * Region code of the Județul Giurgiu.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_GIURGIU = "RO,31,42";

		/**
		 * Region code of the Județul Gorj.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_GORJ = "RO,41,19";

		/**
		 * Region code of the Județul Harghita.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_HARGHITA = "RO,12,20";

		/**
		 * Region code of the Județul Hunedoara.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_HUNEDOARA = "RO,42,21";

		/**
		 * Region code of the Județul Ialomița.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_IALOMIȚA = "RO,31,22";

		/**
		 * Region code of the Județul Iași.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_IASI = "RO,21,23";

		/**
		 * Region code of the Județul Ilfov.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_ILFOV = "RO,32,43";

		/**
		 * Region code of the Județul Maramureș.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_MARAMURES = "RO,11,25";

		/**
		 * Region code of the Județul Mehedinți.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_MEHEDINTI = "RO,41,26";

		/**
		 * Region code of the Județul Mures.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_MURES = "RO,12,27";

		/**
		 * Region code of the Județul Neamț.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_NEAMT = "RO,21,28";

		/**
		 * Region code of the Județul Olt.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_OLT = "RO,41,29";

		/**
		 * Region code of the Județul Prahova.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_PRAHOVA = "RO,31,30";

		/**
		 * Region code of the Județul Sălaj.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_SALAJ = "RO,11,31";

		/**
		 * Region code of the Județul Satu Mare.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_SATU_MARE = "RO,11,32";

		/**
		 * Region code of the Județul Sibiu.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_SIBIU = "RO,12,33";

		/**
		 * Region code of the Județul Suceava.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_SUCEAVA = "RO,21,34";

		/**
		 * Region code of the Județul Teleorman.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_TELEORMAN = "RO,31,35";

		/**
		 * Region code of the Județul Timiș.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_TIMIS = "RO,42,36";

		/**
		 * Region code of the Județul Tulcea.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_TULCEA = "RO,22,37";

		/**
		 * Region code of the Județul Vâlcea.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_VALCEA = "RO,41,39";

		/**
		 * Region code of the Județul Vaslui.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_VASLUI = "RO,21,38";

		/**
		 * Region code of the Județul Vrancea.
		 *
		 * @since 1.1
		 */
		public static final String JUDETUL_VRANCEA = "RO,22,40";

		/**
		 * Region code of the Municipiul București.
		 *
		 * @since 1.1
		 */
		public static final String MUNICIPIUL_BUCURESTI = "RO,32,10";

		/**
		 * Region code of the Regiunea de dezvoltare Bucureşti-Ilfov.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_BUCURESTI_ILFOV = "RO,32";

		/**
		 * Region code of the Regiunea de dezvoltare Centru.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_CENTRU = "RO,12";

		/**
		 * Region code of the Regiunea de dezvoltare Nord-Est.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_NORD_EST = "RO,21";

		/**
		 * Region code of the Regiunea de dezvoltare Nord-Vest.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_NORD_VEST = "RO,11";

		/**
		 * Region code of the Regiunea de dezvoltare Sud-Est.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_SUD_EST = "RO,22";

		/**
		 * Region code of the Regiunea de dezvoltare Sud-Muntenia.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_SUD_MUNTENIA = "RO,31";

		/**
		 * Region code of the Regiunea de dezvoltare Sud-Vest Oltenia.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_SUD_VEST_OLTENIA = "RO,41";

		/**
		 * Region code of the Regiunea de dezvoltare Vest.
		 *
		 * @since 1.1
		 */
		public static final String REGIUNEA_DE_DEZVOLTARE_VEST = "RO,42";


		private Romania() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Russia.
	 *
	 * @since 1.0
	 */
	public static class Russia {

		/**
		 * Region code of the Altayskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String ALTAYSKIY_KRAY = "RU,22";

		/**
		 * Region code of the Amurskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String AMURSKAYA_OBLAST = "RU,28";

		/**
		 * Region code of the Arkhangelskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String ARKHANGELSKAYA_OBLAST = "RU,29";

		/**
		 * Region code of the Astrakhanskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String ASTRAKHANSKAYA_OBLAST = "RU,30";

		/**
		 * Region code of the Belgorodskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String BELGORODSKAYA_OBLAST = "RU,31";

		/**
		 * Region code of the Bryanskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String BRYANSKAYA_OBLAST = "RU,32";

		/**
		 * Region code of the Chelyabinskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String CHELYABINSKAYA_OBLAST = "RU,74";

		/**
		 * Region code of the Chukotskiy avtonomnyy okrug.
		 *
		 * @since 1.0
		 */
		public static final String CHUKOTSKIY_AVTONOMNYY_OKRUG = "RU,87";

		/**
		 * Region code of the Gorod Moskva.
		 *
		 * @since 1.0
		 */
		public static final String GOROD_MOSKVA = "RU,77";

		/**
		 * Region code of the Gorod Sankt-Peterburg.
		 *
		 * @since 1.0
		 */
		public static final String GOROD_SANKT_PETERBURG = "RU,78";

		/**
		 * Region code of the Irkutskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String IRKUTSKAYA_OBLAST = "RU,38";

		/**
		 * Region code of the Ivanovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String IVANOVSKAYA_OBLAST = "RU,37";

		/**
		 * Region code of the Kaliningradskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String KALININGRADSKAYA_OBLAST = "RU,39";

		/**
		 * Region code of the Kaluzhskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String KALUZHSKAYA_OBLAST = "RU,40";

		/**
		 * Region code of the Kamchatskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String KAMCHATSKIY_KRAY = "RU,41";

		/**
		 * Region code of the Kemerovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String KEMEROVSKAYA_OBLAST = "RU,42";

		/**
		 * Region code of the Khabarovskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String KHABAROVSKIY_KRAY = "RU,27";

		/**
		 * Region code of the Khanty-Mansiyskiy avtonomnyy okrug-Yugra.
		 *
		 * @since 1.0
		 */
		public static final String KHANTY_MANSIYSKIY_AVTONOMNYY_OKRUG_YUGRA = "RU,86";

		/**
		 * Region code of the Kirovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String KIROVSKAYA_OBLAST = "RU,43";

		/**
		 * Region code of the Kostromskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String KOSTROMSKAYA_OBLAST = "RU,44";

		/**
		 * Region code of the Krasnodarskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String KRASNODARSKIY_KRAY = "RU,23";

		/**
		 * Region code of the Krasnoyarskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String KRASNOYARSKIY_KRAY = "RU,24";

		/**
		 * Region code of the Kurganskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String KURGANSKAYA_OBLAST = "RU,45";

		/**
		 * Region code of the Kurskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String KURSKAYA_OBLAST = "RU,46";

		/**
		 * Region code of the Leningradskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String LENINGRADSKAYA_OBLAST = "RU,47";

		/**
		 * Region code of the Lipetskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String LIPETSKAYA_OBLAST = "RU,48";

		/**
		 * Region code of the Magadanskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String MAGADANSKAYA_OBLAST = "RU,49";

		/**
		 * Region code of the Moskovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String MOSKOVSKAYA_OBLAST = "RU,50";

		/**
		 * Region code of the Murmanskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String MURMANSKAYA_OBLAST = "RU,51";

		/**
		 * Region code of the Nenetskiy avtonomnyy okrug.
		 *
		 * @since 1.0
		 */
		public static final String NENETSKIY_AVTONOMNYY_OKRUG = "RU,83";

		/**
		 * Region code of the Nizhegorodskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String NIZHEGORODSKAYA_OBLAST = "RU,52";

		/**
		 * Region code of the Novgorodskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String NOVGORODSKAYA_OBLAST = "RU,53";

		/**
		 * Region code of the Novosibirskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String NOVOSIBIRSKAYA_OBLAST = "RU,54";

		/**
		 * Region code of the Omskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String OMSKAYA_OBLAST = "RU,55";

		/**
		 * Region code of the Orenburgskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String ORENBURGSKAYA_OBLAST = "RU,56";

		/**
		 * Region code of the Orlovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String ORLOVSKAYA_OBLAST = "RU,57";

		/**
		 * Region code of the Penzenskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String PENZENSKAYA_OBLAST = "RU,58";

		/**
		 * Region code of the Permskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String PERMSKIY_KRAY = "RU,59";

		/**
		 * Region code of the Primorskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String PRIMORSKIY_KRAY = "RU,25";

		/**
		 * Region code of the Pskovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String PSKOVSKAYA_OBLAST = "RU,60";

		/**
		 * Region code of the Respublika Adygeya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_ADYGEYA = "RU,01";

		/**
		 * Region code of the Respublika Altay.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_ALTAY = "RU,04";

		/**
		 * Region code of the Respublika Bashkortostan.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_BASHKORTOSTAN = "RU,02";

		/**
		 * Region code of the Respublika Buryatiya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_BURYATIYA = "RU,03";

		/**
		 * Region code of the Respublika Chechnya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_CHECHNYA = "RU,20";

		/**
		 * Region code of the Respublika Chuvashiya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_CHUVASHIYA = "RU,21";

		/**
		 * Region code of the Respublika Dagestan.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_DAGESTAN = "RU,05";

		/**
		 * Region code of the Respublika Ingushetiya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_INGUSHETIYA = "RU,06";

		/**
		 * Region code of the Respublika Kabardino-Balkariya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_KABARDINO_BALKARIYA = "RU,07";

		/**
		 * Region code of the Respublika Kalmykiya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_KALMYKIYA = "RU,08";

		/**
		 * Region code of the Respublika Karachayevo-Cherkesiya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_KARACHAYEVO_CHERKESIYA = "RU,09";

		/**
		 * Region code of the Respublika Kareliya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_KARELIYA = "RU,10";

		/**
		 * Region code of the Respublika Khakasiya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_KHAKASIYA = "RU,19";

		/**
		 * Region code of the Respublika Komi.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_KOMI = "RU,11";

		/**
		 * Region code of the Respublika Mariy-El.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_MARIY_EL = "RU,12";

		/**
		 * Region code of the Respublika Mordoviya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_MORDOVIYA = "RU,13";

		/**
		 * Region code of the Respublika Sakha (Yakutiya).
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_SAKHA = "RU,14";

		/**
		 * Region code of the Respublika Severnaya Osetiya-Alaniya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_SEVERNAYA_OSETIYA_ALANIYA = "RU,15";

		/**
		 * Region code of the Respublika Tatarstan.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_TATARSTAN = "RU,16";

		/**
		 * Region code of the Respublika Tyva.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_TYVA = "RU,17";

		/**
		 * Region code of the Respublika Udmurtiya.
		 *
		 * @since 1.0
		 */
		public static final String RESPUBLIKA_UDMURTIYA = "RU,18";

		/**
		 * Region code of the Rostovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String ROSTOVSKAYA_OBLAST = "RU,61";

		/**
		 * Region code of the Ryazanskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String RYAZANSKAYA_OBLAST = "RU,62";

		/**
		 * Region code of the Sakhalinskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String SAKHALINSKAYA_OBLAST = "RU,65";

		/**
		 * Region code of the Samarskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String SAMARSKAYA_OBLAST = "RU,63";

		/**
		 * Region code of the Saratovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String SARATOVSKAYA_OBLAST = "RU,64";

		/**
		 * Region code of the Smolenskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String SMOLENSKAYA_OBLAST = "RU,67";

		/**
		 * Region code of the Stavropolskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String STAVROPOLSKIY_KRAY = "RU,26";

		/**
		 * Region code of the Sverdlovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String SVERDLOVSKAYA_OBLAST = "RU,66";

		/**
		 * Region code of the Tambovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String TAMBOVSKAYA_OBLAST = "RU,68";

		/**
		 * Region code of the Tomskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String TOMSKAYA_OBLAST = "RU,70";

		/**
		 * Region code of the Tulskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String TULSKAYA_OBLAST = "RU,71";

		/**
		 * Region code of the Tverskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String TVERSKAYA_OBLAST = "RU,69";

		/**
		 * Region code of the Tyumenskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String TYUMENSKAYA_OBLAST = "RU,72";

		/**
		 * Region code of the Ulyanovskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String ULYANOVSKAYA_OBLAST = "RU,73";

		/**
		 * Region code of the Vladimirskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String VLADIMIRSKAYA_OBLAST = "RU,33";

		/**
		 * Region code of the Volgogradskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String VOLGOGRADSKAYA_OBLAST = "RU,34";

		/**
		 * Region code of the Vologodskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String VOLOGODSKAYA_OBLAST = "RU,35";

		/**
		 * Region code of the Voronezhskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String VORONEZHSKAYA_OBLAST = "RU,36";

		/**
		 * Region code of the Yamalo-Nenetskiy avtonomnyy okrug.
		 *
		 * @since 1.0
		 */
		public static final String YAMALO_NENETSKIY_AVTONOMNYY_OKRUG = "RU,89";

		/**
		 * Region code of the Yaroslavskaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String YAROSLAVSKAYA_OBLAST = "RU,76";

		/**
		 * Region code of the Yevreyskaya avtonomnaya oblast.
		 *
		 * @since 1.0
		 */
		public static final String YEVREYSKAYA_AVTONOMNAYA_OBLAST = "RU,79";

		/**
		 * Region code of the Zabaykalskiy kray.
		 *
		 * @since 1.0
		 */
		public static final String ZABAYKALSKIY_KRAY = "RU,75";


		private Russia() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Serbia.
	 *
	 * @since 1.1
	 */
	public static class Serbia {

		/**
		 * Region code of the Autonomna Pokrajina Kosovo i Metohija.
		 *
		 * @since 1.1
		 */
		public static final String AUTONOMNA_POKRAJINA_KOSOVO_I_METOHIJA = "RS,2";

		/**
		 * Region code of the Autonomna pokrajina Vojvodina.
		 *
		 * @since 1.1
		 */
		public static final String AUTONOMNA_POKRAJINA_VOJVODINA = "RS,0";

		/**
		 * Region code of the Borski okrug.
		 *
		 * @since 1.1
		 */
		public static final String BORSKI_OKRUG = "RS,1,14";

		/**
		 * Region code of the Braničevski okrug.
		 *
		 * @since 1.1
		 */
		public static final String BRANICEVSKI_OKRUG = "RS,1,11";

		/**
		 * Region code of the Grad Beograd.
		 *
		 * @since 1.1
		 */
		public static final String GRAD_BEOGRAD = "RS,1,00";

		/**
		 * Region code of the Jablanički okrug.
		 *
		 * @since 1.1
		 */
		public static final String JABLANICKI_OKRUG = "RS,1,23";

		/**
		 * Region code of the Južnobački okrug.
		 *
		 * @since 1.1
		 */
		public static final String JUZNOBACKI_OKRUG = "RS,0,06";

		/**
		 * Region code of the Južnobanatski okrug.
		 *
		 * @since 1.1
		 */
		public static final String JUZNOBANATSKI_OKRUG = "RS,0,04";

		/**
		 * Region code of the Kolubarski okrug.
		 *
		 * @since 1.1
		 */
		public static final String KOLUBARSKI_OKRUG = "RS,1,09";

		/**
		 * Region code of the Kosovski okrug.
		 *
		 * @since 1.1
		 */
		public static final String KOSOVSKI_OKRUG = "RS,2,25";

		/**
		 * Region code of the Kosovskomitrovički okrug.
		 *
		 * @since 1.1
		 */
		public static final String KOSOVSKOMITROVICKI_OKRUG = "RS,2,28";

		/**
		 * Region code of the Kosovsko-pomoravski okrug.
		 *
		 * @since 1.1
		 */
		public static final String KOSOVSKO_POMORAVSKI_OKRUG = "RS,2,29";

		/**
		 * Region code of the Mačvanski okrug.
		 *
		 * @since 1.1
		 */
		public static final String MACVANSKI_OKRUG = "RS,1,08";

		/**
		 * Region code of the Moravički okrug.
		 *
		 * @since 1.1
		 */
		public static final String MORAVICKI_OKRUG = "RS,1,17";

		/**
		 * Region code of the Nišavski okrug.
		 *
		 * @since 1.1
		 */
		public static final String NISAVSKI_OKRUG = "RS,1,20";

		/**
		 * Region code of the Pčinjski okrug.
		 *
		 * @since 1.1
		 */
		public static final String PCINJSKI_OKRUG = "RS,1,24";

		/**
		 * Region code of the Pećki okrug.
		 *
		 * @since 1.1
		 */
		public static final String PECKI_OKRUG = "RS,2,26";

		/**
		 * Region code of the Pirotski okrug.
		 *
		 * @since 1.1
		 */
		public static final String PIROTSKI_OKRUG = "RS,1,22";

		/**
		 * Region code of the Podunavski okrug.
		 *
		 * @since 1.1
		 */
		public static final String PODUNAVSKI_OKRUG = "RS,1,10";

		/**
		 * Region code of the Pomoravski okrug.
		 *
		 * @since 1.1
		 */
		public static final String POMORAVSKI_OKRUG = "RS,1,13";

		/**
		 * Region code of the Prizrenski okrug.
		 *
		 * @since 1.1
		 */
		public static final String PRIZRENSKI_OKRUG = "RS,2,27";

		/**
		 * Region code of the Rasinski okrug.
		 *
		 * @since 1.1
		 */
		public static final String RASINSKI_OKRUG = "RS,1,19";

		/**
		 * Region code of the Raški okrug.
		 *
		 * @since 1.1
		 */
		public static final String RASKI_OKRUG = "RS,1,18";

		/**
		 * Region code of the Severnobački okrug.
		 *
		 * @since 1.1
		 */
		public static final String SEVERNOBACKI_OKRUG = "RS,0,01";

		/**
		 * Region code of the Severnobanatski okrug.
		 *
		 * @since 1.1
		 */
		public static final String SEVERNOBANATSKI_OKRUG = "RS,0,03";

		/**
		 * Region code of the Srednjobanatski okrug.
		 *
		 * @since 1.1
		 */
		public static final String SREDNJOBANATSKI_OKRUG = "RS,0,02";

		/**
		 * Region code of the Sremski okrug.
		 *
		 * @since 1.1
		 */
		public static final String SREMSKI_OKRUG = "RS,0,07";

		/**
		 * Region code of the Šumadijski okrug.
		 *
		 * @since 1.1
		 */
		public static final String SUMADIJSKI_OKRUG = "RS,1,12";

		/**
		 * Region code of the Toplički okrug.
		 *
		 * @since 1.1
		 */
		public static final String TOPLICKI_OKRUG = "RS,1,21";

		/**
		 * Region code of the Zaječarski okrug.
		 *
		 * @since 1.1
		 */
		public static final String ZAJECARSKI_OKRUG = "RS,1,15";

		/**
		 * Region code of the Zapadnobački okrug.
		 *
		 * @since 1.1
		 */
		public static final String ZAPADNOBACKI_OKRUG = "RS,0,05";

		/**
		 * Region code of the Zlatiborski okrug.
		 *
		 * @since 1.1
		 */
		public static final String ZLATIBORSKI_OKRUG = "RS,1,16";


		private Serbia() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Slovakia.
	 *
	 * @since 1.0
	 */
	public static class Slovakia {

		/**
		 * Region code of the Banskobystrický kraj.
		 *
		 * @since 1.0
		 */
		public static final String BANSKOBYSTRICKY_KRAJ = "SK,06";

		/**
		 * Region code of the Bratislavský kraj.
		 *
		 * @since 1.0
		 */
		public static final String BRATISLAVSKY_KRAJ = "SK,01";

		/**
		 * Region code of the Košický kraj.
		 *
		 * @since 1.0
		 */
		public static final String KOSICKY_KRAJ = "SK,08";

		/**
		 * Region code of the Nitriansky kraj.
		 *
		 * @since 1.0
		 */
		public static final String NITRIANSKY_KRAJ = "SK,04";

		/**
		 * Region code of the Okres Bánovce nad Bebravou.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BANOVCE_NAD_BEBRAVOU = "SK,03,01";

		/**
		 * Region code of the Okres Banská Bystrica.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BANSKA_BYSTRICA = "SK,06,01";

		/**
		 * Region code of the Okres Banská Štiavnica.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BANSKA_STIAVNICA = "SK,06,02";

		/**
		 * Region code of the Okres Bardejov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BARDEJOV = "SK,07,01";

		/**
		 * Region code of the Okres Bratislava I.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRATISLAVA_1 = "SK,01,01";

		/**
		 * Region code of the Okres Bratislava II.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRATISLAVA_2 = "SK,01,02";

		/**
		 * Region code of the Okres Bratislava III.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRATISLAVA_3 = "SK,01,03";

		/**
		 * Region code of the Okres Bratislava IV.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRATISLAVA_4 = "SK,01,04";

		/**
		 * Region code of the Okres Bratislava V.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BRATISLAVA_5 = "SK,01,05";

		/**
		 * Region code of the Okres Brezno.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BREZNO = "SK,06,03";

		/**
		 * Region code of the Okres Bytča.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_BYTCA = "SK,05,01";

		/**
		 * Region code of the Okres Čadca.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_CADCA = "SK,05,02";

		/**
		 * Region code of the Okres Detva.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_DETVA = "SK,06,04";

		/**
		 * Region code of the Okres Dolný Kubín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_DOLNY_KUBIN = "SK,05,03";

		/**
		 * Region code of the Okres Dunajská Streda.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_DUNAJSKA_STREDA = "SK,02,01";

		/**
		 * Region code of the Okres Galanta.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_GALANTA = "SK,02,02";

		/**
		 * Region code of the Okres Gelnica.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_GELNICA = "SK,08,01";

		/**
		 * Region code of the Okres Hlohovec.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_HLOHOVEC = "SK,02,03";

		/**
		 * Region code of the Okres Humenné.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_HUMENNE = "SK,07,02";

		/**
		 * Region code of the Okres Iľava.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ILAVA = "SK,03,02";

		/**
		 * Region code of the Okres Kežmarok.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KEZMAROK = "SK,07,03";

		/**
		 * Region code of the Okres Komárno.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KOMARNO = "SK,04,01";

		/**
		 * Region code of the Okres Košice I.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KOSICE_1 = "SK,08,02";

		/**
		 * Region code of the Okres Košice II.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KOSICE_2 = "SK,08,03";

		/**
		 * Region code of the Okres Košice III.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KOSICE_3 = "SK,08,04";

		/**
		 * Region code of the Okres Košice IV.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KOSICE_4 = "SK,08,05";

		/**
		 * Region code of the Okres Košice-okolie.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KOSICE_OKOLIE = "SK,08,06";

		/**
		 * Region code of the Okres Krupina.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KRUPINA = "SK,06,05";

		/**
		 * Region code of the Okres Kysucké Nové Mesto.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_KYSUCKE_NOVE_MESTO = "SK,05,04";

		/**
		 * Region code of the Okres Levice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_LEVICE = "SK,04,02";

		/**
		 * Region code of the Okres Levoča.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_LEVOCA = "SK,07,04";

		/**
		 * Region code of the Okres Liptovský Mikuláš.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_LIPTOVSKY_MIKULAS = "SK,05,05";

		/**
		 * Region code of the Okres Lučenec.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_LUCENEC = "SK,06,06";

		/**
		 * Region code of the Okres Malacky.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MALACKY = "SK,01,06";

		/**
		 * Region code of the Okres Martin.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MARTIN = "SK,05,06";

		/**
		 * Region code of the Okres Medzilaborce.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MEDZILABORCE = "SK,07,05";

		/**
		 * Region code of the Okres Michalovce.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MICHALOVCE = "SK,08,07";

		/**
		 * Region code of the Okres Myjava.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_MYJAVA = "SK,03,03";

		/**
		 * Region code of the Okres Námestovo.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_NAMESTOVO = "SK,05,07";

		/**
		 * Region code of the Okres Nitra.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_NITRA = "SK,04,03";

		/**
		 * Region code of the Okres Nové Mesto nad Váhom.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_NOVE_MESTO_NAD_VAHOM = "SK,03,04";

		/**
		 * Region code of the Okres Nové Zámky.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_NOVE_ZAMKY = "SK,04,04";

		/**
		 * Region code of the Okres Partizánske.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PARTIZANSKE = "SK,03,05";

		/**
		 * Region code of the Okres Pezinok.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PEZINOK = "SK,01,07";

		/**
		 * Region code of the Okres Piešťany.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PIESTANY = "SK,02,04";

		/**
		 * Region code of the Okres Poltár.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_POLTAR = "SK,06,07";

		/**
		 * Region code of the Okres Poprad.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_POPRAD = "SK,07,06";

		/**
		 * Region code of the Okres Považská Bystrica.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_POVAZSKA_BYSTRICA = "SK,03,06";

		/**
		 * Region code of the Okres Prešov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PRESOV = "SK,07,07";

		/**
		 * Region code of the Okres Prievidza.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PRIEVIDZA = "SK,03,07";

		/**
		 * Region code of the Okres Púchov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_PUCHOV = "SK,03,08";

		/**
		 * Region code of the Okres Revúca.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_REVUCA = "SK,06,08";

		/**
		 * Region code of the Okres Rimavská Sobota.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_RIMAVSKA_SOBOTA = "SK,06,09";

		/**
		 * Region code of the Okres Rožňava.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ROZNAVA = "SK,08,08";

		/**
		 * Region code of the Okres Ružomberok.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_RUZOMBEROK = "SK,05,08";

		/**
		 * Region code of the Okres Sabinov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SABINOV = "SK,07,08";

		/**
		 * Region code of the Okres Šaľa.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SALA = "SK,04,05";

		/**
		 * Region code of the Okres Senec.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SENEC = "SK,01,08	Okres";

		/**
		 * Region code of the Okres Senica.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SENICA = "SK,02,05";

		/**
		 * Region code of the Okres Skalica.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SKALICA = "SK,02,06";

		/**
		 * Region code of the Okres Snina.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SNINA = "SK,07,09";

		/**
		 * Region code of the Okres Sobrance.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SOBRANCE = "SK,08,09";

		/**
		 * Region code of the Okres Spišská Nová Ves.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SPISSKA_NOVA_VES = "SK,08,10";

		/**
		 * Region code of the Okres Stará Ľubovňa.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_STARA_LUBOVNA = "SK,07,10";

		/**
		 * Region code of the Okres Stropkov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_STROPKOV = "SK,07,11";

		/**
		 * Region code of the Okres Svidník.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_SVIDNIK = "SK,07,12";

		/**
		 * Region code of the Okres Topoľčany.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TOPOLCANY = "SK,04,06";

		/**
		 * Region code of the Okres Trebišov.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TREBISOV = "SK,08,11";

		/**
		 * Region code of the Okres Trenčín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TRENCIN = "SK,03,09";

		/**
		 * Region code of the Okres Trnava.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TRNAVA = "SK,02,07";

		/**
		 * Region code of the Okres Turčianske Teplice.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TURCIANSKE_TEPLICE = "SK,05,09";

		/**
		 * Region code of the Okres Tvrdošín.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_TVRDOSIN = "SK,05,10";

		/**
		 * Region code of the Okres Veľký Krtíš.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_VELKY_KRTIS = "SK,06,10";

		/**
		 * Region code of the Okres Vranov nad Topľou.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_VRANOV_NAD_TOPLOU = "SK,07,13";

		/**
		 * Region code of the Okres Žarnovica.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZARNOVICA = "SK,06,12";

		/**
		 * Region code of the Okres Žiar nad Hronom.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZIAR_NAD_HRONOM = "SK,06,13";

		/**
		 * Region code of the Okres Žilina.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZILINA = "SK,05,11";

		/**
		 * Region code of the Okres Zlaté Moravce.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZLATE_MORAVCE = "SK,04,07";

		/**
		 * Region code of the Okres Zvolen.
		 *
		 * @since 1.0
		 */
		public static final String OKRES_ZVOLEN = "SK,06,11";

		/**
		 * Region code of the Prešovský kraj.
		 *
		 * @since 1.0
		 */
		public static final String PRESOVSKY_KRAJ = "SK,07";

		/**
		 * Region code of the Trenčiansky kraj.
		 *
		 * @since 1.0
		 */
		public static final String TRENCIANSKY_KRAJ = "SK,03";

		/**
		 * Region code of the Trnavský kraj.
		 *
		 * @since 1.0
		 */
		public static final String TRNAVSKY_KRAJ = "SK,02";

		/**
		 * Region code of the Žilinský kraj.
		 *
		 * @since 1.0
		 */
		public static final String ZILINSKY_KRAJ = "SK,05";


		private Slovakia() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Slovenia.
	 *
	 * @since 1.0
	 */
	public static class Slovenia {

		/**
		 * Region code of the Gorenjska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String GORENJSKA_STATISTICNA_REGIJA = "SI,09";

		/**
		 * Region code of the Goriška statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String GORISKA_STATISTICNA_REGIJA = "SI,11";

		/**
		 * Region code of the Jugovzhodna Slovenija statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String JUGOVZHODNA_SLOVENIJA_STATISTICNA_REGIJA = "SI,07";

		/**
		 * Region code of the Koroška statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String KOROSKA_STATISTICNA_REGIJA = "SI,03";

		/**
		 * Region code of the Obalno-kraška statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String OBALNO_KRASKA_STATISTICNA_REGIJA = "SI,12";

		/**
		 * Region code of the Osrednjeslovenska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String OSREDNJESLOVENSKA_STATISTICNA_REGIJA = "SI,08";

		/**
		 * Region code of the Podravska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String PODRAVSKA_STATISTICNA_REGIJA = "SI,02";

		/**
		 * Region code of the Pomurska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String POMURSKA_STATISTICNA_REGIJA = "SI,01";

		/**
		 * Region code of the Posavska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String POSAVSKA_STATISTICNA_REGIJA = "SI,06";

		/**
		 * Region code of the Primorsko-notranjska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String PRIMORSKO_NOTRANJSKA_STATISTICNA_REGIJA = "SI,10";

		/**
		 * Region code of the Savinjska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String SAVINJSKA_STATISTICNA_REGIJA = "SI,04";

		/**
		 * Region code of the Zasavska statistična regija.
		 *
		 * @since 1.0
		 */
		public static final String ZASAVSKA_STATISTICNA_REGIJA = "SI,05";


		private Slovenia() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Spain.
	 *
	 * @since 1.0
	 */
	public static class Spain {

		/**
		 * Region code of the Ciudad autónoma de Ceuta.
		 *
		 * @since 1.0
		 */
		public static final String CIUDAD_AUTONOMA_DE_CEUTA = "ES,18";

		/**
		 * Region code of the Ciudad autónoma de Melilla.
		 *
		 * @since 1.0
		 */
		public static final String CIUDAD_AUTONOMA_DE_MELILLA = "ES,19";

		/**
		 * Region code of the Comunidad autónoma de Andalucía.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_ANDALUCÍA = "ES,01";

		/**
		 * Region code of the Comunidad autónoma de Aragón.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_ARAGON = "ES,02";

		/**
		 * Region code of the Comunidad autónoma de Cantabria.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_CANTABRIA = "ES,04";

		/**
		 * Region code of the Comunidad autónoma de Castilla-La Mancha.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_CASTILLA_LA_MANCHA = "ES,05";

		/**
		 * Region code of the Comunidad autónoma de Castilla y León.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_CASTILLA_Y_LEON = "ES,06";

		/**
		 * Region code of the Comunidad autónoma de Cataluña (also known as Catalunya)
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_CATALUNA = "ES,07";

		/**
		 * Region code of the Comunidad autónoma de Extremadura.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_EXTREMADURA = "ES,09";

		/**
		 * Region code of the Comunidad autónoma de Galicia.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_GALICIA = "ES,10";

		/**
		 * Region code of the Comunidad autónoma de La Rioja.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_LA_RIOJA = "ES,15";

		/**
		 * Region code of the Comunidad autónoma de las Islas Baleares.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_LAS_ISLAS_BALEARES = "ES,16";

		/**
		 * Region code of the Comunidad autónoma de las Islas Canarias.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DE_LAS_ISLAS_CANARIAS = "ES,17";

		/**
		 * Region code of the Comunidad autónoma del País Vasco (also known as Euskadi).
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_AUTONOMA_DEL_PAIS_VASCO = "ES,14";

		/**
		 * Region code of the Comunidad de Madrid.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_DE_MADRID = "ES,11";

		/**
		 * Region code of the Comunidad foral de Navarra.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_FORAL_DE_NAVARRA = "ES,13";

		/**
		 * Region code of the Comunidad Valenciana.
		 *
		 * @since 1.0
		 */
		public static final String COMUNIDAD_VALENCIANA = "ES,08";

		/**
		 * Region code of the Principado de Asturias.
		 *
		 * @since 1.0
		 */
		public static final String PRINCIPADO_DE_ASTURIAS = "ES,03";

		/**
		 * Region code of the Región de Murcia.
		 *
		 * @since 1.0
		 */
		public static final String REGION_DE_MURCIA = "ES,12";


		private Spain() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Sweden.
	 *
	 * @since 1.0
	 */
	public static class Sweden {

		/**
		 * Region code of the Blekinge län.
		 *
		 * @since 1.0
		 */
		public static final String BLEKINGE_LAN = "SE,10";

		/**
		 * Region code of the Dalarnas län.
		 *
		 * @since 1.0
		 */
		public static final String DALARNAS_LAN = "SE,20";

		/**
		 * Region code of the Gävleborgs län.
		 *
		 * @since 1.0
		 */
		public static final String GAVLEBORGS_LAN = "SE,21";

		/**
		 * Region code of the Gotlands län.
		 *
		 * @since 1.0
		 */
		public static final String GOTLANDS_LAN = "SE,09";

		/**
		 * Region code of the Hallands län.
		 *
		 * @since 1.0
		 */
		public static final String HALLANDS_LAN = "SE,13";

		/**
		 * Region code of the Jämtlands län.
		 *
		 * @since 1.0
		 */
		public static final String JÄMTLANDS_LAN = "SE,23";

		/**
		 * Region code of the Jönköpings län.
		 *
		 * @since 1.0
		 */
		public static final String JONKOPINGS_LAN = "SE,06";

		/**
		 * Region code of the Kalmar län.
		 *
		 * @since 1.0
		 */
		public static final String KALMAR_LAN = "SE,08";

		/**
		 * Region code of the Kronobergs län.
		 *
		 * @since 1.0
		 */
		public static final String KRONOBERGS_LAN = "SE,07";

		/**
		 * Region code of the Norrbottens län.
		 *
		 * @since 1.0
		 */
		public static final String NORRBOTTENS_LAN = "SE,25";

		/**
		 * Region code of the Örebro län.
		 *
		 * @since 1.0
		 */
		public static final String OREBRO_LAN = "SE,18";

		/**
		 * Region code of the Östergötlands län.
		 *
		 * @since 1.0
		 */
		public static final String OSTERGOTLANDS_LAN = "SE,05";

		/**
		 * Region code of the Skåne län.
		 *
		 * @since 1.0
		 */
		public static final String SKANE_LAN = "SE,12";

		/**
		 * Region code of the Södermanlands län.
		 *
		 * @since 1.0
		 */
		public static final String SODERMANLANDS_LAN = "SE,04";

		/**
		 * Region code of the Stockholms län.
		 *
		 * @since 1.0
		 */
		public static final String STOCKHOLMS_LAN = "SE,01";

		/**
		 * Region code of the Uppsala län.
		 *
		 * @since 1.0
		 */
		public static final String UPPSALA_LAN = "SE,03";

		/**
		 * Region code of the Värmlands län.
		 *
		 * @since 1.0
		 */
		public static final String VARMLANDS_LAN = "SE,17";

		/**
		 * Region code of the Västerbottens län.
		 *
		 * @since 1.0
		 */
		public static final String VASTERBOTTENS_LAN = "SE,24";

		/**
		 * Region code of the Västernorrlands län.
		 *
		 * @since 1.0
		 */
		public static final String VASTERNORRLANDS_LAN = "SE,22";

		/**
		 * Region code of the Västmanlands län.
		 *
		 * @since 1.0
		 */
		public static final String VASTMANLANDS_LAN = "SE,19";

		/**
		 * Region code of the Västra Götalands län.
		 *
		 * @since 1.0
		 */
		public static final String VASTRA_GOTALANDS_LAN = "SE,14";


		private Sweden() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Switzerland.
	 *
	 * @since 1.0
	 */
	public static class Switzerland {

		/**
		 * Region code of the Canton de Vaud.
		 *
		 * @since 1.0
		 */
		public static final String CANTON_DE_VAUD = "CH,22";

		/**
		 * Region code of the Canton du Valais.
		 *
		 * @since 1.0
		 */
		public static final String CANTON_DU_VALAIS = "CH,23";

		/**
		 * Region code of the État de Fribourg.
		 *
		 * @since 1.0
		 */
		public static final String ETAT_DE_FRIBOURG = "CH,10";

		/**
		 * Region code of the Kanton Aargau.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_AARGAU = "CH,19";

		/**
		 * Region code of the Kanton Appenzell Ausserrhoden.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_APPENZELL_AUSSERRHODEN = "CH,15";

		/**
		 * Region code of the Kanton Appenzell Innerrhoden.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_APPENZELL_INNERRHODEN = "CH,16";

		/**
		 * Region code of the Kanton Basel-Landschaft.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_BASEL_LANDSCHAFT = "CH,13";

		/**
		 * Region code of the Kanton Basel-Stadt.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_BASEL_STADT = "CH,12";

		/**
		 * Region code of the Kanton Bern.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_BERN = "CH,02";

		/**
		 * Region code of the Kanton Glarus.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_GLARUS = "CH,08";

		/**
		 * Region code of the Kanton Graubünden.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_GRAUBUENDEN = "CH,18";

		/**
		 * Region code of the Kanton Luzern.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_LUZERN = "CH,03";

		/**
		 * Region code of the Kanton Nidwalden.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_NIDWALDEN = "CH,07";

		/**
		 * Region code of the Kanton Obwalden.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_OBWALDEN = "CH,06";

		/**
		 * Region code of the Kanton Sankt Gallen.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_SANKT_GALLEN = "CH,17";

		/**
		 * Region code of the Kanton Schaffhausen.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_SCHAFFHAUSEN = "CH,14";

		/**
		 * Region code of the Kanton Schwyz.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_SCHWYZ = "CH,05";

		/**
		 * Region code of the Kanton Solothurn.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_SOLOTHURN = "CH,11";

		/**
		 * Region code of the Kanton Thurgau.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_THURGAU = "CH,20";

		/**
		 * Region code of the Kanton Uri.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_URI = "CH,04";

		/**
		 * Region code of the Kanton Zug.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_ZUG = "CH,09";

		/**
		 * Region code of the Kanton Zürich.
		 *
		 * @since 1.0
		 */
		public static final String KANTON_ZUERICH = "CH,01";

		/**
		 * Region code of the Repubblica e Cantone Ticino.
		 *
		 * @since 1.0
		 */
		public static final String REPUBBLICA_E_CANTONE_TICINO = "CH,21";

		/**
		 * Region code of the République et Canton de Genève.
		 *
		 * @since 1.0
		 */
		public static final String REPUBLIQUE_ET_CANTON_DE_GENEVE = "CH,25";

		/**
		 * Region code of the République et Canton de Neuchâtel.
		 *
		 * @since 1.0
		 */
		public static final String REPUBLIQUE_ET_CANTON_DE_NEUCHATEL = "CH,24";

		/**
		 * Region code of the République et Canton du Jura.
		 *
		 * @since 1.0
		 */
		public static final String REPUBLIQUE_ET_CANTON_DU_JURA = "CH,26";


		private Switzerland() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in Ukraine.
	 *
	 * @since 1.0
	 */
	public static class Ukraine {

		/**
		 * Region code of the Avtonomna respublika Krym.
		 *
		 * @since 1.0
		 */
		public static final String AVTONOMNA_RESPUBLIKA_KRYM = "UA,01";

		/**
		 * Region code of the Cherkaska oblast.
		 *
		 * @since 1.0
		 */
		public static final String CHERKASKA_OBLAST = "UA,71";

		/**
		 * Region code of the Chernihivska oblast.
		 *
		 * @since 1.0
		 */
		public static final String CHERNIHIVSKA_OBLAST = "UA,74";

		/**
		 * Region code of the Chernivetska oblast.
		 *
		 * @since 1.0
		 */
		public static final String CHERNIVETSKA_OBLAST = "UA,73";

		/**
		 * Region code of the Dnipropetrovska oblast.
		 *
		 * @since 1.0
		 */
		public static final String DNIPROPETROVSKA_OBLAST = "UA,12";

		/**
		 * Region code of the Donetska oblast.
		 *
		 * @since 1.0
		 */
		public static final String DONETSKA_OBLAST = "UA,14";

		/**
		 * Region code of the Ivano-Frankivska oblast.
		 *
		 * @since 1.0
		 */
		public static final String IVANO_FRANKIVSKA_OBLAST = "UA,26";

		/**
		 * Region code of the Kharkivska oblast.
		 *
		 * @since 1.0
		 */
		public static final String KHARKIVSKA_OBLAST = "UA,63";

		/**
		 * Region code of the Khersonska oblast.
		 *
		 * @since 1.0
		 */
		public static final String KHERSONSKA_OBLAST = "UA,65";

		/**
		 * Region code of the Khmelnytska oblast.
		 *
		 * @since 1.0
		 */
		public static final String KHMELNYTSKA_OBLAST = "UA,68";

		/**
		 * Region code of the Kirovohradska oblast.
		 *
		 * @since 1.0
		 */
		public static final String KIROVOHRADSKA_OBLAST = "UA,35";

		/**
		 * Region code of the Kyivska oblast.
		 *
		 * @since 1.0
		 */
		public static final String KYIVSKA_OBLAST = "UA,32";

		/**
		 * Region code of the Luhanska oblast.
		 *
		 * @since 1.0
		 */
		public static final String LUHANSKA_OBLAST = "UA,44";

		/**
		 * Region code of the Lvivska oblast.
		 *
		 * @since 1.0
		 */
		public static final String LVIVSKA_OBLAST = "UA,46";

		/**
		 * Region code of the Misto zi specialnym statusom Kyiv.
		 *
		 * @since 1.0
		 */
		public static final String MISTO_ZI_SPECIALNYM_STATUSOM_KYIV = "UA,80";

		/**
		 * Region code of the Misto zi specialnym statusom Sebastopol.
		 *
		 * @since 1.0
		 */
		public static final String MISTO_ZI_SPECIALNYM_STATUSOM_SEBASTOPOL = "UA,85";

		/**
		 * Region code of the Mykolaivska oblast.
		 *
		 * @since 1.0
		 */
		public static final String MYKOLAIVSKA_OBLAST = "UA,48";

		/**
		 * Region code of the Odeska oblast.
		 *
		 * @since 1.0
		 */
		public static final String ODESKA_OBLAST = "UA,51";

		/**
		 * Region code of the Poltavska oblast.
		 *
		 * @since 1.0
		 */
		public static final String POLTAVSKA_OBLAST = "UA,53";

		/**
		 * Region code of the Rivnenska oblast.
		 *
		 * @since 1.0
		 */
		public static final String RIVNENSKA_OBLAST = "UA,56";

		/**
		 * Region code of the Sumska oblast.
		 *
		 * @since 1.0
		 */
		public static final String SUMSKA_OBLAST = "UA,59";

		/**
		 * Region code of the Ternopilska oblast.
		 *
		 * @since 1.0
		 */
		public static final String TERNOPILSKA_OBLAST = "UA,61";

		/**
		 * Region code of the Vinnytska oblast.
		 *
		 * @since 1.0
		 */
		public static final String VINNYTSKA_OBLAST = "UA,05";

		/**
		 * Region code of the Volynska oblast.
		 *
		 * @since 1.0
		 */
		public static final String VOLYNSKA_OBLAST = "UA,07";

		/**
		 * Region code of the Zakarpatska oblast.
		 *
		 * @since 1.0
		 */
		public static final String ZAKARPATSKA_OBLAST = "UA,21";

		/**
		 * Region code of the Zaporizka oblast.
		 *
		 * @since 1.0
		 */
		public static final String ZAPORIZKA_OBLAST = "UA,23";

		/**
		 * Region code of the Zhytomyrska oblast.
		 *
		 * @since 1.0
		 */
		public static final String ZHYTOMYRSKA_OBLAST = "UA,18";


		private Ukraine() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in the United Kingdom.
	 *
	 * @since 1.0
	 */
	public static class UnitedKingdom {

		/**
		 * Region code of the Aberdeenshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String ABERDEENSHIRE_COUNCIL_AREA = "GB,S,12000034";

		/**
		 * Region code of the Adur District.
		 *
		 * @since 1.0
		 */
		public static final String ADUR_DISTRICT = "GB,E,12000008,10000032,07000223";

		/**
		 * Region code of the Angus Council Area.
		 *
		 * @since 1.0
		 */
		public static final String ANGUS_COUNCIL_AREA = "GB,S,12000041";

		/**
		 * Region code of the Antrim and Newtownabbey District.
		 *
		 * @since 1.0
		 */
		public static final String ANTRIM_AND_NEWTOWNABBEY_DISTRICT = "GB,N,09000001";

		/**
		 * Region code of the Ards and North Down District.
		 *
		 * @since 1.0
		 */
		public static final String ARDS_AND_NORTH_DOWN_DISTRICT = "GB,N,09000011";

		/**
		 * Region code of the Argyll and Bute Council Area.
		 *
		 * @since 1.0
		 */
		public static final String ARGYLL_AND_BUTE_COUNCIL_AREA = "GB,S,12000035";

		/**
		 * Region code of the Armagh, Banbridge and Craigavon District.
		 *
		 * @since 1.0
		 */
		public static final String ARMAGH_BANBRIDGE_AND_CRAIGAVON_DISTRICT = "GB,N,09000002";

		/**
		 * Region code of the Arun District.
		 *
		 * @since 1.0
		 */
		public static final String ARUN_DISTRICT = "GB,E,12000008,10000032,07000224";

		/**
		 * Region code of the Ashfield District.
		 *
		 * @since 1.0
		 */
		public static final String ASHFIELD_DISTRICT = "GB,E,12000004,10000024,07000170";

		/**
		 * Region code of the Aylesbury Vale District.
		 *
		 * @since 1.0
		 */
		public static final String AYLESBURY_VALE_DISTRICT = "GB,E,12000008,10000002,07000004";

		/**
		 * Region code of the Babergh District.
		 *
		 * @since 1.0
		 */
		public static final String BABERGH_DISTRICT = "GB,E,120000006,10000029,07000200";

		/**
		 * Region code of the Bassetlaw District.
		 *
		 * @since 1.0
		 */
		public static final String BASSETLAW_DISTRICT = "GB,E,12000004,10000024,07000171";

		/**
		 * Region code of the Bath and North East Somerset District.
		 *
		 * @since 1.0
		 */
		public static final String BATH_AND_NORTH_EAST_SOMERSET_DISTRICT = "GB,E,12000009,,06000022";

		/**
		 * Region code of the Blaby District.
		 *
		 * @since 1.0
		 */
		public static final String BLABY_DISTRICT = "GB,E,12000004,10000018,07000129";

		/**
		 * Region code of the Blaenau Gwent County Borough.
		 *
		 * @since 1.0
		 */
		public static final String BLAENAU_GWENT_COUNTY_BOROUGH = "GB,W,06000019";

		/**
		 * Region code of the Bolsover District.
		 *
		 * @since 1.0
		 */
		public static final String BOLSOVER_DISTRICT = "GB,E,12000004,10000007,07000033";

		/**
		 * Region code of the Borough of Allerdale.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_ALLERDALE = "GB,E,12000002,10000006,07000026";

		/**
		 * Region code of the Borough of Amber Valley.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_AMBER_VALLEY = "GB,E,12000004,10000007,07000032";

		/**
		 * Region code of the Borough of Ashford.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_ASHFORD = "GB,E,12000008,10000016,07000105";

		/**
		 * Region code of the Borough of Barrow-in-Furness.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BARROW_IN_FURNESS = "GB,E,12000002,10000006,07000027";

		/**
		 * Region code of the Borough of Basildon.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BASILDON = "GB,E,120000006,10000012,07000066";

		/**
		 * Region code of the Borough of Basingstoke and Deane.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BASINGSTOKE_AND_DEANE = "GB,E,12000008,10000014,07000084";

		/**
		 * Region code of the Borough of Bedford.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BEDFORD = "GB,E,12000006,,06000055";

		/**
		 * Region code of the Borough of Blackburn with Darwen.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BLACKBURN_WITH_DARWEN = "GB,E,12000002,,06000008";

		/**
		 * Region code of the Borough of Boston.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BOSTON = "GB,E,12000004,10000019,07000136";

		/**
		 * Region code of the Borough of Bournemouth.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BOURNEMOUTH = "GB,E,12000009,,06000028";

		/**
		 * Region code of the Borough of Bracknell Forest.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BRACKNELL_FOREST = "GB,E,12000008,,06000036";

		/**
		 * Region code of the Borough of Brentwood.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BRENTWOOD = "GB,E,120000006,10000012,07000068";

		/**
		 * Region code of the Borough of Broxbourne.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BROXBOURNE = "GB,E,120000006,10000015,07000095";

		/**
		 * Region code of the Borough of Broxtowe.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BROXTOWE = "GB,E,12000004,10000024,07000172";

		/**
		 * Region code of the Borough of Burnley.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_BURNLEY = "GB,E,12000002,10000017,07000117";

		/**
		 * Region code of the Borough of Castle Point.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CASTLE_POINT = "GB,E,120000006,10000012,07000069";

		/**
		 * Region code of the Borough of Charnwood.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CHARNWOOD = "GB,E,12000004,10000018,07000130";

		/**
		 * Region code of the Borough of Cheshire East.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CHESHIRE_EAST = "GB,E,12000002,,06000049";

		/**
		 * Region code of the Borough of Cheshire West and Chester.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CHESHIRE_WEST_AND_CHESTER = "GB,E,12000002,,06000050";

		/**
		 * Region code of the Borough of Chesterfield.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CHESTERFIELD = "GB,E,12000004,10000007,07000034";

		/**
		 * Region code of the Borough of Christchurch.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CHRISTCHURCH = "GB,E,12000009,10000009,07000048";

		/**
		 * Region code of the Borough of Colchester.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_COLCHESTER = "GB,E,120000006,10000012,07000071";

		/**
		 * Region code of the Borough of Copeland.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_COPELAND = "GB,E,12000002,10000006,07000029";

		/**
		 * Region code of the Borough of Corby.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CORBY = "GB,E,12000004,10000021,07000150";

		/**
		 * Region code of the Borough of Crawley.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_CRAWLEY = "GB,E,12000008,10000032,07000226";

		/**
		 * Region code of the Borough of Dacorum.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_DACORUM = "GB,E,120000006,10000015,07000096";

		/**
		 * Region code of the Borough of Darlington.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_DARLINGTON = "GB,E,12000001,,06000005";

		/**
		 * Region code of the Borough of Dartford.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_DARTFORD = "GB,E,12000008,10000016,07000107";

		/**
		 * Region code of the Borough of Eastbourne.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_EASTBOURNE = "GB,E,12000008,10000011,07000061";

		/**
		 * Region code of the Borough of Eastleigh.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_EASTLEIGH = "GB,E,12000008,10000014,07000086";

		/**
		 * Region code of the Borough of Elmbridge.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_ELMBRIDGE = "GB,E,12000008,10000030,07000207";

		/**
		 * Region code of the Borough of Epsom and Ewell.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_EPSOM_AND_EWELL = "GB,E,12000008,10000030,07000208";

		/**
		 * Region code of the Borough of Fareham.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_FAREHAM = "GB,E,12000008,10000014,07000087";

		/**
		 * Region code of the Borough of Fylde.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_FYLDE = "GB,E,12000002,10000017,07000119";

		/**
		 * Region code of the Borough of Gedling.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_GEDLING = "GB,E,12000004,10000024,07000173";

		/**
		 * Region code of the Borough of Gosport.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_GOSPORT = "GB,E,12000008,10000014,07000088";

		/**
		 * Region code of the Borough of Gravesham.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_GRAVESHAM = "GB,E,12000008,10000016,07000109";

		/**
		 * Region code of the Borough of Guildford.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_GUILDFORD = "GB,E,12000008,10000030,07000209";

		/**
		 * Region code of the Borough of Halton.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HALTON = "GB,E,12000002,,06000006";

		/**
		 * Region code of the Borough of Harlow.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HARLOW = "GB,E,120000006,10000012,07000073";

		/**
		 * Region code of the Borough of Harrogate.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HARROGATE = "GB,E,12000003,10000023,07000165";

		/**
		 * Region code of the Borough of Hartlepool.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HARTLEPOOL = "GB,E,12000001,,06000001";

		/**
		 * Region code of the Borough of Hastings.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HASTINGS = "GB,E,12000008,10000011,07000062";

		/**
		 * Region code of the Borough of Havant.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HAVANT = "GB,E,12000008,10000014,07000090";

		/**
		 * Region code of the Borough of Hertsmere.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HERTSMERE = "GB,E,120000006,10000015,07000098";

		/**
		 * Region code of the Borough of High Peak.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HIGH_PEAK = "GB,E,12000004,10000007,07000037";

		/**
		 * Region code of the Borough of Hinckley and Bosworth.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HINCKLEY_AND_BOSWORTH = "GB,E,12000004,10000018,07000132";

		/**
		 * Region code of the Borough of Hyndburn.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_HYNDBURN = "GB,E,12000002,10000017,07000120";

		/**
		 * Region code of the Borough of Ipswich.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_IPSWICH = "GB,E,120000006,10000029,07000202";

		/**
		 * Region code of the Borough of Kettering.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_KETTERING = "GB,E,12000004,10000021,07000153";

		/**
		 * Region code of the Borough of King's Lynn and West Norfolk.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_KINGS_LYNN_AND_WEST_NORFOLK = "GB,E,120000006,10000020,07000146";

		/**
		 * Region code of the Borough of Luton.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_LUTON = "GB,E,12000006,,06000032";

		/**
		 * Region code of the Borough of Maidstone.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_MAIDSTONE = "GB,E,12000008,10000016,07000110";

		/**
		 * Region code of the Borough of Medway.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_MEDWAY = "GB,E,12000008,,06000035";

		/**
		 * Region code of the Borough of Melton.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_MELTON = "GB,E,12000004,10000018,07000133";

		/**
		 * Region code of the Borough of Milton Keynes.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_MILTON_KEYNES = "GB,E,12000008,,06000042";

		/**
		 * Region code of the Borough of Newcastle-under-Lyme.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_NEWCASTLE_UNDER_LYME = "GB,E,12000005,10000028,07000195";

		/**
		 * Region code of the Borough of North East Lincolnshire.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_NORTH_EAST_LINCOLNSHIRE = "GB,E,12000003,,06000012";

		/**
		 * Region code of the Borough of North Lincolnshire.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_NORTH_LINCOLNSHIRE = "GB,E,12000003,,06000013";

		/**
		 * Region code of the Borough of North Warwickshire.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_NORTH_WARWICKSHIRE = "GB,E,12000005,10000031,07000218";

		/**
		 * Region code of the Borough of Northampton.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_NORTHAMPTON = "GB,E,12000004,10000021,07000154";

		/**
		 * Region code of the Borough of Nuneaton and Bedworth.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_NUNEATON_AND_BEDWORTH = "GB,E,12000005,10000031,07000219";

		/**
		 * Region code of the Borough of Oadby and Wigston.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_OADBY_AND_WIGSTON = "GB,E,12000004,10000018,07000135";

		/**
		 * Region code of the Borough of Pendle.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_PENDLE = "GB,E,12000002,10000017,07000122";

		/**
		 * Region code of the Borough of Poole.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_POOLE = "GB,E,12000009,,06000029";

		/**
		 * Region code of the Borough of Redcar and Cleveland.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_REDCAR_AND_CLEVELAND = "GB,E,12000001,,06000003";

		/**
		 * Region code of the Borough of Redditch.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_REDDITCH = "GB,E,12000005,10000034,07000236";

		/**
		 * Region code of the Borough of Reigate and Banstead.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_REIGATE_AND_BANSTEAD = "GB,E,12000008,10000030,07000211";

		/**
		 * Region code of the Borough of Ribble Valley.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_RIBBLE_VALLEY = "GB,E,12000002,10000017,07000124";

		/**
		 * Region code of the Borough of Rossendale.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_ROSSENDALE = "GB,E,12000002,10000017,07000125";

		/**
		 * Region code of the Borough of Rugby.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_RUGBY = "GB,E,12000005,10000031,07000220";

		/**
		 * Region code of the Borough of Runnymede.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_RUNNYMEDE = "GB,E,12000008,10000030,07000212";

		/**
		 * Region code of the Borough of Rushcliffe.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_RUSHCLIFFE = "GB,E,12000004,10000024,07000176";

		/**
		 * Region code of the Borough of Rushmoor.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_RUSHMOOR = "GB,E,12000008,10000014,07000092";

		/**
		 * Region code of the Borough of Saint Edmundsbury.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SAINT_EDMUNDSBURY = "GB,E,120000006,10000029,07000204";

		/**
		 * Region code of the Borough of Scarborough.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SCARBOROUGH = "GB,E,12000003,10000023,07000168";

		/**
		 * Region code of the Borough of Slough.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SLOUGH = "GB,E,12000008,,06000039";

		/**
		 * Region code of the Borough of South Ribble.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SOUTH_RIBBLE = "GB,E,12000002,10000017,07000126";

		/**
		 * Region code of the Borough of Southend-on-Sea.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SOUTHEND_ON_SEA = "GB,E,12000006,,06000033";

		/**
		 * Region code of the Borough of Spelthorne.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SPELTHORNE = "GB,E,12000008,10000030,07000213";

		/**
		 * Region code of the Borough of Stafford.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_STAFFORD = "GB,E,12000005,10000028,07000197";

		/**
		 * Region code of the Borough of Stevenage.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_STEVENAGE = "GB,E,120000006,10000015,07000101";

		/**
		 * Region code of the Borough of Stockton-on-Tees.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_STOCKTON_ON_TEES = "GB,E,12000001,,06000004";

		/**
		 * Region code of the Borough of Swale.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SWALE = "GB,E,12000008,10000016,07000113";

		/**
		 * Region code of the Borough of Swindon.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_SWINDON = "GB,E,12000009,,06000030";

		/**
		 * Region code of the Borough of Telford and Wrekin.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_TELFORD_AND_WREKIN = "GB,E,12000005,,06000020";

		/**
		 * Region code of the Borough of Test Valley.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_TEST_VALLEY = "GB,E,12000008,10000014,7000093";

		/**
		 * Region code of the Borough of Tewkesbury.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_TEWKESBURY = "GB,E,12000009,10000013,07000083";

		/**
		 * Region code of the Borough of Thurrock.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_THURROCK = "GB,E,12000006,,06000034";

		/**
		 * Region code of the Borough of Torbay.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_TORBAY = "GB,E,12000009,,06000027";

		/**
		 * Region code of the Borough of Tunbridge Wells.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_TUNBRIDGE_WELLS = "GB,E,12000008,10000016,07000116";

		/**
		 * Region code of the Borough of Watford.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WATFORD = "GB,E,120000006,10000015,07000103";

		/**
		 * Region code of the Borough of Waverley.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WAVERLEY = "GB,E,12000008,10000030,07000216";

		/**
		 * Region code of the Borough of Wellingborough.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WELLINGBOROUGH = "GB,E,12000004,10000021,07000156";

		/**
		 * Region code of the Borough of Welwyn Hatfield.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WELWYN_HATFIELD = "GB,E,120000006,10000015,07000241";

		/**
		 * Region code of the Borough of West Lancashire.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WEST_LANCASHIRE = "GB,E,12000002,10000017,07000127";

		/**
		 * Region code of the Borough of Weymouth and Portland.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WEYMOUTH_AND_PORTLAND = "GB,E,12000009,10000009,07000053";

		/**
		 * Region code of the Borough of Woking.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WOKING = "GB,E,12000008,10000030,07000217";

		/**
		 * Region code of the Borough of Wokingham.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WOKINGHAM = "GB,E,12000008,,06000041";

		/**
		 * Region code of the Borough of Worthing.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WORTHING = "GB,E,12000008,10000032,07000229";

		/**
		 * Region code of the Borough of Wyre.
		 *
		 * @since 1.0
		 */
		public static final String BOROUGH_OF_WYRE = "GB,E,12000002,10000017,07000128";

		/**
		 * Region code of the Braintree District.
		 *
		 * @since 1.0
		 */
		public static final String BRAINTREE_DISTRICT = "GB,E,120000006,10000012,07000067";

		/**
		 * Region code of the Breckland District.
		 *
		 * @since 1.0
		 */
		public static final String BRECKLAND_DISTRICT = "GB,E,120000006,10000020,07000143";

		/**
		 * Region code of the Bridgend County Borough.
		 *
		 * @since 1.0
		 */
		public static final String BRIDGEND_COUNTY_BOROUGH = "GB,W,06000013";

		/**
		 * Region code of the Broadland District.
		 *
		 * @since 1.0
		 */
		public static final String BROADLAND_DISTRICT = "GB,E,120000006,10000020,07000144";

		/**
		 * Region code of the Bromsgrove District.
		 *
		 * @since 1.0
		 */
		public static final String BROMSGROVE_DISTRICT = "GB,E,12000005,10000034,07000234";

		/**
		 * Region code of the Caerphilly County Borough.
		 *
		 * @since 1.0
		 */
		public static final String CAERPHILLY_COUNTY_BOROUGH = "GB,W,06000018";

		/**
		 * Region code of the Cannock Chase District.
		 *
		 * @since 1.0
		 */
		public static final String CANNOCK_CHASE_DISTRICT = "GB,E,12000005,10000028,07000192";

		/**
		 * Region code of the Causeway Coast and Glens District.
		 *
		 * @since 1.0
		 */
		public static final String CAUSEWAY_COAST_AND_GLENS_DISTRICT = "GB,N,09000004";

		/**
		 * Region code of the Ceredigion County.
		 *
		 * @since 1.0
		 */
		public static final String CEREDIGION_COUNTY = "GB,W,06000008";

		/**
		 * Region code of the Cherwell District.
		 *
		 * @since 1.0
		 */
		public static final String CHERWELL_DISTRICT = "GB,E,12000008,10000025,07000177";

		/**
		 * Region code of the Chichester District.
		 *
		 * @since 1.0
		 */
		public static final String CHICHESTER_DISTRICT = "GB,E,12000008,10000032,07000225";

		/**
		 * Region code of the Chiltern District.
		 *
		 * @since 1.0
		 */
		public static final String CHILTERN_DISTRICT = "GB,E,12000008,10000002,07000005";

		/**
		 * Region code of the City of Aberdeen.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_ABERDEEN = "GB,S,12000033";

		/**
		 * Region code of the City of Belfast.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_BELFAST = "GB,N,09000003";

		/**
		 * Region code of the City of Birmingham.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_BIRMINGHAM = "GB,E,12000005,11000005,08000025";

		/**
		 * Region code of the City of Bradford.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_BRADFORD = "GB,E,12000003,11000006,08000032";

		/**
		 * Region code of the City of Brighton and Hove.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_BRIGHTON_AND_HOVE = "GB,E,12000008,,06000043";

		/**
		 * Region code of the City of Bristol.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_BRISTOL = "GB,E,12000009,,06000023";

		/**
		 * Region code of the City of Cambridge.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_CAMBRIDGE = "GB,E,120000006,10000003,07000008";

		/**
		 * Region code of the City of Canterbury.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_CANTERBURY = "GB,E,12000008,10000016,07000106";

		/**
		 * Region code of the City of Cardiff.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_CARDIFF = "GB,W,06000015";

		/**
		 * Region code of the City of Carlisle.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_CARLISLE = "GB,E,12000002,10000006,07000028";

		/**
		 * Region code of the City of Chelmsford.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_CHELMSFORD = "GB,E,120000006,10000012,07000070";

		/**
		 * Region code of the City of Coventry.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_COVENTRY = "GB,E,12000005,11000005,08000026";

		/**
		 * Region code of the City of Derby.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_DERBY = "GB,E,12000004,,06000015";

		/**
		 * Region code of the City of Dundee.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_DUNDEE = "GB,S,12000042";

		/**
		 * Region code of the City of Edinburgh.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_EDINBURGH = "GB,S,12000036";

		/**
		 * Region code of the City of Exeter.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_EXETER = "GB,E,12000009,10000008,07000041";

		/**
		 * Region code of the City of Glasgow.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_GLASGOW = "GB,S,12000046";

		/**
		 * Region code of the City of Gloucester.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_GLOUCESTER = "GB,E,12000009,10000013,07000081";

		/**
		 * Region code of the City of Kingston upon Hull.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_KINGSTON_UPON_HULL = "GB,E,12000003,,06000010";

		/**
		 * Region code of the City of Lancaster.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_LANCASTER = "GB,E,12000002,10000017,07000121";

		/**
		 * Region code of the City of Leeds.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_LEEDS = "GB,E,12000003,11000006,08000035";

		/**
		 * Region code of the City of Leicester.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_LEICESTER = "GB,E,12000004,,06000016";

		/**
		 * Region code of the City of Lincoln.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_LINCOLN = "GB,E,12000004,10000019,07000138";

		/**
		 * Region code of the City of Liverpool.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_LIVERPOOL = "GB,E,12000002,11000002,08000012";

		/**
		 * Region code of the City of London.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_LONDON = "GB,E,12000007,09000001";

		/**
		 * Region code of the City of Manchester.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_MANCHESTER = "GB,E,12000002,11000001,08000003";

		/**
		 * Region code of the City of Newcastle upon Tyne.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_NEWCASTLE_UPON_TYNE = "GB,E,12000001,11000004,08000021";

		/**
		 * Region code of the City of Norwich.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_NORWICH = "GB,E,120000006,10000020,07000148";

		/**
		 * Region code of the City of Nottingham.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_NOTTINGHAM = "GB,E,12000004,,06000018";

		/**
		 * Region code of the City of Oxford.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_OXFORD = "GB,E,12000008,10000025,07000178";

		/**
		 * Region code of the City of Peterborough.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_PETERBOROUGH = "GB,E,12000006,,06000031";

		/**
		 * Region code of the City of Plymouth.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_PLYMOUTH = "GB,E,12000009,,06000026";

		/**
		 * Region code of the City of Portsmouth.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_PORTSMOUTH = "GB,E,12000008,,06000044";

		/**
		 * Region code of the City of Preston.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_PRESTON = "GB,E,12000002,10000017,07000123";

		/**
		 * Region code of the City of Saint Albans.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_SAINT_ALBANS = "GB,E,120000006,10000015,07000240";

		/**
		 * Region code of the City of Salford.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_SALFORD = "GB,E,12000002,11000001,08000006";

		/**
		 * Region code of the City of Sheffield.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_SHEFFIELD = "GB,E,12000003,11000003,08000019";

		/**
		 * Region code of the City of Southampton.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_SOUTHAMPTON = "GB,E,12000008,,06000045";

		/**
		 * Region code of the City of Stoke-on-Trent.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_STOKE_ON_TRENT = "GB,E,12000005,,06000021";

		/**
		 * Region code of the City of Sunderland.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_SUNDERLAND = "GB,E,12000001,11000004,08000024";

		/**
		 * Region code of the City of Swansea.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_SWANSEA = "GB,W,06000011";

		/**
		 * Region code of the City of Wakefield.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_WAKEFIELD = "GB,E,12000003,11000006,08000036";

		/**
		 * Region code of the City of Westminster.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_WESTMINSTER = "GB,E,12000007,09000033";

		/**
		 * Region code of the City of Winchester.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_WINCHESTER = "GB,E,12000008,10000014,07000094";

		/**
		 * Region code of the City of Wolverhampton.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_WOLVERHAMPTON = "GB,E,12000005,11000005,08000031";

		/**
		 * Region code of the City of Worcester.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_WORCESTER = "GB,E,12000005,10000034,07000237";

		/**
		 * Region code of the City of York.
		 *
		 * @since 1.0
		 */
		public static final String CITY_OF_YORK = "GB,E,12000003,,06000014";

		/**
		 * Region code of the Clackmannanshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String CLACKMANNANSHIRE_COUNCIL_AREA = "GB,S,12000005";

		/**
		 * Region code of the Comhairle nan Eilean Siar (also known as the Outer Hebrides).
		 *
		 * @since 1.0
		 */
		public static final String COMHAIRLE_NAN_EILEAN_SIAR = "GB,S,12000013";

		/**
		 * Region code of the Conwy County Borough.
		 *
		 * @since 1.0
		 */
		public static final String CONWY_COUNTY_BOROUGH = "GB,W,06000003";

		/**
		 * Region code of the Cotswold District.
		 *
		 * @since 1.0
		 */
		public static final String COTSWOLD_DISTRICT = "GB,E,12000009,10000013,07000079";

		/**
		 * Region code of the country of England.
		 *
		 * @since 1.0
		 */
		public static final String COUNTRY_OF_ENGLAND = "GB,E";

		/**
		 * Region code of the country of Northern Ireland.
		 *
		 * @since 1.0
		 */
		public static final String COUNTRY_OF_NORTHERN_IRELAND = "GB,N";

		/**
		 * Region code of the country of Scotland.
		 *
		 * @since 1.0
		 */
		public static final String COUNTRY_OF_SCOTLAND = "GB,S";

		/**
		 * Region code of the country of Wales.
		 *
		 * @since 1.0
		 */
		public static final String COUNTRY_OF_WALES = "GB,W";

		/**
		 * Region code of the County of Buckinghamshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_BUCKINGHAMSHIRE = "GB,E,12000008,10000002";

		/**
		 * Region code of the County of Cambridgeshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_CAMBRIDGESHIRE = "GB,E,12000006,10000003";

		/**
		 * Region code of the County of Carmarthenshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_CARMARTHENSHIRE = "GB,W,06000010";

		/**
		 * Region code of the County of Central Bedfordshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_CENTRAL_BEDFORDSHIRE = "GB,E,12000006,,06000056";

		/**
		 * Region code of the County of Cornwall.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_CORNWALL = "GB,E,12000009,,06000052";

		/**
		 * Region code of the County of Cumbria.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_CUMBRIA = "GB,E,12000002,10000006";

		/**
		 * Region code of the County of Denbighshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_DENBIGHSHIRE = "GB,W,06000004";

		/**
		 * Region code of the County of Derbyshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_DERBYSHIRE = "GB,E,12000004,10000007";

		/**
		 * Region code of the County of Devon.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_DEVON = "GB,E,12000009,10000008";

		/**
		 * Region code of the County of Dorset.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_DORSET = "GB,E,12000009,10000009";

		/**
		 * Region code of the County of Durham.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_DURHAM = "GB,E,12000001,,06000047";

		/**
		 * Region code of the County of East Sussex.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_EAST_SUSSEX = "GB,E,12000008,10000011";

		/**
		 * Region code of the County of Essex.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_ESSEX = "GB,E,12000006,10000012";

		/**
		 * Region code of the County of Flint.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_FLINT = "GB,W,06000005";

		/**
		 * Region code of the County of Gloucestershire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_GLOUCESTERSHIRE = "GB,E,12000009,10000013";

		/**
		 * Region code of the County of Hampshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_HAMPSHIRE = "GB,E,12000008,10000014";

		/**
		 * Region code of the County of Herefordshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_HEREFORDSHIRE = "GB,E,12000005,,06000019";

		/**
		 * Region code of the County of Hertfordshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_HERTFORDSHIRE = "GB,E,12000006,10000015";

		/**
		 * Region code of the County of Kent.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_KENT = "GB,E,12000008,10000016";

		/**
		 * Region code of the County of Lancashire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_LANCASHIRE = "GB,E,12000002,10000017";

		/**
		 * Region code of the County of Leicestershire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_LEICESTERSHIRE = "GB,E,12000004,10000018";

		/**
		 * Region code of the County of Lincolnshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_LINCOLNSHIRE = "GB,E,12000004,10000019";

		/**
		 * Region code of the County of Monmouthshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_MONMOUTHSHIRE = "GB,W,06000021";

		/**
		 * Region code of the County of Norfolk.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_NORFOLK = "GB,E,12000006,10000020";

		/**
		 * Region code of the County of North Yorkshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_NORTH_YORKSHIRE = "GB,E,12000003,10000023";

		/**
		 * Region code of the County of Northamptonshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_NORTHAMPTONSHIRE = "GB,E,12000004,10000021";

		/**
		 * Region code of the County of Northumberland.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_NORTHUMBERLAND = "GB,E,12000001,,06000048";

		/**
		 * Region code of the County of Nottinghamshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_NOTTINGHAMSHIRE = "GB,E,12000004,10000024";

		/**
		 * Region code of the County of Oxfordshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_OXFORDSHIRE = "GB,E,12000008,10000025";

		/**
		 * Region code of the County of Powys.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_POWYS = "GB,W,06000023";

		/**
		 * Region code of the County of Rutland.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_RUTLAND = "GB,E,12000004,,06000017";

		/**
		 * Region code of the County of Somerset.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_SOMERSET = "GB,E,12000009,10000027";

		/**
		 * Region code of the County of Staffordshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_STAFFORDSHIRE = "GB,E,12000005,10000028";

		/**
		 * Region code of the County of Suffolk.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_SUFFOLK = "GB,E,12000006,10000029";

		/**
		 * Region code of the County of Surrey.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_SURREY = "GB,E,12000008,10000030";

		/**
		 * Region code of the County of Warwickshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_WARWICKSHIRE = "GB,E,12000005,10000031";

		/**
		 * Region code of the County of West Sussex.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_WEST_SUSSEX = "GB,E,12000008,10000032";

		/**
		 * Region code of the County of Wiltshire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_WILTSHIRE = "GB,E,12000009,,06000054";

		/**
		 * Region code of the County of Worcestershire.
		 *
		 * @since 1.0
		 */
		public static final String COUNTY_OF_WORCESTERSHIRE = "GB,E,12000005,10000034";

		/**
		 * Region code of the Craven District.
		 *
		 * @since 1.0
		 */
		public static final String CRAVEN_DISTRICT = "GB,E,12000003,10000023,07000163";

		/**
		 * Region code of the Daventry District.
		 *
		 * @since 1.0
		 */
		public static final String DAVENTRY_DISTRICT = "GB,E,12000004,10000021,07000151";

		/**
		 * Region code of the Derbyshire Dales District
		 *
		 * @since 1.0
		 */
		public static final String DERBYSHIRE_DALES_DISTRICT = "GB,E,12000004,10000007,07000035";

		/**
		 * Region code of the Derry and Strabane District.
		 *
		 * @since 1.0
		 */
		public static final String DERRY_AND_STRABANE_DISTRICT = "GB,N,09000005";

		/**
		 * Region code of the Dover District.
		 *
		 * @since 1.0
		 */
		public static final String DOVER_DISTRICT = "GB,E,12000008,10000016,07000108";

		/**
		 * Region code of the Dumfries and Galloway Council Area.
		 *
		 * @since 1.0
		 */
		public static final String DUMFRIES_AND_GALLOWAY_COUNCIL_AREA = "GB,S,12000006";

		/**
		 * Region code of the East Ayrshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String EAST_AYRSHIRE_COUNCIL_AREA = "GB,S,12000008";

		/**
		 * Region code of the East Cambridgeshire District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_CAMBRIDGESHIRE_DISTRICT = "GB,E,120000006,10000003,07000009";

		/**
		 * Region code of the East Devon District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_DEVON_DISTRICT = "GB,E,12000009,10000008,07000040";

		/**
		 * Region code of the East Dorset District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_DORSET_DISTRICT = "GB,E,12000009,10000009,07000049";

		/**
		 * Region code of the East Dunbartonshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String EAST_DUNBARTONSHIRE_COUNCIL_AREA = "GB,S,12000045";

		/**
		 * Region code of the East Hampshire District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_HAMPSHIRE_DISTRICT = "GB,E,12000008,10000014,07000085";

		/**
		 * Region code of the East Hertfordshire District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_HERTFORDSHIRE_DISTRICT = "GB,E,120000006,10000015,07000097";

		/**
		 * Region code of the East Lindsey District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_LINDSEY_DISTRICT = "GB,E,12000004,10000019,07000137";

		/**
		 * Region code of the East Lothian Council Area.
		 *
		 * @since 1.0
		 */
		public static final String EAST_LOTHIAN_COUNCIL_AREA = "GB,S,12000010";

		/**
		 * Region code of the East Northamptonshire District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_NORTHAMPTONSHIRE_DISTRICT = "GB,E,12000004,10000021,07000152";

		/**
		 * Region code of the East Renfrewshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String EAST_RENFREWSHIRE_COUNCIL_AREA = "GB,S,12000011";

		/**
		 * Region code of the East Riding of Yorkshire District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_RIDING_OF_YORKSHIRE_DISTRICT = "GB,E,12000003,,06000011";

		/**
		 * Region code of the East Staffordshire District.
		 *
		 * @since 1.0
		 */
		public static final String EAST_STAFFORDSHIRE_DISTRICT = "GB,E,12000005,10000028,07000193";

		/**
		 * Region code of the Eden District.
		 *
		 * @since 1.0
		 */
		public static final String EDEN_DISTRICT = "GB,E,12000002,10000006,07000030";

		/**
		 * Region code of the Epping Forest District.
		 *
		 * @since 1.0
		 */
		public static final String EPPING_FOREST_DISTRICT = "GB,E,120000006,10000012,07000072";

		/**
		 * Region code of the Falkirk Council Area.
		 *
		 * @since 1.0
		 */
		public static final String FALKIRK_COUNCIL_AREA = "GB,S,12000014";

		/**
		 * Region code of the Fenland District.
		 *
		 * @since 1.0
		 */
		public static final String FENLAND_DISTRICT = "GB,E,120000006,10000003,07000010";

		/**
		 * Region code of the Fermanagh and Omagh District.
		 *
		 * @since 1.0
		 */
		public static final String FERMANAGH_AND_OMAGH_DISTRICT = "GB,N,09000006";

		/**
		 * Region code of the Fife Council Area.
		 *
		 * @since 1.0
		 */
		public static final String FIFE_COUNCIL_AREA = "GB,S,12000015";

		/**
		 * Region code of the Forest Heath District.
		 *
		 * @since 1.0
		 */
		public static final String FOREST_HEATH_DISTRICT = "GB,E,120000006,10000029,07000201";

		/**
		 * Region code of the Forest of Dean District.
		 *
		 * @since 1.0
		 */
		public static final String FOREST_OF_DEAN_DISTRICT = "GB,E,12000009,10000013,07000080";

		/**
		 * Region code of the Gwynedd County.
		 *
		 * @since 1.0
		 */
		public static final String GWYNEDD_COUNTY = "GB,W,06000002";

		/**
		 * Region code of the Hambleton District.
		 *
		 * @since 1.0
		 */
		public static final String HAMBLETON_DISTRICT = "GB,E,12000003,10000023,07000164";

		/**
		 * Region code of the Harborough District.
		 *
		 * @since 1.0
		 */
		public static final String HARBOROUGH_DISTRICT = "GB,E,12000004,10000018,07000131";

		/**
		 * Region code of the Hart District.
		 *
		 * @since 1.0
		 */
		public static final String HART_DISTRICT = "GB,E,12000008,10000014,07000089";

		/**
		 * Region code of the Highland Council Area.
		 *
		 * @since 1.0
		 */
		public static final String HIGHLAND_COUNCIL_AREA = "GB,S,12000017";

		/**
		 * Region code of the Horsham District.
		 *
		 * @since 1.0
		 */
		public static final String HORSHAM_DISTRICT = "GB,E,12000008,10000032,07000227";

		/**
		 * Region code of the Huntingdonshire District.
		 *
		 * @since 1.0
		 */
		public static final String HUNTINGDONSHIRE_DISTRICT = "GB,E,120000006,10000003,07000011";

		/**
		 * Region code of the Inverclyde Council Area.
		 *
		 * @since 1.0
		 */
		public static final String INVERCLYDE_COUNCIL_AREA = "GB,S,12000018";

		/**
		 * Region code of the Isle of Anglesey County.
		 *
		 * @since 1.0
		 */
		public static final String ISLE_OF_ANGLESEY_COUNTY = "GB,W,06000001";

		/**
		 * Region code of the Isle of Wight District.
		 *
		 * @since 1.0
		 */
		public static final String ISLE_OF_WIGHT_DISTRICT = "GB,E,12000008,,06000046";

		/**
		 * Region code of the Isles of Scilly District.
		 *
		 * @since 1.0
		 */
		public static final String ISLES_OF_SCILLY_DISTRICT = "GB,E,12000009,,06000053";

		/**
		 * Region code of the Lewes District.
		 *
		 * @since 1.0
		 */
		public static final String LEWES_DISTRICT = "GB,E,12000008,10000011,07000063";

		/**
		 * Region code of the Lichfield District.
		 *
		 * @since 1.0
		 */
		public static final String LICHFIELD_DISTRICT = "GB,E,12000005,10000028,07000194";

		/**
		 * Region code of the Lisburn and Castlereagh District.
		 *
		 * @since 1.0
		 */
		public static final String LISBURN_AND_CASTLEREAGH_DISTRICT = "GB,N,09000007";

		/**
		 * Region code of the London Borough of Barking and Dagenham.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_BARKING_AND_DAGENHAM = "GB,E,12000007,09000002";

		/**
		 * Region code of the London Borough of Barnet.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_BARNET = "GB,E,12000007,09000003";

		/**
		 * Region code of the London Borough of Bexley.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_BEXLEY = "GB,E,12000007,09000004";

		/**
		 * Region code of the London Borough of Brent.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_BRENT = "GB,E,12000007,09000005";

		/**
		 * Region code of the London Borough of Bromley.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_BROMLEY = "GB,E,12000007,09000006";

		/**
		 * Region code of the London Borough of Camden.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_CAMDEN = "GB,E,12000007,09000007";

		/**
		 * Region code of the London Borough of Croydon.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_CROYDON = "GB,E,12000007,09000008";

		/**
		 * Region code of the London Borough of Ealing.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_EALING = "GB,E,12000007,09000009";

		/**
		 * Region code of the London Borough of Enfield.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_ENFIELD = "GB,E,12000007,09000010";

		/**
		 * Region code of the London Borough of Hackney.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_HACKNEY = "GB,E,12000007,09000012";

		/**
		 * Region code of the London Borough of Hammersmith and Fulham.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_HAMMERSMITH_AND_FULHAM = "GB,E,12000007,09000013";

		/**
		 * Region code of the London Borough of Haringey.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_HARINGEY = "GB,E,12000007,09000014";

		/**
		 * Region code of the London Borough of Harrow.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_HARROW = "GB,E,12000007,09000015";

		/**
		 * Region code of the London Borough of Havering.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_HAVERING = "GB,E,12000007,09000016";

		/**
		 * Region code of the London Borough of Hillingdon.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_HILLINGDON = "GB,E,12000007,09000017";

		/**
		 * Region code of the London Borough of Hounslow.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_HOUNSLOW = "GB,E,12000007,09000018";

		/**
		 * Region code of the London Borough of Islington.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_ISLINGTON = "GB,E,12000007,09000019";

		/**
		 * Region code of the London Borough of Lambeth.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_LAMBETH = "GB,E,12000007,09000022";

		/**
		 * Region code of the London Borough of Lewisham.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_LEWISHAM = "GB,E,12000007,09000023";

		/**
		 * Region code of the London Borough of Merton.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_MERTON = "GB,E,12000007,09000024";

		/**
		 * Region code of the London Borough of Newham.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_NEWHAM = "GB,E,12000007,09000025";

		/**
		 * Region code of the London Borough of Redbridge.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_REDBRIDGE = "GB,E,12000007,09000026";

		/**
		 * Region code of the London Borough of Richmond upon Thames.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_RICHMOND_UPON_THAMES = "GB,E,12000007,09000027";

		/**
		 * Region code of the London Borough of Southwark.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_SOUTHWARK = "GB,E,12000007,09000028";

		/**
		 * Region code of the London Borough of Sutton.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_SUTTON = "GB,E,12000007,09000029";

		/**
		 * Region code of the London Borough of Tower Hamlets.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_TOWER_HAMLETS = "GB,E,12000007,09000030";

		/**
		 * Region code of the London Borough of Waltham Forest.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_WALTHAM_FOREST = "GB,E,12000007,09000031";

		/**
		 * Region code of the London Borough of Wandsworth.
		 *
		 * @since 1.0
		 */
		public static final String LONDON_BOROUGH_OF_WANDSWORTH = "GB,E,12000007,09000032";

		/**
		 * Region code of the Maldon District.
		 *
		 * @since 1.0
		 */
		public static final String MALDON_DISTRICT = "GB,E,120000006,10000012,07000074";

		/**
		 * Region code of the Malvern Hills District.
		 *
		 * @since 1.0
		 */
		public static final String MALVERN_HILLS_DISTRICT = "GB,E,12000005,10000034,07000235";

		/**
		 * Region code of the Mansfield District.
		 *
		 * @since 1.0
		 */
		public static final String MANSFIELD_DISTRICT = "GB,E,12000004,10000024,07000174";

		/**
		 * Region code of the Mendip District.
		 *
		 * @since 1.0
		 */
		public static final String MENDIP_DISTRICT = "GB,E,12000009,10000027,07000187";

		/**
		 * Region code of the Merthyr Tydfil County Borough.
		 *
		 * @since 1.0
		 */
		public static final String MERTHYR_TYDFIL_COUNTY_BOROUGH = "GB,W,06000024";

		/**
		 * Region code of the Metropolitan Borough of Barnsley.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_BARNSLEY = "GB,E,12000003,11000003,08000016";

		/**
		 * Region code of the Metropolitan Borough of Bolton.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_BOLTON = "GB,E,12000002,11000001,08000001";

		/**
		 * Region code of the Metropolitan Borough of Bury.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_BURY = "GB,E,12000002,11000001,08000002";

		/**
		 * Region code of the Metropolitan Borough of Calderdale.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_CALDERDALE = "GB,E,12000003,11000006,08000033";

		/**
		 * Region code of the Metropolitan Borough of Doncaster.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_DONCASTER = "GB,E,12000003,11000003,08000017";

		/**
		 * Region code of the Metropolitan Borough of Dudley.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_DUDLEY = "GB,E,12000005,11000005,08000027";

		/**
		 * Region code of the Metropolitan Borough of Gateshead.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_GATESHEAD = "GB,E,12000001,11000004,08000020";

		/**
		 * Region code of the Metropolitan Borough of Kirklees.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_KIRKLEES = "GB,E,12000003,11000006,08000034";

		/**
		 * Region code of the Metropolitan Borough of Knowsley.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_KNOWSLEY = "GB,E,12000002,11000002,08000011";

		/**
		 * Region code of the Metropolitan Borough of North Tyneside.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_NORTH_TYNESIDE = "GB,E,12000001,11000004,08000022";

		/**
		 * Region code of the Metropolitan Borough of Oldham.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_OLDHAM = "GB,E,12000002,11000001,08000004";

		/**
		 * Region code of the Metropolitan Borough of Rochdale.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_ROCHDALE = "GB,E,12000002,11000001,08000005";

		/**
		 * Region code of the Metropolitan Borough of Rotherham.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_ROTHERHAM = "GB,E,12000003,11000003,08000018";

		/**
		 * Region code of the Metropolitan Borough of Saint Helens.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_SAINT_HELENS = "GB,E,12000002,11000002,08000013";

		/**
		 * Region code of the Metropolitan Borough of Sandwell.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_SANDWELL = "GB,E,12000005,11000005,08000028";

		/**
		 * Region code of the Metropolitan Borough of Sefton.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_SEFTON = "GB,E,12000002,11000002,08000014";

		/**
		 * Region code of the Metropolitan Borough of Solihull.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_SOLIHULL = "GB,E,12000005,11000005,08000029";

		/**
		 * Region code of the Metropolitan Borough of South Tyneside.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_SOUTH_TYNESIDE = "GB,E,12000001,11000004,08000023";

		/**
		 * Region code of the Metropolitan Borough of Tameside.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_TAMESIDE = "GB,E,12000002,11000001,08000008";

		/**
		 * Region code of the Metropolitan Borough of Trafford.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_TRAFFORD = "GB,E,12000002,11000001,08000009";

		/**
		 * Region code of the Metropolitan Borough of Walsall.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_WALSALL = "GB,E,12000005,11000005,08000030";

		/**
		 * Region code of the Metropolitan Borough of Wigan.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_WIGAN = "GB,E,12000002,11000001,08000010";

		/**
		 * Region code of the Metropolitan Borough of Wirral.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_BOROUGH_OF_WIRRAL = "GB,E,12000002,11000002,08000015";

		/**
		 * Region code of the Metropolitan County of Greater Manchester.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_COUNTY_OF_GREATER_MANCHESTER = "GB,E,12000002,11000001";

		/**
		 * Region code of the Metropolitan County of Merseyside.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_COUNTY_OF_MERSEYSIDE = "GB,E,12000002,11000002";

		/**
		 * Region code of the Metropolitan County of South Yorkshire.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_COUNTY_OF_SOUTH_YORKSHIRE = "GB,E,12000003,11000003";

		/**
		 * Region code of the Metropolitan County of Tyne and Wear.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_COUNTY_OF_TYNE_AND_WEAR = "GB,E,12000001,11000004";

		/**
		 * Region code of the Metropolitan County of West Midlands.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_COUNTY_OF_WEST_MIDLANDS = "GB,E,12000005,11000005";

		/**
		 * Region code of the Metropolitan County of West Yorkshire.
		 *
		 * @since 1.0
		 */
		public static final String METROPOLITAN_COUNTY_OF_WEST_YORKSHIRE = "GB,E,12000003,11000006";

		/**
		 * Region code of the Mid and East Antrim District.
		 *
		 * @since 1.0
		 */
		public static final String MID_AND_EAST_ANTRIM_DISTRICT = "GB,N,09000008";

		/**
		 * Region code of the Mid Devon District.
		 *
		 * @since 1.0
		 */
		public static final String MID_DEVON_DISTRICT = "GB,E,12000009,10000008,07000042";

		/**
		 * Region code of the Mid Suffolk District.
		 *
		 * @since 1.0
		 */
		public static final String MID_SUFFOLK_DISTRICT = "GB,E,120000006,10000029,07000203";

		/**
		 * Region code of the Mid Sussex District.
		 *
		 * @since 1.0
		 */
		public static final String MID_SUSSEX_DISTRICT = "GB,E,12000008,10000032,07000228";

		/**
		 * Region code of the Mid-Ulster District.
		 *
		 * @since 1.0
		 */
		public static final String MID_ULSTER_DISTRICT = "GB,N,09000009";

		/**
		 * Region code of the Midlothian Council Area.
		 *
		 * @since 1.0
		 */
		public static final String MIDLOTHIAN_COUNCIL_AREA = "GB,S,12000019";

		/**
		 * Region code of the Mole Valley District.
		 *
		 * @since 1.0
		 */
		public static final String MOLE_VALLEY_DISTRICT = "GB,E,12000008,10000030,07000210";

		/**
		 * Region code of the Moray Council Area.
		 *
		 * @since 1.0
		 */
		public static final String MORAY_COUNCIL_AREA = "GB,S,12000020";

		/**
		 * Region code of the Neath Port Talbot County Borough.
		 *
		 * @since 1.0
		 */
		public static final String NEATH_PORT_TALBOT_COUNTY_BOROUGH = "GB,W,06000012";

		/**
		 * Region code of the New Forest District.
		 *
		 * @since 1.0
		 */
		public static final String NEW_FOREST_DISTRICT = "GB,E,12000008,10000014,07000091";

		/**
		 * Region code of the Newark and Sherwood District.
		 *
		 * @since 1.0
		 */
		public static final String NEWARK_AND_SHERWOOD_DISTRICT = "GB,E,12000004,10000024,07000175";

		/**
		 * Region code of the Newport County Borough.
		 *
		 * @since 1.0
		 */
		public static final String NEWPORT_COUNTY_BOROUGH = "GB,W,06000022";

		/**
		 * Region code of the Newry, Mourne and Down District.
		 *
		 * @since 1.0
		 */
		public static final String NEWRY_MOURNE_AND_DOWN_DISTRICT = "GB,N,09000010";

		/**
		 * Region code of the North Ayrshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_AYRSHIRE_COUNCIL_AREA = "GB,S,12000021";

		/**
		 * Region code of the North Devon District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_DEVON_DISTRICT = "GB,E,12000009,10000008,07000043";

		/**
		 * Region code of the North Dorset District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_DORSET_DISTRICT = "GB,E,12000009,10000009,07000050";

		/**
		 * Region code of the North East Derbyshire District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_EAST_DERBYSHIRE_DISTRICT = "GB,E,12000004,10000007,07000038";

		/**
		 * Region code of the North Hertfordshire District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_HERTFORDSHIRE_DISTRICT = "GB,E,120000006,10000015,07000099";

		/**
		 * Region code of the North Kesteven District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_KESTEVEN_DISTRICT = "GB,E,12000004,10000019,07000139";

		/**
		 * Region code of the North Lanarkshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_LANARKSHIRE_COUNCIL_AREA = "GB,S,12000044";

		/**
		 * Region code of the North Norfolk District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_NORFOLK_DISTRICT = "GB,E,120000006,10000020,07000147";

		/**
		 * Region code of the North Somerset District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_SOMERSET_DISTRICT = "GB,E,12000009,,06000024";

		/**
		 * Region code of the North West Leicestershire District.
		 *
		 * @since 1.0
		 */
		public static final String NORTH_WEST_LEICESTERSHIRE_DISTRICT = "GB,E,12000004,10000018,07000134";

		/**
		 * Region code of the Orkney Islands Council Area.
		 *
		 * @since 1.0
		 */
		public static final String ORKNEY_ISLANDS_COUNCIL_AREA = "GB,S,12000023";

		/**
		 * Region code of the Pembrokeshire County.
		 *
		 * @since 1.0
		 */
		public static final String PEMBROKESHIRE_COUNTY = "GB,W,06000009";

		/**
		 * Region code of the Perth and Kinross Council Area.
		 *
		 * @since 1.0
		 */
		public static final String PERTH_AND_KINROSS_COUNCIL_AREA = "GB,S,12000024";

		/**
		 * Region code of the Purbeck District.
		 *
		 * @since 1.0
		 */
		public static final String PURBECK_DISTRICT = "GB,E,12000009,10000009,07000051";

		/**
		 * Region code of the Region of East Midlands.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_EAST_MIDLANDS = "GB,E,12000004";

		/**
		 * Region code of the Region of East of England.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_EAST_OF_ENGLAND = "GB,E,12000006";

		/**
		 * Region code of the Region of Greater London.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_GREATER_LONDON = "GB,E,12000007";

		/**
		 * Region code of the Region of North East England.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_NORTH_EAST_ENGLAND = "GB,E,12000001";

		/**
		 * Region code of the Region of North West England.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_NORTH_WEST_ENGLAND = "GB,E,12000002";

		/**
		 * Region code of the Region of South East England.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_SOUTH_EAST_ENGLAND = "GB,E,12000008";

		/**
		 * Region code of the Region of South West England.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_SOUTH_WEST_ENGLAND = "GB,E,12000009";

		/**
		 * Region code of the Region of West Midlands
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_WEST_MIDLANDS = "GB,E,12000005";

		/**
		 * Region code of the Region of Yorkshire and the Humber.
		 *
		 * @since 1.0
		 */
		public static final String REGION_OF_YORKSHIRE_AND_THE_HUMBER = "GB,E,12000003";

		/**
		 * Region code of the Renfrewshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String RENFREWSHIRE_COUNCIL_AREA = "GB,S,12000038";

		/**
		 * Region code of the Rhondda Cynon Taf County Borough.
		 *
		 * @since 1.0
		 */
		public static final String RHONDDA_CYNON_TAF_COUNTY_BOROUGH = "GB,W,06000016";

		/**
		 * Region code of the Richmondshire District.
		 *
		 * @since 1.0
		 */
		public static final String RICHMONDSHIRE_DISTRICT = "GB,E,12000003,10000023,07000166";

		/**
		 * Region code of the Rochford District.
		 *
		 * @since 1.0
		 */
		public static final String ROCHFORD_DISTRICT = "GB,E,120000006,10000012,07000075";

		/**
		 * Region code of the Rother District.
		 *
		 * @since 1.0
		 */
		public static final String ROTHER_DISTRICT = "GB,E,12000008,10000011,07000064";

		/**
		 * Region code of the Royal Borough of Greenwich.
		 *
		 * @since 1.0
		 */
		public static final String ROYAL_BOROUGH_OF_GREENWICH = "GB,E,12000007,09000011";

		/**
		 * Region code of the Royal Borough of Kensington and Chelsea.
		 *
		 * @since 1.0
		 */
		public static final String ROYAL_BOROUGH_OF_KENSINGTON_AND_CHELSEA = "GB,E,12000007,09000020";

		/**
		 * Region code of the Royal Borough of Kingston upon Thames.
		 *
		 * @since 1.0
		 */
		public static final String ROYAL_BOROUGH_OF_KINGSTON_UPON_THAMES = "GB,E,12000007,09000021";

		/**
		 * Region code of the Royal Borough of Windsor and Maidenhead.
		 *
		 * @since 1.0
		 */
		public static final String ROYAL_BOROUGH_OF_WINDSOR_AND_MAIDENHEAD = "GB,E,12000008,,06000040";

		/**
		 * Region code of the Ryedale District.
		 *
		 * @since 1.0
		 */
		public static final String RYEDALE_DISTRICT = "GB,E,12000003,10000023,07000167";

		/**
		 * Region code of the Scottish Borders Council Area.
		 *
		 * @since 1.0
		 */
		public static final String SCOTTISH_BORDERS_COUNCIL_AREA = "GB,S,12000026";

		/**
		 * Region code of the Sedgemoor District.
		 *
		 * @since 1.0
		 */
		public static final String SEDGEMOOR_DISTRICT = "GB,E,12000009,10000027,07000188";

		/**
		 * Region code of the Selby District.
		 *
		 * @since 1.0
		 */
		public static final String SELBY_DISTRICT = "GB,E,12000003,10000023,07000169";

		/**
		 * Region code of the Sevenoaks District.
		 *
		 * @since 1.0
		 */
		public static final String SEVENOAKS_DISTRICT = "GB,E,12000008,10000016,07000111";

		/**
		 * Region code of the Shepway District.
		 *
		 * @since 1.0
		 */
		public static final String SHEPWAY_DISTRICT = "GB,E,12000008,10000016,07000112";

		/**
		 * Region code of the Shetland Islands Council Area.
		 *
		 * @since 1.0
		 */
		public static final String SHETLAND_ISLANDS_COUNCIL_AREA = "GB,S,12000027";

		/**
		 * Region code of the Shropshire District.
		 *
		 * @since 1.0
		 */
		public static final String SHROPSHIRE_DISTRICT = "GB,E,12000005,,06000051";

		/**
		 * Region code of the South Ayrshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_AYRSHIRE_COUNCIL_AREA = "GB,S,12000028";

		/**
		 * Region code of the South Bucks District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_BUCKS_DISTRICT = "GB,E,12000008,10000002,07000006";

		/**
		 * Region code of the South Cambridgeshire District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_CAMBRIDGESHIRE_DISTRICT = "GB,E,120000006,10000003,07000012";

		/**
		 * Region code of the South Derbyshire District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_DERBYSHIRE_DISTRICT = "GB,E,12000004,10000007,07000039";

		/**
		 * Region code of the South Gloucestershire District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_GLOUCESTERSHIRE_DISTRICT = "GB,E,12000009,,06000025";

		/**
		 * Region code of the South Hams District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_HAMS_DISTRICT = "GB,E,12000009,10000008,07000044";

		/**
		 * Region code of the South Holland District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_HOLLAND_DISTRICT = "GB,E,12000004,10000019,07000140";

		/**
		 * Region code of the South Kesteven District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_KESTEVEN_DISTRICT = "GB,E,12000004,10000019,07000141";

		/**
		 * Region code of the South Lakeland District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_LAKELAND_DISTRICT = "GB,E,12000002,10000006,07000031";

		/**
		 * Region code of the South Lanarkshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_LANARKSHIRE_COUNCIL_AREA = "GB,S,12000029";

		/**
		 * Region code of the South Norfolk District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_NORFOLK_DISTRICT = "GB,E,120000006,10000020,07000149";

		/**
		 * Region code of the South Northamptonshire District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_NORTHAMPTONSHIRE_DISTRICT = "GB,E,12000004,10000021,07000155";

		/**
		 * Region code of the South Oxfordshire District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_OXFORDSHIRE_DISTRICT = "GB,E,12000008,10000025,07000179";

		/**
		 * Region code of the South Somerset District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_SOMERSET_DISTRICT = "GB,E,12000009,10000027,07000189";

		/**
		 * Region code of the South Staffordshire District.
		 *
		 * @since 1.0
		 */
		public static final String SOUTH_STAFFORDSHIRE_DISTRICT = "GB,E,12000005,10000028,07000196";

		/**
		 * Region code of the Staffordshire Moorlands District.
		 *
		 * @since 1.0
		 */
		public static final String STAFFORDSHIRE_MOORLANDS_DISTRICT = "GB,E,12000005,10000028,07000198";

		/**
		 * Region code of the Stirling Council Area.
		 *
		 * @since 1.0
		 */
		public static final String STIRLING_COUNCIL_AREA = "GB,S,12000030";

		/**
		 * Region code of the Stratford-on-Avon District.
		 *
		 * @since 1.0
		 */
		public static final String STRATFORD_ON_AVON_DISTRICT = "GB,E,12000005,10000031,07000221";

		/**
		 * Region code of the Stroud District.
		 *
		 * @since 1.0
		 */
		public static final String STROUD_DISTRICT = "GB,E,12000009,10000013,07000082";

		/**
		 * Region code of the Suffolk Coastal District.
		 *
		 * @since 1.0
		 */
		public static final String SUFFOLK_COASTAL_DISTRICT = "GB,E,120000006,10000029,07000205";

		/**
		 * Region code of the Surrey Heath District.
		 *
		 * @since 1.0
		 */
		public static final String SURREY_HEATH_DISTRICT = "GB,E,12000008,10000030,07000214";

		/**
		 * Region code of the Tandridge District.
		 *
		 * @since 1.0
		 */
		public static final String TANDRIDGE_DISTRICT = "GB,E,12000008,10000030,07000215";

		/**
		 * Region code of the Taunton Deane District.
		 *
		 * @since 1.0
		 */
		public static final String TAUNTON_DEANE_DISTRICT = "GB,E,12000009,10000027,07000190";

		/**
		 * Region code of the Teignbridge District.
		 *
		 * @since 1.0
		 */
		public static final String TEIGNBRIDGE_DISTRICT = "GB,E,12000009,10000008,07000045";

		/**
		 * Region code of the Tendring District.
		 *
		 * @since 1.0
		 */
		public static final String TENDRING_DISTRICT = "GB,E,120000006,10000012,07000076";

		/**
		 * Region code of the Thanet District.
		 *
		 * @since 1.0
		 */
		public static final String THANET_DISTRICT = "GB,E,12000008,10000016,07000114";

		/**
		 * Region code of the Three Rivers District.
		 *
		 * @since 1.0
		 */
		public static final String THREE_RIVERS_DISTRICT = "GB,E,120000006,10000015,07000102";

		/**
		 * Region code of the Tonbridge and Malling District.
		 *
		 * @since 1.0
		 */
		public static final String TONBRIDGE_AND_MALLING_DISTRICT = "GB,E,12000008,10000016,07000115";

		/**
		 * Region code of the Torfaen County Borough.
		 *
		 * @since 1.0
		 */
		public static final String TORFAEN_COUNTY_BOROUGH = "GB,W,06000020";

		/**
		 * Region code of the Torridge District.
		 *
		 * @since 1.0
		 */
		public static final String TORRIDGE_DISTRICT = "GB,E,12000009,10000008,07000046";

		/**
		 * Region code of the Town of Blackpool.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_BLACKPOOL = "GB,E,12000002,,06000009";

		/**
		 * Region code of the Town of Cheltenham.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_CHELTENHAM = "GB,E,12000009,10000013,07000078";

		/**
		 * Region code of the Town of Chorley.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_CHORLEY = "GB,E,12000002,10000017,07000118";

		/**
		 * Region code of the Town of Great Yarmouth.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_GREAT_YARMOUTH = "GB,E,120000006,10000020,07000145";

		/**
		 * Region code of the Town of Middlesbrough.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_MIDDLESBROUGH = "GB,E,12000001,,06000002";

		/**
		 * Region code of the Town of Reading.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_READING = "GB,E,12000008,,06000038";

		/**
		 * Region code of the Town of Stockport.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_STOCKPORT = "GB,E,12000002,11000001,08000007";

		/**
		 * Region code of the Town of Tamworth.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_TAMWORTH = "GB,E,12000005,10000028,07000199";

		/**
		 * Region code of the Town of Warrington.
		 *
		 * @since 1.0
		 */
		public static final String TOWN_OF_WARRINGTON = "GB,E,12000002,,06000007";

		/**
		 * Region code of the Uttlesford District.
		 *
		 * @since 1.0
		 */
		public static final String UTTLESFORD_DISTRICT = "GB,E,120000006,10000012,07000077";

		/**
		 * Region code of the Vale of Glamorgan County Borough.
		 *
		 * @since 1.0
		 */
		public static final String VALE_OF_GLAMORGAN_COUNTY_BOROUGH = "GB,W,06000014";

		/**
		 * Region code of the Vale of White Horse District.
		 *
		 * @since 1.0
		 */
		public static final String VALE_OF_WHITE_HORSE_DISTRICT = "GB,E,12000008,10000025,07000180";

		/**
		 * Region code of the Warwick District.
		 *
		 * @since 1.0
		 */
		public static final String WARWICK_DISTRICT = "GB,E,12000005,10000031,07000222";

		/**
		 * Region code of the Waveney District.
		 *
		 * @since 1.0
		 */
		public static final String WAVENEY_DISTRICT = "GB,E,120000006,10000029,07000206";

		/**
		 * Region code of the Wealden District.
		 *
		 * @since 1.0
		 */
		public static final String WEALDEN_DISTRICT = "GB,E,12000008,10000011,07000065";

		/**
		 * Region code of the West Berkshire District.
		 *
		 * @since 1.0
		 */
		public static final String WEST_BERKSHIRE_DISTRICT = "GB,E,12000008,,06000037";

		/**
		 * Region code of the West Devon District.
		 *
		 * @since 1.0
		 */
		public static final String WEST_DEVON_DISTRICT = "GB,E,12000009,10000008,07000047";

		/**
		 * Region code of the West Dorset District.
		 *
		 * @since 1.0
		 */
		public static final String WEST_DORSET_DISTRICT = "GB,E,12000009,10000009,07000052";

		/**
		 * Region code of the West Dunbartonshire Council Area.
		 *
		 * @since 1.0
		 */
		public static final String WEST_DUNBARTONSHIRE_COUNCIL_AREA = "GB,S,12000039";

		/**
		 * Region code of the West Lindsey District.
		 *
		 * @since 1.0
		 */
		public static final String WEST_LINDSEY_DISTRICT = "GB,E,12000004,10000019,07000142";

		/**
		 * Region code of the West Lothian Council Area.
		 *
		 * @since 1.0
		 */
		public static final String WEST_LOTHIAN_COUNCIL_AREA = "GB,S,12000040";

		/**
		 * Region code of the West Oxfordshire District.
		 *
		 * @since 1.0
		 */
		public static final String WEST_OXFORDSHIRE_DISTRICT = "GB,E,12000008,10000025,07000181";

		/**
		 * Region code of the West Somerset District.
		 *
		 * @since 1.0
		 */
		public static final String WEST_SOMERSET_DISTRICT = "GB,E,12000009,10000027,07000191";

		/**
		 * Region code of the Wrexham County Borough.
		 *
		 * @since 1.0
		 */
		public static final String WREXHAM_COUNTY_BOROUGH = "GB,W,06000006";

		/**
		 * Region code of the Wychavon District.
		 *
		 * @since 1.0
		 */
		public static final String WYCHAVON_DISTRICT = "GB,E,12000005,10000034,07000238";

		/**
		 * Region code of the Wycombe District.
		 *
		 * @since 1.0
		 */
		public static final String WYCOMBE_DISTRICT = "GB,E,12000008,10000002,07000007";

		/**
		 * Region code of the Wyre Forest District.
		 *
		 * @since 1.0
		 */
		public static final String WYRE_FOREST_DISTRICT = "GB,E,12000005,10000034,07000239";


		private UnitedKingdom() {
			// Namespace for constants, not to be instantiated
		}

	}

	// ------------------------------------------------------------
	// ------------------------------------------------------------
	// ------------------------------------------------------------

	/**
	 * Codes for supported {@link GeoRegion}s in the United States.
	 *
	 * @since 1.0
	 */
	public static class UnitedStates {

		/**
		 * Region code of the District of Columbia.
		 *
		 * @since 1.0
		 */
		public static final String DISTRICT_OF_COLUMBIA = "US,11";

		/**
		 * Region code of the State of Alabama.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_ALABAMA = "US,01";

		/**
		 * Region code of the State of Alaska.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_ALASKA = "US,02";

		/**
		 * Region code of the State of Arizona.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_ARIZONA = "US,04";

		/**
		 * Region code of the State of Arkansas.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_ARKANSAS = "US,05";

		/**
		 * Region code of the State of California.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_CALIFORNIA = "US,06";

		/**
		 * Region code of the State of Colorado.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_COLORADO = "US,08";

		/**
		 * Region code of the State of Connecticut.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_CONNECTICUT = "US,09";

		/**
		 * Region code of the State of Delaware.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_DELAWARE = "US,10";

		/**
		 * Region code of the State of Florida.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_FLORIDA = "US,12";

		/**
		 * Region code of the State of Georgia.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_GEORGIA = "US,13";

		/**
		 * Region code of the State of Hawaii.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_HAWAII = "US,15";

		/**
		 * Region code of the State of Idaho.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_IDAHO = "US,16";

		/**
		 * Region code of the State of Illinois.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_ILLINOIS = "US,17";

		/**
		 * Region code of the State of Indiana.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_INDIANA = "US,18";

		/**
		 * Region code of the State of Iowa.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_IOWA = "US,19";

		/**
		 * Region code of the State of Kansas.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_KANSAS = "US,20";

		/**
		 * Region code of the State of Kentucky.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_KENTUCKY = "US,21";

		/**
		 * Region code of the State of Louisiana.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_LOUISIANA = "US,22";

		/**
		 * Region code of the State of Maine.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MAINE = "US,23";

		/**
		 * Region code of the State of Maryland.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MARYLAND = "US,24";

		/**
		 * Region code of the State of Massachusetts.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MASSACHUSETTS = "US,25";

		/**
		 * Region code of the State of Michigan.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MICHIGAN = "US,26";

		/**
		 * Region code of the State of Minnesota.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MINNESOTA = "US,27";

		/**
		 * Region code of the State of Mississippi.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MISSISSIPPI = "US,28";

		/**
		 * Region code of the State of Missouri.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MISSOURI = "US,29";

		/**
		 * Region code of the State of Montana.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_MONTANA = "US,30";

		/**
		 * Region code of the State of Nebraska.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NEBRASKA = "US,31";

		/**
		 * Region code of the State of Nevada.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NEVADA = "US,32";

		/**
		 * Region code of the State of New Hampshire.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NEW_HAMPSHIRE = "US,33";

		/**
		 * Region code of the State of New Jersey.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NEW_JERSEY = "US,34";

		/**
		 * Region code of the State of New Mexico.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NEW_MEXICO = "US,35";

		/**
		 * Region code of the State of New York.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NEW_YORK = "US,36";

		/**
		 * Region code of the State of North Carolina.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NORTH_CAROLINA = "US,37";

		/**
		 * Region code of the State of North Dakota.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_NORTH_DAKOTA = "US,38";

		/**
		 * Region code of the State of Ohio.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_OHIO = "US,39";

		/**
		 * Region code of the State of Oklahoma.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_OKLAHOMA = "US,40";

		/**
		 * Region code of the State of Oregon.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_OREGON = "US,41";

		/**
		 * Region code of the State of Pennsylvania.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_PENNSYLVANIA = "US,42";

		/**
		 * Region code of the State of Rhode Island.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_RHODE_ISLAND = "US,44";

		/**
		 * Region code of the State of South Carolina.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_SOUTH_CAROLINA = "US,45";

		/**
		 * Region code of the State of South Dakota.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_SOUTH_DAKOTA = "US,46";

		/**
		 * Region code of the State of Tennessee.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_TENNESSEE = "US,47";

		/**
		 * Region code of the State of Texas.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_TEXAS = "US,48";

		/**
		 * Region code of the State of Utah.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_UTAH = "US,49";

		/**
		 * Region code of the State of Vermont.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_VERMONT = "US,50";

		/**
		 * Region code of the State of Virginia.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_VIRGINIA = "US,51";

		/**
		 * Region code of the State of Washington.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_WASHINGTON = "US,53";

		/**
		 * Region code of the State of West Virginia.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_WEST_VIRGINIA = "US,54";

		/**
		 * Region code of the State of Wisconsin.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_WISCONSIN = "US,55";

		/**
		 * Region code of the State of Wyoming.
		 *
		 * @since 1.0
		 */
		public static final String STATE_OF_WYOMING = "US,56";


		private UnitedStates() {
			// Namespace for constants, not to be instantiated
		}

	}

}
