/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal;

import java.text.MessageFormat;
import org.sellcom.geotemporal.internal.ReflectionUtils;

public class Contract {
    private Contract() {
    }

    public static <T extends RuntimeException> void check(boolean condition, Class<T> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("Exception type must not be null");
        }
        if (!condition) {
            throw (RuntimeException)ReflectionUtils.createException(exceptionType);
        }
    }

    public static <T extends RuntimeException> void check(boolean condition, Class<T> exceptionType, String message, Object ... arguments) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("Exception type must not be null");
        }
        if (!condition) {
            if (arguments == null) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionType, message);
            }
            throw (RuntimeException)ReflectionUtils.createException(exceptionType, MessageFormat.format(message, arguments));
        }
    }

    public static void checkArgument(boolean condition, String message, Object ... arguments) {
        Contract.check(condition, IllegalArgumentException.class, message, arguments);
    }

    public static void checkState(boolean condition, String message, Object ... arguments) {
        Contract.check(condition, IllegalStateException.class, message, arguments);
    }
}

