/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.MonthDay;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.EnumSet;
import java.util.Set;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.geography.GeoRegionNotSupportedException;
import org.sellcom.geotemporal.internal.time.TemporalUtils;
import org.sellcom.geotemporal.time.HolidayType;
import org.sellcom.geotemporal.time.MoreTemporalAdjusters;

public class Holidays {
    private Holidays() {
    }

    public static boolean isHoliday(Temporal temporal, GeoRegion region, EnumSet<HolidayType> types) {
        switch (region.getCountryCode()) {
            case "AD": {
                return Holidays.isHoliday_andorra(temporal, region, types);
            }
            case "AT": {
                return Holidays.isHoliday_austria(temporal, region, types);
            }
            case "BE": {
                return Holidays.isHoliday_belgium(temporal, region, types);
            }
            case "HR": {
                return Holidays.isHoliday_croatia(temporal, region, types);
            }
            case "CY": {
                return Holidays.isHoliday_cyprus(temporal, region, types);
            }
            case "CZ": {
                return Holidays.isHoliday_czechRepublic(temporal, region, types);
            }
            case "DK": {
                return Holidays.isHoliday_denmark(temporal, region, types);
            }
            case "EE": {
                return Holidays.isHoliday_estonia(temporal, region, types);
            }
            case "FO": {
                return Holidays.isHoliday_faroeIslands(temporal, region, types);
            }
            case "FI": {
                return Holidays.isHoliday_finland(temporal, region, types);
            }
            case "FR": {
                return Holidays.isHoliday_france(temporal, region, types);
            }
            case "GE": {
                return Holidays.isHoliday_georgia(temporal, region, types);
            }
            case "DE": {
                return Holidays.isHoliday_germany(temporal, region, types);
            }
            case "GL": {
                return Holidays.isHoliday_greenland(temporal, region, types);
            }
            case "GG": {
                return Holidays.isHoliday_guernsey(temporal, region, types);
            }
            case "HU": {
                return Holidays.isHoliday_hungary(temporal, region, types);
            }
            case "IS": {
                return Holidays.isHoliday_iceland(temporal, region, types);
            }
            case "IM": {
                return Holidays.isHoliday_isleOfMan(temporal, region, types);
            }
            case "IT": {
                return Holidays.isHoliday_italy(temporal, region, types);
            }
            case "JE": {
                return Holidays.isHoliday_jersey(temporal, region, types);
            }
            case "LV": {
                return Holidays.isHoliday_latvia(temporal, region, types);
            }
            case "LI": {
                return Holidays.isHoliday_liechtenstein(temporal, region, types);
            }
            case "MT": {
                return Holidays.isHoliday_malta(temporal, region, types);
            }
            case "MD": {
                return Holidays.isHoliday_moldova(temporal, region, types);
            }
            case "NL": {
                return Holidays.isHoliday_netherlands(temporal, region, types);
            }
            case "NO": {
                return Holidays.isHoliday_norway(temporal, region, types);
            }
            case "PL": {
                return Holidays.isHoliday_poland(temporal, region, types);
            }
            case "PT": {
                return Holidays.isHoliday_portugal(temporal, region, types);
            }
            case "IE": {
                return Holidays.isHoliday_republicOfIreland(temporal, region, types);
            }
            case "RO": {
                return Holidays.isHoliday_romania(temporal, region, types);
            }
            case "RS": {
                return Holidays.isHoliday_serbia(temporal, region, types);
            }
            case "SK": {
                return Holidays.isHoliday_slovakia(temporal, region, types);
            }
            case "SI": {
                return Holidays.isHoliday_slovenia(temporal, region, types);
            }
            case "SE": {
                return Holidays.isHoliday_sweden(temporal, region, types);
            }
            case "CH": {
                return Holidays.isHoliday_switzerland(temporal, region, types);
            }
            case "GB": {
                return Holidays.isHoliday_unitedKingdom(temporal, region, types);
            }
            case "VA": {
                return Holidays.isHoliday_vaticanCity(temporal, region, types);
            }
        }
        throw new GeoRegionNotSupportedException(String.format("Unsupported region: %s", region));
    }

    private static boolean isHoliday_andorra(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 14)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.SEPTEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.shroveMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_austria(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_belgium(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JULY, 21)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 11)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_croatia(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 22)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 5)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_cyprus(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 28)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.cleanMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxGoodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxWhitMonday())) {
                return true;
            }
        }
        return types.contains((Object)HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY) && TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterMonday(), MoreTemporalAdjusters.nextDay());
    }

    private static boolean isHoliday_czechRepublic(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 8)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.JULY, 5, Month.JULY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.SEPTEMBER, 28)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 28)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 17)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 24, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday()) && temporal.get(ChronoField.YEAR) >= 2016) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
        }
        if (types.contains((Object)HolidayType.SCHOOLS_ONLY)) {
            String regionCode;
            if (TemporalUtils.isInRange(temporal, 2014, Month.JANUARY, 1, 2014, Month.JANUARY, 5)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2014, Month.JANUARY, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2014, Month.APRIL, 17, 2014, Month.APRIL, 18)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2014, Month.JUNE, 28, 2014, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2014, Month.OCTOBER, 27)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2014, Month.OCTOBER, 29)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2014, Month.DECEMBER, 22, 2015, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2015, Month.JANUARY, 30)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.APRIL, 2, 2015, Month.APRIL, 3)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.JULY, 1, 2015, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.OCTOBER, 29, 2015, Month.OCTOBER, 30)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.DECEMBER, 23, 2016, Month.JANUARY, 3)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2016, Month.JANUARY, 29)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.MARCH, 24, 2016, Month.MARCH, 25)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.JULY, 1, 2016, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.OCTOBER, 26, 2016, Month.OCTOBER, 27)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.DECEMBER, 23, 2017, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2017, Month.FEBRUARY, 3)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2017, Month.APRIL, 13)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2017, Month.JULY, 1, 2017, Month.SEPTEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2017, Month.OCTOBER, 26, 2017, Month.OCTOBER, 27)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2017, Month.DECEMBER, 23, 2018, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2018, Month.FEBRUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2018, Month.MARCH, 29)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2018, Month.JULY, 2, 2018, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2018, Month.OCTOBER, 29, 2018, Month.OCTOBER, 30)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2018, Month.DECEMBER, 22, 2019, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2019, Month.FEBRUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2019, Month.APRIL, 18)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2019, Month.JUNE, 29, 2019, Month.SEPTEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2019, Month.OCTOBER, 29, 2019, Month.OCTOBER, 30)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2019, Month.DECEMBER, 23, 2020, Month.JANUARY, 3)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2020, Month.JANUARY, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2020, Month.APRIL, 9)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2020, Month.JULY, 1, 2020, Month.AUGUST, 31)) {
                return true;
            }
            switch (regionCode = region.atLevel(2).getCode()) {
                case "CZ,20,7": 
                case "CZ,20,B": 
                case "CZ,31,7": 
                case "CZ,31,5": 
                case "CZ,31,6": 
                case "CZ,42,7": 
                case "CZ,42,2": 
                case "CZ,42,5": 
                case "CZ,52,2": 
                case "CZ,52,4": 
                case "CZ,71,2": 
                case "CZ,71,5": 
                case "CZ,80,5": 
                case "CZ,71,1": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.FEBRUARY, 3, 2014, Month.FEBRUARY, 9)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.FEBRUARY, 9, 2015, Month.FEBRUARY, 15)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 15, 2016, Month.FEBRUARY, 21)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.FEBRUARY, 27, 2017, Month.MARCH, 5)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.MARCH, 5, 2018, Month.MARCH, 11)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2019, Month.MARCH, 11, 2019, Month.MARCH, 17)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2020, Month.FEBRUARY, 3, 2020, Month.FEBRUARY, 9)) break;
                    return true;
                }
                case "CZ,20,1": 
                case "CZ,20,2": 
                case "CZ,32,6": 
                case "CZ,31,1": 
                case "CZ,31,2": 
                case "CZ,32,2": 
                case "CZ,52,5": 
                case "CZ,53,2": 
                case "CZ,53,1": 
                case "CZ,53,3": 
                case "CZ,53,4": 
                case "CZ,80,6": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.FEBRUARY, 10, 2014, Month.FEBRUARY, 16)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.FEBRUARY, 16, 2015, Month.FEBRUARY, 22)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 22, 2016, Month.FEBRUARY, 28)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.MARCH, 6, 2017, Month.MARCH, 12)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.MARCH, 12, 2018, Month.MARCH, 18)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2019, Month.FEBRUARY, 4, 2019, Month.FEBRUARY, 10)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2020, Month.FEBRUARY, 10, 2020, Month.FEBRUARY, 16)) break;
                    return true;
                }
                case "CZ,10,,500054": 
                case "CZ,10,,500089": 
                case "CZ,10,,500097": 
                case "CZ,10,,500119": 
                case "CZ,10,,500143": 
                case "CZ,10,,547034": 
                case "CZ,10,,547107": 
                case "CZ,10,,539694": 
                case "CZ,10,,539601": 
                case "CZ,10,,547042": 
                case "CZ,10,,547051": 
                case "CZ,10,,539449": 
                case "CZ,10,,539465": 
                case "CZ,10,,539635": 
                case "CZ,10,,539678": 
                case "CZ,10,,539724": 
                case "CZ,10,,539791": 
                case "CZ,10,,547115": 
                case "CZ,10,,539864": 
                case "CZ,10,,539899": 
                case "CZ,64,1": 
                case "CZ,64,2": 
                case "CZ,64,3": 
                case "CZ,64,4": 
                case "CZ,64,5": 
                case "CZ,64,6": 
                case "CZ,64,7": 
                case "CZ,32,1": 
                case "CZ,32,7": 
                case "CZ,42,4": 
                case "CZ,80,3": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.FEBRUARY, 17, 2014, Month.FEBRUARY, 23)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.FEBRUARY, 23, 2015, Month.MARCH, 1)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 29, 2016, Month.MARCH, 6)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.MARCH, 13, 2017, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.FEBRUARY, 5, 2018, Month.FEBRUARY, 11)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2019, Month.FEBRUARY, 11, 2019, Month.FEBRUARY, 17)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2020, Month.FEBRUARY, 17, 2020, Month.FEBRUARY, 23)) break;
                    return true;
                }
                case "CZ,10,,500178": 
                case "CZ,10,,500186": 
                case "CZ,10,,500208": 
                case "CZ,10,,500216": 
                case "CZ,10,,500224": 
                case "CZ,10,,547361": 
                case "CZ,10,,547387": 
                case "CZ,10,,547174": 
                case "CZ,10,,547417": 
                case "CZ,10,,547344": 
                case "CZ,10,,538213": 
                case "CZ,10,,538949": 
                case "CZ,10,,538931": 
                case "CZ,10,,538060": 
                case "CZ,10,,538078": 
                case "CZ,10,,538124": 
                case "CZ,10,,547310": 
                case "CZ,10,,547298": 
                case "CZ,10,,547301": 
                case "CZ,10,,547379": 
                case "CZ,10,,538175": 
                case "CZ,10,,538205": 
                case "CZ,10,,538302": 
                case "CZ,10,,538353": 
                case "CZ,10,,538361": 
                case "CZ,10,,538388": 
                case "CZ,10,,538400": 
                case "CZ,10,,547140": 
                case "CZ,10,,547158": 
                case "CZ,10,,538531": 
                case "CZ,10,,547395": 
                case "CZ,10,,539589": 
                case "CZ,10,,538736": 
                case "CZ,10,,547271": 
                case "CZ,10,,547409": 
                case "CZ,10,,547328": 
                case "CZ,10,,539007": 
                case "CZ,41,1": 
                case "CZ,41,2": 
                case "CZ,41,3": 
                case "CZ,20,8": 
                case "CZ,31,3": 
                case "CZ,42,3": 
                case "CZ,42,1": 
                case "CZ,71,4": 
                case "CZ,80,2": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.FEBRUARY, 24, 2014, Month.MARCH, 2)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.MARCH, 2, 2015, Month.MARCH, 8)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.MARCH, 7, 2016, Month.MARCH, 13)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.FEBRUARY, 6, 2017, Month.FEBRUARY, 12)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.FEBRUARY, 12, 2018, Month.FEBRUARY, 18)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2019, Month.FEBRUARY, 18, 2019, Month.FEBRUARY, 24)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2020, Month.FEBRUARY, 24, 2020, Month.MARCH, 1)) break;
                    return true;
                }
                case "CZ,72,1": 
                case "CZ,72,2": 
                case "CZ,72,3": 
                case "CZ,72,4": 
                case "CZ,20,9": 
                case "CZ,20,A": 
                case "CZ,20,6": 
                case "CZ,20,C": 
                case "CZ,32,3": 
                case "CZ,32,5": 
                case "CZ,32,4": 
                case "CZ,52,1": 
                case "CZ,42,6": 
                case "CZ,80,4": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.MARCH, 3, 2014, Month.MARCH, 9)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.MARCH, 9, 2015, Month.MARCH, 15)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 1, 2016, Month.FEBRUARY, 7)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.FEBRUARY, 13, 2017, Month.FEBRUARY, 19)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.FEBRUARY, 19, 2018, Month.FEBRUARY, 25)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2019, Month.FEBRUARY, 25, 2019, Month.MARCH, 3)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2020, Month.MARCH, 2, 2020, Month.MARCH, 8)) break;
                    return true;
                }
                case "CZ,51,1": 
                case "CZ,51,2": 
                case "CZ,51,3": 
                case "CZ,51,4": 
                case "CZ,63,1": 
                case "CZ,63,2": 
                case "CZ,63,3": 
                case "CZ,63,4": 
                case "CZ,63,5": 
                case "CZ,20,3": 
                case "CZ,20,4": 
                case "CZ,20,5": 
                case "CZ,31,4": 
                case "CZ,52,3": 
                case "CZ,80,1": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.MARCH, 10, 2014, Month.MARCH, 16)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.FEBRUARY, 2, 2015, Month.FEBRUARY, 8)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 8, 2016, Month.FEBRUARY, 14)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.FEBRUARY, 20, 2017, Month.FEBRUARY, 26)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.FEBRUARY, 26, 2018, Month.MARCH, 4)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2019, Month.MARCH, 4, 2019, Month.MARCH, 10)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2020, Month.MARCH, 9, 2020, Month.MARCH, 15)) break;
                    return true;
                }
                case "CZ,71,3": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.FEBRUARY, 17, 2014, Month.FEBRUARY, 23)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.FEBRUARY, 23, 2015, Month.MARCH, 1)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 29, 2016, Month.MARCH, 6)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.MARCH, 6, 2017, Month.MARCH, 12)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.MARCH, 12, 2018, Month.MARCH, 18)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2019, Month.FEBRUARY, 4, 2019, Month.FEBRUARY, 10)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2020, Month.FEBRUARY, 10, 2020, Month.FEBRUARY, 16)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_denmark(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 5)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 24, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.maundyThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.storeBededag())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return types.contains((Object)HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY) && TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday(), MoreTemporalAdjusters.nextDay());
    }

    private static boolean isHoliday_estonia(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 24)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 23)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 24)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 20)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 24)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_faroeIslands(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JULY, 29)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 24, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.maundyThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.storeBededag())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_finland(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 6)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MonthDay.of(Month.JUNE, 19), TemporalAdjusters.next(DayOfWeek.SATURDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, MonthDay.of(Month.OCTOBER, 30), TemporalAdjusters.next(DayOfWeek.SATURDAY))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_france(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            String regionCode;
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JULY, 14)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 11)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
            switch (regionCode = region.atLevel(2).getCode()) {
                case "FR,44,57": 
                case "FR,44,67": 
                case "FR,44,68": {
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_georgia(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.isInRange(temporal, Month.JANUARY, 1, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 7)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 19)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 3)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 9)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 9)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 12)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 28)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 14)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 23)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxGoodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxHolySaturday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_germany(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            String regionCode;
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 3)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2017, Month.OCTOBER, 31)) {
                return true;
            }
            switch (regionCode = region.atLevel(1).getCode()) {
                case "DE,09": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "DE,14": {
                    if (TemporalUtils.is(temporal, Month.OCTOBER, 31)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.bussUndBettag())) break;
                    return true;
                }
                case "DE,16": {
                    if (TemporalUtils.is(temporal, Month.OCTOBER, 31)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "DE,08": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "DE,12": {
                    if (TemporalUtils.is(temporal, Month.OCTOBER, 31)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) break;
                    return true;
                }
                case "DE,06": {
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "DE,13": {
                    if (!TemporalUtils.is(temporal, Month.OCTOBER, 31)) break;
                    return true;
                }
                case "DE,05": 
                case "DE,07": {
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "DE,10": {
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "DE,15": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, Month.OCTOBER, 31)) break;
                    return true;
                }
            }
        }
        if (types.contains((Object)HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY)) {
            if (TemporalUtils.is(temporal, Month.DECEMBER, 24)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 31)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_greenland(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 21)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 24, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.maundyThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.storeBededag())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_guernsey(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            String regionCode;
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 2) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            switch (regionCode = region.atLevel(1).getCode()) {
                case "GG,2": {
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 15)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) break;
                    return true;
                }
                case "GG,1": 
                case "GG,3": {
                    if (TemporalUtils.is(temporal, Month.MAY, 9)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_hungary(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 20)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 23)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday()) && temporal.get(ChronoField.YEAR) >= 2017) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_iceland(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 17)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.maundyThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MonthDay.of(Month.APRIL, 18), TemporalAdjusters.next(DayOfWeek.THURSDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_isleOfMan(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 2) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JULY, 5)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JULY, 6) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JULY, 5)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JULY, 7) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JULY, 5)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, MonthDay.of(Month.JUNE, 5), TemporalAdjusters.next(DayOfWeek.FRIDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_italy(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            String regionCode;
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            switch (regionCode = region.atLevel(1).getCode()) {
                case "IT,04": {
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_jersey(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 2) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 9)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_latvia(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 4)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.JUNE, 23, Month.JUNE, 24)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 18)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 24, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_liechtenstein(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.SEPTEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) {
                return true;
            }
        }
        if (types.contains((Object)HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 24)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.shroveTuesday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_malta(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 10)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 7)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 29)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.SEPTEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.SEPTEMBER, 21)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 13)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
        }
        if (types.contains((Object)HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY)) {
            if (TemporalUtils.is(temporal, Month.MARCH, 28)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_moldova(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.JANUARY, 7, Month.JANUARY, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 9)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 27)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.pastileBlajinilor())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_netherlands(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 26) && TemporalUtils.is(temporal.with(MonthDay.of(Month.APRIL, 27)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 27) && !TemporalUtils.is(temporal, DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 5) && temporal.get(ChronoField.YEAR) % 5 == 0) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return types.contains((Object)HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY) && TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday());
    }

    private static boolean isHoliday_norway(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 17)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.maundyThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_poland(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 3)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 11)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_portugal(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            String regionCode;
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 10)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.shroveTuesday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            switch (regionCode = region.atLevel(1).getCode()) {
                case "PT,30": {
                    if (!TemporalUtils.is(temporal, Month.JULY, 1)) break;
                    return true;
                }
                case "PT,20": {
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_republicOfIreland(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 17)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.JUNE, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.OCTOBER, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_romania(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 24)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.NOVEMBER, 30, Month.DECEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxWhitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxWhitMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_serbia(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 2)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 7)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 16)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 17) && TemporalUtils.is(temporal.with(MonthDay.of(Month.FEBRUARY, 15)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 17) && TemporalUtils.is(temporal.with(MonthDay.of(Month.FEBRUARY, 16)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.MAY, 1)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.MAY, 2)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 11)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 12) && TemporalUtils.is(temporal.with(MonthDay.of(Month.NOVEMBER, 11)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxGoodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.orthodoxEasterMonday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_slovakia(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JULY, 5)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 29)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.SEPTEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.SEPTEMBER, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 17)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 24, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
        }
        if (types.contains((Object)HolidayType.SCHOOLS_ONLY)) {
            String regionCode;
            if (TemporalUtils.isInRange(temporal, 2014, Month.JANUARY, 1, 2014, Month.JANUARY, 7)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2014, Month.FEBRUARY, 3)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2014, Month.APRIL, 17, 2014, Month.APRIL, 22)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2014, Month.JUNE, 30, 2014, Month.AUGUST, 29)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2014, Month.OCTOBER, 30, 2014, Month.OCTOBER, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2014, Month.DECEMBER, 22, 2015, Month.JANUARY, 7)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2015, Month.FEBRUARY, 2)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.APRIL, 2, 2015, Month.APRIL, 7)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.JULY, 1, 2015, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.OCTOBER, 29, 2015, Month.OCTOBER, 30)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2015, Month.DECEMBER, 23, 2016, Month.JANUARY, 7)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2016, Month.FEBRUARY, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.MARCH, 24, 2016, Month.MARCH, 29)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.JULY, 1, 2016, Month.SEPTEMBER, 2)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.OCTOBER, 28, 2016, Month.OCTOBER, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2016, Month.DECEMBER, 23, 2017, Month.JANUARY, 5)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2017, Month.FEBRUARY, 3)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2017, Month.APRIL, 13, 2017, Month.APRIL, 18)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2017, Month.JULY, 3, 2017, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2017, Month.OCTOBER, 30, 2017, Month.OCTOBER, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2017, Month.DECEMBER, 23, 2018, Month.JANUARY, 5)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2018, Month.FEBRUARY, 2)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2018, Month.MARCH, 29, 2018, Month.APRIL, 3)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2018, Month.JULY, 2, 2018, Month.AUGUST, 31)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2018, Month.OCTOBER, 31, 2018, Month.NOVEMBER, 2)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2018, Month.DECEMBER, 22, 2019, Month.JANUARY, 7)) {
                return true;
            }
            if (TemporalUtils.is(temporal, 2019, Month.FEBRUARY, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2019, Month.APRIL, 18, 2019, Month.APRIL, 23)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, 2019, Month.JULY, 1, 2019, Month.AUGUST, 31)) {
                return true;
            }
            switch (regionCode = region.atLevel(1).getCode()) {
                case "SK,06": 
                case "SK,05": 
                case "SK,03": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.FEBRUARY, 17, 2014, Month.FEBRUARY, 21)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.FEBRUARY, 16, 2015, Month.FEBRUARY, 20)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 29, 2016, Month.MARCH, 4)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.FEBRUARY, 27, 2017, Month.MARCH, 3)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.FEBRUARY, 19, 2018, Month.FEBRUARY, 23)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2019, Month.MARCH, 4, 2018, Month.MARCH, 9)) break;
                    return true;
                }
                case "SK,01": 
                case "SK,04": 
                case "SK,02": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.FEBRUARY, 24, 2014, Month.FEBRUARY, 28)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.MARCH, 2, 2015, Month.MARCH, 6)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 22, 2016, Month.FEBRUARY, 26)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.FEBRUARY, 20, 2017, Month.FEBRUARY, 24)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.MARCH, 5, 2018, Month.MARCH, 9)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2019, Month.FEBRUARY, 25, 2018, Month.MARCH, 1)) break;
                    return true;
                }
                case "SK,08": 
                case "SK,07": {
                    if (TemporalUtils.isInRange(temporal, 2014, Month.MARCH, 3, 2014, Month.MARCH, 7)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2015, Month.FEBRUARY, 23, 2015, Month.FEBRUARY, 27)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2016, Month.FEBRUARY, 15, 2016, Month.FEBRUARY, 19)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2017, Month.MARCH, 6, 2017, Month.MARCH, 10)) {
                        return true;
                    }
                    if (TemporalUtils.isInRange(temporal, 2018, Month.FEBRUARY, 26, 2018, Month.MARCH, 2)) {
                        return true;
                    }
                    if (!TemporalUtils.isInRange(temporal, 2019, Month.FEBRUARY, 18, 2018, Month.FEBRUARY, 22)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_slovenia(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 8)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 27)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.MAY, 1, Month.MAY, 2)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.OCTOBER, 31)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_sweden(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 6)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MonthDay.of(Month.JUNE, 19), TemporalAdjusters.next(DayOfWeek.SATURDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, MonthDay.of(Month.OCTOBER, 30), TemporalAdjusters.next(DayOfWeek.SATURDAY))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isHoliday_switzerland(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        String regionCode;
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.ascensionThursday())) {
                return true;
            }
            switch (regionCode = region.atLevel(1).getCode()) {
                case "CH,22": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, Month.SEPTEMBER, TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.SUNDAY), TemporalAdjusters.next(DayOfWeek.MONDAY))) break;
                    return true;
                }
                case "CH,23": {
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,10": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,19": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,15": {
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,16": {
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.SEPTEMBER, 22)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,13": {
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,12": {
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,02": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,08": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.APRIL, TemporalAdjusters.firstInMonth(DayOfWeek.THURSDAY))) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,18": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JUNE, 29)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,03": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JUNE, 29)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,07": {
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,06": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.SEPTEMBER, 25)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,17": {
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,14": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,05": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,11": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,20": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,04": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,01": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) break;
                    return true;
                }
                case "CH,09": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,21": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JUNE, 29)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,25": {
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 31)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MonthDay.of(Month.SEPTEMBER, 1), TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY), TemporalAdjusters.next(DayOfWeek.THURSDAY))) break;
                    return true;
                }
                case "CH,24": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
                case "CH,26": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JUNE, 23)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.whitMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, MoreTemporalAdjusters.corpusChristi())) break;
                    return true;
                }
            }
        }
        if (types.contains((Object)HolidayType.BANKS_AND_FINANCIAL_INSTITUTIONS_ONLY)) {
            switch (regionCode = region.atLevel(1).getCode()) {
                case "CH,23": {
                    if (!TemporalUtils.is(temporal, Month.SEPTEMBER, TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.SUNDAY), TemporalAdjusters.next(DayOfWeek.MONDAY))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_unitedKingdom(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            String regionCode;
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 2) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 1)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 25)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 27) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 25)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SATURDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 28) && TemporalUtils.is(temporal.with(MonthDay.of(Month.DECEMBER, 26)), DayOfWeek.SUNDAY)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.goodFriday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            if (TemporalUtils.is(temporal, (TemporalAdjuster)Month.MAY, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) {
                return true;
            }
            switch (regionCode = region.atLevel(1).getCode()) {
                case "GB,E": 
                case "GB,W": {
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) break;
                    return true;
                }
                case "GB,N": {
                    if (TemporalUtils.is(temporal, Month.MARCH, 17)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 18) && TemporalUtils.is(temporal.with(MonthDay.of(Month.MARCH, 17)), DayOfWeek.SUNDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.MARCH, 19) && TemporalUtils.is(temporal.with(MonthDay.of(Month.MARCH, 17)), DayOfWeek.SATURDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JULY, 12)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JULY, 13) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JULY, 12)), DayOfWeek.SUNDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JULY, 14) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JULY, 12)), DayOfWeek.SATURDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY))) break;
                    return true;
                }
                case "GB,S": {
                    if (TemporalUtils.is(temporal, Month.JANUARY, 2)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JANUARY, 3) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 2)), DayOfWeek.MONDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JANUARY, 4) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 2)), DayOfWeek.SUNDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.JANUARY, 4) && TemporalUtils.is(temporal.with(MonthDay.of(Month.JANUARY, 2)), DayOfWeek.SATURDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.NOVEMBER, 30)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 1) && TemporalUtils.is(temporal.with(MonthDay.of(Month.NOVEMBER, 30)), DayOfWeek.SUNDAY)) {
                        return true;
                    }
                    if (TemporalUtils.is(temporal, Month.DECEMBER, 2) && TemporalUtils.is(temporal.with(MonthDay.of(Month.NOVEMBER, 30)), DayOfWeek.SATURDAY)) {
                        return true;
                    }
                    if (!TemporalUtils.is(temporal, (TemporalAdjuster)Month.AUGUST, TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHoliday_vaticanCity(Temporal temporal, GeoRegion region, Set<HolidayType> types) {
        if (types.contains((Object)HolidayType.PUBLIC)) {
            if (TemporalUtils.is(temporal, Month.JANUARY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JANUARY, 6)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.FEBRUARY, 11)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 13)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MARCH, 19)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.APRIL, 23)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.MAY, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.JUNE, 29)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 14)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.AUGUST, 15)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.NOVEMBER, 1)) {
                return true;
            }
            if (TemporalUtils.is(temporal, Month.DECEMBER, 8)) {
                return true;
            }
            if (TemporalUtils.isInRange(temporal, Month.DECEMBER, 25, Month.DECEMBER, 26)) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterSunday())) {
                return true;
            }
            if (TemporalUtils.is(temporal, MoreTemporalAdjusters.easterMonday())) {
                return true;
            }
        }
        return false;
    }
}

