/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time;

import java.time.Month;
import java.util.Objects;

public class JulianLocalDate {
    private final int dayOfMonth;
    private final Month month;
    private final int year;

    private JulianLocalDate(int year, Month month, int dayOfMonth) {
        this.year = year;
        this.month = month;
        this.dayOfMonth = dayOfMonth;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof JulianLocalDate) {
            JulianLocalDate otherCast = (JulianLocalDate)other;
            return Objects.equals(this.getYear(), otherCast.getYear()) && Objects.equals(this.getMonth(), otherCast.getMonth()) && Objects.equals(this.getDayOfMonth(), otherCast.getDayOfMonth());
        }
        return false;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Month getMonth() {
        return this.month;
    }

    public int getMonthValue() {
        return this.month.getValue();
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.dayOfMonth);
    }

    public static JulianLocalDate of(int year, int month, int dayOfMonth) {
        return new JulianLocalDate(year, Month.of(month), dayOfMonth);
    }

    public static JulianLocalDate of(int year, Month month, int dayOfMonth) {
        return new JulianLocalDate(year, month, dayOfMonth);
    }
}

