/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.DayOfWeek;
import java.time.MonthDay;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class DayOfWeekBeforeMonthDayApplicability
extends TemporalApplicability {
    private final DayOfWeek dayOfWeek;
    private final MonthDay monthDay;
    private final int ordinal;

    public DayOfWeekBeforeMonthDayApplicability(int ordinal, DayOfWeek dayOfWeek, MonthDay monthDay) {
        Contract.checkArgument(ordinal > 0, "Ordinal must be positive: {0}", ordinal);
        Contract.checkArgument(dayOfWeek != null, "Day of week must not be null", new Object[0]);
        Contract.checkArgument(monthDay != null, "Month-day must not be null", new Object[0]);
        this.ordinal = ordinal;
        this.dayOfWeek = dayOfWeek;
        this.monthDay = monthDay;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        Temporal targetTemporal = temporal.with(this.monthDay).with(TemporalAdjusters.previous(this.dayOfWeek)).minus(this.ordinal - 1, ChronoUnit.WEEKS);
        return temporal.equals(targetTemporal);
    }
}

