/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.temporal.Temporal;
import java.util.EnumSet;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.HolidayType;
import org.sellcom.geotemporal.time.Temporals;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicability;

public class HolidayApplicability
extends GeoTemporalApplicability {
    private final EnumSet<HolidayType> types;

    public HolidayApplicability(EnumSet<HolidayType> types) {
        Contract.checkArgument(types != null, "Holiday types must not be null", new Object[0]);
        this.types = types;
    }

    @Override
    public boolean test(Temporal temporal, GeoRegion region) {
        return Temporals.isHoliday(temporal, region, this.types);
    }
}

