/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.MonthDay;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.MonthDays;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class RangeOfMonthDaysApplicability
extends TemporalApplicability {
    private final MonthDay endMonthDay;
    private final MonthDay startMonthDay;

    public RangeOfMonthDaysApplicability(MonthDay startMonthDay, MonthDay endMonthDay) {
        Contract.checkArgument(startMonthDay != null, "Start month-day must not be null", new Object[0]);
        Contract.checkArgument(endMonthDay != null, "End month-day must not be null", new Object[0]);
        this.startMonthDay = startMonthDay;
        this.endMonthDay = endMonthDay;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return MonthDays.isInRange(MonthDay.from(temporal), this.startMonthDay, this.endMonthDay);
    }
}

