/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.Month;
import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.Months;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public final class RangeOfMonthsApplicability
extends TemporalApplicability {
    private final Month endMonth;
    private final Month startMonth;

    public RangeOfMonthsApplicability(Month startMonth, Month endMonth) {
        Contract.checkArgument(startMonth != null, "Start month must not be null", new Object[0]);
        Contract.checkArgument(endMonth != null, "End month must not be null", new Object[0]);
        this.startMonth = startMonth;
        this.endMonth = endMonth;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return Months.isInRange(Month.from(temporal), this.startMonth, this.endMonth);
    }
}

