/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.temporal.Temporal;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.Temporals;
import org.sellcom.geotemporal.time.applicability.TemporalApplicability;

public class SingleIsoWeekNumberApplicability
extends TemporalApplicability {
    private final int isoWeekNumber;

    public SingleIsoWeekNumberApplicability(int isoWeekNumber) {
        Contract.checkArgument(isoWeekNumber >= 1, "ISO week number must be positive: {0}", isoWeekNumber);
        Contract.checkArgument(isoWeekNumber <= 53, "ISO week number must be at most 53: {0}", isoWeekNumber);
        this.isoWeekNumber = isoWeekNumber;
    }

    @Override
    public boolean test(Temporal temporal) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        return Temporals.getIsoWeekNumber(temporal) == this.isoWeekNumber;
    }
}

