/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicability;

public final class UnionOfTemporalApplicabilities
extends GeoTemporalApplicability {
    private final List<GeoTemporalApplicability> applicabilities = new ArrayList<GeoTemporalApplicability>();

    public void add(GeoTemporalApplicability applicability) {
        Contract.checkArgument(applicability != null, "Applicability must not be null", new Object[0]);
        this.applicabilities.add(applicability);
    }

    @Override
    public boolean test(Temporal temporal, GeoRegion region) {
        Contract.checkArgument(temporal != null, "Temporal must not be null", new Object[0]);
        Contract.checkArgument(region != null, "Region must not be null", new Object[0]);
        return this.applicabilities.stream().anyMatch(applicability -> applicability.test(temporal, region));
    }
}

