/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability.parser;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.sellcom.geotemporal.internal.time.applicability.IntersectionOfTemporalApplicabilities;
import org.sellcom.geotemporal.internal.time.applicability.InverseGeoTemporalApplicability;
import org.sellcom.geotemporal.internal.time.applicability.UnionOfTemporalApplicabilities;
import org.sellcom.geotemporal.internal.time.applicability.parser.ParserUtils;
import org.sellcom.geotemporal.internal.time.applicability.parser.Token;
import org.sellcom.geotemporal.internal.time.applicability.parser.TokenType;
import org.sellcom.geotemporal.internal.time.applicability.parser.Tokenizer;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicability;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicabilityParseException;

public class GeoTemporalApplicabilityParser {
    private static final Map<TokenType, InfixParselet> infixParselets = new HashMap<TokenType, InfixParselet>();
    private static final Map<TokenType, PrefixParselet> prefixParselets;

    public GeoTemporalApplicability parse(String expression) {
        Tokenizer tokenizer = new Tokenizer(expression);
        return this.parse(tokenizer, 0);
    }

    private int evaluatePrecedence(Token nextToken) {
        InfixParselet infixParselet = infixParselets.get((Object)nextToken.getType());
        return infixParselet == null ? 0 : infixParselet.getPrecedence();
    }

    private GeoTemporalApplicability parse(Tokenizer tokenizer, int precedence) {
        Token firstToken = tokenizer.pollToken();
        PrefixParselet prefixParselet = prefixParselets.get((Object)firstToken.getType());
        if (prefixParselet == null) {
            throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" could not be parsed", firstToken.getValue()));
        }
        GeoTemporalApplicability result = prefixParselet.parse(this, firstToken, tokenizer);
        while (precedence < this.evaluatePrecedence(tokenizer.peekToken())) {
            Token nextToken = tokenizer.pollToken();
            InfixParselet infixParselet = infixParselets.get((Object)nextToken.getType());
            if (infixParselet == null) {
                throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Token \"{0}\" could not be parsed", nextToken.getValue()));
            }
            result = infixParselet.parse(this, result, nextToken, tokenizer);
        }
        return result;
    }

    static {
        infixParselets.put(TokenType.AND_OPERATOR, new AndOperatorParselet());
        infixParselets.put(TokenType.OR_OPERATOR, new OrOperatorParselet());
        prefixParselets = new HashMap<TokenType, PrefixParselet>();
        prefixParselets.put(TokenType.LEFT_PARENTHESIS, new GroupParselet());
        prefixParselets.put(TokenType.NOT_OPERATOR, new NotOperatorParselet());
        prefixParselets.put(TokenType.RULE, new RuleParselet());
    }

    private static final class RuleParselet
    implements PrefixParselet {
        private RuleParselet() {
        }

        @Override
        public int getPrecedence() {
            return 0;
        }

        @Override
        public GeoTemporalApplicability parse(GeoTemporalApplicabilityParser parser, Token token, Tokenizer tokenizer) {
            return ParserUtils.parseLocalDateApplicability(token.getValue());
        }
    }

    private static interface PrefixParselet {
        public int getPrecedence();

        public GeoTemporalApplicability parse(GeoTemporalApplicabilityParser var1, Token var2, Tokenizer var3);
    }

    private static final class OrOperatorParselet
    implements InfixParselet {
        private OrOperatorParselet() {
        }

        @Override
        public int getPrecedence() {
            return 1;
        }

        @Override
        public GeoTemporalApplicability parse(GeoTemporalApplicabilityParser parser, GeoTemporalApplicability leftOperand, Token token, Tokenizer tokenizer) {
            GeoTemporalApplicability rightOperand = parser.parse(tokenizer, this.getPrecedence());
            if (leftOperand instanceof UnionOfTemporalApplicabilities) {
                ((UnionOfTemporalApplicabilities)leftOperand).add(rightOperand);
                return leftOperand;
            }
            UnionOfTemporalApplicabilities result = new UnionOfTemporalApplicabilities();
            result.add(leftOperand);
            result.add(rightOperand);
            return result;
        }
    }

    private static final class NotOperatorParselet
    implements PrefixParselet {
        private NotOperatorParselet() {
        }

        @Override
        public int getPrecedence() {
            return 3;
        }

        @Override
        public GeoTemporalApplicability parse(GeoTemporalApplicabilityParser parser, Token token, Tokenizer tokenizer) {
            return new InverseGeoTemporalApplicability(parser.parse(tokenizer, this.getPrecedence()));
        }
    }

    private static interface InfixParselet {
        public int getPrecedence();

        public GeoTemporalApplicability parse(GeoTemporalApplicabilityParser var1, GeoTemporalApplicability var2, Token var3, Tokenizer var4);
    }

    private static final class GroupParselet
    implements PrefixParselet {
        private GroupParselet() {
        }

        @Override
        public int getPrecedence() {
            return 0;
        }

        @Override
        public GeoTemporalApplicability parse(GeoTemporalApplicabilityParser parser, Token token, Tokenizer tokenizer) {
            GeoTemporalApplicability result = parser.parse(tokenizer, this.getPrecedence());
            tokenizer.discardExpectedToken(TokenType.RIGHT_PARENTHESIS);
            return result;
        }
    }

    private static final class AndOperatorParselet
    implements InfixParselet {
        private AndOperatorParselet() {
        }

        @Override
        public int getPrecedence() {
            return 2;
        }

        @Override
        public GeoTemporalApplicability parse(GeoTemporalApplicabilityParser parser, GeoTemporalApplicability leftOperand, Token token, Tokenizer tokenizer) {
            GeoTemporalApplicability rightOperand = parser.parse(tokenizer, this.getPrecedence());
            if (leftOperand instanceof IntersectionOfTemporalApplicabilities) {
                ((IntersectionOfTemporalApplicabilities)leftOperand).add(rightOperand);
                return leftOperand;
            }
            IntersectionOfTemporalApplicabilities result = new IntersectionOfTemporalApplicabilities();
            result.add(leftOperand);
            result.add(rightOperand);
            return result;
        }
    }
}

