/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.internal.time.applicability.parser;

import java.text.MessageFormat;
import org.sellcom.geotemporal.internal.time.applicability.parser.MatcherUtils;
import org.sellcom.geotemporal.internal.time.applicability.parser.Token;
import org.sellcom.geotemporal.internal.time.applicability.parser.TokenType;
import org.sellcom.geotemporal.time.applicability.GeoTemporalApplicabilityParseException;

class Tokenizer {
    private static final String AND_OPERATOR = "AND";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String NOT_OPERATOR = "NOT";
    private static final String OR_OPERATOR = "OR";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String SPACE = " ";
    private final String expression;
    private int index = 0;
    private Token token;

    Tokenizer(String expression) {
        this.expression = expression;
        this.token = this.prepareNextToken();
    }

    void discardExpectedToken(TokenType expectedType) {
        if (this.token.getType() != expectedType) {
            throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Expected {0} but found {1} instead", new Object[]{expectedType, this.token.getType()}));
        }
        this.token = this.prepareNextToken();
    }

    Token peekToken() {
        return this.token;
    }

    Token pollToken() {
        try {
            Token token = this.token;
            return token;
        }
        finally {
            this.token = this.prepareNextToken();
        }
    }

    private Token prepareNextToken() {
        while (this.index < this.expression.length()) {
            if (MatcherUtils.matchPrefix(this.expression, this.index, LEFT_PARENTHESIS)) {
                this.index += LEFT_PARENTHESIS.length();
                return new Token(TokenType.LEFT_PARENTHESIS, "");
            }
            if (MatcherUtils.matchPrefix(this.expression, this.index, RIGHT_PARENTHESIS)) {
                this.index += RIGHT_PARENTHESIS.length();
                return new Token(TokenType.RIGHT_PARENTHESIS, "");
            }
            if (MatcherUtils.matchPrefix(this.expression, this.index, SPACE)) {
                this.index += SPACE.length();
                continue;
            }
            if (MatcherUtils.matchPrefix(this.expression, this.index, AND_OPERATOR)) {
                this.index += AND_OPERATOR.length();
                if (Character.isLetterOrDigit(this.expression.charAt(this.index))) {
                    throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Expression \"{0}\" could not be parsed at index %d", this.expression, this.index));
                }
                return new Token(TokenType.AND_OPERATOR, "");
            }
            if (MatcherUtils.matchPrefix(this.expression, this.index, NOT_OPERATOR)) {
                this.index += NOT_OPERATOR.length();
                if (Character.isLetterOrDigit(this.expression.charAt(this.index))) {
                    throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Expression \"{0}\" could not be parsed at index %d", this.expression, this.index));
                }
                return new Token(TokenType.NOT_OPERATOR, "");
            }
            if (MatcherUtils.matchPrefix(this.expression, this.index, OR_OPERATOR)) {
                this.index += OR_OPERATOR.length();
                if (Character.isLetterOrDigit(this.expression.charAt(this.index))) {
                    throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Expression \"{0}\" could not be parsed at index %d", this.expression, this.index));
                }
                return new Token(TokenType.OR_OPERATOR, "");
            }
            if (MatcherUtils.matchRuleCharacter(this.expression, this.index)) {
                int startIndex = this.index++;
                while (this.index < this.expression.length() && MatcherUtils.matchRuleCharacter(this.expression, this.index)) {
                    ++this.index;
                }
                int endIndex = this.index;
                String rule = this.expression.substring(startIndex, endIndex);
                return new Token(TokenType.RULE, rule);
            }
            throw new GeoTemporalApplicabilityParseException(MessageFormat.format("Expression \"{0}\" could not be parsed at index %d", this.expression, this.index));
        }
        return new Token(TokenType.END_OF_EXPRESSION, "");
    }
}

