/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time;

import java.time.LocalDate;
import org.sellcom.geotemporal.internal.Contract;

public class LocalDates {
    private LocalDates() {
    }

    public static boolean isInRange(LocalDate date, LocalDate startDate, LocalDate endDate) {
        Contract.checkArgument(date != null, "Date must not be null", new Object[0]);
        Contract.checkArgument(startDate != null, "Start date must not be null", new Object[0]);
        Contract.checkArgument(endDate != null, "End date must not be null", new Object[0]);
        if (startDate.isAfter(endDate)) {
            return !date.isBefore(endDate) && !date.isAfter(startDate);
        }
        return !date.isBefore(startDate) && !date.isAfter(endDate);
    }
}

