/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time;

import java.time.LocalTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.internal.StringUtils;

public class LocalTimes {
    private static final Pattern END_OF_THE_DAY_PATTERN = Pattern.compile("24:00(:00)?(\\.0{1,9})?");

    private LocalTimes() {
    }

    public static boolean isInRange(LocalTime time, LocalTime startTime, LocalTime endTime) {
        Contract.checkArgument(time != null, "Time not be null", new Object[0]);
        Contract.checkArgument(startTime != null, "Start time must not be null", new Object[0]);
        Contract.checkArgument(endTime != null, "End time must not be null", new Object[0]);
        if (startTime.isAfter(endTime)) {
            return !time.isBefore(startTime) || !time.isAfter(endTime);
        }
        return !time.isBefore(startTime) && !time.isAfter(endTime);
    }

    public static LocalTime parse(String time) {
        Contract.checkArgument(!StringUtils.isNullOrEmpty(time), "Time must not be null or empty", new Object[0]);
        Matcher matcher = END_OF_THE_DAY_PATTERN.matcher(time);
        return matcher.matches() ? LocalTime.MAX : LocalTime.parse(time);
    }

    public static String toString(LocalTime time) {
        Contract.checkArgument(time != null, "Time not be null", new Object[0]);
        return time.equals(LocalTime.MAX) ? "24:00" : time.toString();
    }
}

