/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time;

import java.time.Month;
import java.time.MonthDay;
import org.sellcom.geotemporal.internal.Contract;

public class MonthDays {
    private MonthDays() {
    }

    public static boolean isInRange(MonthDay monthDay, MonthDay startMonthDay, MonthDay endMonthDay) {
        Contract.checkArgument(monthDay != null, "Month-day must not be null", new Object[0]);
        Contract.checkArgument(startMonthDay != null, "Start month-day must not be null", new Object[0]);
        Contract.checkArgument(endMonthDay != null, "End month-day must not be null", new Object[0]);
        if (startMonthDay.isAfter(endMonthDay)) {
            return !monthDay.isBefore(startMonthDay) || !monthDay.isAfter(endMonthDay);
        }
        return !monthDay.isBefore(startMonthDay) && !monthDay.isAfter(endMonthDay);
    }

    public static MonthDay next(MonthDay monthDay) {
        Contract.checkArgument(monthDay != null, "MonthDay must not be null", new Object[0]);
        Month month = monthDay.getMonth();
        int dayOfMonth = monthDay.getDayOfMonth();
        if (dayOfMonth == month.maxLength()) {
            month = month.plus(1L);
            return MonthDay.of(month, 1);
        }
        return MonthDay.of(month, dayOfMonth + 1);
    }

    public static MonthDay previous(MonthDay monthDay) {
        Contract.checkArgument(monthDay != null, "MonthDay must not be null", new Object[0]);
        Month month = monthDay.getMonth();
        int dayOfMonth = monthDay.getDayOfMonth();
        if (dayOfMonth == 1) {
            month = month.minus(1L);
            return MonthDay.of(month, month.maxLength());
        }
        return MonthDay.of(month, dayOfMonth - 1);
    }

    static boolean is(MonthDay monthDay, Month month, int dayOfMonth) {
        return monthDay.getMonth() == month && monthDay.getDayOfMonth() == dayOfMonth;
    }
}

