/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.geotemporal.time.applicability;

import java.time.temporal.Temporal;
import java.util.EnumSet;
import org.sellcom.geotemporal.geography.GeoRegion;
import org.sellcom.geotemporal.internal.Contract;
import org.sellcom.geotemporal.internal.StringUtils;
import org.sellcom.geotemporal.internal.time.applicability.HolidayApplicability;
import org.sellcom.geotemporal.internal.time.applicability.WeekendApplicability;
import org.sellcom.geotemporal.internal.time.applicability.WorkingDayApplicability;
import org.sellcom.geotemporal.internal.time.applicability.parser.GeoTemporalApplicabilityParser;
import org.sellcom.geotemporal.time.GeoTemporalPredicate;
import org.sellcom.geotemporal.time.HolidayType;

public abstract class GeoTemporalApplicability
implements GeoTemporalPredicate {
    private static final GeoTemporalApplicabilityParser parser = new GeoTemporalApplicabilityParser();

    public static GeoTemporalApplicability holiday(EnumSet<HolidayType> types) {
        return new HolidayApplicability(types);
    }

    public static GeoTemporalApplicability parse(String expression) {
        Contract.checkArgument(!StringUtils.isNullOrEmpty(expression), "Expression must not be null or empty", new Object[0]);
        return parser.parse(expression);
    }

    public static GeoTemporalApplicability publicHoliday() {
        return new HolidayApplicability(EnumSet.of(HolidayType.PUBLIC));
    }

    public static GeoTemporalApplicability schoolHoliday() {
        return new HolidayApplicability(EnumSet.of(HolidayType.SCHOOLS_AND_UNIVERSITIES_ONLY, HolidayType.SCHOOLS_ONLY));
    }

    @Override
    public abstract boolean test(Temporal var1, GeoRegion var2);

    public static GeoTemporalApplicability weekend() {
        return new WeekendApplicability();
    }

    public static GeoTemporalApplicability workingDay() {
        return new WorkingDayApplicability();
    }
}

