/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.io.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class Utf8BomCharset
extends Charset {
    private static final String[] ALIASES = new String[0];
    private static final String CANONICAL_NAME = "UTF-8BOM";

    protected Utf8BomCharset() {
        super(CANONICAL_NAME, ALIASES);
    }

    @Override
    public boolean contains(Charset charset) {
        return StandardCharsets.UTF_8.contains(charset);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this, StandardCharsets.UTF_8.newDecoder());
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this, StandardCharsets.UTF_8.newEncoder());
    }

    private static class Encoder
    extends CharsetEncoder {
        private final CharsetEncoder charsetEncoder;
        private boolean needsByteOrderMark = true;

        protected Encoder(Charset charset, CharsetEncoder charsetEncoder) {
            super(charset, charsetEncoder.averageBytesPerChar(), charsetEncoder.maxBytesPerChar());
            this.charsetEncoder = charsetEncoder;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer destination) {
            if (this.needsByteOrderMark) {
                if (destination.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                destination.put((byte)-17);
                destination.put((byte)-69);
                destination.put((byte)-65);
                this.needsByteOrderMark = false;
            }
            return this.charsetEncoder.encode(source, destination, false);
        }

        @Override
        protected void implReset() {
            this.charsetEncoder.reset();
            this.needsByteOrderMark = true;
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private final CharsetDecoder charsetDecoder;
        private boolean needsByteOrderMark = true;

        protected Decoder(Charset charset, CharsetDecoder charsetDecoder) {
            super(charset, charsetDecoder.averageCharsPerByte(), charsetDecoder.maxCharsPerByte());
            this.charsetDecoder = charsetDecoder;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer destination) {
            if (this.needsByteOrderMark) {
                if (source.remaining() < 3) {
                    return CoderResult.UNDERFLOW;
                }
                if (source.get() != -17) {
                    source.position(source.position() - 1);
                    return CoderResult.malformedForLength(3);
                }
                if (source.get() != -69) {
                    source.position(source.position() - 1);
                    return CoderResult.malformedForLength(2);
                }
                if (source.get() != -65) {
                    source.position(source.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                this.needsByteOrderMark = false;
            }
            return this.charsetDecoder.decode(source, destination, false);
        }

        @Override
        protected void implReset() {
            this.charsetDecoder.reset();
            this.needsByteOrderMark = true;
        }
    }
}

