/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.net;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.sellcom.core.Contract;
import org.sellcom.core.Threads;
import org.sellcom.core.internal.collection.concurrent.SimpleDelayed;
import org.sellcom.core.io.Io;
import org.sellcom.core.net.NetworkEndPoint;
import org.sellcom.core.net.NetworkMessage;
import org.sellcom.core.net.NetworkReceiver;
import org.sellcom.core.net.NetworkSender;
import org.sellcom.core.net.TrafficClass;

public class DatagramSenderAndReceiver
implements NetworkReceiver,
NetworkSender {
    private static final int DEFAULT_HANDLER_THREAD_PRIORITY = 5;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 8192;
    private static final int DEFAULT_RECEIVER_THREAD_PRIORITY = 5;
    private static final int DEFAULT_SEND_BUFFER_SIZE = 8192;
    private static final int DEFAULT_SENDER_THREAD_PRIORITY = 5;
    private DatagramChannel channel;
    private final Map<InetAddress, MembershipKey> groups = new HashMap<InetAddress, MembershipKey>();
    private ExecutorService handlerExecutor;
    private int handlerThreadPriority = 5;
    private int handlerThreads = 1;
    private InetSocketAddress localEndPoint = new InetSocketAddress(0);
    private Consumer<NetworkMessage> messageConsumer;
    private NetworkInterface networkInterface;
    private final BlockingQueue<NetworkMessage> pendingIncomingMessages = new LinkedBlockingQueue<NetworkMessage>();
    private final DelayQueue<DelayedNetworkMessage> pendingOutgoingMessages = new DelayQueue();
    private final ProtocolFamily protocolFamily;
    private int receiveBufferSize = 8192;
    private ExecutorService receiverExecutor;
    private int receiverThreadPriority = 5;
    private int receiverThreads = 1;
    private int sendBufferSize = 8192;
    private int sendRepeatCount = 0;
    private int sendRepeatInterval = 100;
    private ExecutorService senderExecutor;
    private int senderThreadPriority = 5;
    private int senderThreads = 1;
    private volatile NetworkEndPoint.State state = NetworkEndPoint.State.STOPPED;
    private int timeToLive = 16;
    private TrafficClass trafficClass = TrafficClass.NORMAL_SERVICE;

    private DatagramSenderAndReceiver(ProtocolFamily protocolFamily) {
        this.protocolFamily = protocolFamily;
    }

    public static DatagramSenderAndReceiver create(ProtocolFamily protocolFamily) {
        Contract.checkArgument(protocolFamily != null, "Protocol family must not be null", new Object[0]);
        return new DatagramSenderAndReceiver(protocolFamily);
    }

    public Set<InetAddress> getGroups() {
        return this.groups.keySet();
    }

    public int getHandlerThreadPriority() {
        return this.handlerThreadPriority;
    }

    public int getHandlerThreads() {
        return this.handlerThreads;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.localEndPoint.getAddress();
    }

    @Override
    public InetSocketAddress getLocalEndPoint() {
        return this.localEndPoint;
    }

    @Override
    public int getLocalPort() {
        return this.localEndPoint.getPort();
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getReceiverThreadPriority() {
        return this.receiverThreadPriority;
    }

    public int getReceiverThreads() {
        return this.receiverThreads;
    }

    @Override
    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getSendRepeatCount() {
        return this.sendRepeatCount;
    }

    public long getSendRepeatInterval() {
        return this.sendRepeatInterval;
    }

    public int getSenderThreadPriority() {
        return this.senderThreadPriority;
    }

    public int getSenderThreads() {
        return this.senderThreads;
    }

    @Override
    public NetworkEndPoint.State getState() {
        return this.state;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public TrafficClass getTrafficClass() {
        return this.trafficClass;
    }

    @Override
    public void sendDelayed(NetworkMessage message, long initialDelay, TimeUnit unit) {
        Contract.checkState(this.state == NetworkEndPoint.State.STARTED || this.state == NetworkEndPoint.State.STOPPING, "Sender has not yet been started", new Object[0]);
        Contract.checkArgument(message != null, "Message must not be null", new Object[0]);
        Contract.checkArgument(message.getRemoteEndPoint() != null, "Message's remote end point must not be null", new Object[0]);
        Contract.checkArgument(message.getUuid() != null, "Message's UUID must not be null", new Object[0]);
        Contract.checkArgument(initialDelay >= 0L, "Initial delay must not be negative", new Object[0]);
        Contract.checkArgument(unit != null, "Unit must not be null", new Object[0]);
        int j = this.sendRepeatCount;
        for (int i = 0; i <= j; ++i) {
            this.pendingOutgoingMessages.offer(new DelayedNetworkMessage(message, Math.addExact(unit.toMillis(initialDelay), (long)Math.multiplyExact(i, this.sendRepeatInterval))));
        }
    }

    @Override
    public void sendImmediately(NetworkMessage message) {
        Contract.checkState(this.state == NetworkEndPoint.State.STARTED || this.state == NetworkEndPoint.State.STOPPING, "Sender has not yet been started", new Object[0]);
        Contract.checkArgument(message != null, "Message must not be null", new Object[0]);
        Contract.checkArgument(message.getRemoteEndPoint() != null, "Message's remote end point must not be null", new Object[0]);
        Contract.checkArgument(message.getUuid() != null, "Message's UUID must not be null", new Object[0]);
        int j = this.sendRepeatCount;
        for (int i = 0; i <= j; ++i) {
            this.pendingOutgoingMessages.offer(new DelayedNetworkMessage(message, Math.multiplyExact(i, this.sendRepeatInterval)));
        }
    }

    @Override
    public void start() throws IOException {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        this.state = NetworkEndPoint.State.STARTING;
        try {
            this.createChannel();
            this.startBackgroundThreads();
        }
        catch (IOException e) {
            this.state = NetworkEndPoint.State.STARTED;
            this.stop();
        }
        this.state = NetworkEndPoint.State.STARTED;
    }

    @Override
    public void stop() {
        if (this.state == NetworkEndPoint.State.STARTED) {
            this.state = NetworkEndPoint.State.STOPPING;
            this.stopBackgroundThreads();
            this.clearQueues();
            this.destroyChannel();
            this.state = NetworkEndPoint.State.STOPPED;
        }
    }

    public DatagramSenderAndReceiver withHandlerThreadPriority(int threadPriority) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(threadPriority >= 1 && threadPriority <= 10, "Thread priority must be valid: {0}", threadPriority);
        this.handlerThreadPriority = threadPriority;
        return this;
    }

    public DatagramSenderAndReceiver withGroups(Set<InetAddress> groups) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(groups != null, "Groups must not be null", new Object[0]);
        groups.forEach(group -> {
            MembershipKey cfr_ignored_0 = this.groups.put((InetAddress)group, (MembershipKey)null);
        });
        return this;
    }

    public DatagramSenderAndReceiver withHandlerThreads(int threads) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(threads > 0, "Number of threads must be positive: {0}", threads);
        this.handlerThreads = threads;
        return this;
    }

    public DatagramSenderAndReceiver withLocalAddressAndPort(InetAddress localAddress, int localPort) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(localAddress != null, "Local address must not be null", new Object[0]);
        Contract.checkArgument(localPort >= 0 && localPort <= 65535, "Local port must be valid: {0}", localPort);
        this.localEndPoint = new InetSocketAddress(localAddress, localPort);
        return this;
    }

    public DatagramSenderAndReceiver withLocalPort(int localPort) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(localPort >= 0 && localPort <= 65535, "Local port must be valid: {0}", localPort);
        this.localEndPoint = new InetSocketAddress(localPort);
        return this;
    }

    public DatagramSenderAndReceiver withMessageConsumer(Consumer<NetworkMessage> messageConsumer) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(messageConsumer != null, "Message consumer must not be null", new Object[0]);
        this.messageConsumer = messageConsumer;
        return this;
    }

    public DatagramSenderAndReceiver withMulticast(NetworkInterface networkInterface) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(networkInterface != null, "Network interface must not be null", new Object[0]);
        this.networkInterface = networkInterface;
        return this;
    }

    public DatagramSenderAndReceiver withNetworkInterface(NetworkInterface networkInterface) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(networkInterface != null, "Network interface must not be null", new Object[0]);
        this.networkInterface = networkInterface;
        return this;
    }

    public DatagramSenderAndReceiver withReceiveBufferSize(int bufferSize) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(bufferSize >= 0, "Buffer size must not be negative: {0}", bufferSize);
        this.receiveBufferSize = bufferSize;
        return this;
    }

    public DatagramSenderAndReceiver withReceiverThreadPriority(int threadPriority) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(threadPriority >= 1 && threadPriority <= 10, "Thread priority must be valid: {0}", threadPriority);
        this.receiverThreadPriority = threadPriority;
        return this;
    }

    public DatagramSenderAndReceiver withReceiverThreads(int threads) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(threads > 0, "Number of threads must be positive: {0}", threads);
        this.receiverThreads = threads;
        return this;
    }

    public DatagramSenderAndReceiver withSendBufferSize(int bufferSize) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(bufferSize >= 0, "Buffer size must not be negative: {0}", bufferSize);
        this.sendBufferSize = bufferSize;
        return this;
    }

    public DatagramSenderAndReceiver withSendRepeatCount(int repeatCount) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(repeatCount >= 0, "Repeat count must not be negative: {0}", repeatCount);
        this.sendRepeatCount = repeatCount;
        return this;
    }

    public DatagramSenderAndReceiver withSendRepeatInterval(int repeatInterval) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(repeatInterval >= 0, "Repeat interval must not be negative: {0}", repeatInterval);
        this.sendRepeatInterval = repeatInterval;
        return this;
    }

    public DatagramSenderAndReceiver withSenderThreadPriority(int threadPriority) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(threadPriority >= 1 && threadPriority <= 10, "Thread priority must be valid: {0}", threadPriority);
        this.senderThreadPriority = threadPriority;
        return this;
    }

    public DatagramSenderAndReceiver withSenderThreads(int threads) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(threads > 0, "Number of threads must be positive: {0}", threads);
        this.senderThreads = threads;
        return this;
    }

    public DatagramSenderAndReceiver withTimeToLive(int timeToLive) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(timeToLive > 0, "Time to live must be positive: {0}", timeToLive);
        this.timeToLive = timeToLive;
        return this;
    }

    public DatagramSenderAndReceiver withTrafficClass(TrafficClass trafficClass) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Sender/receiver has already been started", new Object[0]);
        Contract.checkArgument(trafficClass != null, "Traffic class address must not be null", new Object[0]);
        this.trafficClass = trafficClass;
        return this;
    }

    private void clearQueues() {
        this.pendingIncomingMessages.clear();
        this.pendingOutgoingMessages.clear();
    }

    private void createChannel() throws IOException {
        this.channel = DatagramChannel.open(this.protocolFamily);
        this.channel.configureBlocking(true);
        this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)true);
        this.channel.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)this.trafficClass.getValue());
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)true);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.sendBufferSize);
        if (this.networkInterface != null) {
            this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.networkInterface);
            this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)true);
            this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.timeToLive);
        }
        this.channel.bind(this.localEndPoint);
        for (InetAddress group : this.groups.keySet()) {
            this.groups.put(group, this.channel.join(group, this.networkInterface));
        }
    }

    private Thread createHandlerThread(Runnable handler) {
        Thread thread = new Thread(handler);
        thread.setDaemon(true);
        thread.setName("DatagramSenderAndReceiver.HandlerThread@" + System.identityHashCode(thread));
        thread.setPriority(this.handlerThreadPriority);
        return thread;
    }

    private Thread createReceiverThread(Runnable receiver) {
        Thread thread = new Thread(receiver);
        thread.setDaemon(true);
        thread.setName("DatagramSenderAndReceiver.ReceiverThread@" + System.identityHashCode(thread));
        thread.setPriority(this.receiverThreadPriority);
        return thread;
    }

    private Thread createSenderThread(Runnable sender) {
        Thread thread = new Thread(sender);
        thread.setDaemon(true);
        thread.setName("DatagramSenderAndReceiver.SenderThread@" + System.identityHashCode(thread));
        thread.setPriority(this.senderThreadPriority);
        return thread;
    }

    private void destroyChannel() {
        this.groups.keySet().stream().map(group -> this.groups.put((InetAddress)group, (MembershipKey)null)).filter(((Predicate<MembershipKey>)Objects::isNull).negate()).forEach(MembershipKey::drop);
        Io.close(this.channel);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void startBackgroundThreads() {
        int i;
        this.senderExecutor = Executors.newFixedThreadPool(this.senderThreads, this::createSenderThread);
        for (i = 0; i < this.senderThreads; ++i) {
            this.senderExecutor.submit(new Sender());
        }
        this.handlerExecutor = Executors.newFixedThreadPool(this.handlerThreads, this::createHandlerThread);
        for (i = 0; i < this.handlerThreads; ++i) {
            this.handlerExecutor.submit(new Handler());
        }
        this.receiverExecutor = Executors.newFixedThreadPool(this.receiverThreads, this::createReceiverThread);
        for (i = 0; i < this.receiverThreads; ++i) {
            this.receiverExecutor.submit(new Receiver());
        }
    }

    private void stopBackgroundThreads() {
        this.receiverExecutor.shutdownNow();
        this.handlerExecutor.shutdownNow();
        try {
            this.senderExecutor.shutdown();
            this.senderExecutor.awaitTermination(Math.addExact(1000, Math.multiplyExact(this.sendRepeatCount, this.sendRepeatInterval)), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.senderExecutor.shutdownNow();
            Threads.preserveInterruptedStatus(e);
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    DelayedNetworkMessage message = (DelayedNetworkMessage)DatagramSenderAndReceiver.this.pendingOutgoingMessages.take();
                    DatagramSenderAndReceiver.this.channel.send(message.getByteBuffer(), message.getRemoteEndPoint());
                }
                catch (InterruptedException e) {
                    Threads.preserveInterruptedStatus(e);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class Receiver
    implements Runnable {
        private Receiver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(DatagramSenderAndReceiver.this.receiveBufferSize);
            while (!Thread.interrupted()) {
                try {
                    SocketAddress remoteAddress = DatagramSenderAndReceiver.this.channel.receive(buffer);
                    buffer.flip();
                    if (remoteAddress instanceof InetSocketAddress && DatagramSenderAndReceiver.this.pendingIncomingMessages.offer(NetworkMessage.fromByteBuffer(buffer, (InetSocketAddress)remoteAddress))) {
                        // empty if block
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                buffer.clear();
            }
            return;
        }
    }

    private class Handler
    implements Runnable {
        private Handler() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    DatagramSenderAndReceiver.this.messageConsumer.accept(DatagramSenderAndReceiver.this.pendingIncomingMessages.take());
                }
                catch (InterruptedException e) {
                    Threads.preserveInterruptedStatus(e);
                }
            }
        }
    }

    private static class DelayedNetworkMessage
    extends SimpleDelayed<NetworkMessage> {
        DelayedNetworkMessage(NetworkMessage message, long delay) {
            super(message, delay, TimeUnit.MILLISECONDS);
        }

        ByteBuffer getByteBuffer() {
            return ((NetworkMessage)this.getValue()).toByteBuffer();
        }

        InetSocketAddress getRemoteEndPoint() {
            return ((NetworkMessage)this.getValue()).getRemoteEndPoint();
        }
    }
}

