/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingLongConsumer
extends LongConsumer {
    @Override
    default public void accept(long argument) {
        try {
            this.acceptThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public void acceptThrowing(long var1) throws Exception;

    default public LongConsumer fallbackTo(LongConsumer fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public LongConsumer fallbackTo(LongConsumer fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback consumer must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                fallback.accept(argument);
            }
        };
    }

    default public ThrowingLongConsumer orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingLongConsumer orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingLongConsumer orTryWith(ThrowingLongConsumer other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingLongConsumer orTryWith(ThrowingLongConsumer other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other consumer must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                other.acceptThrowing(argument);
            }
        };
    }
}

