/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.core.i18n;

/**
 * Common special characters.
 *
 * @since 1.1
 */
public class SpecialCharacters {

	/**
	 * Em-width dash.
	 *
	 * @since 1.1
	 */
	public static final char EM_DASH = '\u2014';

	/**
	 * Em-width space.
	 *
	 * @since 1.1
	 */
	public static final char EM_SPACE = '\u2003';

	/**
	 * En-width dash.
	 *
	 * @since 1.1
	 */
	public static final char EN_DASH = '\u2013';

	/**
	 * En-width space.
	 *
	 * @since 1.1
	 */
	public static final char EN_SPACE = '\u2002';

	/**
	 * Figure dash.
	 *
	 * @since 1.1
	 */
	public static final char FIGURE_DASH = '\u2012';

	/**
	 * Figure space.
	 *
	 * @since 1.1
	 */
	public static final char FIGURE_SPACE = '\u2007';

	/**
	 * First strong isolate.
	 *
	 * @since 1.1
	 */
	public static final char FIRST_STRONG_ISOLATE = '\u2068';

	/**
	 * Hair space.
	 *
	 * @since 1.1
	 */
	public static final char HAIR_SPACE = '\u200A';

	/**
	 * Horizontal ellipsis.
	 *
	 * @since 1.1
	 */
	public static final char HORIZONTAL_ELLIPSIS = '\u2026';

	/**
	 * Hyphen.
	 *
	 * @since 1.1
	 */
	public static final char HYPHEN = '\u2010';

	/**
	 * Ideographic space.
	 *
	 * @since 1.1
	 */
	public static final char IDEOGRAPHIC_SPACE = '\u3000';

	/**
	 * Left-to-right embedding.
	 *
	 * @since 1.1
	 */
	public static final char LEFT_TO_RIGHT_EMBEDDING = '\u202A';

	/**
	 * Left-to-right isolate.
	 *
	 * @since 1.1
	 */
	public static final char LEFT_TO_RIGHT_ISOLATE = '\u2066';

	/**
	 * Left-to-right mark.
	 *
	 * @since 1.1
	 */
	public static final char LEFT_TO_RIGHT_MARK = '\u200E';

	/**
	 * Left-to-right override.
	 *
	 * @since 1.1
	 */
	public static final char LEFT_TO_RIGHT_OVERRIDE = '\u202D';

	/**
	 * Narrow non-breaking space.
	 *
	 * @since 1.1
	 */
	public static final char NARROW_NON_BREAKING_SPACE = '\u202F';

	/**
	 * Non-breaking hyphen.
	 *
	 * @since 1.1
	 */
	public static final char NON_BREAKING_HYPHEN = '\u2011';

	/**
	 * Non-breaking space.
	 *
	 * @since 1.1
	 */
	public static final char NON_BREAKING_SPACE = '\u00A0';

	/**
	 * Pop directional formatting.
	 *
	 * @since 1.1
	 */
	public static final char POP_DIRECTIONAL_FORMATTING = '\u202C';

	/**
	 * Pop directional isolate.
	 *
	 * @since 1.1
	 */
	public static final char POP_DIRECTIONAL_ISOLATE = '\u2069';

	/**
	 * Punctuation space.
	 *
	 * @since 1.1
	 */
	public static final char PUNCTUATION_SPACE = '\u2008';

	/**
	 * Right-to-left embedding.
	 *
	 * @since 1.1
	 */
	public static final char RIGHT_TO_LEFT_EMBEDDING = '\u202B';

	/**
	 * Right-to-left isolate.
	 *
	 * @since 1.1
	 */
	public static final char RIGHT_TO_LEFT_ISOLATE = '\u2067';

	/**
	 * Right-to-left mark.
	 *
	 * @since 1.1
	 */
	public static final char RIGHT_TO_LEFT_MARK = '\u200F';

	/**
	 * Right-to-left override.
	 *
	 * @since 1.1
	 */
	public static final char RIGHT_TO_LEFT_OVERRIDE = '\u202E';

	/**
	 * Soft hyphen.
	 *
	 * @since 1.1
	 */
	public static final char SOFT_HYPHEN = '\u00AD';

	/**
	 * Thin space.
	 *
	 * @since 1.1
	 */
	public static final char THIN_SPACE = '\u2009';

	/**
	 * Word joiner.
	 *
	 * @since 1.1
	 */
	public static final char WORD_JOINER = '\u2060';

	/**
	 * Zero-width joiner.
	 *
	 * @since 1.1
	 */
	public static final char ZERO_WIDTH_JOINER = '\u200D';

	/**
	 * Zero-width non-breaking space.
	 *
	 * @since 1.1
	 */
	public static final char ZERO_WIDTH_NON_BREAKING_SPACE = '\uFEFF';

	/**
	 * Zero-width non-joiner.
	 *
	 * @since 1.1
	 */
	public static final char ZERO_WIDTH_NON_JOINER = '\u200C';

	/**
	 * Zero-width space.
	 *
	 * @since 1.1
	 */
	public static final char ZERO_WIDTH_SPACE = '\u200B';


	private SpecialCharacters() {
		// Namespace for constants, not to be instantiated
	}

}
