/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core;

import java.util.Objects;
import java.util.stream.Stream;
import org.sellcom.core.Contract;

public class MoreObjects {
    private MoreObjects() {
    }

    @SafeVarargs
    public static <T> T coalesce(T first, T ... other) {
        if (first != null) {
            return first;
        }
        if (other == null) {
            return null;
        }
        return Stream.of(other).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isDescendantOf(Object object, Class<?> clazz) {
        Contract.checkArgument(clazz != null, "Class must not be null", new Object[0]);
        return object == null ? false : clazz.isInstance(object);
    }

    public static boolean isInstanceOf(Object object, Class<?> clazz) {
        Contract.checkArgument(clazz != null, "Class must not be null", new Object[0]);
        return object == null ? false : Objects.equals(object.getClass(), clazz);
    }
}

