/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core;

import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class StringBuilders {
    private StringBuilders() {
    }

    public static void clear(StringBuilder builder) {
        Contract.checkArgument(builder != null, "Builder must not be null", new Object[0]);
        builder.setLength(0);
    }

    public static boolean isNullOrEmpty(StringBuilder builder) {
        return builder == null || builder.length() == 0;
    }

    public static void removeAll(StringBuilder builder, char character) {
        Contract.checkArgument(builder != null, "Builder must not be null", new Object[0]);
        int i = 0;
        int j = builder.length();
        while (i < j) {
            if (builder.charAt(i) == character) {
                builder.deleteCharAt(i);
                --j;
                continue;
            }
            ++i;
        }
    }

    public static void removeAll(StringBuilder builder, String string) {
        Contract.checkArgument(builder != null, "Builder must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(string), "String must not be null or empty", new Object[0]);
        int index = builder.indexOf(string);
        while (index >= 0) {
            builder.delete(index, index + string.length());
            index = builder.indexOf(string, index);
        }
    }

    public static void replaceAll(StringBuilder builder, char character, char replacement) {
        Contract.checkArgument(builder != null, "Builder must not be null", new Object[0]);
        int j = builder.length();
        for (int i = 0; i < j; ++i) {
            if (builder.charAt(i) != character) continue;
            builder.setCharAt(i, replacement);
        }
    }

    public static void replaceAll(StringBuilder builder, String string, String replacement) {
        Contract.checkArgument(builder != null, "Builder must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(string), "String must not be null or empty", new Object[0]);
        int index = builder.indexOf(string);
        while (index >= 0) {
            builder.replace(index, index + string.length(), replacement);
            index += replacement.length();
            index = builder.indexOf(string, index);
        }
    }

    public static void toLowerCase(StringBuilder builder) {
        Contract.checkArgument(builder != null, "Builder must not be null", new Object[0]);
        int j = builder.length();
        for (int i = 0; i < j; ++i) {
            builder.setCharAt(i, Character.toLowerCase(builder.charAt(i)));
        }
    }

    public static void toUpperCase(StringBuilder builder) {
        Contract.checkArgument(builder != null, "Builder must not be null", new Object[0]);
        int j = builder.length();
        for (int i = 0; i < j; ++i) {
            builder.setCharAt(i, Character.toUpperCase(builder.charAt(i)));
        }
    }
}

