/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class InetAddresses {
    private InetAddresses() {
    }

    public static boolean isInet4Address(String address) {
        Contract.checkArgument(!Strings.isNullOrEmpty(address), "Address must not be null or empty", new Object[0]);
        try {
            InetAddress parsedAddress = InetAddress.getByName(address);
            return parsedAddress instanceof Inet4Address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isInet6Address(String address) {
        Contract.checkArgument(!Strings.isNullOrEmpty(address), "Address must not be null or empty", new Object[0]);
        try {
            InetAddress parsedAddress = InetAddress.getByName(address);
            return parsedAddress instanceof Inet6Address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

