/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.security.password;

import java.util.Arrays;
import org.sellcom.core.Contract;
import org.sellcom.core.security.password.PasswordStrengthPolicy;

public class CharacterClassesPasswordStrengthPolicy
implements PasswordStrengthPolicy {
    private static final int[] SPECIAL_CHARS = new int[]{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 95, 96, 123, 124, 125, 126};
    private int minDigits = 0;
    private int minLength = 0;
    private int minLowerCaseLetters = 0;
    private int minOtherChars = 0;
    private int minSpecialChars = 0;
    private int minUpperCaseLetters = 0;

    private CharacterClassesPasswordStrengthPolicy() {
    }

    public CharacterClassesPasswordStrengthPolicy create() {
        return new CharacterClassesPasswordStrengthPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(char[] password) {
        Contract.checkArgument(password != null, "Password must not be null", new Object[0]);
        int length = password.length;
        if (length < this.minLength) {
            return false;
        }
        int digits = 0;
        int lowerCaseLetters = 0;
        int otherChars = 0;
        int specialChars = 0;
        int upperCaseLetters = 0;
        int offset = 0;
        while (offset < length) {
            int codePoint = Character.codePointAt(password, offset);
            try {
                if (Character.isUpperCase(codePoint)) {
                    ++upperCaseLetters;
                    continue;
                }
                if (Character.isLowerCase(codePoint)) {
                    ++lowerCaseLetters;
                    continue;
                }
                if (Character.isDigit(codePoint)) {
                    ++digits;
                    continue;
                }
                if (Arrays.binarySearch(SPECIAL_CHARS, codePoint) != -1) {
                    ++specialChars;
                    continue;
                }
                ++otherChars;
            }
            finally {
                offset += Character.charCount(codePoint);
            }
        }
        return upperCaseLetters >= this.minUpperCaseLetters && lowerCaseLetters >= this.minLowerCaseLetters && digits >= this.minDigits && specialChars >= this.minSpecialChars && otherChars >= this.minOtherChars;
    }

    public CharacterClassesPasswordStrengthPolicy withMinDigits(int minDigits) {
        Contract.checkArgument(minDigits >= 0, "Minimum number of digits must not be negative: {0}", minDigits);
        this.minDigits = minDigits;
        return this;
    }

    public CharacterClassesPasswordStrengthPolicy withMinLength(int minLength) {
        Contract.checkArgument(minLength >= 0, "Minimum length must not be negative: {0}", minLength);
        this.minLength = minLength;
        return this;
    }

    public CharacterClassesPasswordStrengthPolicy withMinLowerCaseLetters(int minLowerCaseLetters) {
        Contract.checkArgument(minLowerCaseLetters >= 0, "Minimum number of lower-case letters must not be negative: {0}", minLowerCaseLetters);
        this.minLowerCaseLetters = minLowerCaseLetters;
        return this;
    }

    public CharacterClassesPasswordStrengthPolicy withMinOtherChars(int minOtherChars) {
        Contract.checkArgument(minOtherChars >= 0, "Minimum number of other characters must not be negative: {0}", minOtherChars);
        this.minOtherChars = minOtherChars;
        return this;
    }

    public CharacterClassesPasswordStrengthPolicy withMinSpecialChars(int minSpecialChars) {
        Contract.checkArgument(minSpecialChars >= 0, "Minimum number of special characters must not be negative: {0}", minSpecialChars);
        this.minSpecialChars = minSpecialChars;
        return this;
    }

    public CharacterClassesPasswordStrengthPolicy withMinUpperCaseLetters(int minUpperCaseLetters) {
        Contract.checkArgument(minUpperCaseLetters >= 0, "Minimum number of upper-case letters must not be negative: {0}", minUpperCaseLetters);
        this.minUpperCaseLetters = minUpperCaseLetters;
        return this;
    }
}

