/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util;

import java.util.Arrays;
import java.util.Objects;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.math.MoreMath;

public class MoreArrays {
    private MoreArrays() {
    }

    public static boolean[] concat(boolean[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        boolean[] result = new boolean[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static byte[] concat(byte[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        byte[] result = new byte[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static char[] concat(char[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        char[] result = new char[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static double[] concat(double[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        double[] result = new double[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static float[] concat(float[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        float[] result = new float[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static int[] concat(int[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        int[] result = new int[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static long[] concat(long[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        long[] result = new long[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static short[] concat(short[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        short[] result = new short[totalLength];
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] ... arrays) {
        Contract.checkArgument(arrays != null, "Arrays must not be null", new Object[0]);
        int totalLength = 0;
        int j = arrays.length;
        for (int i = 0; i < j; ++i) {
            Contract.checkArgument(arrays[i] != null, "Arrays must not contain null", new Object[0]);
            totalLength = Math.addExact(totalLength, arrays[i].length);
        }
        T[] result = ReflectionUtils.createArray(arrays[0], totalLength);
        int position = 0;
        int j2 = arrays.length;
        for (int i = 0; i < j2; ++i) {
            System.arraycopy(arrays[i], 0, result, position, arrays[i].length);
            position += arrays[i].length;
        }
        return result;
    }

    public static boolean contains(boolean[] array, boolean element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, element) >= 0;
    }

    public static boolean contains(boolean[] array, int fromIndex, int toIndex, boolean element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element) >= 0;
    }

    public static boolean contains(byte[] array, byte element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, element) >= 0;
    }

    public static boolean contains(byte[] array, int fromIndex, int toIndex, byte element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element) >= 0;
    }

    public static boolean contains(char[] array, char element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, element) >= 0;
    }

    public static boolean contains(char[] array, int fromIndex, int toIndex, char element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element) >= 0;
    }

    public static boolean contains(double[] array, double element, double tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0, "Tolerance must not be negative: {0}", tolerance);
        return MoreArrays.indexOf(array, element, tolerance) >= 0;
    }

    public static boolean contains(double[] array, int fromIndex, int toIndex, double element, double tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0, "Tolerance must not be negative: {0}", tolerance);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element, tolerance) >= 0;
    }

    public static boolean contains(float[] array, float element, float tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0f, "Tolerance must not be negative: {0}", Float.valueOf(tolerance));
        return MoreArrays.indexOf(array, element, tolerance) >= 0;
    }

    public static boolean contains(float[] array, int fromIndex, int toIndex, float element, float tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0f, "Tolerance must not be negative: {0}", Float.valueOf(tolerance));
        return MoreArrays.indexOf(array, fromIndex, toIndex, element, tolerance) >= 0;
    }

    public static boolean contains(int[] array, int element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, element) >= 0;
    }

    public static boolean contains(int[] array, int fromIndex, int toIndex, int element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element) >= 0;
    }

    public static boolean contains(long[] array, long element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, element) >= 0;
    }

    public static boolean contains(long[] array, int fromIndex, int toIndex, long element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element) >= 0;
    }

    public static boolean contains(short[] array, short element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, element) >= 0;
    }

    public static boolean contains(short[] array, int fromIndex, int toIndex, short element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element) >= 0;
    }

    public static <T> boolean contains(T[] array, T element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, element) >= 0;
    }

    public static <T> boolean contains(T[] array, int fromIndex, int toIndex, T element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, fromIndex, toIndex, element) >= 0;
    }

    public static boolean[] copyOf(boolean[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static byte[] copyOf(byte[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static char[] copyOf(char[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static double[] copyOf(double[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static float[] copyOf(float[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static int[] copyOf(int[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static long[] copyOf(long[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static short[] copyOf(short[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static <T> T[] copyOf(T[] array) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return Arrays.copyOf(array, array.length);
    }

    public static boolean[] emptyToNull(boolean[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static byte[] emptyToNull(byte[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static char[] emptyToNull(char[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static double[] emptyToNull(double[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static float[] emptyToNull(float[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static int[] emptyToNull(int[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static long[] emptyToNull(long[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static short[] emptyToNull(short[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static <T> T[] emptyToNull(T[] array) {
        return MoreArrays.isNullOrEmpty(array) ? null : array;
    }

    public static int indexOf(boolean[] array, boolean element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element);
    }

    public static int indexOf(boolean[] array, int fromIndex, int toIndex, boolean element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element);
    }

    public static int indexOf(byte[] array, int fromIndex, int toIndex, byte element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element);
    }

    public static int indexOf(char[] array, int fromIndex, int toIndex, char element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double element, double tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element, tolerance);
    }

    public static int indexOf(double[] array, int fromIndex, int toIndex, double element, double tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0, "Tolerance must not be negative: {0}", tolerance);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!MoreMath.equals(array[i], element, tolerance)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float element, float tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element, tolerance);
    }

    public static int indexOf(float[] array, int fromIndex, int toIndex, float element, float tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0f, "Tolerance must not be negative: {0}", Float.valueOf(tolerance));
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!MoreMath.equals(array[i], element, tolerance)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element);
    }

    public static int indexOf(int[] array, int fromIndex, int toIndex, int element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element);
    }

    public static int indexOf(long[] array, int fromIndex, int toIndex, long element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element);
    }

    public static int indexOf(short[] array, int fromIndex, int toIndex, short element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, T element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.indexOf(array, 0, array.length, element);
    }

    public static <T> int indexOf(T[] array, int fromIndex, int toIndex, T element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!Objects.equals(array[i], element)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNullOrEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static int lastIndexOf(boolean[] array, boolean element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element);
    }

    public static int lastIndexOf(boolean[] array, int fromIndex, int toIndex, boolean element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element);
    }

    public static int lastIndexOf(byte[] array, int fromIndex, int toIndex, byte element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element);
    }

    public static int lastIndexOf(char[] array, int fromIndex, int toIndex, char element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double element, double tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element, tolerance);
    }

    public static int lastIndexOf(double[] array, int fromIndex, int toIndex, double element, double tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0, "Tolerance must not be negative: {0}", tolerance);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (!MoreMath.equals(array[i], element, tolerance)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float element, float tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element, tolerance);
    }

    public static int lastIndexOf(float[] array, int fromIndex, int toIndex, float element, float tolerance) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        Contract.checkArgument(tolerance >= 0.0f, "Tolerance must not be negative: {0}", Float.valueOf(tolerance));
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (!MoreMath.equals(array[i], element, tolerance)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element);
    }

    public static int lastIndexOf(int[] array, int fromIndex, int toIndex, int element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element);
    }

    public static int lastIndexOf(long[] array, int fromIndex, int toIndex, long element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element);
    }

    public static int lastIndexOf(short[] array, int fromIndex, int toIndex, short element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        return MoreArrays.lastIndexOf(array, 0, array.length, element);
    }

    public static <T> int lastIndexOf(T[] array, int fromIndex, int toIndex, T element) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (!Objects.equals(array[i], element)) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] nullToEmpty(boolean[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new boolean[]{} : array;
    }

    public static byte[] nullToEmpty(byte[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new byte[]{} : array;
    }

    public static char[] nullToEmpty(char[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new char[]{} : array;
    }

    public static double[] nullToEmpty(double[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new double[]{} : array;
    }

    public static float[] nullToEmpty(float[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new float[]{} : array;
    }

    public static int[] nullToEmpty(int[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new int[]{} : array;
    }

    public static long[] nullToEmpty(long[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new long[]{} : array;
    }

    public static short[] nullToEmpty(short[] array) {
        return MoreArrays.isNullOrEmpty(array) ? new short[]{} : array;
    }

    public static <T> T[] nullToEmpty(T[] array) {
        return MoreArrays.isNullOrEmpty(array) ? ReflectionUtils.createArray(array, 0) : array;
    }

    public static void reverse(boolean[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static void reverse(byte[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static void reverse(char[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static void reverse(double[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static void reverse(float[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static void reverse(int[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static void reverse(long[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static void reverse(short[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static <T> void reverse(T[] array) {
        Contract.checkArgument(array != null, "Input array must not be null", new Object[0]);
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            MoreArrays.swap(array, i, j);
        }
    }

    public static boolean slowEquals(boolean[] former, boolean[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        int diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= Boolean.compare(former[i], latter[i]);
        }
        return diff == 0;
    }

    public static boolean slowEquals(byte[] former, byte[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        int diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= former[i] ^ latter[i];
        }
        return diff == 0;
    }

    public static boolean slowEquals(char[] former, char[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        int diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= former[i] ^ latter[i];
        }
        return diff == 0;
    }

    public static boolean slowEquals(double[] former, double[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        long diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= Double.doubleToLongBits(former[i]) ^ Double.doubleToLongBits(latter[i]);
        }
        return diff == 0L;
    }

    public static boolean slowEquals(float[] former, float[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        int diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= Float.floatToIntBits(former[i]) ^ Float.floatToIntBits(latter[i]);
        }
        return diff == 0;
    }

    public static boolean slowEquals(int[] former, int[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        int diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= former[i] ^ latter[i];
        }
        return diff == 0;
    }

    public static boolean slowEquals(long[] former, long[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        long diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= former[i] ^ latter[i];
        }
        return diff == 0L;
    }

    public static boolean slowEquals(short[] former, short[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        int diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= former[i] ^ latter[i];
        }
        return diff == 0;
    }

    public static <T> boolean slowEquals(T[] former, T[] latter) {
        Contract.checkArgument(former != null, "Former array must not be null", new Object[0]);
        Contract.checkArgument(latter != null, "Latter array must not be null", new Object[0]);
        int diff = former.length ^ latter.length;
        for (int i = 0; i < former.length && i < latter.length; ++i) {
            diff |= Objects.equals(former[i], latter[i]) ? 0 : 1;
        }
        return diff == 0;
    }

    public static void swap(boolean[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        boolean element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static void swap(byte[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        byte element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static void swap(char[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        char element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static void swap(double[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        double element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static void swap(float[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        float element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static void swap(int[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        int element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static void swap(long[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        long element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static void swap(short[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        short element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }

    public static <T> void swap(T[] array, int formerIndex, int latterIndex) {
        Contract.checkArgument(array != null, "Array must not be null", new Object[0]);
        T element = array[formerIndex];
        array[formerIndex] = array[latterIndex];
        array[latterIndex] = element;
    }
}

