/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingDoubleFunction<R>
extends DoubleFunction<R> {
    @Override
    default public R apply(double argument) {
        try {
            return this.applyThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public R applyThrowing(double var1) throws Exception;

    default public DoubleFunction<R> fallbackTo(DoubleFunction<R> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public DoubleFunction<R> fallbackTo(DoubleFunction<R> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.apply(argument);
            }
        };
    }

    default public DoubleFunction<R> orReturn(R value) {
        return this.orReturn(value, null);
    }

    default public DoubleFunction<R> orReturn(R value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingDoubleFunction<R> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingDoubleFunction<R> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingDoubleFunction<R> orTryWith(ThrowingDoubleFunction<? extends R> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingDoubleFunction<R> orTryWith(ThrowingDoubleFunction<? extends R> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyThrowing(argument);
            }
        };
    }
}

