/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.LongFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingLongFunction<R>
extends LongFunction<R> {
    @Override
    default public R apply(long argument) {
        try {
            return this.applyThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public R applyThrowing(long var1) throws Exception;

    default public LongFunction<R> fallbackTo(LongFunction<R> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public LongFunction<R> fallbackTo(LongFunction<R> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.apply(argument);
            }
        };
    }

    default public LongFunction<R> orReturn(R value) {
        return this.orReturn(value, null);
    }

    default public LongFunction<R> orReturn(R value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingLongFunction<R> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingLongFunction<R> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingLongFunction<R> orTryWith(ThrowingLongFunction<? extends R> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingLongFunction<R> orTryWith(ThrowingLongFunction<? extends R> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyThrowing(argument);
            }
        };
    }
}

