/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.core.internal.util;

import java.util.concurrent.ThreadLocalRandom;

public class RandomGenerator {

	private RandomGenerator() {
		// Utility class, not to be instantiated
	}


	public static byte nextByte() {
		return (byte) nextInt(Byte.MIN_VALUE, Byte.MAX_VALUE);
	}

	public static byte nextByte(byte from, byte to) {
		return (byte) nextInt(from, to);
	}

	public static byte[] nextBytes(int count) {
		byte[] bytes = new byte[count];
		ThreadLocalRandom.current().nextBytes(bytes);

		return bytes;
	}

	public static byte nextNegativeByte() {
		return (byte) nextInt(Byte.MIN_VALUE, 0);
	}

	public static byte nextPositiveByte() {
		return (byte) (nextInt(0, Byte.MAX_VALUE) + 1);
	}

	public static int nextInt() {
		return ThreadLocalRandom.current().nextInt();
	}

	public static int nextInt(int from, int to) {
		return ThreadLocalRandom.current().nextInt(from, to);
	}

	public static int nextNegativeInt() {
		return nextInt(Integer.MIN_VALUE, 0);
	}

	public static int nextPositiveInt() {
		return nextInt(0, Integer.MAX_VALUE) + 1;
	}

	public static long nextLong() {
		return ThreadLocalRandom.current().nextLong();
	}

	public static long nextLong(long from, long to) {
		return ThreadLocalRandom.current().nextLong(from, to);
	}

	public static long nextNegativeLong() {
		return nextLong(Long.MIN_VALUE, 0);
	}

	public static long nextPositiveLong() {
		return nextLong(0, Long.MAX_VALUE) + 1;
	}

	public static short nextShort() {
		return (short) nextInt(Short.MIN_VALUE, Short.MAX_VALUE);
	}

	public static short nextShort(short from, short to) {
		return (short) nextInt(from, to);
	}

	public static String nextString(String alphabet, int length) {
		StringBuilder builder = new StringBuilder();
		for (int i = 0; i < length; i++) {
			builder.append(alphabet.charAt(nextInt(0, alphabet.length())));
		}

		return builder.toString();
	}

	public static short nextNegativeShort() {
		return (short) nextInt(Short.MIN_VALUE, 0);
	}

	public static short nextPositiveShort() {
		return (short) (nextInt(0, Short.MAX_VALUE) + 1);
	}

}
