/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MoreCollectors {
    private MoreCollectors() {
    }

    public static <E> Collector<E, List<E>, List<E>> toUnmodifiableList() {
        return MoreCollectors.toUnmodifiableList(ArrayList::new);
    }

    public static <E, C extends List<E>> Collector<E, C, List<E>> toUnmodifiableList(Supplier<C> listFactory) {
        return Collector.of(listFactory, List::add, MoreCollectors::listCombiner, Collections::unmodifiableList, new Collector.Characteristics[0]);
    }

    public static <E> Collector<E, Set<E>, Set<E>> toUnmodifiableSet() {
        return MoreCollectors.toUnmodifiableSet(HashSet::new);
    }

    public static <E, C extends Set<E>> Collector<E, C, Set<E>> toUnmodifiableSet(Supplier<C> setFactory) {
        return Collector.of(setFactory, Set::add, MoreCollectors::setCombiner, Collections::unmodifiableSet, new Collector.Characteristics[0]);
    }

    private static <E, C extends List<E>> C listCombiner(C left, C right) {
        left.addAll(right);
        return left;
    }

    private static <E, C extends Set<E>> C setCombiner(C left, C right) {
        left.addAll(right);
        return left;
    }
}

