/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Random;

public class RandomUtils {
    private RandomUtils() {
    }

    public static BigDecimal nextBigDecimal(Random random, BigDecimal from, BigDecimal to, int scale) {
        return from.add(RandomUtils._nextBigDecimal(random, to.subtract(from), scale));
    }

    public static BigInteger nextBigInteger(Random random, BigInteger from, BigInteger to) {
        return from.add(RandomUtils._nextBigInteger(random, to.subtract(from)));
    }

    public static byte nextByte(Random random, byte from, byte to) {
        return (byte)RandomUtils.nextInt(random, from, to);
    }

    public static byte[] nextBytes(Random random, int count) {
        byte[] bytes = new byte[count];
        random.nextBytes(bytes);
        return bytes;
    }

    public static int nextInt(Random random, int from, int to) {
        return from + random.nextInt(to - from);
    }

    public static long nextLong(Random random, long from, long to) {
        return from + RandomUtils._nextLong(random, to - from);
    }

    public static short nextShort(Random random, short from, short to) {
        return (short)RandomUtils.nextInt(random, from, to);
    }

    public static String nextString(Random random, String alphabet, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(alphabet.charAt(RandomUtils.nextInt(random, 0, alphabet.length())));
        }
        return builder.toString();
    }

    private static BigDecimal _nextBigDecimal(Random random, BigDecimal upperBound, int scale) {
        BigDecimal result = new BigDecimal(random.nextDouble()).multiply(upperBound);
        return result.setScale(scale, RoundingMode.HALF_UP);
    }

    private static BigInteger _nextBigInteger(Random random, BigInteger upperBound) {
        BigInteger result;
        while ((result = new BigInteger(upperBound.bitLength(), random)).compareTo(upperBound) >= 0) {
        }
        return result;
    }

    private static long _nextLong(Random random, long upperBound) {
        long result;
        long bits;
        while ((bits = random.nextLong() << 1 >>> 1) + (result = bits % upperBound) + (upperBound - 1L) < 0L) {
        }
        return result;
    }
}

