/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io.encoding;

import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.sellcom.core.Contract;

public abstract class BinaryEncoder {
    public byte[] encode(byte[] input) {
        Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
        return this.encodeToString(input).getBytes(StandardCharsets.US_ASCII);
    }

    public ByteBuffer encode(ByteBuffer input) {
        Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
        byte[] bytes = new byte[input.remaining()];
        input.get(bytes);
        return ByteBuffer.wrap(this.encode(bytes));
    }

    public String encodeToString(BigInteger input) {
        Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
        byte[] bytes = input.toByteArray();
        if (bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return this.encodeToString(bytes);
    }

    public abstract String encodeToString(byte[] var1);

    public boolean supportsStreaming() {
        return false;
    }

    public OutputStream wrap(OutputStream destination) {
        throw new UnsupportedOperationException();
    }
}

