/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.net;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class NetworkInterfaces {
    private NetworkInterfaces() {
    }

    public static List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            networkInterfaces.add(enumeration.nextElement());
        }
        return networkInterfaces;
    }

    public static List<NetworkInterface> getBroadcastEnabledNetworkInterfaces() throws SocketException {
        List<NetworkInterface> networkInterfaces = NetworkInterfaces.getNetworkInterfaces();
        Iterator<NetworkInterface> iterator = networkInterfaces.iterator();
        while (iterator.hasNext()) {
            NetworkInterface networkInterface = iterator.next();
            Optional<InterfaceAddress> broadcastEnabledInterfaceAddress = networkInterface.getInterfaceAddresses().stream().filter(interfaceAddress -> interfaceAddress.getBroadcast() != null).findAny();
            if (broadcastEnabledInterfaceAddress.isPresent()) continue;
            iterator.remove();
        }
        return networkInterfaces;
    }
}

