/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.core.i18n;

import java.util.Locale;

/**
 * Standard {@link Locale}s.
 *
 * @since 1.0
 */
public class StandardLocales {

	/**
	 * Afrikaans.
	 *
	 * @since 1.0
	 */
	public static final Locale AFRIKAANS = new Locale("af");

	/**
	 * Albanian.
	 *
	 * @since 1.0
	 */
	public static final Locale ALBANIAN = new Locale("sq");

	/**
	 * American English.
	 *
	 * @since 1.0
	 */
	public static final Locale AMERICAN_ENGLISH = new Locale("en", "US");

	/**
	 * Arabic.
	 *
	 * @since 1.0
	 */
	public static final Locale ARABIC = new Locale("ar");

	/**
	 * Armenian.
	 *
	 * @since 1.0
	 */
	public static final Locale ARMENIAN = new Locale("hy");

	/**
	 * Australian English.
	 *
	 * @since 1.0
	 */
	public static final Locale AUSTRALIAN_ENGLISH = new Locale("en", "AU");

	/**
	 * Austrian German.
	 *
	 * @since 1.0
	 */
	public static final Locale AUSTRIAN_GERMAN = new Locale("de", "AT");

	/**
	 * Azerbaijani.
	 *
	 * @since 1.0
	 */
	public static final Locale AZERBAIJANI = new Locale("az");

	/**
	 * Basque.
	 *
	 * @since 1.0
	 */
	public static final Locale BASQUE = new Locale("eu");

	/**
	 * Belarusian.
	 *
	 * @since 1.0
	 */
	public static final Locale BELARUSIAN = new Locale("be");

	/**
	 * Belgian French.
	 *
	 * @since 1.0
	 */
	public static final Locale BELGIAN_FRENCH = new Locale("fr", "BE");

	/**
	 * Bosnian.
	 *
	 * @since 1.0
	 */
	public static final Locale BOSNIAN = new Locale("bs");

	/**
	 * Brazilian Portuguese.
	 *
	 * @since 1.0
	 */
	public static final Locale BRAZILIAN_PORTUGUESE = new Locale("pt", "BR");

	/**
	 * British English.
	 *
	 * @since 1.0
	 */
	public static final Locale BRITISH_ENGLISH = new Locale("en", "GB");

	/**
	 * Bulgarian.
	 *
	 * @since 1.0
	 */
	public static final Locale BULGARIAN = new Locale("bg");

	/**
	 * Canadian English.
	 *
	 * @since 1.0
	 */
	public static final Locale CANADIAN_ENGLISH = new Locale("en", "CA");

	/**
	 * Canadian French.
	 *
	 * @since 1.0
	 */
	public static final Locale CANADIAN_FRENCH = new Locale("fr", "CA");

	/**
	 * Catalan.
	 *
	 * @since 1.0
	 */
	public static final Locale CATALAN = new Locale("ca");

	/**
	 * Croatian.
	 *
	 * @since 1.0
	 */
	public static final Locale CROATIAN = new Locale("hr");

	/**
	 * Czech.
	 *
	 * @since 1.0
	 */
	public static final Locale CZECH = new Locale("cs");

	/**
	 * Danish.
	 *
	 * @since 1.0
	 */
	public static final Locale DANISH = new Locale("da");

	/**
	 * Dutch.
	 *
	 * @since 1.0
	 */
	public static final Locale DUTCH = new Locale("nl");

	/**
	 * Estonian.
	 *
	 * @since 1.0
	 */
	public static final Locale ESTONIAN = new Locale("et");

	/**
	 * European Portuguese.
	 *
	 * @since 1.0
	 */
	public static final Locale EUROPEAN_PORTUGUESE = new Locale("pt", "PT");

	/**
	 * Faroese.
	 *
	 * @since 1.0
	 */
	public static final Locale FAROESE = new Locale("fo");

	/**
	 * Finland Swedish.
	 *
	 * @since 1.0
	 */
	public static final Locale FINLAND_SWEDISH = new Locale("sv", "FI");

	/**
	 * Finnish.
	 *
	 * @since 1.0
	 */
	public static final Locale FINNISH = new Locale("fi");

	/**
	 * Flemish.
	 *
	 * @since 1.0
	 */
	public static final Locale FLEMISH = new Locale("nl", "BE");

	/**
	 * French.
	 *
	 * @since 1.0
	 */
	public static final Locale FRENCH = new Locale("fr");

	/**
	 * Galician.
	 *
	 * @since 1.0
	 */
	public static final Locale GALICIAN = new Locale("gl");

	/**
	 * Georgian.
	 *
	 * @since 1.0
	 */
	public static final Locale GEORGIAN = new Locale("ka");

	/**
	 * German.
	 *
	 * @since 1.0
	 */
	public static final Locale GERMAN = new Locale("de");

	/**
	 * Greek.
	 *
	 * @since 1.0
	 */
	public static final Locale GREEK = new Locale("el");

	/**
	 * Hebrew.
	 *
	 * @since 1.0
	 */
	public static final Locale HEBREW = new Locale("iw");

	/**
	 * Hungarian.
	 *
	 * @since 1.0
	 */
	public static final Locale HUNGARIAN = new Locale("hu");

	/**
	 * Icelandic.
	 *
	 * @since 1.0
	 */
	public static final Locale ICELANDIC = new Locale("is");

	/**
	 * Inuktitut.
	 *
	 * @since 1.0
	 */
	public static final Locale INUKTITUT = new Locale("iu");

	/**
	 * Irish.
	 *
	 * @since 1.0
	 */
	public static final Locale IRISH = new Locale("ga");

	/**
	 * Irish English, also known as Hiberno‐English.
	 *
	 * @since 1.0
	 */
	public static final Locale IRISH_ENGLISH = new Locale("en", "IE");

	/**
	 * Italian.
	 *
	 * @since 1.0
	 */
	public static final Locale ITALIAN = new Locale("it");

	/**
	 * Japanese.
	 *
	 * @since 1.0
	 */
	public static final Locale JAPANESE = new Locale("ja");

	/**
	 * Kazakh.
	 *
	 * @since 1.0
	 */
	public static final Locale KAZAKH = new Locale("kk");

	/**
	 * Korean.
	 *
	 * @since 1.0
	 */
	public static final Locale KOREAN = new Locale("ko");

	/**
	 * Kyrgyz.
	 *
	 * @since 1.0
	 */
	public static final Locale KYRGYZ = new Locale("ky");

	/**
	 * Latvian.
	 *
	 * @since 1.0
	 */
	public static final Locale LATVIAN = new Locale("lv");

	/**
	 * Lithuanian.
	 *
	 * @since 1.0
	 */
	public static final Locale LITHUANIAN = new Locale("lt");

	/**
	 * Luxembourgish.
	 *
	 * @since 1.0
	 */
	public static final Locale LUXEMBOURGISH = new Locale("lb");

	/**
	 * Macedonian.
	 *
	 * @since 1.0
	 */
	public static final Locale MACEDONIAN = new Locale("mk");

	/**
	 * Mexican Spanish.
	 *
	 * @since 1.0
	 */
	public static final Locale MEXICAN_SPANISH = new Locale("es", "MX");

	/**
	 * Moldovan.
	 *
	 * @since 1.0
	 */
	public static final Locale MOLDOVAN = new Locale("ro", "MD");

	/**
	 * Mongolian.
	 *
	 * @since 1.0
	 */
	public static final Locale MONGOLIAN = new Locale("mn");

	/**
	 * New Zealand English.
	 *
	 * @since 1.0
	 */
	public static final Locale NEW_ZEALAND_ENGLISH = new Locale("en", "NZ");

	/**
	 * Northern Sami.
	 *
	 * @since 1.0
	 */
	public static final Locale NORTHERN_SAMI = new Locale("se");

	/**
	 * Norwegian Bokmål.
	 *
	 * @since 1.0
	 */
	public static final Locale NORWEGIAN_BOKMAL = new Locale("nb");

	/**
	 * Norwegian Nynorsk.
	 *
	 * @since 1.0
	 */
	public static final Locale NORWEGIAN_NYNORSK = new Locale("nn");

	/**
	 * Polish.
	 *
	 * @since 1.0
	 */
	public static final Locale POLISH = new Locale("pl");

	/**
	 * Romanian.
	 *
	 * @since 1.0
	 */
	public static final Locale ROMANIAN = new Locale("ro");

	/**
	 * Romansh.
	 *
	 * @since 1.0
	 */
	public static final Locale ROMANSH = new Locale("rm");

	/**
	 * Russian.
	 *
	 * @since 1.0
	 */
	public static final Locale RUSSIAN = new Locale("ru");

	/**
	 * Scottish Gaelic.
	 *
	 * @since 1.0
	 */
	public static final Locale SCOTTISH_GAELIC = new Locale("gd");

	/**
	 * Serbian.
	 *
	 * @since 1.0
	 */
	public static final Locale SERBIAN = new Locale("sr");

	/**
	 * Simplified Chinese.
	 *
	 * @since 1.0
	 */
	public static final Locale SIMPLIFIED_CHINESE = createLocaleWithScript("zh", "Hans");

	/**
	 * Slovak.
	 *
	 * @since 1.0
	 */
	public static final Locale SLOVAK = new Locale("sk");

	/**
	 * Slovenian.
	 *
	 * @since 1.0
	 */
	public static final Locale SLOVENIAN = new Locale("sl");

	/**
	 * South African English.
	 *
	 * @since 1.0
	 */
	public static final Locale SOUTH_AFRICAN_ENGLISH = new Locale("en", "ZA");

	/**
	 * Spanish.
	 *
	 * @since 1.0
	 */
	public static final Locale SPANISH = new Locale("es");

	/**
	 * Swedish.
	 *
	 * @since 1.0
	 */
	public static final Locale SWEDISH = new Locale("sv");

	/**
	 * Swiss French.
	 *
	 * @since 1.0
	 */
	public static final Locale SWISS_FRENCH = new Locale("fr", "CH");

	/**
	 * Swiss German.
	 *
	 * @since 1.0
	 */
	public static final Locale SWISS_GERMAN = new Locale("de", "CH");

	/**
	 * Tajik.
	 *
	 * @since 1.0
	 */
	public static final Locale TAJIK = new Locale("tg");

	/**
	 * Traditional Chinese.
	 *
	 * @since 1.0
	 */
	public static final Locale TRADITIONAL_CHINESE = createLocaleWithScript("zh", "Hant");

	/**
	 * Turkish.
	 *
	 * @since 1.0
	 */
	public static final Locale TURKISH = new Locale("tr");

	/**
	 * Turkmen.
	 *
	 * @since 1.0
	 */
	public static final Locale TURKMEN = new Locale("tk");

	/**
	 * Ukrainian.
	 *
	 * @since 1.0
	 */
	public static final Locale UKRAINIAN = new Locale("uk");

	/**
	 * Uzbek.
	 *
	 * @since 1.0
	 */
	public static final Locale UZBEK = new Locale("uz");

	/**
	 * Vietnamese.
	 *
	 * @since 1.0
	 */
	public static final Locale VIETNAMESE = new Locale("vi");

	/**
	 * Welsh.
	 *
	 * @since 1.0
	 */
	public static final Locale WELSH = new Locale("cy");

	/**
	 * Western Frisian.
	 *
	 * @since 1.0
	 */
	public static final Locale WESTERN_FRISIAN = new Locale("fy");

	/**
	 * Yiddish.
	 *
	 * @since 1.0
	 */
	public static final Locale YIDDISH = new Locale("yi");


	private StandardLocales() {
		// Namespace for constants, not to be instantiated
	}


	private static Locale createLocaleWithScript(String language, String script) {
		return new Locale.Builder()
				.setLanguage(language)
				.setScript(script)
				.build();
	}

}
