/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.i18n;

import java.util.Locale;
import java.util.Optional;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class Locales {
    private Locales() {
    }

    public static Optional<Locale> getParentLocale(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        if (locale.equals(Locale.ROOT)) {
            return Optional.empty();
        }
        if (!Strings.isNullOrEmpty(locale.getVariant())) {
            return Optional.of(Locales.createLocale(locale.getLanguage(), locale.getScript(), locale.getCountry(), ""));
        }
        if (!Strings.isNullOrEmpty(locale.getCountry())) {
            return Optional.of(Locales.createLocale(locale.getLanguage(), locale.getScript(), "", ""));
        }
        if (!Strings.isNullOrEmpty(locale.getScript())) {
            return Optional.of(Locales.createLocale(locale.getLanguage(), "", "", ""));
        }
        return Optional.of(Locale.ROOT);
    }

    private static Locale createLocale(String language, String script, String region, String variant) {
        return new Locale.Builder().setLanguage(language).setScript(script).setRegion(region).setVariant(variant).build();
    }
}

