/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.i18n;

import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Locale;
import java.util.Objects;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class OptionalNumberFormat
extends Format {
    private static final long serialVersionUID = -140815875712012388L;
    private final NumberFormat format;

    private OptionalNumberFormat(NumberFormat format) {
        this.format = format;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof OptionalNumberFormat) {
            OptionalNumberFormat otherCast = (OptionalNumberFormat)other;
            return Objects.equals(this.format, otherCast.format);
        }
        return false;
    }

    public String format(double number) {
        return this.format.format(number);
    }

    public String format(long number) {
        return this.format.format(number);
    }

    @Override
    public StringBuffer format(Object source, StringBuffer buffer, FieldPosition position) {
        return source == null ? buffer : this.format.format(source, buffer, position);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public Currency getCurrency() {
        return this.format.getCurrency();
    }

    public static OptionalNumberFormat getCurrencyInstance() {
        return new OptionalNumberFormat(NumberFormat.getCurrencyInstance());
    }

    public static OptionalNumberFormat getCurrencyInstance(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        return new OptionalNumberFormat(NumberFormat.getCurrencyInstance(locale));
    }

    public static OptionalNumberFormat getInstance() {
        return new OptionalNumberFormat(NumberFormat.getInstance());
    }

    public static OptionalNumberFormat getInstance(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        return new OptionalNumberFormat(NumberFormat.getInstance(locale));
    }

    public static OptionalNumberFormat getIntegerInstance() {
        return new OptionalNumberFormat(NumberFormat.getIntegerInstance());
    }

    public static OptionalNumberFormat getIntegerInstance(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        return new OptionalNumberFormat(NumberFormat.getIntegerInstance(locale));
    }

    public int getMaximumFractionDigits() {
        return this.format.getMaximumFractionDigits();
    }

    public int getMaximumIntegerDigits() {
        return this.format.getMaximumFractionDigits();
    }

    public int getMinimumFractionDigits() {
        return this.format.getMinimumFractionDigits();
    }

    public int getMinimumIntegerDigits() {
        return this.format.getMinimumIntegerDigits();
    }

    public static OptionalNumberFormat getNumberInstance() {
        return new OptionalNumberFormat(NumberFormat.getNumberInstance());
    }

    public static OptionalNumberFormat getNumberInstance(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        return new OptionalNumberFormat(NumberFormat.getNumberInstance(locale));
    }

    public static OptionalNumberFormat getPercentInstance() {
        return new OptionalNumberFormat(NumberFormat.getPercentInstance());
    }

    public static OptionalNumberFormat getPercentInstance(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        return new OptionalNumberFormat(NumberFormat.getPercentInstance(locale));
    }

    public RoundingMode getRoundingMode() {
        return this.format.getRoundingMode();
    }

    public boolean isGroupingUsed() {
        return this.format.isGroupingUsed();
    }

    public boolean isParseIntegerOnly() {
        return this.format.isParseIntegerOnly();
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return Strings.isNullOrEmpty(source) ? null : this.format.parseObject(source);
    }

    @Override
    public Object parseObject(String source, ParsePosition position) {
        return Strings.isNullOrEmpty(source) ? null : this.format.parseObject(source, position);
    }

    public int hashCode() {
        return this.format.hashCode();
    }

    public void setCurrency(Currency currency) {
        this.format.setCurrency(currency);
    }

    public void setGroupingUsed(boolean value) {
        this.format.setGroupingUsed(value);
    }

    public void setMaximumFractionDigits(int value) {
        this.format.setMaximumFractionDigits(value);
    }

    public void setMaximumIntegerDigits(int value) {
        this.format.setMaximumIntegerDigits(value);
    }

    public void setMinimumFractionDigits(int value) {
        this.format.setMinimumFractionDigits(value);
    }

    public void setMinimumIntegerDigits(int value) {
        this.format.setMinimumIntegerDigits(value);
    }

    public void setParseIntegerOnly(boolean value) {
        this.format.setParseIntegerOnly(value);
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.format.setRoundingMode(roundingMode);
    }
}

