/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io.charset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sellcom.core.Contract;
import org.sellcom.core.io.charset.LocaleToCharset;
import org.sellcom.core.io.charset.MoreCharsets;

public class Charsets {
    private static final Map<String, String> DISPLAY_NAMES;

    private Charsets() {
    }

    public static String getDisplayName(Charset charset) {
        Contract.checkArgument(charset != null, "Charset must not be null", new Object[0]);
        return DISPLAY_NAMES.getOrDefault(charset.name(), charset.displayName());
    }

    public static List<Charset> getSupportedCharsets(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        return LocaleToCharset.getSupportedCharsets(locale);
    }

    static {
        HashMap<String, String> displayNames = new HashMap<String, String>();
        displayNames.put(MoreCharsets.GB2312.name(), "GB 2312");
        displayNames.put(MoreCharsets.GB18030.name(), "GB 18030");
        displayNames.put(MoreCharsets.ISCII91.name(), "ISCII");
        displayNames.put(StandardCharsets.ISO_8859_1.name(), "Latin 1 (ISO-8859-1/CP819)");
        displayNames.put(MoreCharsets.ISO_8859_2.name(), "Latin 2 (ISO-8859-2)");
        displayNames.put(MoreCharsets.ISO_8859_3.name(), "Latin 3 (ISO-8859-3)");
        displayNames.put(MoreCharsets.ISO_8859_4.name(), "Latin 4 (ISO-8859-4)");
        displayNames.put(MoreCharsets.ISO_8859_5.name(), "Latin/Cyrillic (ISO-8859-5)");
        displayNames.put(MoreCharsets.ISO_8859_6.name(), "Latin/Arabic (ISO-8859-6)");
        displayNames.put(MoreCharsets.ISO_8859_7.name(), "Latin/Greek (ISO-8859-7)");
        displayNames.put(MoreCharsets.ISO_8859_8.name(), "Latin/Hebrew (ISO-8859-8)");
        displayNames.put(MoreCharsets.ISO_8859_9.name(), "Latin 5 (ISO-8859-9)");
        displayNames.put(MoreCharsets.ISO_8859_10.name(), "Latin 6 (ISO-8859-10)");
        displayNames.put(MoreCharsets.ISO_8859_11.name(), "Latin/Thai (ISO-8859-11)");
        displayNames.put(MoreCharsets.ISO_8859_13.name(), "Latin 7 (ISO-8859-13)");
        displayNames.put(MoreCharsets.ISO_8859_14.name(), "Latin 8 (ISO-8859-13)");
        displayNames.put(MoreCharsets.ISO_8859_15.name(), "Latin 9 (ISO-8859-15)");
        displayNames.put(MoreCharsets.ISO_8859_16.name(), "Latin 10 (ISO-8859-16)");
        displayNames.put(MoreCharsets.SHIFT_JIS.name(), "Shift JIS");
        displayNames.put(StandardCharsets.US_ASCII.name(), "ASCII");
        displayNames.put(MoreCharsets.UTF_8BOM.name(), "UTF-8, BOM");
        displayNames.put(StandardCharsets.UTF_16BE.name(), "UTF-16, Big Engian");
        displayNames.put(StandardCharsets.UTF_16LE.name(), "UTF-16, Little Engian");
        displayNames.put(MoreCharsets.UTF_32BE.name(), "UTF-32, Big Engian");
        displayNames.put(MoreCharsets.UTF_32LE.name(), "UTF-32, Little Engian");
        displayNames.put(MoreCharsets.WINDOWS_31J.name(), "Windows-31J (CP932)");
        displayNames.put(MoreCharsets.WINDOWS_874.name(), "Windows-874");
        displayNames.put(MoreCharsets.WINDOWS_949.name(), "Windows-949");
        displayNames.put(MoreCharsets.WINDOWS_1250.name(), "Windows-1250");
        displayNames.put(MoreCharsets.WINDOWS_1251.name(), "Windows-1251");
        displayNames.put(MoreCharsets.WINDOWS_1252.name(), "Windows-1252");
        displayNames.put(MoreCharsets.WINDOWS_1253.name(), "Windows-1253");
        displayNames.put(MoreCharsets.WINDOWS_1254.name(), "Windows-1254");
        displayNames.put(MoreCharsets.WINDOWS_1255.name(), "Windows-1255");
        displayNames.put(MoreCharsets.WINDOWS_1256.name(), "Windows-1256");
        displayNames.put(MoreCharsets.WINDOWS_1257.name(), "Windows-1257");
        displayNames.put(MoreCharsets.WINDOWS_1258.name(), "Windows-1258");
        DISPLAY_NAMES = Collections.unmodifiableMap(displayNames);
    }
}

