/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.security.password;

import java.util.Arrays;
import java.util.function.ToDoubleFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.util.MoreArrays;

public class StandardSyntaxRules {
    private static final int[] LESS_COMMON_SPECIAL_CHARS = new int[]{34, 39, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 91, 92, 93, 95, 96, 123, 124, 125, 126};
    private static final int[] MORE_COMMON_SPECIAL_CHARS = new int[]{33, 35, 36, 37, 38, 40, 41, 42, 64, 94};
    private static final int[] SPECIAL_CHARS_SEQUENCE = new int[]{126, 33, 64, 35, 36, 37, 94, 38, 42, 40, 41, 95, 43};

    private StandardSyntaxRules() {
    }

    public static ToDoubleFunction<char[]> characterClasses(int minClasses, double weight) {
        Contract.checkArgument(minClasses > 0, "Minimum number of classes must be positive: {0}", minClasses);
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            boolean digits = false;
            boolean lessCommonSpecialChars = false;
            boolean lowerCaseLetters = false;
            boolean moreCommonSpecialChars = false;
            boolean upperCaseLetters = false;
            int offset = 0;
            while (offset < ((char[])password).length) {
                int codePoint = Character.codePointAt(password, offset);
                try {
                    if (Character.isUpperCase(codePoint)) {
                        if (upperCaseLetters) continue;
                        upperCaseLetters = true;
                        continue;
                    }
                    if (Character.isLowerCase(codePoint)) {
                        if (lowerCaseLetters) continue;
                        lowerCaseLetters = true;
                        continue;
                    }
                    if (Character.isDigit(codePoint)) {
                        if (digits) continue;
                        digits = true;
                        continue;
                    }
                    if (Arrays.binarySearch(MORE_COMMON_SPECIAL_CHARS, codePoint) >= 0) {
                        if (moreCommonSpecialChars) continue;
                        moreCommonSpecialChars = true;
                        continue;
                    }
                    if (Arrays.binarySearch(LESS_COMMON_SPECIAL_CHARS, codePoint) < 0 || lessCommonSpecialChars) continue;
                    lessCommonSpecialChars = true;
                }
                finally {
                    offset += Character.charCount(codePoint);
                }
            }
            int characterClasses = 0;
            characterClasses += digits ? 1 : 0;
            characterClasses += lessCommonSpecialChars ? 1 : 0;
            characterClasses += lowerCaseLetters ? 1 : 0;
            characterClasses += moreCommonSpecialChars ? 1 : 0;
            return (characterClasses += upperCaseLetters ? 1 : 0) >= minClasses ? weight * (double)characterClasses : Double.MIN_VALUE;
        };
    }

    public static ToDoubleFunction<char[]> consecutiveDigits(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            if (MoreArrays.isNullOrEmpty(password)) {
                return 0.0;
            }
            int currentLength = 0;
            int totalLength = 0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (Character.isDigit(codePoint)) {
                    ++currentLength;
                    continue;
                }
                totalLength += currentLength;
                currentLength = 0;
            }
            return weight * (double)(totalLength += currentLength);
        };
    }

    public static ToDoubleFunction<char[]> consecutiveLowerCaseLetters(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            if (MoreArrays.isNullOrEmpty(password)) {
                return 0.0;
            }
            int currentLength = 0;
            int totalLength = 0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (Character.isLowerCase(codePoint)) {
                    ++currentLength;
                    continue;
                }
                totalLength += currentLength;
                currentLength = 0;
            }
            return weight * (double)(totalLength += currentLength);
        };
    }

    public static ToDoubleFunction<char[]> consecutiveUpperCaseLetters(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            if (MoreArrays.isNullOrEmpty(password)) {
                return 0.0;
            }
            int currentLength = 0;
            int totalLength = 0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (Character.isUpperCase(codePoint)) {
                    ++currentLength;
                    continue;
                }
                totalLength += currentLength;
                currentLength = 0;
            }
            return weight * (double)(totalLength += currentLength);
        };
    }

    public static ToDoubleFunction<char[]> digits(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (!Character.isDigit(codePoint)) continue;
                score += weight;
            }
            return score;
        };
    }

    public static ToDoubleFunction<char[]> digitsOnly(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int offset = 0;
            while (offset < ((char[])password).length) {
                int codePoint = Character.codePointAt(password, offset);
                try {
                    if (Character.isDigit(codePoint)) continue;
                    double d = 0.0;
                    return d;
                }
                finally {
                    offset += Character.charCount(codePoint);
                }
            }
            return weight * (double)((char[])password).length;
        };
    }

    public static ToDoubleFunction<char[]> length(int minLength, double weight) {
        Contract.checkArgument(minLength > 0, "Minimum length must be positive: {0}", minLength);
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> ((char[])password).length >= minLength ? weight * (double)((char[])password).length : Double.MIN_VALUE;
    }

    public static ToDoubleFunction<char[]> lessCommonSpecialChars(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (Arrays.binarySearch(LESS_COMMON_SPECIAL_CHARS, codePoint) < 0) continue;
                score += weight;
            }
            return score;
        };
    }

    public static ToDoubleFunction<char[]> lettersOnly(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int offset = 0;
            while (offset < ((char[])password).length) {
                int codePoint = Character.codePointAt(password, offset);
                try {
                    if (Character.isLetter(codePoint)) continue;
                    double d = 0.0;
                    return d;
                }
                finally {
                    offset += Character.charCount(codePoint);
                }
            }
            return weight * (double)((char[])password).length;
        };
    }

    public static ToDoubleFunction<char[]> lowerCaseLetters(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (!Character.isLowerCase(codePoint)) continue;
                score += weight;
            }
            return score;
        };
    }

    public static ToDoubleFunction<char[]> midDigits(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 1; offset < ((char[])password).length - 1; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (!Character.isDigit(codePoint)) continue;
                score += weight;
            }
            return score;
        };
    }

    public static ToDoubleFunction<char[]> midLessCommonSpecialChars(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 1; offset < ((char[])password).length - 1; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (Arrays.binarySearch(LESS_COMMON_SPECIAL_CHARS, codePoint) < 0) continue;
                score += weight;
            }
            return score;
        };
    }

    public static ToDoubleFunction<char[]> midMoreCommonSpecialChars(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 1; offset < ((char[])password).length - 1; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (Arrays.binarySearch(MORE_COMMON_SPECIAL_CHARS, codePoint) < 0) continue;
                score += weight;
            }
            return score;
        };
    }

    public static ToDoubleFunction<char[]> moreCommonSpecialChars(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (Arrays.binarySearch(MORE_COMMON_SPECIAL_CHARS, codePoint) < 0) continue;
                score += weight;
            }
            return score;
        };
    }

    public static ToDoubleFunction<char[]> sequentialDigits(int minSequenceLength, double weight) {
        Contract.checkArgument(minSequenceLength >= 2, "Minimum sequence length must not be less than 2: {0}", minSequenceLength);
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint1;
            int offset2;
            int codePoint2;
            if (((char[])password).length < 2) {
                return 0.0;
            }
            int totalSequenceLength = 0;
            int currentSequenceLength = 1;
            int offset1 = 0;
            for (offset2 = Character.charCount(0); offset2 < ((char[])password).length; offset2 += Character.charCount(codePoint2)) {
                codePoint1 = Character.codePointAt(password, offset1);
                codePoint2 = Character.codePointAt(password, offset2);
                if (Character.isDigit(codePoint1) && Character.isDigit(codePoint2) && Character.digit(codePoint1, 10) + 1 == Character.digit(codePoint2, 10)) {
                    ++currentSequenceLength;
                } else {
                    if (currentSequenceLength >= minSequenceLength) {
                        totalSequenceLength += currentSequenceLength;
                    }
                    currentSequenceLength = 1;
                }
                offset1 += Character.charCount(codePoint1);
            }
            if (currentSequenceLength >= minSequenceLength) {
                totalSequenceLength += currentSequenceLength;
            }
            currentSequenceLength = 1;
            offset1 = 0;
            for (offset2 = Character.charCount(0); offset2 < ((char[])password).length; offset2 += Character.charCount(codePoint2)) {
                codePoint1 = Character.codePointAt(password, offset1);
                codePoint2 = Character.codePointAt(password, offset2);
                if (Character.isDigit(codePoint1) && Character.isDigit(codePoint2) && Character.digit(codePoint1, 10) - 1 == Character.digit(codePoint2, 10)) {
                    ++currentSequenceLength;
                } else {
                    if (currentSequenceLength >= minSequenceLength) {
                        totalSequenceLength += currentSequenceLength;
                    }
                    currentSequenceLength = 1;
                }
                offset1 += Character.charCount(codePoint1);
            }
            if (currentSequenceLength >= minSequenceLength) {
                totalSequenceLength += currentSequenceLength;
            }
            return weight * (double)totalSequenceLength;
        };
    }

    public static ToDoubleFunction<char[]> sequentialLetters(int minSequenceLength, double weight) {
        Contract.checkArgument(minSequenceLength >= 2, "Minimum sequence length must not be less than 2: {0}", minSequenceLength);
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint1;
            int offset2;
            int codePoint2;
            if (((char[])password).length < 2) {
                return 0.0;
            }
            int totalSequenceLength = 0;
            int currentSequenceLength = 1;
            int offset1 = 0;
            for (offset2 = Character.charCount(0); offset2 < ((char[])password).length; offset2 += Character.charCount(codePoint2)) {
                codePoint1 = Character.codePointAt(password, offset1);
                codePoint2 = Character.codePointAt(password, offset2);
                if (Character.isLetter(codePoint1) && Character.isLetter(codePoint2) && Character.toLowerCase(codePoint1) + 1 == Character.toLowerCase(codePoint2)) {
                    ++currentSequenceLength;
                } else {
                    if (currentSequenceLength >= minSequenceLength) {
                        totalSequenceLength += currentSequenceLength;
                    }
                    currentSequenceLength = 1;
                }
                offset1 += Character.charCount(codePoint1);
            }
            if (currentSequenceLength >= minSequenceLength) {
                totalSequenceLength += currentSequenceLength;
            }
            currentSequenceLength = 1;
            offset1 = 0;
            for (offset2 = Character.charCount(0); offset2 < ((char[])password).length; offset2 += Character.charCount(codePoint2)) {
                codePoint1 = Character.codePointAt(password, offset1);
                codePoint2 = Character.codePointAt(password, offset2);
                if (Character.isLetter(codePoint1) && Character.isLetter(codePoint2) && Character.toLowerCase(codePoint1) - 1 == Character.toLowerCase(codePoint2)) {
                    ++currentSequenceLength;
                } else {
                    if (currentSequenceLength >= minSequenceLength) {
                        totalSequenceLength += currentSequenceLength;
                    }
                    currentSequenceLength = 1;
                }
                offset1 += Character.charCount(codePoint1);
            }
            if (currentSequenceLength >= minSequenceLength) {
                totalSequenceLength += currentSequenceLength;
            }
            return weight * (double)totalSequenceLength;
        };
    }

    public static ToDoubleFunction<char[]> sequentialSpecialChars(int minSequenceLength, double weight) {
        Contract.checkArgument(minSequenceLength >= 2, "Minimum sequence length must not be less than 2: {0}", minSequenceLength);
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint2Index;
            int codePoint1Index;
            int codePoint1;
            int offset2;
            int codePoint2;
            if (((char[])password).length < 2) {
                return 0.0;
            }
            int totalSequenceLength = 0;
            int currentSequenceLength = 1;
            int offset1 = 0;
            for (offset2 = Character.charCount(0); offset2 < ((char[])password).length; offset2 += Character.charCount(codePoint2)) {
                codePoint1 = Character.codePointAt(password, offset1);
                codePoint2 = Character.codePointAt(password, offset2);
                codePoint1Index = MoreArrays.indexOf(SPECIAL_CHARS_SEQUENCE, codePoint1);
                codePoint2Index = MoreArrays.indexOf(SPECIAL_CHARS_SEQUENCE, codePoint2);
                if (codePoint1Index >= 0 && codePoint2Index >= 0 && codePoint1Index + 1 == codePoint2Index) {
                    ++currentSequenceLength;
                } else {
                    if (currentSequenceLength >= minSequenceLength) {
                        totalSequenceLength += currentSequenceLength;
                    }
                    currentSequenceLength = 1;
                }
                offset1 += Character.charCount(codePoint1);
            }
            if (currentSequenceLength >= minSequenceLength) {
                totalSequenceLength += currentSequenceLength;
            }
            currentSequenceLength = 1;
            offset1 = 0;
            for (offset2 = Character.charCount(0); offset2 < ((char[])password).length; offset2 += Character.charCount(codePoint2)) {
                codePoint1 = Character.codePointAt(password, offset1);
                codePoint2 = Character.codePointAt(password, offset2);
                codePoint1Index = MoreArrays.indexOf(SPECIAL_CHARS_SEQUENCE, codePoint1);
                codePoint2Index = MoreArrays.indexOf(SPECIAL_CHARS_SEQUENCE, codePoint2);
                if (codePoint1Index >= 0 && codePoint2Index >= 0 && codePoint1Index - 1 == codePoint2Index) {
                    ++currentSequenceLength;
                } else {
                    if (currentSequenceLength >= minSequenceLength) {
                        totalSequenceLength += currentSequenceLength;
                    }
                    currentSequenceLength = 1;
                }
                offset1 += Character.charCount(codePoint1);
            }
            if (currentSequenceLength >= minSequenceLength) {
                totalSequenceLength += currentSequenceLength;
            }
            return weight * (double)totalSequenceLength;
        };
    }

    public static ToDoubleFunction<char[]> upperCaseLetters(double weight) {
        Contract.checkArgument(Double.isFinite(weight), "Weight must be a finite value: {0}", weight);
        return password -> {
            int codePoint;
            double score = 0.0;
            for (int offset = 0; offset < ((char[])password).length; offset += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(password, offset);
                if (!Character.isUpperCase(codePoint)) continue;
                score += weight;
            }
            return score;
        };
    }
}

