/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingIntUnaryOperator
extends IntUnaryOperator {
    default public ThrowingIntUnaryOperator andThen(ThrowingIntUnaryOperator after) {
        Contract.checkArgument(after != null, "After operator must not be null", new Object[0]);
        return argument -> after.applyAsIntThrowing(this.applyAsIntThrowing(argument));
    }

    @Override
    default public int applyAsInt(int argument) {
        try {
            return this.applyAsIntThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public int applyAsIntThrowing(int var1) throws Exception;

    default public ThrowingIntUnaryOperator compose(ThrowingIntUnaryOperator before) {
        Contract.checkArgument(before != null, "Before operator must not be null", new Object[0]);
        return argument -> this.applyAsIntThrowing(before.applyAsIntThrowing(argument));
    }

    default public IntUnaryOperator fallbackTo(IntUnaryOperator fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public IntUnaryOperator fallbackTo(IntUnaryOperator fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback operator must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsInt(argument);
            }
        };
    }

    default public IntUnaryOperator orReturn(int value) {
        return this.orReturn(value, null);
    }

    default public IntUnaryOperator orReturn(int value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingIntUnaryOperator orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingIntUnaryOperator orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingIntUnaryOperator orTryWith(ThrowingIntUnaryOperator other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingIntUnaryOperator orTryWith(ThrowingIntUnaryOperator other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other operator must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsIntThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsIntThrowing(argument);
            }
        };
    }
}

