/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.LongToDoubleFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingLongToDoubleFunction
extends LongToDoubleFunction {
    @Override
    default public double applyAsDouble(long argument) {
        try {
            return this.applyAsDoubleThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public double applyAsDoubleThrowing(long var1) throws Exception;

    default public LongToDoubleFunction fallbackTo(LongToDoubleFunction fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public LongToDoubleFunction fallbackTo(LongToDoubleFunction fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsDouble(argument);
            }
        };
    }

    default public LongToDoubleFunction orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public LongToDoubleFunction orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingLongToDoubleFunction orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingLongToDoubleFunction orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingLongToDoubleFunction orTryWith(ThrowingLongToDoubleFunction other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingLongToDoubleFunction orTryWith(ThrowingLongToDoubleFunction other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsDoubleThrowing(argument);
            }
        };
    }
}

