/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingToDoubleFunction<T>
extends ToDoubleFunction<T> {
    @Override
    default public double applyAsDouble(T argument) {
        try {
            return this.applyAsDoubleThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public double applyAsDoubleThrowing(T var1) throws Exception;

    default public ToDoubleFunction<T> fallbackTo(ToDoubleFunction<T> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public ToDoubleFunction<T> fallbackTo(ToDoubleFunction<T> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsDouble(argument);
            }
        };
    }

    default public ToDoubleFunction<T> orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public ToDoubleFunction<T> orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingToDoubleFunction<T> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingToDoubleFunction<T> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingToDoubleFunction<T> orTryWith(ThrowingToDoubleFunction<? super T> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingToDoubleFunction<T> orTryWith(ThrowingToDoubleFunction<? super T> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsDoubleThrowing(argument);
            }
        };
    }
}

