/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.platform;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.util.platform.JreVersionParseException;

public class JreVersion
implements Comparable<JreVersion> {
    private static final Pattern VERSION_FORMAT_PATTERN = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(_([0-9]+))?(-b([0-9]+))?(-[0-9A-Za-z])?$");
    private final int build;
    private final int major;
    private final int minor;
    private final int revision;
    private final int update;

    private JreVersion(int major, int minor, int revision, int update, int build) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.update = update;
        this.build = build;
    }

    @Override
    public int compareTo(JreVersion other) {
        Contract.checkArgument(other != null, "Compared version must not be null", new Object[0]);
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.revision < other.revision) {
            return -1;
        }
        if (this.revision > other.revision) {
            return 1;
        }
        if (this.update < other.update) {
            return -1;
        }
        if (this.update > other.update) {
            return 1;
        }
        if (this.build < other.build) {
            return -1;
        }
        if (this.build > other.build) {
            return 1;
        }
        return 0;
    }

    public static JreVersion current() {
        return JreVersion.parse(System.getProperty("java.runtime.version"));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof JreVersion) {
            JreVersion otherCast = (JreVersion)other;
            return Objects.equals(this.major, otherCast.major) && Objects.equals(this.minor, otherCast.minor) && Objects.equals(this.revision, otherCast.revision) && Objects.equals(this.update, otherCast.update) && Objects.equals(this.build, otherCast.build);
        }
        return false;
    }

    public int getBuild() {
        return this.build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getUpdate() {
        return this.update;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.update, this.build);
    }

    public static JreVersion parse(String string) {
        Contract.checkArgument(!Strings.isNullOrEmpty(string), "Input string must not be null or empty", new Object[0]);
        Matcher matcher = VERSION_FORMAT_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new JreVersionParseException(String.format("Unsupported version format: %s", string));
        }
        try {
            String majorString = matcher.group(1);
            int major = Integer.parseInt(majorString);
            String minorString = matcher.group(2);
            int minor = Integer.parseInt(minorString);
            String revisionString = matcher.group(3);
            int revision = Integer.parseInt(revisionString);
            String updateString = matcher.group(5);
            int update = Strings.isNullOrEmpty(updateString) ? -1 : Integer.parseInt(updateString);
            String buildString = matcher.group(7);
            int build = Strings.isNullOrEmpty(buildString) ? -1 : Integer.parseInt(buildString);
            return new JreVersion(major, minor, revision, update, build);
        }
        catch (NumberFormatException e) {
            throw new JreVersionParseException(String.format("Unsupported version format: %s", string));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        builder.append('.');
        builder.append(this.minor);
        builder.append('.');
        builder.append(this.revision);
        if (this.update >= 0) {
            builder.append('_');
            builder.append(this.update);
        }
        if (this.build >= 0) {
            builder.append("-b");
            builder.append(this.build);
        }
        return builder.toString();
    }
}

