/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sellcom.core.Contract;

public class MoreCollections {
    private MoreCollections() {
    }

    public static <T> Map<T, Integer> countFrequencies(Collection<T> collection) {
        Contract.checkArgument(collection != null, "Collection must not be null", new Object[0]);
        return Collections.unmodifiableMap(collection.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, element -> 1, Integer::sum))));
    }

    public static NavigableSet<String> caseIgnoringSet() {
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    public static NavigableSet<String> caseIgnoringSet(Collection<String> strings) {
        Contract.checkArgument(strings != null, "Strings must not be null", new Object[0]);
        TreeSet<String> caseIgnoringSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        caseIgnoringSet.addAll(strings);
        return caseIgnoringSet;
    }

    public static <E> Collection<E> emptyToNull(Collection<E> collection) {
        return MoreCollections.isNullOrEmpty(collection) ? null : collection;
    }

    public static <E> boolean isNullOrEmpty(Collection<E> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <E> List<E> nullToEmpty(List<E> set) {
        return MoreCollections.isNullOrEmpty(set) ? new ArrayList() : set;
    }

    public static <E> NavigableSet<E> nullToEmpty(NavigableSet<E> navigableSet) {
        return MoreCollections.isNullOrEmpty(navigableSet) ? new TreeSet() : navigableSet;
    }

    public static <E> Set<E> nullToEmpty(Set<E> set) {
        return MoreCollections.isNullOrEmpty(set) ? new HashSet() : set;
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortByValues(Map<K, V> map) {
        Contract.checkArgument(map != null, "Map must not be null", new Object[0]);
        return Collections.unmodifiableMap(map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (key, value) -> value, LinkedHashMap::new)));
    }

    public static <K, V> Map<K, V> sortByValues(Map<K, V> map, Comparator<V> comparator) {
        Contract.checkArgument(map != null, "Map must not be null", new Object[0]);
        Contract.checkArgument(comparator != null, "Comparator must not be null", new Object[0]);
        return Collections.unmodifiableMap(map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (key, value) -> value, LinkedHashMap::new)));
    }
}

