/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.collection.concurrent;

import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.sellcom.core.Contract;
import org.sellcom.core.collection.concurrent.SimpleExpiringObject;
import org.sellcom.core.internal.collection.MapEntry;

public class ExpiringHashMap<K, V>
implements Map<K, V> {
    private Clock clock = Clock.systemUTC();
    private final Map<K, V> entries = new HashMap();
    private final Queue<SimpleExpiringObject<K>> expiryTimeline = new PriorityQueue<SimpleExpiringObject<K>>();
    private final long timeToLive;

    public ExpiringHashMap(long timeToLive, TimeUnit unit) {
        Contract.checkArgument(timeToLive >= 0L, "Time to live must not be negative: {0}", timeToLive);
        Contract.checkArgument(unit != null, "Unit must not be null", new Object[0]);
        this.timeToLive = unit.toMillis(timeToLive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.entries.clear();
            this.expiryTimeline.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return this.entries.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return this.entries.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            HashSet entrySet = new HashSet(this.entries.size());
            this.entries.forEach((key, value) -> entrySet.add(new MapEntry<Object, Object>(key, value)));
            return entrySet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return this.entries.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return this.entries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return new HashSet<K>(this.entries.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return this._put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Contract.checkArgument(map != null, "Map must not be null", new Object[0]);
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            map.forEach(this::_put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Contract.checkArgument(key != null, "Key must not be null", new Object[0]);
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return this._remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Queue<SimpleExpiringObject<K>> queue = this.expiryTimeline;
        synchronized (queue) {
            this.cleanUp();
            return new HashSet<V>(this.entries.values());
        }
    }

    private V _put(K key, V value) {
        V previousValue = this.entries.put(key, value);
        this.expiryTimeline.remove(key);
        this.expiryTimeline.add(new SimpleExpiringObject<K>(key, this.timeToLive, TimeUnit.MILLISECONDS, this.clock));
        return previousValue;
    }

    private V _remove(Object key) {
        V previousValue = this.entries.remove(key);
        this.expiryTimeline.remove(key);
        return previousValue;
    }

    private void cleanUp() {
        while (!this.expiryTimeline.isEmpty() && this.expiryTimeline.peek().isExpired()) {
            this.entries.remove(this.expiryTimeline.poll().getValue());
        }
    }

    void setClock(Clock clock) {
        Contract.checkArgument(clock != null, "Clock must not be null", new Object[0]);
        this.clock = clock;
        this.expiryTimeline.forEach((? super T expiringObject) -> expiringObject.setClock(clock));
    }
}

