/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io.encoding;

import org.sellcom.core.internal.io.encoding.Base16Encoding;
import org.sellcom.core.internal.io.encoding.Base58BitcoinEncoding;
import org.sellcom.core.internal.io.encoding.Base58FlickrEncoding;
import org.sellcom.core.internal.io.encoding.Base64Encoding;
import org.sellcom.core.internal.io.encoding.Base64UrlEncoding;
import org.sellcom.core.io.encoding.BinaryDecoder;
import org.sellcom.core.io.encoding.BinaryEncoder;
import org.sellcom.core.io.encoding.BinaryEncoding;

public class StandardBinaryEncodings {
    public static final BinaryEncoding BASE_16 = new Base16Encoding();
    public static final BinaryEncoding BASE_58_BITCOIN = new Base58BitcoinEncoding();
    public static final BinaryEncoding BASE_58_FLICKR = new Base58FlickrEncoding();
    public static final BinaryEncoding BASE_64 = new Base64Encoding();
    public static final BinaryEncoding BASE_64_URL = new Base64UrlEncoding();

    private StandardBinaryEncodings() {
    }

    public static BinaryDecoder createBase16Decoder() {
        return BASE_16.newDecoder();
    }

    public static BinaryEncoder createBase16Encoder() {
        return BASE_16.newEncoder();
    }

    public static BinaryDecoder createBase58BitcoinDecoder() {
        return BASE_58_BITCOIN.newDecoder();
    }

    public static BinaryEncoder createBase58BitcoinEncoder() {
        return BASE_58_BITCOIN.newEncoder();
    }

    public static BinaryDecoder createBase58FlickrDecoder() {
        return BASE_58_FLICKR.newDecoder();
    }

    public static BinaryEncoder createBase58FlickrEncoder() {
        return BASE_58_FLICKR.newEncoder();
    }

    public static BinaryDecoder createBase64Decoder() {
        return BASE_64.newDecoder();
    }

    public static BinaryEncoder createBase64Encoder() {
        return BASE_64.newEncoder();
    }

    public static BinaryDecoder createBase64UrlDecoder() {
        return BASE_64_URL.newDecoder();
    }

    public static BinaryEncoder createBase64UrlEncoder() {
        return BASE_64_URL.newEncoder();
    }
}

