/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.sellcom.core.Contract;
import org.sellcom.core.io.UnexpectedDataEndException;

public class NetworkMessage {
    public static final int HEADER_LENGTH = 20;
    private ByteBuffer buffer;
    private byte[] payload = new byte[0];
    private InetSocketAddress remoteEndPoint;
    private UUID uuid;
    private boolean valid = true;

    private NetworkMessage() {
    }

    public static NetworkMessage create() {
        return new NetworkMessage();
    }

    public static NetworkMessage fromByteBuffer(ByteBuffer buffer, InetSocketAddress remoteEndPoint) throws IOException {
        Contract.checkArgument(buffer != null, "Buffer must not be null", new Object[0]);
        Contract.checkArgument(remoteEndPoint != null, "Remote end point must not be null", new Object[0]);
        if (buffer.remaining() < 20) {
            throw new UnexpectedDataEndException(String.format("Expected %d bytes but got only %d", 20, buffer.remaining()));
        }
        NetworkMessage message = new NetworkMessage();
        message.remoteEndPoint = remoteEndPoint;
        message.uuid = new UUID(buffer.getLong(), buffer.getLong());
        int payloadLength = buffer.getInt();
        if (buffer.remaining() != payloadLength) {
            throw new UnexpectedDataEndException(String.format("Expected %d bytes but got only %d", payloadLength, buffer.remaining()));
        }
        message.payload = new byte[buffer.remaining()];
        buffer.get(message.payload);
        return message;
    }

    public byte[] getPayload() {
        return Arrays.copyOf(this.payload, this.payload.length);
    }

    public InetAddress getRemoteAddress() {
        return this.remoteEndPoint == null ? null : this.remoteEndPoint.getAddress();
    }

    public InetSocketAddress getRemoteEndPoint() {
        return this.remoteEndPoint;
    }

    public String getRemoteHostName() {
        return this.remoteEndPoint == null ? null : this.remoteEndPoint.getHostName();
    }

    public Integer getRemotePort() {
        return this.remoteEndPoint == null ? null : Integer.valueOf(this.remoteEndPoint.getPort());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public ByteBuffer toByteBuffer() {
        Contract.checkState(this.uuid != null, "UUID has not yet been set", new Object[0]);
        if (this.buffer == null) {
            ByteBuffer buffer = ByteBuffer.allocate(this.payload.length + 20);
            buffer.putLong(this.uuid.getMostSignificantBits());
            buffer.putLong(this.uuid.getLeastSignificantBits());
            buffer.putInt(this.payload.length);
            buffer.put(this.payload);
            buffer.flip();
            this.buffer = buffer;
        }
        return this.buffer.duplicate();
    }

    public NetworkMessage withPayload(byte[] payload) {
        Contract.checkArgument(payload != null, "Payload must not be null", new Object[0]);
        this.payload = Arrays.copyOf(payload, payload.length);
        return this;
    }

    public NetworkMessage withRandomUuid() {
        this.uuid = UUID.randomUUID();
        return this;
    }

    public NetworkMessage withRemoteEndPoint(InetSocketAddress remoteEndPoint) {
        Contract.checkArgument(remoteEndPoint != null, "Remote end point must not be null", new Object[0]);
        Contract.checkArgument(remoteEndPoint.getPort() != 0, "Remote post must not be 0", new Object[0]);
        this.remoteEndPoint = remoteEndPoint;
        return this;
    }

    public NetworkMessage withUuid(UUID uuid) {
        Contract.checkArgument(uuid != null, "Identifier must not be null", new Object[0]);
        this.uuid = uuid;
        return this;
    }
}

