/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingBiConsumer<T, U>
extends BiConsumer<T, U> {
    @Override
    default public void accept(T former, U latter) {
        try {
            this.acceptThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public void acceptThrowing(T var1, U var2) throws Exception;

    default public BiConsumer<T, U> fallbackTo(BiConsumer<T, U> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public BiConsumer<T, U> fallbackTo(BiConsumer<T, U> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback consumer must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                fallback.accept(former, latter);
            }
        };
    }

    default public ThrowingBiConsumer<T, U> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingBiConsumer<T, U> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingBiConsumer<T, U> orTryWith(ThrowingBiConsumer<? super T, ? super U> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingBiConsumer<T, U> orTryWith(ThrowingBiConsumer<? super T, ? super U> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other consumer must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                this.acceptThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                other.acceptThrowing(former, latter);
            }
        };
    }
}

