/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingDoubleBinaryOperator
extends DoubleBinaryOperator {
    @Override
    default public double applyAsDouble(double former, double latter) {
        try {
            return this.applyAsDoubleThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public double applyAsDoubleThrowing(double var1, double var3) throws Exception;

    default public DoubleBinaryOperator fallbackTo(DoubleBinaryOperator fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public DoubleBinaryOperator fallbackTo(DoubleBinaryOperator fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback operator must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsDouble(former, latter);
            }
        };
    }

    default public DoubleBinaryOperator orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public DoubleBinaryOperator orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingDoubleBinaryOperator orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingDoubleBinaryOperator orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingDoubleBinaryOperator orTryWith(ThrowingDoubleBinaryOperator other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingDoubleBinaryOperator orTryWith(ThrowingDoubleBinaryOperator other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other operator must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyAsDoubleThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsDoubleThrowing(former, latter);
            }
        };
    }
}

