/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingDoubleSupplier
extends DoubleSupplier {
    default public DoubleSupplier fallbackTo(DoubleSupplier fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public DoubleSupplier fallbackTo(DoubleSupplier fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsDoubleThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.getAsDouble();
            }
        };
    }

    @Override
    default public double getAsDouble() {
        try {
            return this.getAsDoubleThrowing();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public double getAsDoubleThrowing() throws Exception;

    default public DoubleSupplier orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public DoubleSupplier orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return () -> {
            try {
                return this.getAsDoubleThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingDoubleSupplier orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsDoubleThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingDoubleSupplier orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsDoubleThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingDoubleSupplier orTryWith(ThrowingDoubleSupplier other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingDoubleSupplier orTryWith(ThrowingDoubleSupplier other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsDoubleThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.getAsDoubleThrowing();
            }
        };
    }
}

